var cplmspreview = new Object();
cplmspreview.assetArray = ['step1', 'step2', 'step3', 'computer' ,'scorm-logo','Green-arrow'];
cplmspreview.assetsFolder = 'assets';
cplmspreview.folderSeperator = '/';
cplmspreview.loadedAssets = {};
cplmspreview.progressText = ['Uploading the project to the SCORM cloud..','Preparing the course..', 'Getting ready for the LMS Preview..'];
cplmspreview.NumAssetsLoaded  = 0;
cplmspreview.PNGExtension = '.png';
cplmspreview.GIFExtension = '.gif';
cplmspreview.dialogWidth = 720;
cplmspreview.currentStep = 1;
cplmspreview.loadAssets = function() 
{
    for(var i=0; i< cplmspreview.assetArray.length; ++i)
    {
        var img = new Image();			
        img.playbarassetName = cplmspreview.assetArray[i];
        cplmspreview.loadedAssets[cplmspreview.assetArray[i]] = img;
        img.onload = cplmspreview.assetLoaded;
        img.onerror = cplmspreview.assetLoaded;
        if(i == 5)
        {
            img.src = cplmspreview.assetsFolder + cplmspreview.folderSeperator + cplmspreview.assetArray[i] + cplmspreview.GIFExtension ;
        }
        else
            img.src = cplmspreview.assetsFolder + cplmspreview.folderSeperator + cplmspreview.assetArray[i] + cplmspreview.PNGExtension ;
    }
}
cplmspreview.assetLoaded = function(event)
{
   cplmspreview.NumAssetsLoaded +=1;
    if(cplmspreview.NumAssetsLoaded == cplmspreview.assetArray.length)
    {
        cplmspreview.NumAssetsLoaded = 0;
        cplmspreview.continueLoad();
    }
}
cplmspreview.continueLoad = function()
{
    cplmspreview.loadStepImage(1);
    cplmspreview.loadLogos();
    this.loadAnimation();
    this.loadProgressText(1);
     if(window.cpCancelText != undefined)
        window.document.getElementById("cancel-button").value = window.cpCancelText;
}
cplmspreview.loadStepImage = function(stepNum)
{
    var c=document.getElementById("stepsCanvas");
    var ctx=c.getContext("2d");
    var img=cplmspreview.loadedAssets[cplmspreview.assetArray[stepNum-1]];
    c.width = img.width;
    c.height = img.height;
    ctx.drawImage(img,0,0,img.width,img.height);
}
cplmspreview.loadProgressText = function(stepNo)
{
   // var cplmsprogress;
    cplmspreview.currentStep = stepNo;
    var textElem=document.getElementById("progressText");
    if(window.cplmsprogress != undefined && window.cplmsprogress.localizedProgressText != undefined && window.cplmsprogress.localizedProgressText.length != undefined && window.cplmsprogress.localizedProgressText.length >= stepNo)
        textElem.innerHTML = window.cplmsprogress.localizedProgressText[stepNo -1];
    else
        textElem.innerHTML = cplmspreview.progressText[stepNo - 1];
    var a = String( (this.dialogWidth - textElem.clientWidth) /2);
    var b =  a+ "px";
    textElem.style.left = b;
}
cplmspreview.loadLogos = function()
{
    var c=document.getElementById("computerLogoCanvas");
    var ctx=c.getContext("2d");
    var img=cplmspreview.loadedAssets[cplmspreview.assetArray[3]];
    c.width = img.width;
    c.height = img.height;
    ctx.drawImage(img,0,0,img.width,img.height);
    
    c=document.getElementById("scormLogoCanvas");
    ctx=c.getContext("2d");
    img=cplmspreview.loadedAssets[cplmspreview.assetArray[4]];
    c.width = img.width;
    c.height = img.height;
    ctx.drawImage(img,0,0,img.width,img.height);
}
cplmspreview.loadStep = function(stepNum)
{
    cplmspreview.loadStepImage(stepNum);
    this.loadProgressText(stepNum);
}
cplmspreview.loadAnimation = function()
{
    var img = cplmspreview.loadedAssets[cplmspreview.assetArray[5]];
    img.width = 240;
    img.height = 40;
    img.style.position = "absolute";
    img.style.top = "160px";
    img.style.left = "250px";
    document.body.appendChild(img);
}
cplmspreview.oncancel = function()
{
    window.location = window.location.origin+"/goodbye.html";
    //alert(window.location);
    return false;
}
window.refreshProgressText = function()
{
    if(cplmspreview != undefined)
        cplmspreview.loadProgressText(cplmspreview.currentStep);
    if(window.cpCancelText != undefined && window.document && window.document.getElementById("cancel-button")!=undefined)
        window.document.getElementById("cancel-button").value = window.cpCancelText;
}