"use strict";Object.defineProperty(exports,"__esModule",{value:!0});var e=require("@dcx/error"),t=require("@dcx/logger"),s=require("@dcx/promise"),r=require("@dcx/util");function o(e){return e&&"object"==typeof e&&"default"in e?e:{default:e}}var n=o(e),i=o(s);const a={Asset:"asset",Composite:"composite",File:"file",Directory:"directory",Version:"version"};var d,c;exports.HeaderKeys=void 0,(d=exports.HeaderKeys||(exports.HeaderKeys={})).CONTENT_ID="content-id",d.CONTENT_LENGTH="content-length",d.CONTENT_RANGE="content-range",d.CONTENT_TYPE="content-type",d.IF_MATCH="if-match",d.IF_NONE_MATCH="if-none-match",d.AUTHORIZATION="authorization",d.X_API_KEY="x-api-key",exports.HTTPMethods=void 0,(c=exports.HTTPMethods||(exports.HTTPMethods={})).GET="GET",c.PUT="PUT",c.PATCH="PATCH",c.HEAD="HEAD",c.POST="POST",c.DELETE="DELETE";const p={ACCESS_CHECK:"http://ns.adobe.com/adobecloud/rel/ac/check",ACL_POLICY:"http://ns.adobe.com/adobecloud/rel/ac/policy",ANNOTATIONS:"http://ns.adobe.com/adobecloud/rel/annotations",APP_METADATA:"http://ns.adobe.com/adobecloud/rel/metadata/application",BASE_DIRECTORY:"http://ns.adobe.com/adobecloud/rel/directory/base",BLOCK_DOWNLOAD:"http://ns.adobe.com/adobecloud/rel/download",BLOCK_EXTEND:"http://ns.adobe.com/adobecloud/rel/block/extend",BLOCK_FINALIZE:"http://ns.adobe.com/adobecloud/rel/block/finalize",BLOCK_TRANSFER:"http://ns.adobe.com/adobecloud/rel/block/transfer",BLOCK_UPLOAD_INIT:"http://ns.adobe.com/adobecloud/rel/block/init",BULK_REQUEST:"http://ns.adobe.com/adobecloud/rel/bulk",COMPONENT:"http://ns.adobe.com/adobecloud/rel/component",CREATE:"http://ns.adobe.com/adobecloud/rel/create",DESCRIBED_BY:"describedBy",DIRECTORY:"http://ns.adobe.com/adobecloud/rel/directory",DISCARD:"http://ns.adobe.com/adobecloud/rel/discard",EFFECTIVE_PRIVILAGES:"http://ns.adobe.com/adobecloud/rel/ac/effective",EMBEDDED_METADATA:"http://ns.adobe.com/adobecloud/rel/metadata/embedded",ID:"http://ns.adobe.com/adobecloud/rel/id",MANIFEST:"http://ns.adobe.com/adobecloud/rel/manifest",PAGE:"http://ns.adobe.com/adobecloud/rel/page",PATH:"http://ns.adobe.com/adobecloud/rel/path",PRIMARY:"http://ns.adobe.com/adobecloud/rel/primary",RENDITION:"http://ns.adobe.com/adobecloud/rel/rendition",REPO_METADATA:"http://ns.adobe.com/adobecloud/rel/metadata/repository",REPO_OPS:"http://ns.adobe.com/adobecloud/rel/ops",REPOSITORY:"http://ns.adobe.com/adobecloud/rel/repository",RESOLVE_BY_ID:"http://ns.adobe.com/adobecloud/rel/resolve/id",RESOLVE_BY_PATH:"http://ns.adobe.com/adobecloud/rel/resolve/path",RESTORE:"http://ns.adobe.com/adobecloud/rel/restore",VERSION_HISTORY:"version-history"},l="application/vnd.adobecloud.directory+json",h="application/vnd.adobe.dcx-manifest+json",u="application/json",f="application/problem+json",_="application/json-patch+json",E="application/vnd.adobecloud.bulk-transfer+json",T="application/vnd.adobe.asset-operation+json";var g,I,P,A,y,k;exports.Properties=void 0,(g=exports.Properties||(exports.Properties={})).DC_FORMAT="dc:format",g.DC_TITLE="dc:title",g.LINKS="_links",g.PAGE="_page",g.CHILDREN="children",g.EMBEDDED="_embedded",g.REPO_ASSET_ID="repo:assetId",g.REPO_REPOSITORY_ID="repo:repositoryId",g.REPO_REPOSITORY_TYPE="repo:repositoryType",g.REPO_BASE_ASSET_ID="repo:baseAssetId",g.REPO_SIZE="repo:size",g.REPO_NAME="repo:name",g.REPO_PATH="repo:path",g.REPO_ASSET_CLASS="repo:assetClass",g.REPO_CREATE_DATE="repo:createDate",g.REPO_MODIFY_DATE="repo:modifyDate",g.REPO_DISCARD_DATE="repo:discardDate",g.REPO_ETAG="repo:etag",g.REPO_CREATED_BY="repo:createdBy",g.REPO_MODIFIED_BY="repo:modifiedBy",g.REPO_DISCARDED_BY="repo:discardedBy",g.REPO_DEVICE_CREATE_DATE="storage:deviceCreateDate",g.REPO_DEVICE_MODIFY_DATE="storage:deviceModifyDate",g.REPO_DEFAULT_SCHEDULED_DELETION_DURATION="repo:defaultScheduledDeletionDuration",g.REPO_SCHEDULED_DELETION_DATE="repo:scheduledDeletionDate",g.REPO_VERSION="repo:version",g.REPO_STATE="repo:state",g.REPO_AVAILABLE_REGIONS="repo:availableRegions",g.REPO_REGIONS="repo:regions",g.REPO_OWNER="repo:owner",g.REPO_OWNER_ID="id",g.REPO_OWNER_TYPE="type",g.STORAGE_ASSIGNEE="storage:assignee",g.STORAGE_ASSIGNEE_ID="id",g.STORAGE_ASSIGNEE_TYPE="type",g.IMAGE_LENGTH="tiff:imageLength",g.IMAGE_WIDTH="tiff:imageWidth",g.NUM_OF_PAGES="xmpTPg:NPages",g.PAGE_START="start",g.PAGE_ORDER_BY="orderBy",g.PAGE_NEXT="next",g.PAGE_COUNT="count",g.PAGE_LIMIT="limit",exports.VersionProperties=void 0,(I=exports.VersionProperties||(exports.VersionProperties={})).REPO_ID="repo:id",I.CREATED="created",I.CREATED_BY="created_by",I.MILESTONE="milestone",I.VERSION="version",I.TOTAL_CHILDREN="total_children",exports.PolicyProperties=void 0,(P=exports.PolicyProperties||(exports.PolicyProperties={})).REPO_ACL="repo:acl",P.REPO_PRINCIPLE="repo:principal",P.REPO_MODIFIER="repo:modifier",P.REPO_PRIVILEGES="repo:privileges",P.REPO_RELATIONS="repo:relations",P.REPO_INHERITANCE="repo:inheritance",exports.PolicyPrincipalProperties=void 0,(A=exports.PolicyPrincipalProperties||(exports.PolicyPrincipalProperties={})).XDM_PROVIDER="xdm:provider",A.ID="@id",A.TYPE="@type",exports.XDMProviderProperties=void 0,(exports.XDMProviderProperties||(exports.XDMProviderProperties={})).ID="@id",exports.EmbeddedMetadataMediaTypes=void 0,(y=exports.EmbeddedMetadataMediaTypes||(exports.EmbeddedMetadataMediaTypes={})).XML="application/rdf+xml",y.JSON="application/ld+json",exports.BlockTransferProperties=void 0,(k=exports.BlockTransferProperties||(exports.BlockTransferProperties={})).REPO_SIZE="repo:size",k.REPO_BLOCK_SIZE="repo:blocksize",k.REPO_REL_TYPE="repo:reltype",k.COMPONENT_ID="component_id",k.DC_FORMAT="dc:format",k.REPO_MD5="repo:md5",k.REPO_EXPIRES="repo:expires",k.REPO_IF_MATCH="repo:if-match",k.MAX_SINGLE_TRANSFER_SIZE="repo:maxSingleTransferSize",k.REPO_MIN_BLOCK_TRANSFER_SIZE="repo:minBlockTransferSize";const D=["buffer","arraybuffer","string","text","blob","json","stream","defaultbuffer"];function m(e,t){var s={};for(var r in e)Object.prototype.hasOwnProperty.call(e,r)&&t.indexOf(r)<0&&(s[r]=e[r]);if(null!=e&&"function"==typeof Object.getOwnPropertySymbols){var o=0;for(r=Object.getOwnPropertySymbols(e);o<r.length;o++)t.indexOf(r[o])<0&&Object.prototype.propertyIsEnumerable.call(e,r[o])&&(s[r[o]]=e[r[o]])}return s}function v(e,t,s,r){return new(s||(s=Promise))((function(o,n){function i(e){try{d(r.next(e))}catch(e){n(e)}}function a(e){try{d(r.throw(e))}catch(e){n(e)}}function d(e){var t;e.done?o(e.value):(t=e.value,t instanceof s?t:new s((function(e){e(t)}))).then(i,a)}d((r=r.apply(e,t||[])).next())}))}function b(e){return this instanceof b?(this.v=e,this):new b(e)}function x(e,t,s){if(!Symbol.asyncIterator)throw new TypeError("Symbol.asyncIterator is not defined.");var r,o=s.apply(e,t||[]),n=[];return r={},i("next"),i("throw"),i("return"),r[Symbol.asyncIterator]=function(){return this},r;function i(e){o[e]&&(r[e]=function(t){return new Promise((function(s,r){n.push([e,t,s,r])>1||a(e,t)}))})}function a(e,t){try{(s=o[e](t)).value instanceof b?Promise.resolve(s.value.v).then(d,c):p(n[0][2],s)}catch(e){p(n[0][3],e)}var s}function d(e){a("next",e)}function c(e){a("throw",e)}function p(e,t){e(t),n.shift(),n.length&&a(n[0][0],n[0][1])}}function O(e){return r.isObject(e)&&["headers","responseType","statusCode","xhr"].every((t=>t in e))}function R(e){return r.isObject(e)&&O(e.response)}function S(e){return r.isObject(e)&&R(e)&&"result"in e}function C(e){return r.isObject(e)&&r.isAnyFunction(e.slice)}function N(e){return r.isObject(e)&&"resolvePullWithBranch"in e}function L(e){return"undefined"!=typeof Blob&&e instanceof Blob}function B(e){return r.isObject(e)&&("string"==typeof e.repositoryId&&"string"==typeof e.path||"string"==typeof e.assetId)}function M(e){return r.isObject(e)&&("AdobeHTTPService"===e.name||r.isAnyFunction(e.invoke))}function w(e){return r.isObject(e)&&M(e.service)}function H(e){if(!r.isObject(e))return!1;const t=e[exports.Properties.LINKS];if(!r.isObject(t))return!1;return!!(t[p.BLOCK_TRANSFER]&&t[p.BLOCK_EXTEND]&&t[p.BLOCK_FINALIZE])}const j=t.newDebug("dcx:assets:service"),U=e=>w(e)?e.service:e,V=e=>w(e)?e.cache:void 0;function X(e,t){j("constructServiceEndpoint()",e);const s=t._repoAPIBaseUrl;return s&&(e=`${s.endsWith("/")?s.substr(0,s.length-1):s}${e}`),j("cSE()",e),e}const K=(t,s,r)=>{if(null==s&&null==r&&null==t)return e._defaultStatusValidator;const o=r||{},i=s||{},a=t||[];return(t,s)=>{var r,d;if(!t||!s)return new n.default(e.ErrorCodes.NETWORK_ERROR,"Invalid or missing status code",void 0,s);if(a.includes(t))return!0;const c=i[t]||(null===(r=e.HTTP_STATUS_ERROR_MAP.get(t))||void 0===r?void 0:r.message)||"Unexpected response",p=o[t]||(null===(d=e.HTTP_STATUS_ERROR_MAP.get(t))||void 0===d?void 0:d.code),l=e._defaultStatusValidator(t,s);return!0===l&&null==p||(e.isAdobeDCXError(l)?l:!!p&&new n.default(p,c,void 0,s))}},F=(e,t=[],s,o)=>{if(!r.isObject(e))throw new n.default(s||n.default.INVALID_PARAMS,o||"Missing or invalid links on Asset");t.map((t=>{if(!(t in e)||!r.isObject(e[t]))throw new n.default(s||n.default.INVALID_PARAMS,o||`Missing required link: ${t}`)}))},G=(e={},t=[])=>{if(0!==t.length){for(let s=0;s<t.length;s++){const o=t[s];if(o in e&&r.isObject(e[o]))return o}throw new n.default(n.default.INVALID_PARAMS,`Missing links, one required: ${t.join(", ")}`)}},z=(e,t,s,o)=>{const i=r.getLinkProperty(e,t,s);if(!i)throw new n.default(n.default.INVALID_DATA,`Missing ${s} param on Link`);if(i!==o)throw new n.default(n.default.INVALID_DATA,`Invalid ${s} param on Link, expected ${o}`)},Y=(e,t=[])=>{try{F(e,t)}catch(e){return!1}return!0},q=(e,t=[])=>!!r.isObject(e)&&Y(e.links||e._links,t);function $(e){if(!B(e))throw new n.default(n.default.INVALID_PARAMS,"Asset must contain links or repositoryId + path or assetId to be resolved.")}function W(e,t,s){if(!r.isObject(e))throw new n.default(n.default.INVALID_PARAMS,`Invalid parameter. Expected object, encountered "${null===e?"null":typeof e}".`);if(!(t in e))throw new n.default(n.default.INVALID_PARAMS,`Invalid parameter object. Expected object containing key "${String(t)}".`);if(s)try{r.validateParam(t,e[t],s)}catch(r){throw new n.default(n.default.INVALID_PARAMS,`Invalid parameter object. Expected object containing key "${String(t)}" with type "${s}", encountered type "${typeof e[t]}".`)}}function Z(e,t,s){if(!(t.length<1)){for(const r of t)try{return void W(e,r,s)}catch(e){}throw new n.default(n.default.INVALID_PARAMS,`Invalid parameter object. Expected object containing one of [${t.join(", ")}]`+(s?` with type ${s}, encountered types [${t.map((t=>typeof e[t])).join(", ")}].`:"."))}}const J=t.newDebug("dcx:assets:util:http");function Q(e,t,s){J("headHTTPResource()");return U(e).invoke(exports.HTTPMethods.HEAD,t,s,void 0,{isStatusValid:K()})}function ee(e,t,s,r){return U(e).invoke(exports.HTTPMethods.GET,t,s,void 0,{isStatusValid:K(),responseType:r})}const te=t.newDebug("dcx:assets:util:serialization");function se(e,t){te("deserializeAsset()");const s={};s.repositoryId=e.repositoryId||e[exports.Properties.REPO_REPOSITORY_ID],s.assetId=e.assetId||e[exports.Properties.REPO_ASSET_ID],s.name=e.name||e[exports.Properties.REPO_NAME],s.size=null!=e.size?e.size:e[exports.Properties.REPO_SIZE],s.path=e.path||e[exports.Properties.REPO_PATH],s.assetClass=e.etag||e[exports.Properties.REPO_ASSET_CLASS],s.etag=e.etag||e[exports.Properties.REPO_ETAG],s.version=e.version||e[exports.Properties.REPO_VERSION],s.format=e.format||e[exports.Properties.DC_FORMAT],s.md5=e.md5,s.createDate=e.createDate||e[exports.Properties.REPO_CREATE_DATE],s.modifyDate=e.modifyDate||e.modifiedDate||e[exports.Properties.REPO_MODIFY_DATE],s.discardDate=e.discardDate||e[exports.Properties.REPO_DISCARD_DATE],s.createdBy=e.createdBy||e[exports.Properties.REPO_CREATED_BY],s.modifiedBy=e.modifiedBy||e[exports.Properties.REPO_MODIFIED_BY],s.discardedBy=e.discardedBy||e[exports.Properties.REPO_DISCARDED_BY],s.deviceCreateDate=e.deviceCreateDate||e[exports.Properties.REPO_DEVICE_CREATE_DATE],s.deviceModifyDate=e.deviceModifyDate||e[exports.Properties.REPO_DEVICE_MODIFY_DATE],s.defaultScheduledDeletionDuration=e.defaultScheduledDeletionDuration||e[exports.Properties.REPO_DEFAULT_SCHEDULED_DELETION_DURATION],s.scheduledDeletionDate=e.scheduledDeletionDate||e[exports.Properties.REPO_SCHEDULED_DELETION_DATE],s.baseAssetId=e.baseAssetId||e[exports.Properties.REPO_BASE_ASSET_ID],s.state=e.state||e[exports.Properties.REPO_STATE],s.links=e.links||e[exports.Properties.LINKS],s.width=e.width||e[exports.Properties.IMAGE_WIDTH],s.length=e.length||e[exports.Properties.IMAGE_LENGTH];const o=[t,e._embedded].flat();return s.embedded=Object.entries({EffectivePrivileges:p.EFFECTIVE_PRIVILAGES,RepositoryResource:p.REPOSITORY,AppMetadata:p.APP_METADATA}).reduce(((e,[t,s])=>(o.filter((e=>e&&s in e)).forEach((o=>r.merge(e,{[t]:s===p.REPOSITORY?re(o):o}))),e)),{}),r.pruneUndefined(s)}function re(e={}){te("deserializeRepository()");const t=e[p.REPOSITORY]?e[p.REPOSITORY]:e;return{repositoryId:t[exports.Properties.REPO_REPOSITORY_ID],repositoryType:t[exports.Properties.REPO_REPOSITORY_TYPE],owner:t[exports.Properties.REPO_OWNER],createDate:t[exports.Properties.REPO_CREATE_DATE],title:t[exports.Properties.DC_TITLE],availableRegions:t[exports.Properties.REPO_AVAILABLE_REGIONS]}}const oe=t.newDebug("dcx:assets:util:link");function ne(e,t){oe("getIndexLinks()");const s=U(e),r=V(e);if(r){const e=r.getIndexLinks();if(e)return i.default.resolve(e);r.setPending("INDEX")}return Q(s,X("/",s),t).then((e=>ae(e))).then((e=>(r&&r.setIndexLinks(e),e))).catch((e=>{throw r&&r.delete("INDEX"),e}))}function ie(e,t){oe("getIndexDocument()");const s=U(e),r=V(e);if(r){const e=r.getIndexRepository();if(e)return i.default.resolve(e)}const o=X("/",s);return s.invoke(exports.HTTPMethods.GET,o,t,void 0,{responseType:"json",isStatusValid:K()}).then((e=>{const t=ae(e),s=e.response,o={};for(const e in s.children){const t=s.children[e],r=t[exports.Properties.LINKS];switch(t[exports.Properties.REPO_PATH]){case"/Index.json":o.indexLinks=r;break;case"/Assets.json":o.assetLinks=r;break;case"/Repositories.json":o.repositoryLinks=r}}return r&&(r.setIndexLinks(t),r.setIndexRepository(o)),o}))}function ae(t){if(!t.headers||!t.headers.link)throw new e.DCXError(e.DCXError.INVALID_DATA,"Failed to parse, missing link header");return de(t.headers.link)}function de(t){try{const e=r.parse(t),s={};for(const t in e.refs){const o=e.refs[t],{rel:n,uri:i,templated:a,type:d,width:c,height:p}=o,l=m(o,["rel","uri","templated","type","width","height"]),h=r.pruneUndefined({href:i,templated:a?"true"===a:void 0,type:d,width:c,height:p,[exports.BlockTransferProperties.MAX_SINGLE_TRANSFER_SIZE]:l[exports.BlockTransferProperties.MAX_SINGLE_TRANSFER_SIZE.toLowerCase()],[exports.BlockTransferProperties.REPO_MIN_BLOCK_TRANSFER_SIZE]:l[exports.BlockTransferProperties.REPO_MIN_BLOCK_TRANSFER_SIZE.toLowerCase()]});["width","height"].filter((e=>e in h)).forEach((e=>{const t=parseInt(h[e],10);isNaN(t)||(h[e]=t)}));const u=s[n];Array.isArray(u)?u.push(h):s[n]=u?[u,h]:h}return Object.assign({},s)}catch(t){throw new e.DCXError(e.DCXError.INVALID_DATA,"Failed to parse, invalid link header",t)}}function ce(t,s){if(r.isObject(this)){if("string"==typeof this.opsHref)return i.default.resolve(this.opsHref);if(r.isFunction(this.opsHref))return i.default.resolve(this.opsHref())}return ne(t,s).then((t=>{try{return r.getLinkHref(t,p.REPO_OPS)}catch(t){throw new e.DCXError(e.DCXError.UNEXPECTED,"Could not get ops href.",t)}}))}const pe=t.newDebug("dcx:assets:operations"),le=t.newDebug("dcx:assets:operations:builder");function he(e,t,s,o,n,i,a){pe("copyAsset()"),r.validateParams(["svc",e,"object"],["srcAsset",t,"object"],["destAsset",s,"object"],["createIntermediates",o,"boolean"],["overwriteExisting",n,"boolean",!0],["manifestPatch",a,["object","string"],!0]),Z(t,["repo:path","path","assetId","repo:assetId"],"string"),Z(s,["repo:path","path","assetId","repo:assetId"],"string");const d=Oe("copy",s,t,{overwriteExisting:n,createIntermediates:o},{"repo:manifestPatch":JSON.stringify(a)}),c=U(e);return ce.call(this,e).then((e=>Ae(c,e,d,i))).then(me.bind(void 0,s)).then(ve)}const ue=e=>"string"==typeof e?{reltype:e,component_id:"",revision:""}:e;function fe(e,t,s,o,n,i){pe("moveAsset()"),r.validateParams(["svc",e,"object"],["srcAsset",t,"object"],["destAsset",s,"object"],["createIntermediates",o,"boolean"],["overwriteExisting",n,"boolean",!0]),Z(t,["repo:path","path","assetId","repo:assetId"],"string"),Z(s,["repo:path","path","assetId","repo:assetId"],"string");const a=Oe("move",s,t,{createIntermediates:o,overwriteExisting:n}),d=U(e);return ce.call(this,e).then((e=>Ae(d,e,a,i))).then(me.bind(void 0,s)).then(ve)}function _e(e,t,s,o,n){pe("discardAsset()"),r.validateParams(["svc",e,"object"],["asset",t,"object"],["etag",s,"string",!0],["recursive",o,"boolean",!0]);const i=U(e);Z(t,["repo:path","path","assetId","repo:assetId"],"string");const a=Oe("discard",Object.assign(Object.assign({},t),{etag:s}),void 0,{recursive:o});return ce.call(this,e).then((e=>Ae(i,e,a,n))).then(be)}function Ee(e,t,s="*",o,i){pe("deleteAsset()"),r.validateParams(["svc",e,"object"],["asset",t,"object"],["etag",s,"string",!0],["recursive",o,"boolean",!0]);const a=U(e);if(t.format===l&&null==o)throw new n.default(n.default.INVALID_PARAMS,"Recursive flag is required for directory assets.");if(!o&&q(t,[p.REPO_METADATA])){const e=r.getLinkHrefTemplated(t,p.REPO_METADATA,{});return a.invoke("DELETE",e,{[exports.HeaderKeys.IF_MATCH]:s},void 0,{isStatusValid:K()}).then(be)}Z(t,["repo:path","path","assetId","repo:assetId"],"string");const d=Object.create(Object.getPrototypeOf(t),Object.getOwnPropertyDescriptors(t));d.etag=s;const c=Oe("delete",d,void 0,{recursive:o});return ce.call(this,e).then((e=>Ae(a,e,c,i))).then(be)}function Te(e,t,s){pe("restoreAsset()"),r.validateParams(["svc",e,"object"],["asset",t,"object"]);const o=U(e);Z(t,["assetId","repo:assetId"],"string");const n=Oe("restore",t);return ce.call(this,e).then((e=>Ae(o,e,n,s))).then(me.bind(void 0,t)).then(ve)}function ge(e,t,s,o,n,i){var a,d;pe("packageAssets()"),r.validateParams(["svc",e,"object"],["destination",s,"object"]),r.validateParam("sources",t,["object","object[]"]),t=r.isArray(t)?t:[t],a=["repo:path","path","assetId","repo:assetId"],d="string",t.map((e=>Z(e,a,d))),Z(s,["repo:path","path","assetId","repo:assetId"],"string");const c=Oe("package",s,t,{createIntermediates:o,overwriteExisting:n}),p=U(e);return ce.call(this,e).then((e=>Ae(p,e,c,i))).then(me.bind(void 0,s)).then(be)}function Ie(e){return{result:(r.isArray(e.response)?e.response:[e.response]).map(Pe),response:e}}function Pe(t){if(!t.error)return t;const s=Object.assign({},t),r=K()(t.error.status);return s.error=e.isAdobeDCXError(r)?r:new n.default(n.default.UNEXPECTED,"Unexpected response"),s._additionalData=t.error,s.error._message=t.error.title,s}function Ae(e,t,s,o){return pe("doOperation()"),r.validateParams(["svc",e,"object"],["opsEndpoint",t,"string"],["operationDocument",s,["string","object"]],["additionalHeaders",o,"object",!0]),function(e,t,s,r={}){return e.invoke(exports.HTTPMethods.POST,t,Object.assign({[exports.HeaderKeys.CONTENT_TYPE]:T},r),"string"==typeof s?s:JSON.stringify(s),{isStatusValid:K(),responseType:"json",retryOptions:{pollCodes:[202],pollHeader:"location",pollMethod:"get"}})}(e,t,s,o).then((e=>{if(e.response=e.response||{},e.response.error)throw new n.default(n.default.UNEXPECTED_RESPONSE,e.response.type||"Operation failed.",new Error(e.response.title),e);return e}))}class ye{constructor(){this.opBatchLimit=100,this._docs=[]}getDocumentEntry(e){return this._docs[e]}getDocument(){return this._docs}get entryCount(){return this._docs.length}copyResources(e,t,s,r,o,n){le("copyResource()"),this._assertUnderLimit(),this._checkSourceType(e),this._checkTargetType(t);const i=this._docs.find(function(e,t){return function(s){return"copy_resources"===s.op&&De(s.source,e)&&De(s.target,t)}}(e,t));if(i)return i.resources=i.resources.concat(s),o&&(i["repo:manifestPatch"]=JSON.stringify(o)),void 0!==r&&(i.intermediates=r),this;const a=Oe("copy_resources",t,e,{createIntermediates:r},{resources:s,"repo:manifestPatch":JSON.stringify(o),additionalHeaders:n});return this._docs.push(a),this}copy(e,t,s,r,o){le("copy()"),this._assertUnderLimit(),this._checkSourceType(e),this._checkTargetType(t);const n=Oe("copy",t,e,{createIntermediates:s,overwriteExisting:r},o);return this._docs.push(n),this}move(e,t,s,r,o){le("move()"),this._assertUnderLimit(),this._checkSourceType(e),this._checkTargetType(t);const n=Oe("move",t,e,{createIntermediates:s,overwriteExisting:r},o);return this._docs.push(n),this}package(e,t,s,o,n){le("package()"),this._assertUnderLimit(),(e=r.isArray(e)?e:[e]).map((e=>{this._checkSourceType(e)})),this._checkTargetType(t);const i=Oe("package",t,e,{createIntermediates:s,overwriteExisting:o},n);return this._docs.push(i),this}discard(e,t,s){le("discard()"),this._assertUnderLimit(),this._checkTargetType(e);const r=Oe("discard",e,void 0,{recursive:t},s);return this._docs.push(r),this}restore(e,t){le("restore()"),this._assertUnderLimit(),Z(e,["assetId","repo:assetId"],"string"),this._checkTargetType(e);const s=Oe("restore",e,void 0,void 0,t);return this._docs.push(s),this}delete(e,t,s){le("delete()"),this._assertUnderLimit(),this._checkTargetType(e);const r=Oe("delete",e,void 0,{recursive:t},s);return this._docs.push(r),this}_assertUnderLimit(){if(this._docs.length>=this.opBatchLimit)throw new n.default(n.default.INVALID_STATE,`Exceeds limit of ${this.opBatchLimit} operations in a single batch.`)}_checkTargetType(e){this._checkSourceOrTargetType(e,"Target")}_checkSourceType(e){this._checkSourceOrTargetType(e,"Source")}_checkSourceOrTargetType(e,t){if(0===[!!e.assetId||!!e["repo:assetId"],!!e.path||!!e["repo:path"]].filter((e=>e)).length)throw new n.default(n.default.INVALID_PARAMS,`${t} identifier is underspecified. Exactly one of [href, repo:path, repo:assetId] required.`);const s=this._getSourceType(e),r="Source"===t?this._batchSourceType:this._batchTargetType;if(r){if(s!==r)throw new n.default(n.default.INVALID_PARAMS,`Operation ${t.toLowerCase()} types must all be the same type. Expected ${r}, encountered ${s}.`)}else"Source"===t?this._batchSourceType=s:this._batchTargetType=s}_getSourceType(e){return e.assetId||e["repo:assetId"]?"id":e.path||e["repo:path"]?e.baseAssetId||e["repo:baseAssetId"]?"pathAndBaseAssetId":"path":void 0}}function ke(){return new ye}function De(e,t){var s,r;return e[exports.Properties.REPO_ASSET_ID]===(null!==(s=t[exports.Properties.REPO_ASSET_ID])&&void 0!==s?s:t.assetId)&&e[exports.Properties.REPO_REPOSITORY_ID]===(null!==(r=t[exports.Properties.REPO_REPOSITORY_ID])&&void 0!==r?r:t.repositoryId)}function me(e,t){return t.response.asset=Object.assign(Object.assign({},t.response.asset||{}),{repositoryId:e.repositoryId||e["repo:repositoryId"]}),t}function ve(e){return{response:e,result:se(e.response.asset)}}function be(e){return{response:e,result:{success:e.statusCode>199&&e.statusCode<400}}}function xe(e,t,s){if(pe("_convertToACPSource()"),"object"!=typeof t)return;const o={"repo:repositoryId":t.repositoryId||t["repo:repositoryId"],"repo:path":t.path||t["repo:path"],"repo:assetId":t.assetId||t["repo:assetId"],"repo:baseAssetId":t.baseAssetId||t["repo:baseAssetId"]};return"string"==typeof o.href?(delete o["repo:path"],delete o["repo:assetId"],delete o["repo:baseAssetId"]):"string"==typeof o["repo:assetId"]&&(delete o["repo:path"],delete o["repo:baseAssetId"]),"target"===e?!0===s?o[exports.HeaderKeys.IF_MATCH]=t.format!==a.Directory&&t["dc:format"]!==a.Directory&&t.etag||"*":!1===s?o[exports.HeaderKeys.IF_NONE_MATCH]="*":t.format!==a.Directory&&t["dc:format"]!==a.Directory&&(o[exports.HeaderKeys.IF_MATCH]=t.etag):t.format!==a.Directory&&t["dc:format"]!==a.Directory&&(o[exports.HeaderKeys.IF_MATCH]=t.etag||"*"),t.version&&(o["repo:version"]=t.version),o["repo:path"]&&W(o,"repo:repositoryId","string"),pe("_cTACPS() out",o),r.pruneUndefined(o)}function Oe(e,t,s,o={},n={}){pe("_buildOperationDoc()");const i=r.pruneUndefined({op:e,target:t,source:r.isArray(s)?[]:s?{}:void 0}),{overwriteExisting:a,createIntermediates:d,recursive:c}=o;if(i.source&&(i.source=r.isArray(s)?s.map((e=>xe("source",e,a))).filter((e=>null!=e)):xe("source",s,a)),"object"==typeof t){const e=xe("target",t,a);e&&(i.target=e)}return null==i.target["repo:assetId"]&&null!=d&&(i.intermediates=d),null!=c&&(i.recursive=c),Object.assign(i,n),pe("_OD() doc",i),i}function Re(t,s,o,n,i,a,d){r.validateParams(["resources",n,"array",!1]);const c=ke().copyResources(s,o,n,i,a).getDocument();return ce(t).then((e=>Ae(U(t),e,c,d))).then(e._handleErrorResponsePayload).then((e=>{const{asset:t,source:s,target:r,resources:o}=e.response[0];return{result:{source:se(s),target:se(r),resources:o,asset:t?se(t):void 0},response:e}}))}const Se=t.newDebug("dcx:assets:block_transfer"),Ce=10485760,Ne=52428800,Le=Ce/4;let Be=Ne;function Me(e,t){const s=function(e){return we(e,exports.BlockTransferProperties.REPO_MIN_BLOCK_TRANSFER_SIZE)}(e);if(s&&t<s)return!1;const r=He(e);return!!(r&&t>r)||t>Ce}function we(e,t){if(!Y(e.links,[p.BLOCK_UPLOAD_INIT]))return;const s=r.getLinkProperty(e.links,p.BLOCK_UPLOAD_INIT,t);return s?parseInt(s):void 0}function He(e){return we(e,exports.BlockTransferProperties.MAX_SINGLE_TRANSFER_SIZE)}const je=e=>"string"==typeof e?e.length>=Le?r.stringToBuffer(e).byteLength:e.length:"size"in e?e.size:e.byteLength,Ue=(t,s)=>{if(!r.isFunction(t))return t;if(t.length<2)throw new e.DCXError(e.DCXError.INVALID_PARAMS,"GetSliceCallback is expected to accept 2 parameters");if(void 0===s||isNaN(s)||s<0)throw new e.DCXError(e.DCXError.INVALID_PARAMS,"Size parameter should indicate total number of bytes to be read from GetSliceCallback");return{getSlice:t,size:s}},Ve=()=>Be;function Xe(e,t,s,o){const n=r.parseHeaders(o);return{id:t,length:s,type:e,links:de(n.link),etag:n.etag,location:n.location,version:n.version,revision:n.revision,md5:n["content-md5"]}}function Ke(e){return new Promise((t=>{let s;e.finally((()=>{clearTimeout(s),t(void 0)})),function o(){["blockUpload","blockDownload"].forEach((n=>{if(r.isObject(e[n]))return clearTimeout(s),t(e[n]);clearTimeout(s),s=setTimeout(o,1)}))}()}))}var Fe;exports.BlockTransferStates=void 0,(Fe=exports.BlockTransferStates||(exports.BlockTransferStates={})).NOT_INITIALIZED="NOT_INITIALIZED",Fe.INITIALIZING="INITIALIZING",Fe.INITIALIZED="INITIALIZED",Fe.WAITING="WAITING",Fe.STARTED="STARTED",Fe.PAUSING="PAUSING",Fe.PAUSED="PAUSED",Fe.CANCELED="CANCELED",Fe.ERROR="ERROR",Fe.FINALIZING="FINALIZING",Fe.COMPLETE="COMPLETE";const Ge=new class{constructor(){this._uploads=[],this._downloads=[],this._pendingUploadRequests=[],this._pendingDownloadRequests=[],this._downloadChunkSize=10485760}get downloads(){return this._downloads}get uploads(){return this._uploads}set downloadChunkSize(e){r.validateParams(["downloadChunkSize",e,"+number"]),this._downloadChunkSize=e}get downloadChunkSize(){return this._downloadChunkSize}get pendingUploadRequests(){return this._pendingUploadRequests}get pendingDownloadRequests(){return this._pendingDownloadRequests}resetUploads(){this._uploads=[],this._pendingUploadRequests=[]}addAndStartUpload(e){return this._addAndStart("upload",e)}addAndStartDownload(e){return e.state!==exports.BlockTransferStates.INITIALIZED?Promise.resolve(e):this._addAndStart("download",e)}startNextWaiting(e){const t="upload"===e?this._uploads:this._downloads,s=[];let r=!1;for(const e of t)!r&&e&&e.state===exports.BlockTransferStates.WAITING?(e.start(),r=!0):e.state!==exports.BlockTransferStates.CANCELED&&e.state!==exports.BlockTransferStates.ERROR&&e.state!==exports.BlockTransferStates.FINALIZING&&e.state!==exports.BlockTransferStates.COMPLETE||s.push(e);const o=t.filter((e=>!s.includes(e)));"download"===e?this._downloads=o:this._uploads=o}_addAndStart(e,t){const s="upload"===e?this._uploads:this._downloads;return 0===s.filter((e=>e&&(e.state===exports.BlockTransferStates.NOT_INITIALIZED||e.state===exports.BlockTransferStates.INITIALIZED||e.state===exports.BlockTransferStates.INITIALIZING||e.state===exports.BlockTransferStates.STARTED))).length?t.start():t._setWaiting(),s.push(t),t.promise}},ze=t.newDebug("dcx:assets:blockdownload"),Ye=t.newDebug("dcx:assets:blockdownload:leaf");const qe=function*(){let e=0;for(;;)yield e++}();class $e extends r.EventEmitter{constructor(e,t,s={}){super(["stateChanged"]),this._state=exports.BlockTransferStates.NOT_INITIALIZED,this._cachedBlocks=new Map,this._blockRequestIndex=0,this._blockHandledIndex=0,this._currentByteRange=[void 0,void 0],this._pending=[],ze("constructor");const{startByte:o,blockSize:n,endByte:a,url:d,totalSize:c,maxConcurrentRequests:p}=Object.assign({blockSize:Ge.downloadChunkSize,maxConcurrentRequests:4},r.pruneUndefined(s));r.validateParams(["svc",e,"object"],["responseType",t,"enum",!1,["buffer"]],["blockSize",n,"+number"],["url",d,"string",!0],["startByte",o,"number",!0],["endByte",a,"number",!0],["totalSize",c,"number",!0],["maxConcurrentRequests",p,"+number"]),this._dbgId=qe.next().value,this._maxConcurrentRequests=p,this._blockSize=Math.round(n),this._service=e,this._url=d,this._startByte=o,this._endByte=a,this._totalSize=c,this._bytes=new Uint8Array,this._promise=new i.default(((e,t)=>{this._resolve=()=>{ze(this._dbgId,"resolving"),this.removeAllHandlers(),e(this)},this._reject=e=>{ze(this._dbgId,"rejecting: ",e),this.removeAllHandlers(),t(e)}}))}get contentType(){var e;return null!==(e=this._contentType)&&void 0!==e?e:""}get totalSize(){return this._totalSize}get buffer(){return this._bytes}get state(){return this._state}get promise(){return this._promise}_requestBlock(e,t,s,r){ze(this._dbgId,"_requestBlock(): ",e,t,s,r);const o=Qe(e,t);return this._service.invoke(exports.HTTPMethods.GET,this._url,o,void 0,{responseType:"defaultbuffer",isStatusValid:K(),isExternalRequest:!0}).then((e=>({response:e,index:s,lane:r}))).catch(this._handleErrorAndThrow.bind(this))}init(e=this._url,t=this._totalSize){if(ze(this._dbgId,"init(): ",e,t),this._state===exports.BlockTransferStates.INITIALIZED&&e===this._url&&t===this._totalSize)return i.default.resolve(this);if(this._assertStateIsValid("init"),this._shiftState(exports.BlockTransferStates.INITIALIZING),this._url=e,this._initByteRange(t),this._totalSize!==1/0||null==this._currentByteRange[0])return this._shiftState(exports.BlockTransferStates.INITIALIZED),i.default.resolve(this);const{startByte:s,endByte:r,blockIndex:o}=this._nextBlockData();let n=exports.BlockTransferStates.INITIALIZED;return this._requestBlock(s,r,o,0).then((e=>(this._updateTotalSize(e),(!r||r>this._endByte)&&(n=exports.BlockTransferStates.FINALIZING),e))).then(this._handleBlock.bind(this)).then((()=>this._shiftState(n))).catch(this._handleErrorAndThrow.bind(this))}start(){if(ze(this._dbgId,"start()"),this._assertStateIsValid("start"),this._shiftState(exports.BlockTransferStates.STARTED),null!=this._currentByteRange[0])return this._start(),this._promise;const[e,t]=this._currentByteRange,s=this._blockRequestIndex;return this._blockRequestIndex+=1,this._currentByteRange=[t+1,t],this._requestBlock(e,t,s,0).then(this._handleBlock.bind(this)).catch(this._handleError.bind(this)),this._promise}pause(){return ze(this._dbgId,"pause()"),this._assertStateIsValid("pause"),this._shiftState(exports.BlockTransferStates.PAUSING),i.default.allSettled(this._pending).then((()=>(this._shiftState(exports.BlockTransferStates.PAUSED),Ge.startNextWaiting("download"),this)))}resume(){return ze(this._dbgId,"resume()"),this.state===exports.BlockTransferStates.PAUSED&&(this._shiftState(exports.BlockTransferStates.STARTED),this._start()),this}cancel(){return ze(this._dbgId,"cancel()"),this._assertStateIsValid("cancel"),this._shiftState(exports.BlockTransferStates.CANCELED),this._reject(new n.default(n.default.ABORTED,"BlockDownload aborted.")),Ge.startNextWaiting("download"),this._promise}_setWaiting(){this._shiftState(exports.BlockTransferStates.WAITING)}_start(){ze(this._dbgId,"_start()");for(let e=0;e<this._maxConcurrentRequests;e++)this._loop(e).catch(this._handleError.bind(this))}get _loopShouldContinue(){const e=this._state===exports.BlockTransferStates.STARTED&&this._currentByteRange[0]<=this._endByte;return ze(this._dbgId,"_loopShouldContinue() ",e,this._currentByteRange,this._endByte),e}_loop(e){return v(this,void 0,void 0,(function*(){ze(this._dbgId,"_loop(): ",e);let t=!1;for(;this._loopShouldContinue&&!t;){const{startByte:s,endByte:r,blockIndex:o,done:n}=this._nextBlockData();t=n;const i=this._requestBlock(s,r,o,e).then(this._handleBlock.bind(this)).catch(this._handleError.bind(this));this._pending[e]=i,yield i}ze(this._dbgId,`_loop(${e}) done, ${t}`),t&&(ze(this._dbgId,`_loop(${e}) finalize`),this._shiftState(exports.BlockTransferStates.FINALIZING))}))}_nextBlockData(){ze(this._dbgId,"_nextBlockData()");const e=this._blockRequestIndex;this._blockRequestIndex+=1;const[t,s]=this._currentByteRange;this._currentByteRange[0]+=this._blockSize,this._currentByteRange[1]=Math.min(this._currentByteRange[1]+this._blockSize,this._endByte);return{startByte:t,endByte:s,blockIndex:e,done:s>=this._endByte}}_initByteRange(e=this._totalSize){if(ze(this._dbgId,"_initByteRange(): ",e),this._totalSize=e,null!=this._totalSize&&this._totalSize<0)throw new n.default(n.default.INVALID_PARAMS,"Total size must be positive.");if(this._totalSize||(this._totalSize=1/0),this._endByte||(this._endByte=this._totalSize),!this._startByte&&this._endByte===this._totalSize)return this._startByte=0,void(this._currentByteRange=[0,this._blockSize-1]);if(!this._startByte&&this._endByte<0&&this._totalSize!==1/0?(this._startByte=Math.max(0,this._totalSize+this._endByte),this._endByte=this._totalSize):!this._startByte&&this._endByte>0&&(this._startByte=0),null!=this._startByte&&(this._currentByteRange[0]=Math.max(this._startByte,0)),(null==this._endByte||this._endByte>0)&&(this._currentByteRange[1]=Math.min(this._endByte,(this._startByte||0)+this._blockSize-1)),null!=this._startByte||this._endByte===1/0)return;if(this._totalSize===1/0){if(-this._endByte>this._blockSize)throw new n.default(n.default.INVALID_PARAMS,"Cannot download last N bytes without a total size.");return void(this._currentByteRange=[void 0,this._endByte])}this._startByte=Math.max(0,this._totalSize+this._endByte),this._endByte=this._totalSize;const t=Math.min(this._startByte+this._blockSize-1,this._endByte);this._currentByteRange=[this._startByte,t]}_finalize(){return ze(this._dbgId,"_finalize() start"),Ge.startNextWaiting("download"),i.default.allSettled(this._pending).then((()=>{this._checkCachedBlocks(),this._shiftState(exports.BlockTransferStates.COMPLETE)}))}_updateTotalSize(e){if(ze(this._dbgId,"_updateTotalSize()"),null==this._totalSize||this._totalSize===1/0)try{const t=e.response.headers["content-range"],s=parseInt(t.split("/")[1]);r.assert((()=>!isNaN(s)),"Invalid number."),this._totalSize=s,this._endByte===1/0&&(this._endByte=this._totalSize)}catch(t){throw new n.default(n.default.INVALID_DATA,"Could not determine total size.",t,e.response)}return ze(this._dbgId,"_uTS(): ",this._totalSize,this._endByte),e}_handleError(t){ze(this._dbgId,"_handleError(): ",t),this._shiftState(exports.BlockTransferStates.ERROR),this._error=t,e.isAdobeDCXError(t)||(this._error=new n.default(n.default.UNEXPECTED,"An unexpected error occurred.",t)),this._reject(this._error)}_handleErrorAndThrow(e){throw this._handleError(e),this._error}_handleBlock(e){this._endByte===1/0&&this._updateTotalSize(e);const{index:t,response:s}=e;if(ze(this._dbgId,`_handleBlock(${t})`),t!==this._blockHandledIndex)return ze(this._dbgId,`_handleBlock(${t}) cached`),void this._cachedBlocks.set(t,e);ze(this._dbgId,`_handleBlock(${t}) handled`),this._pushBlockData(s),this._markCurrentBlockHandled()}_markCurrentBlockHandled(){this._cachedBlocks.delete(this._blockHandledIndex),this._blockHandledIndex+=1,this._checkCachedBlocks()}_checkCachedBlocks(){const e=this._cachedBlocks.get(this._blockHandledIndex);e&&this._handleBlock(e)}_pushBlockData(e){if(this._state===exports.BlockTransferStates.ERROR)return;this._contentType=this._contentType||e.headers[exports.HeaderKeys.CONTENT_TYPE];const t="undefined"!=typeof Buffer&&e.response instanceof Buffer?e.response:new Uint8Array(e.response);this._bytes=r.concatUint8Arrays(this._bytes,t)}_shiftState(e){return ze(this._dbgId,"_shiftState(): ",e),this._state===exports.BlockTransferStates.COMPLETE||this._state===exports.BlockTransferStates.ERROR||this._state===exports.BlockTransferStates.CANCELED||(this._state=e,this.emit("stateChanged",[this._state,this]),e===exports.BlockTransferStates.FINALIZING&&this._finalize(),e===exports.BlockTransferStates.COMPLETE&&Promise.all(this._pending).then(this._resolve.bind(this))),this}_assertStateIsValid(e,t=this._state){ze(this._dbgId,"_assertStateIsValid() ",e,t);let s=!1;const r="Invalid state transition.";switch(e){case"init":t===exports.BlockTransferStates.NOT_INITIALIZED&&(s=!0);break;case"start":t!==exports.BlockTransferStates.INITIALIZED&&t!==exports.BlockTransferStates.WAITING&&t!==exports.BlockTransferStates.STARTED||(s=!0);break;case"pause":t!==exports.BlockTransferStates.INITIALIZING&&t!==exports.BlockTransferStates.STARTED||(s=!0);break;case"cancel":s=!0}if(!s)throw ze(this._dbgId,"_aSIV() throw ",r),new n.default(n.default.INVALID_STATE,r,void 0,void 0,{method:e,currentState:t})}}function We(e,t,s){return new $e(e,t,s)}function Ze(e,t,s,o,a="defaultbuffer",d,c,p){Ye("_doBlockDownload()");const l="stream"===a?void 0:We(e,"buffer",{startByte:s,endByte:o});(null!=this?this:{}).blockDownload=l;let h=i.default.resolve(t,void 0!==this?this:{});return d||(h=h.then((()=>e.invoke(exports.HTTPMethods.GET,t,Object.assign({priority:"u=1"},p),void 0,{responseType:"text",isStatusValid:K(),retryOptions:{pollCodes:[202],pollHeader:"location",pollMethod:"GET"}}))).then((e=>{const t=e.response.indexOf("href")>0?r.getFirstRegexpCapture(e.response,'"href":\\s*"([^;"]*)"'):"";if("string"!=typeof t||""===t)throw new n.default(n.default.UNEXPECTED_RESPONSE,"No block download href found in response.",void 0,e);return c=c||parseInt(r.getFirstRegexpCapture(e.response,'"size":\\s*(\\d+)')),t}))),h.then((t=>v(this,void 0,void 0,(function*(){return l?Promise.race([l.init(t,c).then((()=>Ge.addAndStartDownload(l))),l.promise]).then((()=>({statusCode:200,headers:r.pruneUndefined({[exports.HeaderKeys.CONTENT_TYPE]:l.contentType,[exports.HeaderKeys.CONTENT_LENGTH]:l.totalSize}),responseType:a,response:Je(l.buffer,a,l.contentType),message:"OK"}))):e.invoke(exports.HTTPMethods.GET,t,Qe(s,o),void 0,{responseType:"stream",isExternalRequest:!0})}))))}function Je(e,t,s){if("defaultbuffer"===t||"buffer"===t||"arraybuffer"===t)return e.buffer;if("blob"===t)return new Blob([e],{type:s});const o=r.arrayBufferToString(e);if("text"===t)return o;try{return JSON.parse(o)}catch(e){return o}}function Qe(e,t){if(null==e&&null==t)return{};return{range:`bytes=${null!=e?e:null!=t&&t>0?"0":""}-${null!=t?Math.abs(t):""}`}}const et=t.newDebug("dcx:assets:private");function tt(t,s,o,n,a="defaultbuffer",d,c,l={},h=!1){let u;et("_getUrlFallbackDirect()");const f=void 0!==this?this:{};return i.default.resolve(void 0,f).then((()=>t.invoke(exports.HTTPMethods.GET,o,Object.assign({priority:"u=1"},l),void 0,{responseType:a,isStatusValid:K([400])}))).then((e=>(et("_gUFD() status code",e.statusCode),u=e,400===e.statusCode&&e.xhr?e.xhr.getResponseDataAsJSON():e))).then((t=>{const s=r.isObject(t)&&(400===u.statusCode||400===t.status)&&t.type===e.ProblemTypes.RESPONSE_TOO_LARGE;if(et("_gUFD() do direct",s),!s&&400===u.statusCode)throw new e.DCXError(e.DCXError.UNEXPECTED_RESPONSE,"Unexpected response",void 0,u);return s})).then((o=>{if(!o)return u;if(!("location"in u.headers)||"string"!=typeof u.headers.location){if(!Y(s.links,[p.BLOCK_DOWNLOAD]))throw new e.DCXError(e.DCXError.INVALID_DATA,"Resource too large and missing download link.");const o=r.pruneUndefined({reltype:n,component_id:d,revision:c}),i=r.getLinkHrefTemplated(s.links,p.BLOCK_DOWNLOAD,{resource:n?JSON.stringify(o):void 0});return h?{statusCode:200,headers:r.pruneUndefined({[exports.HeaderKeys.CONTENT_TYPE]:u.headers["content-type"],[exports.HeaderKeys.CONTENT_LENGTH]:u.headers["content-length"]}),responseType:a,response:{href:i},message:"OK"}:Ze.call(f,t,i,void 0,void 0,a,!1,void 0,l)}return h?{statusCode:200,headers:r.pruneUndefined({[exports.HeaderKeys.CONTENT_TYPE]:u.headers["content-type"],[exports.HeaderKeys.CONTENT_LENGTH]:u.headers["content-length"]}),responseType:a,response:{href:u.headers.location},message:"OK"}:Ze.call(f,t,u.headers.location,void 0,void 0,a,!0,void 0,l)}))}function st({additionalHeaders:t={},asset:s,contentType:o,data:n,etag:i,headHref:a,href:d,maybeIsNew:c,relation:p,service:l},h=!1){if(et("_doUpload()"),r.validateParams(["service",l,"object"],["asset",s,"object"],["href",d,"string"],["headHref",a,"string"],["contentType",o,"string",!0],["maybeIsNew",c,"boolean",!0],["etag",i,"string",!0],["isRetry",h,"boolean",!0],["additionalHeaders",t,"object",!0]),null==c)return l.invoke(exports.HTTPMethods.HEAD,a,t,void 0,{isStatusValid:K([404])}).then((e=>{const r=200!==e.statusCode;return st({additionalHeaders:t,asset:s,contentType:o,data:n,etag:i,headHref:a,href:d,maybeIsNew:r,relation:p,service:l},h)}));const u=c;return u?delete t[exports.HeaderKeys.IF_MATCH]:t[exports.HeaderKeys.IF_MATCH]=i||"*",o&&(t[exports.HeaderKeys.CONTENT_TYPE]=o),l.invoke(exports.HTTPMethods.PUT,d,t,n,{isStatusValid:K([404,409,412]),retryOptions:{pollHeader:"location",pollCodes:[202]}}).then((r=>{const c=r.statusCode;if(c>400&&!h){if(null!=i)throw K()(c,r);if(!u&&404===c)return st({additionalHeaders:t,asset:s,contentType:o,data:n,etag:i,headHref:a,href:d,maybeIsNew:!0,relation:p,service:l},!0);if(404===c)throw new e.DCXError(e.DCXError.NOT_FOUND,"Unexpected response",void 0,r);if(409===c||412===c)return st({additionalHeaders:t,asset:s,contentType:o,data:n,etag:i,headHref:a,href:d,maybeIsNew:void 0,relation:p,service:l},!0)}return r}))}const rt=t.newDebug("dcx:assets:bulk");function ot(e,t){const s="\r\n";let o=Uint8Array.from([]);for(let n=0;n<e.length;n++){const i=e[n];o=0===n?r.concatUint8Arrays(o,r.stringToBuffer(`--${t}${s}`)):r.concatUint8Arrays(o,r.stringToBuffer(`${s}--${t}${s}`)),o=r.concatUint8Arrays(o,r.stringToBuffer(`${[exports.HeaderKeys.CONTENT_TYPE]}: application/http${s}`)),o=r.concatUint8Arrays(o,r.stringToBuffer(`${s}${i.method} ${i.href}`));let a=!1;for(const e in i.headers){const t=e.toLowerCase();"content-length"===t&&(a=!0),o=r.concatUint8Arrays(o,r.stringToBuffer(`${s}${t}: ${i.headers[e]}`))}if(i.body){const e=nt(i.body);a||(o=r.concatUint8Arrays(o,r.stringToBuffer(`${s}content-length: ${e.length}`))),o=r.concatUint8Arrays(o,r.stringToBuffer(`${s}${s}`)),o=r.concatUint8Arrays(o,e)}}return o=r.concatUint8Arrays(o,r.stringToBuffer(`${s}--${t}--${s}`)),o}function nt(t){if("string"==typeof t)return r.stringToBuffer(t);if(r.isArrayBuffer(t))return new Uint8Array(t);if(C(t))return t;throw new e.AdobeDCXError(e.AdobeDCXError.INVALID_PARAMS,"Bulk subrequest body expecting string | ArrayBuffer | Buffer")}function it(t,s){const o=t.headers[exports.HeaderKeys.CONTENT_TYPE];if(!o)throw new e.AdobeDCXError(e.AdobeDCXError.UNEXPECTED_RESPONSE,"Missing boundary header in multipart response");const n=o.split("=")[1],i=function(e,t){const s=new Uint8Array(e),o=r.stringToBuffer(`--${t}`),n=dt(s,at(s,o),o.byteLength);return n.map((e=>ct(e,!0)))}(t.response,n);if(s&&i.length!==s)throw new e.AdobeDCXError(e.AdobeDCXError.UNEXPECTED_RESPONSE,`Unexpected number of parts; Expected ${s}, Received ${i.length}`);return i}function at(e,t){const s=new Array(256).fill(-1),r=[];for(let e=0;e<t.length;e++)s[t[e]]=e;let o=0;for(;o<=e.length-t.length;){let n=t.length-1;for(;n>=0&&t[n]===e[o+n];)n--;n<0?(r.push(o),o+=o+t.length<e.length?t.length-s[e[o+t.length]]:1):o+=Math.max(1,n-s[e[o+n]])}return r}function dt(e,t,s,r=!1){let o=r?0:void 0;const n=[];for(const r of t)void 0!==o&&n.push(e.subarray(o,r)),o=r+s;return r&&n.push(e.subarray(o)),n}function ct(e,t=!1){const s=r.stringToBuffer("\r\n\r\n"),o=at(e,s).slice(0,2),n=r.stringToBuffer("\n\n"),i=dt(e,...o.length>0?[o,s.byteLength]:[at(e,n).slice(0,2),n.byteLength],!0),a=i.slice(0,t||i.length>1?2:1).reduce(((e,t)=>Object.assign(e,r.parseHeaders(r.arrayBufferToString(t)))),{}),d=i.length>1?i[i.length-1]:void 0,c=parseInt(r.arrayBufferToString(i[t?1:0]).split("\r\n",1)[0].split(" ")[1]),p=parseInt(a["content-length"],10);let l;return l=isNaN(p)?0===(null==d?void 0:d.length)?new Uint8Array([]):d:0===p?new Uint8Array([]):null==d?void 0:d.subarray(0,p),{headers:a,response:a[exports.HeaderKeys.CONTENT_TYPE]===f&&void 0!==l?JSON.parse(r.arrayBufferToString(l)):l,statusCode:c}}function pt(t){if(t.length>10)throw new e.AdobeDCXError(e.AdobeDCXError.INVALID_PARAMS,"A single bulk request can only contain a maximum of 10 sub-requests.");const{writeOperations:s,readOperations:r}=t.reduce(((t,s)=>{if("string"!=typeof s.href)throw new e.AdobeDCXError(e.AdobeDCXError.INVALID_PARAMS,"A sub-request of the bulk operation is missing an href");if("string"!=typeof s.method)throw new e.AdobeDCXError(e.AdobeDCXError.INVALID_PARAMS,"A sub-request of the bulk operation is missing the HTTP method");const r=s.method.toUpperCase();if(!Object.values(exports.HTTPMethods).includes(r))throw new e.AdobeDCXError(e.AdobeDCXError.INVALID_PARAMS,"A sub-request of the bulk operation includes an invalid HTTP method");return[exports.HTTPMethods.GET,exports.HTTPMethods.HEAD].includes(r)?t.readOperations.push(s):t.writeOperations.push(s),t}),{readOperations:[],writeOperations:[]});if(s.length>0&&r.length>0)throw new e.AdobeDCXError(e.AdobeDCXError.INVALID_PARAMS,"Cannot mix READ and WRITE operations in bulk sub requests.")}function lt(e,t,s,o="id",n={},i=!1){return rt("performBulkRequest()"),r.validateParams(["svc",e,"object"],["asset",t,"object"],["requests",s,"array"],["linkMode",o,"string",!0,["id","path"]]),F(t.links,[p.BULK_REQUEST]),pt(s),ht(e,t,s,o,n).then((({response:r,subresponses:a})=>v(this,void 0,void 0,(function*(){const d=ut(a,s);return{result:i?yield ft(e,t,d,o,n,a):a,response:r}}))))}function ht(e,t,s,o="id",n={}){const i=`boundary-${Date.now()}`,a=ot(s,i),d=Object.assign(Object.assign({},n),{[exports.HeaderKeys.CONTENT_TYPE]:`multipart/mixed;boundary=${i}`}),c=r.getLinkHref(t.links,p.BULK_REQUEST,o);return e.invoke(exports.HTTPMethods.POST,c,d,a,{isStatusValid:K(),responseType:"defaultbuffer",retryOptions:{pollHeader:"location",pollCodes:[202],pollMethod:exports.HTTPMethods.GET}}).then((e=>({response:e,subresponses:it(e,s.length)})))}function ut(e,t){return e.filter((({statusCode:e})=>r.checkRetriable(e))).map((e=>t.find((({href:t})=>t===e.headers["content-id"])))).filter((e=>e))}function ft(e,t,s,r="id",o={},n,i=5){return v(this,void 0,void 0,(function*(){if(0===s.length||i<=0)return n;if(1===s.length){const[t]=s,r=yield U(e).invoke(t.method,t.href,t.headers,t.body,{isStatusValid:K(),responseType:"defaultbuffer",retryOptions:{pollHeader:"location",pollCodes:[202],pollMethod:exports.HTTPMethods.GET}});return r.headers["content-id"]=t.href,n.map((e=>"content-id"in e.headers&&e.headers["content-id"]===r.headers["content-id"]?r:e))}const a=yield ht(e,t,s,r,o).then((n=>v(this,void 0,void 0,(function*(){const a=ut(n.subresponses,s);return a.length?yield ft(e,t,a,r,o,n.subresponses,i-1):n.subresponses}))));return n.map((e=>a.find((t=>t.headers["content-id"]===e.headers["content-id"]))||e))}))}const _t=t.newDebug("dcx:assets:asset"),Et=t.newDebug("dcx:assets:asset:leaf");class Tt{constructor(e,t,s={}){this.type=a.Asset,this._data={},this._data=se(e),this._svc=U(t),this._cache=V(t),this._links=r.merge({},e.links||{},e._links||{},s)}setLinks(e){this._links=e,this._updateCachedLinks()}get links(){return this._links}set links(e){this.setLinks(e)}setLink(e,t){this._links[e]=t,this._updateCachedLinks()}getLink(e){return this._links[e]}removeLink(e){delete this._links[e],this._updateCachedLinks()}_updateCachedLinks(){this._cache&&this._cache.setValueWithAsset(this.links,this.asset)}getLinkProperty(e,t,s="id"){return _t("getLinkProperty()"),r.getLinkProperty({_links:this._links},e,t,s)}getLinkHrefTemplated(e,t,s="id"){return _t("getLinkHrefTemplated()"),r.getLinkHrefTemplated({_links:this._links},e,t,s)}getLinkHref(e,t="id"){return _t("getLinkHref()"),r.getLinkHref({_links:this._links},e,t)}get asset(){return Object.assign(Object.assign({},this._data),this.links)}get serviceConfig(){return{service:this._svc,cache:this._cache}}get repositoryId(){return this._data.repositoryId}set repositoryId(e){this._data.repositoryId=e}get assetId(){return this._data.assetId}set assetId(e){this._data.assetId=e}get path(){return this._data.path}set path(e){this._data.path=e}get name(){return this._data.name}get etag(){return this._data.etag}set etag(e){this._data.etag=e}get version(){return this._data.version}set version(e){this._data.version=e}get format(){return this._data.format}set format(e){this._data.format=e}get assetClass(){return this._data.assetClass}get createDate(){return this._data.createDate}get modifyDate(){return this._data.modifyDate}get discardDate(){return this._data.discardDate}get createdBy(){return this._data.createdBy}get modifiedBy(){return this._data.modifiedBy}get discardedBy(){return this._data.discardedBy}get deviceCreateDate(){return this._data.deviceCreateDate}get deviceModifyDate(){return this._data.deviceModifyDate}get baseAssetId(){return this._data.baseAssetId}set baseAssetId(e){this._data.baseAssetId=e}get state(){return this._data.state}get size(){return this._data.size}set size(e){this._data.size=e}get md5(){return this._data.md5}set defaultScheduledDeletionDuration(e){this._data.defaultScheduledDeletionDuration=e}get defaultScheduledDeletionDuration(){return this._data.defaultScheduledDeletionDuration}set scheduledDeletionDate(e){this._data.scheduledDeletionDate=e}get scheduledDeletionDate(){return this._data.scheduledDeletionDate}set width(e){this._data.width=e}get width(){return this._data.width}set length(e){this._data.length=e}get length(){return this._data.length}fetchLinksIfMissing(e=[],t){return _t("fetchLinksIfMissing()"),Kt(this.serviceConfig,this,e,void 0,t).then((({result:e,response:t})=>(this._updateDataWithResponse(t),this)))}useLinkOrResolveResource(e,t){return _t("useLinkOrResolveResource()"),Ht(this.serviceConfig,this,e,t).then((e=>(this._updateDataWithResponse(e.response),this.setLinks(r.merge(this.links,e.result.links)),e)))}headPrimaryResource(e){return _t("headPrimaryResource()"),this.fetchLinksIfMissing([p.PRIMARY],e).then((()=>It(this.serviceConfig,this,e))).then((e=>(this._updateDataWithResponse(e),e)))}getRepoMetadata(){return _t("getRepoMetadata()"),this.useLinkOrResolveResource(p.REPO_METADATA,"json").then((e=>{this._data=r.merge(this._data,e.result,se(e.response.response));const t=e.response.response;return t&&t._links&&this.setLinks(r.merge(this.links,t._links)),{result:this._data,response:e.response}}))}headAppMetadata(e){return _t("headAppMetadata()"),this.fetchLinksIfMissing([p.APP_METADATA],e).then((()=>Ot(this.serviceConfig,this)))}getAppMetadata(e,t){return _t("getAppMetadata()"),r.validateParams(["etag",e,"string",!0]),this.fetchLinksIfMissing([p.APP_METADATA],t).then((()=>Rt(this._svc,this,e,t)))}putAppMetadata(e,t,s){return _t("putAppMetadata()"),r.validateParams(["etag",t,"string",!0],["metadata",e,["object","string"]]),this.fetchLinksIfMissing([p.APP_METADATA],s).then((()=>St(this._svc,this,e,t,s)))}patchAppMetadata(e,t,s){return _t("patchAppMetadata()"),r.validateParams(["patchDoc",e,["string","object[]"]],["etag",t,"string"]),this.fetchLinksIfMissing([p.APP_METADATA],s).then((()=>Ct(this._svc,this,e,t,s)))}getBaseDirectoryMetadata(){return _t("getBaseDirectoryMetadata()"),bt(this._svc)}getLinks(e){return _t("getLinks()"),r.isObject(this.links)&&Object.keys(this.links).length>0?i.default.resolve(this.links):vt(this._svc,this,e).then((e=>(this.setLinks(e),e)))}getRepositoryResource(e){return _t("getRepositoryResource()"),this.fetchLinksIfMissing([p.REPOSITORY],e).then((()=>xt(this._svc,this,e))).then((e=>(this.repositoryId=e.result["repo:repositoryId"],e)))}getEffectivePrivileges(e){return _t("getEffectivePrivileges()"),this.fetchLinksIfMissing([p.EFFECTIVE_PRIVILAGES],e).then((()=>Nt(this._svc,this)))}performBulkRequest(e,t,s){return _t("performBulkRequest()"),r.validateParams(["requests",e,"array"],["linkMode",t,"string",!0,["id","path"]]),this.fetchLinksIfMissing([p.BULK_REQUEST],s).then((()=>lt(this._svc,this,e,t,s)))}getACLPolicy(e){return _t("getACLPolicy()"),this.fetchLinksIfMissing([p.ACL_POLICY],e).then((()=>Lt(this._svc,this)))}checkACLPrivilege(e,t,s){return _t("checkACLPrivilege()"),r.validateParams(["privilege",e,"string"],["relation",t,"string"]),this.fetchLinksIfMissing([p.ACCESS_CHECK],s).then((()=>Bt(this._svc,this,e,t)))}patchACLPolicy(e,t,s){return _t("patchACLPolicy()"),r.validateParams(["policy",e,["string","object"]]),this.fetchLinksIfMissing([p.ACL_POLICY],s).then((()=>Mt(this._svc,this,e,t)))}deleteACLPolicy(e){return _t("deleteACLPolicy()"),this.fetchLinksIfMissing([p.ACL_POLICY],e).then((()=>wt(this._svc,this)))}getPrimaryResource(e,t){_t("getPrimaryResource()"),r.validateParams(["responseType",e,"string"]);const s={};return this._withSourcePromise(s).then((()=>this.fetchLinksIfMissing([p.PRIMARY],t))).then((()=>gt.call(s,this._svc,this,e,t)))}copy(e,t,s,o,n){return _t("copy()"),r.validateParams(["destination",e,["object","string"]],["createIntermediates",t,"boolean"],["overwriteExisting",s,"boolean"],["manifestPatch",n,["object","string"],!0]),he(this.serviceConfig,{repositoryId:this.repositoryId,assetId:this.assetId,path:this.path},e,t,s,o,n).then((({response:e,result:t})=>({response:e,result:new Tt(t,this.serviceConfig)})))}copyResources(e,t,s,o,n){return _t("copyResources()"),r.validateParams(["targetAsset",e,"object"],["resources",t,"array"],["manifestPatch",o,["object","string"],!0],["intermediates",s,"boolean",!0]),Re(this.serviceConfig,{repositoryId:this.repositoryId,assetId:this.assetId,path:this.path,version:this.version},e,t,s,o,n)}move(e,t,s,o){return _t("move()"),r.validateParams(["destination",e,["object","string"]],["createIntermediates",t,"boolean"],["overwriteExisting",s,"boolean"]),fe(this.serviceConfig,{repositoryId:this.repositoryId,assetId:this.assetId,path:this.path},e,t,s,o).then((({response:e,result:t})=>(this._data=Object.assign(Object.assign({},this._data),r.pruneUndefined(t)),{response:e,result:this})))}delete(e,t=!1,s){return _t("delete()"),r.validateParams(["etag",e,"string",!0],["recursive",t,"boolean"]),Ee(this.serviceConfig,{repositoryId:this.repositoryId,assetId:this.assetId,path:this.path},e,t,s).then((e=>(this._data.state="DELETED",e)))}discard(e,t=!1,s){return _t("discard()"),r.validateParams(["etag",e,"string",!0],["recursive",t,"boolean"]),_e(this.serviceConfig,{repositoryId:this.repositoryId,assetId:this.assetId,path:this.path},e,t,s).then((e=>(this._data.state="DISCARDED",e)))}package(e,t,s,o){return _t("package()"),r.validateParams(["destination",e,["object","string"]],["createIntermediates",t,"boolean"],["overwriteExisting",s,"boolean"]),ge(this._svc,{repositoryId:this.repositoryId,assetId:this.assetId,path:this.path},e,t,s,o)}restore(e){return _t("restore()"),Te(this._svc,{repositoryId:this.repositoryId,assetId:this.assetId},e).then((({response:e,result:t})=>(this._data=Object.assign(Object.assign(Object.assign({},this._data),r.pruneUndefined(t)),{state:"ACTIVE"}),{response:e,result:this})))}_updateDataWithResponse(e){return e?(this._data.etag=e.headers.etag||this._data.etag,this._data.version=e.headers.version||this._data.version,this._data.assetId=e.headers["asset-id"]||this._data.assetId,this._data.md5=e.headers["content-md5"]||this._data.md5,this._data.repositoryId=e.headers["repository-id"]||this._data.repositoryId,e):e}_withSourcePromise(e){return i.default.resolve(void 0,e)}}function gt(e,t,s,o){_t("getPrimaryResource()"),r.validateParams(["svc",e,"object"],["asset",t,"object"],["responseType",s,"enum",!0,D]),F(t.links,[p.PRIMARY]);const n=r.getLinkHref(t.links,p.PRIMARY);return tt.call({},e,t,n,p.PRIMARY,s,void 0,void 0,o)}function It(e,t,s){_t("headPrimaryResource()"),r.validateParams(["svc",e,"object"],["asset",t,"object"]),F(t.links,[p.PRIMARY]);const o=r.getLinkHref(t.links,p.PRIMARY);return U(e).invoke(exports.HTTPMethods.HEAD,o,s,void 0,{isStatusValid:K()}).then((s=>{const o=ae(s);t.links=r.merge(t.links||{},o);const n=V(e);return n&&n.setValueWithAsset(t.links||{},t),s}))}const Pt="/content/directory/resolve{?repositoryId,id,resource,mode}",At="/content/directory/resolve{?repositoryId,path,resource,mode}";function yt(e,t,s="id",o,n){Et("getResolveLinkForAsset()"),r.validateParams(["svc",e,"object"],["asset",t,"object"],["mode",s,"enum",!1,["id","path"]],["resource",o,["string","object"],!0]),$(t);const a={repositoryId:t.repositoryId,id:t.assetId,path:t.path,mode:s,resource:r.isObject(o)?JSON.stringify(o):o},d=U(e),c=X(t.assetId?Pt:At,d);return i.default.resolve(r.expandURITemplate(c,r.pruneUndefined(a)))}function kt(e,t,s="id",o,n,i){Et("resolveAsset()"),r.validateParams(["svc",e,"object"],["asset",t,"object"],["mode",s,"enum",!0,["id","path"]],["resource",o,["string","object"],!0]),$(t);const a=U(e),d=V(e),c=d&&t.assetId&&t.repositoryId&&"id"===s;return c&&(Et("rA() set pending"),d.setPending(t.assetId,t.repositoryId)),yt(e,t,s,o).then((e=>null==o?Q(a,e,i):ee(a,e,i,n))).then((e=>({response:e,result:Gt(t,e,"id"===s,d)}))).catch((e=>{throw c&&d.deleteWithAsset(t),e}))}function Dt(e,t,s){return Et("fetchLinksForAsset()"),mt(e,t,s).then((e=>e.result.links))}function mt(t,s,o){if(Et("fetchAsset()"),r.validateParams(["svc",t,"object"],["asset",s,"object"]),B(s))return kt(t,s,"id",void 0,void 0,o).then((e=>e));let n;try{n=G(s.links,[p.ID,p.REPO_METADATA,p.PRIMARY,p.PATH])}catch(t){throw new e.DCXError(e.DCXError.INVALID_PARAMS,"Asset is not resolvable. Must contain repositoryId & path, assetId, or links.",t)}const i=r.getLinkHref(s.links,n),a=U(t),d=V(t);return a.invoke(exports.HTTPMethods.HEAD,i,o,void 0,{isStatusValid:K()}).then((e=>({result:Gt(s,e,n===p.ID,d),response:e})))}function vt(e,t,s){Et("getLinksForAsset()"),r.validateParams(["svc",e,"object"],["asset",t,"object"]);const o=t.links||t[exports.Properties.LINKS];if(r.isObject(o)&&0!==Object.keys(o).length)return i.default.resolve(o);const n=V(e);if(n){const e=n.getValueWithAsset(t);if(e)return i.default.resolve(e)}return Dt(e,t,s)}function bt(t,s){throw Et("getBaseDirectoryMetadata()"),new e.DCXError(e.DCXError.NOT_IMPLEMENTED,"Method not implemented.")}function xt(e,t,s){Et("getRepositoryResource()"),r.validateParams(["svc",e,"object"],["asset",t,"object"]),F(t.links,[p.REPOSITORY]);const o=r.getLinkHref(t.links,p.REPOSITORY);return e.invoke(exports.HTTPMethods.GET,o,s,void 0,{responseType:"json",isStatusValid:K()}).then((e=>({result:e.response,response:e})))}function Ot(e,t,s){_t("headAppMetadata()"),r.validateParams(["svc",e,"object"],["asset",t,"object"]),F(t.links,[p.APP_METADATA]);const o=r.getLinkHref(t.links,p.APP_METADATA);return U(e).invoke(exports.HTTPMethods.HEAD,o,s,void 0,{isStatusValid:K()}).then((s=>{const o=ae(s);t.links=r.merge(t.links||{},o);const n=V(e);return n&&n.setValueWithAsset(t.links,t),s}))}function Rt(e,t,s,o={}){Et("getAppMetadata()"),r.validateParams(["svc",e,"object"],["asset",t,"object"],["etag",s,"string",!0]);const n=r.getLinkHref(t.links,p.APP_METADATA),i=Object.assign({},o);return s&&(i[exports.HeaderKeys.IF_NONE_MATCH]=s),e.invoke(exports.HTTPMethods.GET,n,i,void 0,{responseType:"json",isStatusValid:K([304])}).then((e=>{let t=e.response,r=e.headers.etag;return 304===e.statusCode&&(t=null,r=s),{result:t,response:e,etag:r}}))}function St(e,t,s,o,n={}){Et("putAppMetadata()"),r.validateParams(["svc",e,"object"],["asset",t,"object"],["metadata",s,["object","string"]],["etag",o,"string",!0]),F(t.links,[p.APP_METADATA]);const i=r.getLinkHref(t.links,p.APP_METADATA);return e.invoke(exports.HTTPMethods.PUT,i,r.pruneUndefined(Object.assign(n,{[exports.HeaderKeys.IF_MATCH]:o,[exports.HeaderKeys.CONTENT_TYPE]:u})),"string"==typeof s?s:JSON.stringify(s),{isStatusValid:K()}).then((e=>({response:e,result:{etag:e.headers.etag}})))}function Ct(e,t,s,o,n={}){Et("patchAppMetadata()"),r.validateParams(["svc",e,"object"],["asset",t,"object"],["metadata",s,["object[]","string"]],["etag",o,"string"]),F(t.links,[p.APP_METADATA]);const i=r.getLinkHref(t.links,p.APP_METADATA);return e.invoke(exports.HTTPMethods.PATCH,i,r.pruneUndefined(Object.assign(n,{[exports.HeaderKeys.IF_MATCH]:o,[exports.HeaderKeys.CONTENT_TYPE]:_})),"string"==typeof s?s:JSON.stringify(s),{isStatusValid:K()}).then((e=>({response:e,result:{etag:e.headers.etag}})))}function Nt(e,t,s){Et("getEffectivePrivileges()"),r.validateParams(["svc",e,"object"],["asset",t,"object"]),F(t.links,[p.EFFECTIVE_PRIVILAGES]);const o=r.getLinkHref(t.links,p.EFFECTIVE_PRIVILAGES);return e.invoke(exports.HTTPMethods.GET,o,s,void 0,{responseType:"json",isStatusValid:K()}).then((e=>({result:e.response,response:e})))}function Lt(e,t,s){Et("getACLPolicy()"),r.validateParams(["svc",e,"object"],["asset",t,"object"]),F(t.links,[p.ACL_POLICY]);const o=r.getLinkHref(t.links,p.ACL_POLICY);return e.invoke(exports.HTTPMethods.GET,o,s,void 0,{responseType:"json",isStatusValid:K()}).then((e=>({result:e.response,response:e})))}function Bt(e,t,s,o,n={}){Et("checkACLPrivilege()"),r.validateParams(["svc",e,"object"],["asset",t,"object"],["privilege",s,"string",!1,["ack","read","write","delete"]]),F(t.links,[p.ACCESS_CHECK]);const i=r.getLinkHrefTemplated(t.links,p.ACCESS_CHECK,{privilege:s.toString(),relation:o});return e.invoke(exports.HTTPMethods.GET,i,Object.assign({directive:"acl-check-no-body"},n),void 0,{responseType:"json",isStatusValid:K([403])}).then((e=>({result:403!==e.statusCode,response:e})))}function Mt(e,t,s,o,n={}){Et("patchACLPolicy()"),r.validateParams(["svc",e,"object"],["asset",t,"object"],["policy",s,["string","object"]],["etag",o,"string",!0]),F(t.links,[p.ACL_POLICY]);const i=r.pruneUndefined(Object.assign(n,{[exports.HeaderKeys.CONTENT_TYPE]:_,[exports.HeaderKeys.IF_MATCH]:o})),a=r.getLinkHref(t.links,p.ACL_POLICY);return U(e).invoke(exports.HTTPMethods.PATCH,a,i,"string"==typeof s?s:JSON.stringify(s),{responseType:"json",isStatusValid:K()}).then((e=>({result:e.response,response:e})))}function wt(e,t,s={}){Et("deleteACLPolicy()"),r.validateParams(["svc",e,"object"],["asset",t,"object"]),F(t.links,[p.ACL_POLICY]);const o=r.getLinkHref(t.links,p.ACL_POLICY);return U(e).invoke(exports.HTTPMethods.DELETE,o,s,void 0,{responseType:"json",isStatusValid:K()}).then((e=>({result:e.response,response:e})))}function Ht(t,s,o,n,a){Et("useLinkOrResolveResource()"),r.validateParams(["svc",t,"object"],["asset",s,"object"],["resource",o,"string"]);const d=U(t);let c;try{c=r.getLinkHref(s.links,o)}catch(e){}return i.default.resolve(c).then((e=>{if("string"==typeof e)return Et("uLORR() asset has link"),e;const r=V(t);return Ft(s,r,[o])})).then((e=>{if("string"==typeof e)return e;try{return r.getLinkHref(e,o)}catch(e){return}})).then((r=>{if("string"==typeof r)return Et("uLORR() cache or asset had link"),d.invoke(exports.HTTPMethods.GET,r,a,void 0,{isStatusValid:K(),responseType:n});if(!B(s))throw new e.DCXError(e.DCXError.INVALID_PARAMS,"Asset is not resolvable. Must contain repository ID + path/id or links.");return kt(t,s,"id",o,n,a)})).then((e=>S(e)?e:{result:s,response:e}))}function jt(e,t,s=[],r=!1,o){return Kt(e,t,s,r,o).then((({result:e})=>e))}const Ut=new Set([p.BASE_DIRECTORY,p.RESOLVE_BY_ID,p.RESOLVE_BY_PATH,p.REPO_OPS,p.REPOSITORY,p.DIRECTORY,p.DISCARD,p.RESTORE,p.PATH,p.ANNOTATIONS]),Vt="/links{?assetId,repositoryId,clientRegion}";function Xt(e,t,s){const o=function(e,t){Et("getLinksAPIUrlForAsset()"),r.validateParams(["svc",e,"object"],["asset",t,"object"]);const s=U(e),o=X(Vt,s),{assetId:n,repositoryId:i,contentRegion:a}=t,d=r.pruneUndefined({assetId:n,repositoryId:i,contentRegion:a});return r.expandURITemplate(o,d)}(e,t);return U(e).invoke(exports.HTTPMethods.GET,o,s,void 0,{responseType:"json"}).then((s=>{const r=V(e);return t.links=Object.assign({},t.links,s.response._links),null==r||r.setValueWithAsset(t.links,t),{response:s,result:t}}))}function Kt(t,s,o=[],n=!1,a){if(Et("fetchLinksIfMissing()",o),r.validateParams(["svc",t,"object"],["asset",s,"object"],["linksToPopulate",o,"string[]"],["suppressMissingErrors",n,"boolean",!0]),Y(s.links,o))return Et("fLIM() links exist"),i.default.resolve({result:s.links});const d=V(t);return Ft(s,d,o,!0).then((e=>e||(function(e,t){return"string"==typeof e.assetId&&e.assetId.length>0&&t.every((e=>!Ut.has(e)))}(s,o)?Xt(t,s,a):(Et("fLIM() fetching links"),mt(t,s,a))))).then((i=>{let a,d,c=i;if(S(i)&&(a=i.response,c=i.result.links,d=i.result),s.links!==c){s.links=r.merge(s.links||{},c);const e=V(t);e&&e.setValueWithAsset(s.links,s)}if(!n&&!Y(c,o))throw new e.DCXError(e.DCXError.INVALID_PARAMS,"Required links could not be fetched for asset.",void 0,a,r.pruneUndefined({required:o,asset:d}));return Et("fLIM() fetchedOCached exists"),{result:c||s.links,response:a}}))}function Ft(e,t,s,r){if(Et("getLinksFromCache()"),!t)return i.default.resolve(void 0);const o=t.getValueWithAsset(e);return null==o?(r&&t.setPending(e.assetId,e.repositoryId),i.default.resolve(void 0)):i.default.resolve(o).then((o=>s?Y(o,s)?o:void(r&&t.setPending(e.assetId,e.repositoryId)):o))}function Gt(e,t,s,o){const n=ae(t),i=Object.assign(Object.assign(Object.assign({},function(e){if(!r.isObject(e.asset))return e;return e.asset}(e)),r.pruneUndefined({assetId:t.headers["asset-id"]||t.headers["x-resource-id"],format:t.headers[exports.HeaderKeys.CONTENT_TYPE],md5:t.headers["content-md5"],etag:t.headers.etag,version:t.headers.version,repositoryId:t.headers["repository-id"]})),{links:n});return s&&n&&Object.keys(n).length>0&&o&&o.setValueWithAsset(n,i),i}const zt=t.newDebug("dcx:assets:blockupload"),Yt=t.newDebug("dcx:assets:blockupload:leaf");class qt extends r.EventEmitter{constructor(t,s,o,n,a,d,c,l,h,u,f,_,E,T){super(["stateChanged"]),this._internalBlockUploadId=r.generateUuid(),this._state=exports.BlockTransferStates.NOT_INITIALIZED,this._currentBlockIndex=0,this._pendingBlockRequests=[],this._bytesUploaded=0,this._totalBlocksUploaded=0,this._indeterminateTransfer=!1,this._maxConcurrentRequests=4,this._service=t,this._getSliceCallback=s,H(o)?(r.validateParams([exports.BlockTransferProperties.REPO_SIZE,o[exports.BlockTransferProperties.REPO_SIZE],"number"]),this._blockTransferDocument=o,this._transferBlockLinks=this._blockTransferDocument[exports.Properties.LINKS][p.BLOCK_TRANSFER],this._dataSize=this._blockTransferDocument[exports.BlockTransferProperties.REPO_SIZE],this._relationType=this._blockTransferDocument[exports.BlockTransferProperties.REPO_REL_TYPE],this._shiftState(exports.BlockTransferStates.INITIALIZED),zt(`BlockUpload Initialized: Transfer document found with ${this._transferBlockLinks.length} links. BlockUploadId: ${this._internalBlockUploadId}`)):(r.validateParams(["relationType",n,"string"],["dataSize",a,"number"],["contentType",d,"string"],["componentId",c,"string",!0],["etag",h,"string",!0]),this._asset=o,F(this._asset.links,[p.BLOCK_UPLOAD_INIT],e.DCXError.UNEXPECTED,"/rel/block/init missing from BlockTransferDocument."),this._relationType=n,this._dataSize=a,this._contentType=d,this._componentId=c,this._md5=l,this._ifMatch=h),this._relPath=u,this._createIntermediates=f,this._respondWith=_,this._repoMetaPatch=E,this._maxConcurrentRequests=T||4,this._promise=new i.default(((e,t)=>{this._reject=t,this._resolve=e})),Ge.uploads.push(this)}init(e){if(this._assertStateIsValid("init"),!this._blockTransferDocument||!this._blockTransferDocument[exports.Properties.LINKS]){this._shiftState(exports.BlockTransferStates.INITIALIZING);const t=r.pruneUndefined(Object.assign({[exports.BlockTransferProperties.REPO_REL_TYPE]:this._relationType,[exports.BlockTransferProperties.REPO_IF_MATCH]:this._ifMatch,[exports.BlockTransferProperties.REPO_SIZE]:this._dataSize,[exports.BlockTransferProperties.DC_FORMAT]:this._contentType,[exports.BlockTransferProperties.COMPONENT_ID]:this._componentId,[exports.BlockTransferProperties.REPO_MD5]:this._md5},this._blockTransferDocument));return $t(this._service,this._asset,t,e).then((e=>(this._blockTransferDocument=e.result,this._transferBlockLinks=this._blockTransferDocument[exports.Properties.LINKS][p.BLOCK_TRANSFER],this._shiftState(exports.BlockTransferStates.INITIALIZED),zt(`BlockUpload Initialized: Transfer document found with ${this._transferBlockLinks.length} links. BlockUploadId: ${this._internalBlockUploadId}`),this)))}return i.default.resolve(this)}get state(){return this._state}get promise(){return this._promise}start(){return this._assertStateIsValid("start"),Ge.uploads[0]!==this||this._state!==exports.BlockTransferStates.INITIALIZED&&this._state!==exports.BlockTransferStates.PAUSED||(zt(`Starting the transfer of BlockUpload: ${this._internalBlockUploadId}`),this._shiftState(exports.BlockTransferStates.STARTED),this._uploadLoop()),this._promise}pause(){return this._assertStateIsValid("pause"),this._shiftState(exports.BlockTransferStates.PAUSING),i.default.allSettled(this._pendingBlockRequests).then((()=>(this._shiftState(exports.BlockTransferStates.PAUSED),zt(`BlockUploading has been paused.  BlockUploadId: ${this._internalBlockUploadId}`),this)))}resume(){return this._assertStateIsValid("resume"),zt(`BlockUploading has been resumed.  BlockUploadId: ${this._internalBlockUploadId}`),this.start(),this}cancel(){this._assertStateIsValid("cancel"),this._shiftState(exports.BlockTransferStates.CANCELED),zt(`A BlockUpload has been canceled... BlockUploadId: ${this._internalBlockUploadId}`),this._promise.cancel(),this._cancel()}_setWaiting(){this._shiftState(exports.BlockTransferStates.WAITING)}uploadNextBlock(t){if(this._assertStateIsValid("uploadNextBlock"),this._isEmptyBlock(t))throw new e.DCXError(e.DCXError.INVALID_PARAMS,"Trying to upload empty data block.");const s=this._blockTransferDocument[exports.Properties.LINKS][p.BLOCK_TRANSFER][this._currentBlockIndex].href;let r;zt(`Uploading a block... BlockUploadId: ${this._internalBlockUploadId}`);const o=je(t),n=this._uploadBlock(t,s).then((e=>(this._totalBlocksUploaded++,this._updateProgress(o),r(),zt(`A block has completed... ${this._pendingBlocksCount} requests still active. BlockUploadId: ${this._internalBlockUploadId}`),e))).catch((t=>{zt(`A block upload has failed. BlockUploadId: ${this._internalBlockUploadId}`),r(),this._shiftState(exports.BlockTransferStates.ERROR),this._reject(new e.DCXError(e.DCXError.UNEXPECTED_RESPONSE,"A block has failed during upload",t,t.response)),this.cancel()}));return r=this._pushPendingBlockRequest(n),n}get _pendingBlocksCount(){return Ge.pendingUploadRequests.filter((e=>!!e)).length}_nextBlockLock(){return this._pendingBlocksCount<this._maxConcurrentRequests?Promise.resolve():Promise.race(Ge.pendingUploadRequests.filter((e=>!!e)))}_handleAssetMoved(e){throw zt("_handleAssetMoved"),this._pendingBlockRequests.forEach((e=>{e.abort()})),this._pendingBlockRequests.length=0,this._transferBlockLinks.length=0,this._asset.links=Object.assign(Object.assign({},this._asset.links),ae(e.response)),this._currentBlockIndex=0,this._bytesUploaded=0,this._state=exports.BlockTransferStates.NOT_INITIALIZED,this._blockTransferDocument[exports.Properties.LINKS]=void 0,this.init().then((()=>this.start())),exports.BlockTransferStates.INITIALIZING}_uploadLoop(){this._nextBlockLock().then((()=>{if(this._state===exports.BlockTransferStates.FINALIZING||this._state===exports.BlockTransferStates.COMPLETE)throw exports.BlockTransferStates.COMPLETE;if(this._state===exports.BlockTransferStates.PAUSING||this._state===exports.BlockTransferStates.PAUSED)throw exports.BlockTransferStates.PAUSED;if(this._state===exports.BlockTransferStates.CANCELED)throw exports.BlockTransferStates.CANCELED;if(this._state===exports.BlockTransferStates.ERROR)throw exports.BlockTransferStates.ERROR})).then((()=>this._getBlockAtIndex(this._currentBlockIndex))).then((e=>this._isEmptyBlock(e)?(zt(`No more blocks.  BlockUploadId: ${this._internalBlockUploadId}`),Promise.all(this._pendingBlockRequests).then(this._finalize.bind(this))):e&&je(e)>0&&this._currentBlockIndex>=this._transferBlockLinks.length?this._extend().then((()=>e)):e)).then((e=>{if(!e)throw exports.BlockTransferStates.COMPLETE;this.uploadNextBlock(e),this._currentBlockIndex++})).then((()=>{this._uploadLoop()})).catch((e=>{if("string"!=typeof e&&(this._continueBlockUploads(),this._reject(e)),e!==exports.BlockTransferStates.INITIALIZING)if(e!==exports.BlockTransferStates.COMPLETE){if(e!==exports.BlockTransferStates.PAUSED)return e===exports.BlockTransferStates.CANCELED?(zt(`BlockUpload loop is terminated due to the upload being canceled. BlockUploadId: ${this._internalBlockUploadId}`),void this._continueBlockUploads()):e===exports.BlockTransferStates.ERROR?(zt(`BlockUpload loop is terminated due to error state. BlockUploadId: ${this._internalBlockUploadId}`),void this._continueBlockUploads()):void 0;zt(`BlockUpload loop is terminated due to paused state. BlockUploadId: ${this._internalBlockUploadId}`)}else zt(`BlockUpload loop is complete. BlockUploadId: ${this._internalBlockUploadId}`);else zt(`BlockUpload loop must be re-started due to assetmoved BlockUploadId: ${this._internalBlockUploadId}`)}))}_getBlockAtIndex(t){zt(`_getBlockAtIndex(${t})`);const s=Math.min(this._dataSize,this._blockTransferDocument[exports.BlockTransferProperties.REPO_BLOCK_SIZE]);if(this._state===exports.BlockTransferStates.STARTED){const r=t*s;return zt("calling _getSliceCallback",r,r+s),this._getSliceCallback(r,r+s).catch((t=>{throw new e.DCXError(e.DCXError.UNEXPECTED_RESPONSE,"The getSliceCallback threw an unexpected error.",t)}))}}_uploadBlock(e,t){return this._service.invoke(exports.HTTPMethods.PUT,t,void 0,e,{isStatusValid:K(),isExternalRequest:!0})}_isEmptyBlock(e){return"string"==typeof e?0===e.length:L(e)?0===e.size:!e||0===e.byteLength}_extend(){F(this._blockTransferDocument[exports.Properties.LINKS],[p.BLOCK_EXTEND],e.DCXError.UNEXPECTED,"The transfer document does not contain an extend href");const t=Math.ceil(1.5*this._blockTransferDocument[exports.BlockTransferProperties.REPO_SIZE]),s=r.getLinkHrefTemplated(this._blockTransferDocument[exports.Properties.LINKS],p.BLOCK_EXTEND,{size:t});return this._service.invoke(exports.HTTPMethods.POST,s,{},void 0,{isStatusValid:K(),responseType:"json"}).then((e=>(this._indeterminateTransfer=!0,this._blockTransferDocument=e.response,this._transferBlockLinks=this._blockTransferDocument[exports.Properties.LINKS][p.BLOCK_TRANSFER],zt(`Transfer document was extended to ${this._transferBlockLinks.length} transfer links. BlockUploadId: ${this._internalBlockUploadId}`),e))).catch((t=>{throw e.isAdobeDCXError(t)&&t.problemType===e.ProblemTypes.ASSET_MOVED&&this._handleAssetMoved(t),new e.DCXError(e.DCXError.UNEXPECTED_RESPONSE,"An unexpected error occurred while extending the block transfer document.",t,t.response)}))}_pushPendingBlockRequest(e){const t=this._pendingBlockRequests.push(e),s=Ge.pendingUploadRequests.push(e);return()=>{delete this._pendingBlockRequests[t-1],delete Ge.pendingUploadRequests[s-1]}}_updateProgress(e){if(zt("_updateProgress()",e),"number"==typeof e&&(this._bytesUploaded+=e),this.onProgress&&r.isAnyFunction(this.onProgress))try{this.onProgress(this._bytesUploaded,Math.max(this._blockTransferDocument[exports.BlockTransferProperties.REPO_SIZE],this._bytesUploaded),this._indeterminateTransfer)}catch(e){console.error("Error in onProgress callback",e)}}_cancel(){this._pendingBlockRequests.map((e=>{e&&e.cancel()})),this._state!==exports.BlockTransferStates.ERROR&&this._resolve(this)}_assertStateIsValid(t,s){const r=s||this._state;switch(t){case"init":if(r!==exports.BlockTransferStates.NOT_INITIALIZED&&r!==exports.BlockTransferStates.INITIALIZED)throw new e.DCXError(e.DCXError.INVALID_STATE,"BlockUpload has already been initialized");break;case"start":if(r===exports.BlockTransferStates.NOT_INITIALIZED)throw new e.DCXError(e.DCXError.INVALID_STATE,"Please call init before starting the block upload");break;case"uploadNextBlock":if(r===exports.BlockTransferStates.PAUSED||r===exports.BlockTransferStates.CANCELED)throw new e.DCXError(e.DCXError.INVALID_STATE,"Cannot add block when Paused or Cancelled");break;case"getBlockAtIndex":if(r!==exports.BlockTransferStates.STARTED)throw new e.DCXError(e.DCXError.INVALID_STATE,`Cannot fetch block while in the ${r} state`);break;case"cancel":if(r!==exports.BlockTransferStates.STARTED&&r!==exports.BlockTransferStates.FINALIZING&&r!==exports.BlockTransferStates.PAUSING&&r!==exports.BlockTransferStates.PAUSED&&r!==exports.BlockTransferStates.ERROR)throw new e.DCXError(e.DCXError.INVALID_STATE,`Trying to cancel while in an invalid state ${r}`)}}_continueBlockUploads(){if(zt("continueBlockUploads()"),Ge.uploads[0]===this)if(Ge.uploads.shift(),Ge.uploads.length>0){const e=Ge.uploads[0];zt("Another block upload found in the queue, starting..."),e.start()}else 0===this._pendingBlocksCount&&(zt("There are no more pending block transfers.. Clean up blockUploadManager.."),Ge.resetUploads())}_finalize(){zt(`Finalizing block transfer.  BlockUploadId: ${this._internalBlockUploadId}`),this._shiftState(exports.BlockTransferStates.FINALIZING);const t=r.getLinkHrefTemplated(this._blockTransferDocument[exports.Properties.LINKS],p.BLOCK_FINALIZE,r.pruneUndefined({path:this._relPath,intermediates:this._createIntermediates,respondWith:r.isObject(this._respondWith)?JSON.stringify(this._respondWith):this._respondWith,repoMetaPatch:this._repoMetaPatch}));return this._blockTransferDocument[exports.Properties.LINKS][p.BLOCK_TRANSFER]=this._transferBlockLinks.slice(0,this._totalBlocksUploaded),this._service.invoke(exports.HTTPMethods.POST,t,{[exports.HeaderKeys.CONTENT_TYPE]:E},JSON.stringify(r.pruneUndefined(this._blockTransferDocument)),{isStatusValid:K(),retryOptions:{pollHeader:"location",pollCodes:[202],timeoutAfter:12e4},responseType:"arraybuffer"}).then((t=>{if(200===t.statusCode||201===t.statusCode){zt(`Finalize complete.  BlockUploadId: ${this._internalBlockUploadId}`);const s=ct(new Uint8Array(t.response));if(this._relationType===p.PRIMARY){if(this.finalizeResponse=s,this.createdAsset=r.pruneUndefined({assetId:s.headers["asset-id"],repositoryId:s.headers["repository-id"],links:de(s.headers.link),etag:s.headers.etag,md5:s.headers["content-md5"]}),s.response&&this._respondWith)try{const e=JSON.parse(r.arrayBufferToString(s.response));s.response=e,this.createdAsset=r.mergeDeep(this.createdAsset,se(e))}catch(t){throw new e.DCXError(e.DCXError.UNEXPECTED,"Unexpected error parsing respondWith parameter",t)}}else{this.finalizeResponse=t;try{this.uploadRecord=Xe(this._blockTransferDocument[exports.BlockTransferProperties.DC_FORMAT],this._blockTransferDocument[exports.BlockTransferProperties.COMPONENT_ID],this._bytesUploaded,r.arrayBufferToString(t.response))}catch(t){throw new e.DCXError(e.DCXError.UNEXPECTED,"An error occurred while deserializing upload component record.",t,s)}}this._shiftState(exports.BlockTransferStates.COMPLETE),this._updateProgress(!0),this._resolve(this)}this._continueBlockUploads()})).catch((t=>{e.isAdobeDCXError(t)&&t.problemType===e.ProblemTypes.ASSET_MOVED&&this._handleAssetMoved(t),zt("Error occurred finalizing the block transfer.. Rejecting"),this._reject(new e.DCXError(e.DCXError.UNEXPECTED_RESPONSE,"An error occurred while finalizing the block transfer.",t,t.response)),this._continueBlockUploads()}))}_shiftState(e){return zt(`_shiftState(): ${e}`),this._state===exports.BlockTransferStates.COMPLETE||this._state===exports.BlockTransferStates.ERROR||this._state===exports.BlockTransferStates.CANCELED||(this._state=e,this.emit("stateChanged",[this._state])),this}}function $t(t,s,o,n={}){if(r.validateParams(["svc",t,"object"],["asset",s,"object"],["transferDocument",o,"object"],["additionalHeaders",n,"object",!0]),F(s.links,[p.BLOCK_UPLOAD_INIT]),o["repo:resource"]){if(!o["repo:resource"].reltype)throw new e.DCXError(e.DCXError.INVALID_DATA,"reltype param is required in the Resource Designator");o[exports.BlockTransferProperties.REPO_REL_TYPE]=o["repo:resource"].reltype,o["repo:resource"].component_id&&(o[exports.BlockTransferProperties.COMPONENT_ID]=o["repo:resource"].component_id),o["repo:resource"].etag&&(o[exports.BlockTransferProperties.REPO_IF_MATCH]=o["repo:resource"].etag),delete o["repo:resource"]}if(o[exports.BlockTransferProperties.REPO_REL_TYPE]===p.COMPONENT&&!o[exports.BlockTransferProperties.COMPONENT_ID])throw new e.DCXError(e.DCXError.INVALID_DATA,"Component Id required to block upload to a component");const i=r.getLinkHref(s.links,p.BLOCK_UPLOAD_INIT);n[exports.HeaderKeys.CONTENT_TYPE]=E;const a=r.normalizeHeaders(n);return a.priority=a.priority||"u=1",t.invoke(exports.HTTPMethods.POST,i,a,JSON.stringify(o),{responseType:"json",isStatusValid:K()}).then((e=>({response:e,result:e.response})))}function Wt({additionalHeaders:e,asset:t,componentId:s,contentType:o,dataOrSliceCallback:n,etag:a,maybeIsNew:d,md5:c,progressCb:p,relation:l,size:h,svc:u,blockSize:f,maxConcurrentRequests:_}){Yt("_upload()"),r.validateParams(["svc",u,"object"],["asset",t,"object"],["size",h,"number",!0],["md5",c,"string",!0],["etag",a,"string",!0]);const E=Ue(n,h),T=je(E),g=U(u);if(Me(t,T))return Zt({asset:t,additionalHeaders:e,componentId:s,contentType:o,dataOrSliceCallback:n,etag:a,md5:c,progressCb:p,relation:l,size:h,service:g,blockSize:f,maxConcurrentRequests:_});F(t.links,[l]);const I=r.getLinkHrefTemplated(t.links,l,{component_id:s});return i.default.resolve(void 0,{blockUpload:void 0,progress:p}).then((()=>Promise.resolve(r.isAnyFunction(n)?n(0,T):n))).then((s=>st({asset:t,additionalHeaders:e,contentType:o,data:s,etag:a,headHref:I,href:I,maybeIsNew:d,relation:l,service:g}))).then((e=>{let s={};try{s=ae(e),t.links=r.merge(t.links||{},s);const o=V(u);o&&o.setValueWithAsset(t.links,t)}catch(e){}return{response:e,result:{revision:e.headers.revision||e.headers.version,location:e.headers.location,links:s,etag:e.headers.etag,version:e.headers.version||e.headers.revision,md5:e.headers.md5||e.headers["content-md5"],length:T,type:o},isBlockUpload:!1,asset:{assetId:t.assetId||e.headers["asset-id"],repositoryId:t.repositoryId||e.headers["repository-id"],links:t.links||s}}})).catch((e=>{throw e}))}function Zt({service:t,asset:s,additionalHeaders:o,dataOrSliceCallback:n,contentType:i,progressCb:a,relation:d,size:c,componentId:l,md5:h,etag:u,relPath:f,createIntermediates:_,respondWith:E,blockSize:T,repoMetaPatch:g,maxConcurrentRequests:I}){if(!c)throw new e.DCXError(e.DCXError.INVALID_DATA,"A size estimate is required when a GetSliceCallback is provided. The size is used to determine the number of requests required to block transfer the asset.");const P=r.isAnyFunction(n)?n:function(t){if(!r.isFunction(t.slice))throw new e.DCXError(e.DCXError.INVALID_PARAMS,"Data cannot be sliced");return function(e,s){return v(this,void 0,void 0,(function*(){return t.slice(e,s)}))}}(n);F(s.links,[p.BLOCK_UPLOAD_INIT]);const A=$t(t,s,r.pruneUndefined({[exports.BlockTransferProperties.REPO_REL_TYPE]:d,[exports.BlockTransferProperties.REPO_IF_MATCH]:u,[exports.BlockTransferProperties.REPO_SIZE]:c,[exports.BlockTransferProperties.DC_FORMAT]:i,[exports.BlockTransferProperties.COMPONENT_ID]:l,[exports.BlockTransferProperties.REPO_MD5]:h,[exports.BlockTransferProperties.REPO_BLOCK_SIZE]:T}),o);return A.then((e=>{const s=new qt(t,P,e.result,d,c,i,l,h,u,f,_,E,g,I);return s.onProgress=a,Object.assign(A,{blockUpload:s}),s.init(o)})).then((e=>e.start())).then((e=>{const t=e.finalizeResponse||{headers:{}};return{response:t,result:e.uploadRecord||e.createdAsset,blockUpload:e,isBlockUpload:!0,asset:{assetId:t.headers["asset-id"]||s.assetId,repositoryId:t.headers["repository-id"]||s.repositoryId,etag:t.headers.etag,links:s.links}}}))}const Jt=Ge;function Qt(e){return e||"defaultbuffer"}function es(e,t,s="json",o={}){r.validateParams(["svc",e,"object"],["asset",t,"object"],["format",s,"enum",!1,["json","xml"]]),F(t.links,[p.EMBEDDED_METADATA]);const n=r.getLinkHref(t.links,p.EMBEDDED_METADATA);return e.invoke(exports.HTTPMethods.GET,n,Object.assign(Object.assign({},o),{accept:exports.EmbeddedMetadataMediaTypes[s.toUpperCase()],vary:"accept"}),void 0,{isStatusValid:K(),responseType:"json"===s?"json":"text"}).then((e=>({result:e.response,response:e})))}function ts(e,t,s,o,n="json",i={}){r.validateParams(["svc",e,"object"],["asset",t,"object"],["data",s,["string","object","object[]"]],["etag",o,"string",!0],["format",n,"enum",!1,["json","xml"]]),F(t.links,[p.EMBEDDED_METADATA]);const a=r.getLinkHref(t.links,p.EMBEDDED_METADATA),d=Object.assign(Object.assign({},i),{[exports.HeaderKeys.CONTENT_TYPE]:exports.EmbeddedMetadataMediaTypes[n.toUpperCase()],[exports.HeaderKeys.IF_MATCH]:o});return e.invoke(exports.HTTPMethods.PUT,a,d,"string"==typeof s?s:JSON.stringify(s),{isStatusValid:K()})}function ss(e,t,s,o,n={}){r.validateParams(["svc",e,"object"],["asset",t,"object"],["data",s,["string","object","object[]"]],["etag",o,"string",!0]),F(t.links,[p.EMBEDDED_METADATA]);const i=r.getLinkHref(t.links,p.EMBEDDED_METADATA);return e.invoke(exports.HTTPMethods.PATCH,i,Object.assign(n,{[exports.HeaderKeys.CONTENT_TYPE]:_,[exports.HeaderKeys.IF_MATCH]:o}),"string"==typeof s?s:JSON.stringify(s),{isStatusValid:K(),retryOptions:{pollCodes:[202],pollHeader:"location",pollMethod:"GET"}})}const rs=t.newDebug("dcx:assets:filebase"),os=t.newDebug("dcx:assets:filebase:leaf"),ns="application/vnd.adobe.versions+json";class is extends Tt{constructor(e,t,s){super(e,t,s),this._data.width=null!=e.width?e.width:e[exports.Properties.IMAGE_WIDTH],this._data.length=null!=e.length?e.length:e[exports.Properties.IMAGE_LENGTH],this._data.renderable=null!=e.renderable?e.renderable:"object"==typeof this._data.links?p.RENDITION in this._data.links:void 0}get width(){return this._data.width}get length(){return this._data.length}get renderable(){return this._data.renderable}getRendition(e,t,s,o){return rs("getRendition()"),r.validateParams(["opts",e,"object",!0],["responseType",t,"string",!0],["linkProvider",s,"object",!0]),this.fetchLinksIfMissing([p.RENDITION],o).then((()=>as(this._svc,this,e,t,s,o)))}getEmbeddedMetadata(e="json",t){return rs("getEmbeddedMetadata()"),r.validateParams(["format",e,"enum",!1,["json","xml"]]),this.fetchLinksIfMissing([p.EMBEDDED_METADATA],t).then((()=>es(this._svc,this,e,t)))}putEmbeddedMetadata(e,t,s="json",o){return r.validateParams(["data",e,["object","object[]","string"]],["etag",t,"string",!0],["format",s,"enum",!1,["json","xml"]]),this.fetchLinksIfMissing([p.EMBEDDED_METADATA],o).then((()=>ts(this._svc,this,e,t,s,o)))}patchEmbeddedMetadata(e,t,s){return r.validateParams(["data",e,["object","object[]","string"]],["etag",t,"string",!0]),this.fetchLinksIfMissing([p.EMBEDDED_METADATA],s).then((()=>ss(this._svc,this,e,t,s)))}blockDownload(e,t,s,o,n,i,a){rs("blockDownload()"),r.validateParams(["startByte",e,"number",!0],["endByte",t,"number",!0],["resource",s,"string",!0],["componentId",o,"string",!0],["version",n,"string",!0],["responseType",i,"enum",!0,D]),r.assert((()=>null==e||null==t||e<t),"endByte must be greater than startByte");const d={};return this._withSourcePromise(d).then((()=>this.fetchLinksIfMissing([p.BLOCK_DOWNLOAD]))).then((()=>ds.call(d,this._svc,this,e,t,s,o,n,i,a)))}updatePrimaryResource(e,t,s,o,n,i){rs("updatePrimaryResource()");const a=r.isAnyFunction(e)?p.BLOCK_UPLOAD_INIT:p.PRIMARY;return this.fetchLinksIfMissing([a],i).then((()=>cs(this.serviceConfig,this,e,t,s,o,n,i))).then((e=>(this._data.etag=e.result.etag,this._data.md5=e.result.md5,this._data.length=e.result.length,this._data.version=e.result.version,e)))}}function as(e,t,s,o="defaultbuffer",n,i){os("getRendition()"),r.validateParams(["svc",e,"object"],["asset",t,"object"],["renditionOptions",s,"object",!0],["linkProvider",n,"object",!0]),F(t.links,[p.RENDITION]);const a=n?r.provideLink(t.links[p.RENDITION],n,s):r.getLinkHrefTemplated(t.links,p.RENDITION,Object.assign({},s));return e.invoke(exports.HTTPMethods.GET,a,i,void 0,{responseType:Qt(o),isStatusValid:K()}).then((e=>({result:e.response,response:e})))}function ds(e,t,s,o,n,i,a,d,c){os("doBlockDownload()"),r.validateParams(["svc",e,"object"],["assetOrPresignedUrl",t,["object","string"]],["startByte",s,"number",!0],["endByte",o,"number",!0],["resource",n,"string",!0],["componentId",i,"string",!0],["version",a,"string",!0],["responseType",d,"enum",!0,D]),r.assert((()=>null==s||null==o||s<o),"endByte must be greater than startByte");const l=null!=this?this:{};if("string"==typeof t)return Ze.call(l,e,t,s,o,d,!0,void 0,c);const h=t;F(h.links,[p.BLOCK_DOWNLOAD]);const u=r.pruneUndefined({reltype:n,component_id:i,revision:a}),f=r.getLinkHrefTemplated(h.links,p.BLOCK_DOWNLOAD,{resource:void 0!==n?JSON.stringify(u):void 0});return Ze.call(l,e,f,s,o,d,!1,void 0,c)}function cs(e,t,s,o,n,i,a,d){return os("updatePrimaryResource()"),r.validateParams(["service",e,"object"],["asset",t,"object"],["dataOrSliceCallback",s,["function","object","string"]],["contentType",o,"string"],["size",n,"number",!0],["md5",a,"string",!0]),F(t.links,[p.PRIMARY]),Wt({svc:e,asset:t,dataOrSliceCallback:s,contentType:o,relation:p.PRIMARY,size:n,md5:a,maybeIsNew:!1,etag:i,additionalHeaders:d}).catch((r=>{var c;if(413===(null===(c=r.response)||void 0===c?void 0:c.statusCode))return Zt({service:U(e),asset:t,dataOrSliceCallback:s,contentType:o,relation:p.PRIMARY,size:n,md5:a,etag:i,additionalHeaders:d});throw r}))}const ps=t.newDebug("dcx:assets:pagination");class ls{constructor(t,s,r,o){if(this._links=t,this._svc=s,this._transformer=r,this._items={},this.ListResource=o,!t||!t[p.PAGE])throw new e.DCXError(e.DCXError.INVALID_PARAMS,"Asset must have links that contain a page relation.")}get items(){return Object.values(this._items)}get data(){return this._data}getPage(e={},t){ps("getPage()");const{embed:s}=e,o=m(e,["embed"]);s&&(o.embed=s.some((e=>"object"==typeof e))?JSON.stringify(s):s.join(",")),this.ListResource&&Object.assign(o,{resource:this.ListResource});const n=r.getLinkHrefTemplated(this._links,p.PAGE,o);return this._svc.invoke(exports.HTTPMethods.GET,n,t,void 0,{isStatusValid:K(),responseType:"json"}).then((e=>{const t=this.parseResponse(e);return this._data=t,{paged:this,result:this._data,response:e}}))}getNextPage(){if(ps("getNextPage()"),this.hasNextPage()&&this._nextPageLink)return this._svc.invoke(exports.HTTPMethods.GET,this._nextPageLink.href,void 0,void 0,{isStatusValid:K(),responseType:"json"}).then((e=>{const t=this.parseResponse(e);return this._data=t,{paged:this,result:this._data,response:e}}))}hasNextPage(){return ps("hasNextPage() ",void 0!==this._nextPageLink),void 0!==this._nextPageLink}*[Symbol.iterator](){for(const e in this._items)yield this._items[e]}[Symbol.asyncIterator](){return x(this,arguments,(function*(){for(const e in this._items)yield yield b(this._items[e]);for(;this.hasNextPage();){const e=yield b(this.next());for(const t of e.value.paged)yield yield b(t)}}))}next(){return v(this,void 0,void 0,(function*(){if(ps("next()"),!this.hasNextPage())return{done:!0,value:void 0};const e=yield this.getNextPage();return e?{done:!1,value:e}:{done:!0,value:void 0}}))}parseResponse(e){ps("parseResponse()"),this._items={};const t=e.response;for(const e in t[exports.Properties.CHILDREN]){const s=t[exports.Properties.CHILDREN][e],[r,o]=this._transformer(s,this._svc);this._items[r]=o}return this._nextPageLink=t[exports.Properties.LINKS].next,this.currentPage=t[exports.Properties.PAGE],t}}const hs=t.newDebug("dcx:assets:version"),us=t.newDebug("dcx:assets:version:leaf");class fs extends is{constructor(e,t,s){super(e,t,s),this._svc=t,this.type=a.Version,this._data=Ts(e)}get milestone(){return this._data.milestone}getRepositoryResource(){throw hs("getRepositoryResource()"),new e.DCXError(e.DCXError.NOT_IMPLEMENTED,"Method not implemented.")}getEffectivePrivileges(){throw hs("getEffectivePrivileges()"),new e.DCXError(e.DCXError.NOT_IMPLEMENTED,"Method not implemented.")}performBulkRequest(t,s){throw hs("performBulkRequest()"),new e.DCXError(e.DCXError.NOT_IMPLEMENTED,"Method not implemented.")}checkACLPrivilege(t,s){throw hs("checkACLPrivilege()"),new e.DCXError(e.DCXError.NOT_IMPLEMENTED,"Method not implemented.")}getACLPolicy(){throw hs("getACLPolicy()"),new e.DCXError(e.DCXError.NOT_IMPLEMENTED,"Method not implemented.")}}function _s(e){us("adobeVersionTransformer()");const t=Ts(e);return t.links=r.merge({},e.links,e._links),[t.version,t]}function Es(e,t){us("versionTransformer()");const s=new fs(e,t);return[s.version,s]}function Ts(e){us("deserializeVersion()");return{version:e.version||e[exports.VersionProperties.VERSION],createDate:e.created||e[exports.VersionProperties.CREATED],createdBy:e.createdBy||e[exports.VersionProperties.CREATED_BY],milestone:e.milestone||e[exports.VersionProperties.MILESTONE],links:e._links}}const gs=t.newDebug("dcx:assets:file"),Is=t.newDebug("dcx:assets:file:leaf");class Ps extends is{constructor(e,t,s){super(e,t,s),this.type=a.File}getPagedVersions(e={itemTransformer:Es},t){return gs("getPagedVersions()"),r.validateParams(["pageOpts",e,"object",!0]),this.fetchLinksIfMissing([p.PAGE],t).then((()=>ks(this._svc,this,e,t)))}getVersionResource(e,t){return gs("getVersionResource()"),r.validateParams(["version",e,"string"]),this.fetchLinksIfMissing([p.PAGE],t).then((()=>ys(this._svc,this,e,t).then((e=>({result:e.result?new fs(e.result,this._svc):void 0,response:e.response})))))}patchVersions(e,t,s){return gs("patchVersions()"),r.validateParams(["patchDoc",e,["string","array"]],["etag",t,"string",!0]),this.fetchLinksIfMissing([p.VERSION_HISTORY],s).then((()=>As(this._svc,this,e,t,s)))}initBlockUpload(e,t){return r.validateParams(["transferDocument",e,"object"],["additionalHeaders",t,"object",!0]),this.fetchLinksIfMissing([p.BLOCK_UPLOAD_INIT],t).then((()=>$t(this._svc,this,e,t)))}copy(e,t,s,r,o){return super.copy(e,t,s,r,o).then((({response:e,result:t})=>({response:e,result:new Ps(t,this.serviceConfig)})))}}function As(e,t,s,o,n){Is("patchVersions()"),r.validateParams(["svc",e,"object"],["asset",t,"object"],["patchDoc",s,["string","array"]],["etag",o,"string",!0]),F(t.links,[p.VERSION_HISTORY]);const i=Object.assign(Object.assign({},n),{[exports.HeaderKeys.CONTENT_TYPE]:_});o&&(i[exports.HeaderKeys.IF_MATCH]=o);const a=r.getLinkHref(t.links,p.VERSION_HISTORY);return e.invoke(exports.HTTPMethods.PATCH,a,i,"string"==typeof s?s:JSON.stringify(s),{isStatusValid:K()})}function ys(e,t,s,o){Is("getVersionResource()"),r.validateParams(["svc",e,"object"],["asset",t,"object"],["version",s,"string"]),F(t.links,[p.PAGE]),z(t.links,p.PAGE,"type",ns);const n=r.getLinkHrefTemplated(t.links,p.PAGE,{version:s});return e.invoke(exports.HTTPMethods.GET,n,o,void 0,{responseType:"json",isStatusValid:K()}).then((e=>({result:e.response[exports.VersionProperties.TOTAL_CHILDREN]>0?e.response[exports.Properties.CHILDREN][0]:void 0,response:e})))}function ks(e,t,s={},o){Is("getPagedVersions()"),r.validateParams(["svc",e,"object"],["asset",t,"object"],["pageOpts",s,"object"]),F(t.links,[p.PAGE]),z(t.links,p.PAGE,"type",ns);return new ls(t.links,e,s.itemTransformer||_s,p.VERSION_HISTORY).getPage(s,o)}const Ds=t.newDebug("dcx:assets:composite"),ms=t.newDebug("dcx:assets:composite:leaf"),vs=t.AdobeDCXLogger.getInstance();class bs extends Ps{constructor(e,t,s){super(e,t,s),this.type=a.Composite}headManifest(e){return Ds("headManifest()"),this.fetchLinksIfMissing([p.MANIFEST],e).then((()=>xs(this._svc,this,e))).then((e=>this._updateDataWithResponse(e)))}getManifest(e,t,s){return Ds("getManifest()"),r.validateParams(["version",e,"string",!0],["etag",t,"string",!0]),this.fetchLinksIfMissing([p.MANIFEST],s).then((()=>Os(this._svc,this,e,t,s)))}getManifestUrl(e){Ds("getManifestUrl()");const t=null==e?p.MANIFEST:p.PAGE;return this.fetchLinksIfMissing([t]).then((()=>Rs(this._svc,this,e)))}getManifestAndComponentsByPath(e,t,s,r){return ms("getManifestAndComponentsByPath()"),Ns(this._svc,this,e,t,s,r)}getComponent(e,t,s,r,o){Ds("getComponent()");const n={};return this._withSourcePromise(n).then((()=>Us.call(n,this._svc,this,e,t,s,r,o)))}getComponentByPath(e,t="defaultbuffer",s){return Ds("getComponentByPath()"),js(this.serviceConfig,this,e,t,s)}getComponentUrl(e,t,s){return Ds("getComponentUrl()"),this.fetchLinksIfMissing([p.COMPONENT],s).then((()=>Ms(this._svc,this,e,t)))}updateManifest(e,t,s,r,o){return Ds("updateManifest()"),this.fetchLinksIfMissing([p.MANIFEST],o).then((()=>Vs(this._svc,this,e,t,s,r,o))).then(this._updateDataWithResponse.bind(this))}putComponent(t,s,o,n,i,a,d,c){if(Ds("putComponent()"),n&&!r.verifyUuid(t))throw new e.DCXError(e.DCXError.INVALID_PARAMS,"Component id is not a uuid");return r.verifyUuid(t)||vs.warn("Existing component id is not a uuid"),this.fetchLinksIfMissing([p.COMPONENT],c).then((()=>Xs(this.serviceConfig,this,t,s,o,n,i,a,d,c)))}putEmbeddedMetadata(e,t,s="json",o){return r.validateParams(["data",e,["object","object[]","string"]],["etag",t,"string",!0],["format",s,"enum",!1,["json","xml"]]),this.fetchLinksIfMissing([p.EMBEDDED_METADATA],o).then((()=>ts(this._svc,this,e,t,s,o))).then((e=>v(this,void 0,void 0,(function*(){return yield this.headManifest(o),e}))))}patchEmbeddedMetadata(e,t,s){return r.validateParams(["data",e,["object","object[]","string"]],["etag",t,"string",!0]),this.fetchLinksIfMissing([p.EMBEDDED_METADATA],s).then((()=>ss(this._svc,this,e,t,s))).then((e=>v(this,void 0,void 0,(function*(){return yield this.headManifest(),e}))))}copy(e,t,s,r,o){return super.copy(e,t,s,r,o).then((({response:e,result:t})=>({response:e,result:new bs(t,this.serviceConfig)})))}}function xs(e,t,s){ms("headCompositeManifest()"),r.validateParams(["svc",e,"object"],["asset",t,"object"]),F(t.links,[p.MANIFEST]);const o=r.getLinkHref(t.links,p.MANIFEST);return e.invoke(exports.HTTPMethods.HEAD,o,s,void 0,{responseType:"json",isStatusValid:K()})}function Os(e,t,s,o,n){return ms("getCompositeManifest()"),r.validateParams(["svc",e,"object"],["asset",t,"object"],["version",s,"string",!0],["etag",o,"string",!0]),F(t.links,[p.MANIFEST]),Rs(e,t,s,n).then((t=>e.invoke(exports.HTTPMethods.GET,t,Object.assign(null!=n?n:{},o?{[exports.HeaderKeys.IF_NONE_MATCH]:o}:{}),void 0,{responseType:"json",isStatusValid:K([304])}))).then((e=>({manifestData:e.response||null,manifestEtag:e.headers.etag,response:e})))}function Rs(e,t,s,r){return ms("getCompositeManifestUrl()"),Cs(e,t,p.MANIFEST,s,r)}function Ss(e,t,s,o){return ms("_getComponentPathUrl()"),Cs(e,t,p.COMPONENT,t.version,o).then((e=>r.expandURITemplate(e,r.pruneUndefined({component_path:s}))))}function Cs(t,s,o,n,a){return ms("_getUrl()"),r.validateParams(["svc",t,"object"],["asset",s,"object"],["versionId",n,"string",!0]),i.default.resolve().then((()=>{if(n)return ys(t,s,n,a)})).then((t=>{if(null!=n){if(!t||!r.isObject(t)||"object"!=typeof t.result)throw new e.DCXError(e.DCXError.UNEXPECTED_RESPONSE,"Invalid version resource.",void 0,t?t.response:void 0);return F(t.result[exports.Properties.LINKS],[o]),r.getLinkHref(t.result[exports.Properties.LINKS],o)}return r.getLinkHref(s.links,o)}))}function Ns(t,s,o,n,a,d){r.validateParams(["svc",t,"object"],["asset",s,"object"],["components",o,"array"],["version",n,"string",!0],["etag",a,"string",!0]);const c=[p.MANIFEST,p.COMPONENT,p.BULK_REQUEST,p.BLOCK_DOWNLOAD];return n&&c.push(p.PAGE),jt(t,s,c,void 0,d).then((c=>v(this,void 0,void 0,(function*(){s.links=Object.assign({},s.links,c);const l=U(t),h=o.map((({component_path:e,responseType:t,subrequestHeaders:o})=>({method:exports.HTTPMethods.GET,href:r.getLinkHrefTemplated(s.links,p.COMPONENT,{component_path:e}),headers:Object.assign(o||{},d),component_path:e,responseType:t})));h.unshift({method:exports.HTTPMethods.GET,href:yield Rs(l,s,n,d),headers:Object.assign(a?{[exports.HeaderKeys.IF_NONE_MATCH]:a}:{},d)});const u=yield Promise.all(r.chunkArray(h,10).map((e=>lt(l,s,e,void 0,d,!0))));return i.default.resolve(yield u.reduce(((n,i)=>v(this,void 0,void 0,(function*(){var a,c;const u=yield n;if(u.responses.push(i.response),200!==i.response.statusCode)return u;const{componentResponses:_,manifestResponse:E}=function(t,s){return t.reduce(((t,r)=>{const o=s.find((e=>e.href===r.headers[exports.HeaderKeys.CONTENT_ID]));if(!o)throw new e.DCXError(e.DCXError.UNEXPECTED_RESPONSE,"Bulk sub-response content-id did not match any bulk request",void 0,r);return"component_path"in o?t.componentResponses.push(r):t.manifestResponse=r,t}),{componentResponses:[]})}(i.result,h),T={};if(o.forEach((e=>{e.hasOwnProperty("skipBlockDownload")&&(T[e.component_path]=e.skipBlockDownload)})),Object.assign(u.components,yield function(t,s,o,n,i,a){return v(this,void 0,void 0,(function*(){return(yield Promise.all(s.map((s=>v(this,void 0,void 0,(function*(){if(s.headers[exports.HeaderKeys.CONTENT_TYPE]===f&&s.response.type===e.ProblemTypes.RESPONSE_TOO_LARGE){const e=Ls(s,t),d=s.headers.location?s.headers.location:r.getLinkHrefTemplated(n,p.BLOCK_DOWNLOAD,{resource:JSON.stringify({component_path:e.component_path})});if(a&&a[e.component_path])return{statusCode:200,headers:r.pruneUndefined({[exports.HeaderKeys.CONTENT_TYPE]:s.headers["content-type"],[exports.HeaderKeys.CONTENT_LENGTH]:s.headers["content-length"],[exports.HeaderKeys.CONTENT_ID]:s.headers[exports.HeaderKeys.CONTENT_ID]}),responseType:"application/json",response:{href:d},message:"OK"};const c=yield Ze(U(o),d,void 0,void 0,"defaultbuffer",!0,void 0,i);return Object.assign(c.headers,{[exports.HeaderKeys.CONTENT_ID]:s.headers[exports.HeaderKeys.CONTENT_ID]}),c}return s})))))).reduce(((s,r)=>{const o=Ls(r,t);try{const t=e._responseToError(r);s[o.component_path]=Object.assign({},o,{response:r,[t?"error":"data"]:t||Bs(r.response,o.responseType||"defaultbuffer",r.headers["content-type"])})}catch(t){s[o.component_path]=Object.assign({},o,{response:r,error:new e.DCXError(e.DCXError.UNEXPECTED,"Error parsing sub-response into requested responseType",t)})}return s}),{})}))}(h.slice(1),_,t,s.links,d,T)),!E)return u;if(200===E.statusCode){u.manifest.data=Bs(E.response,"json"),u.manifest.response=E,N(s)&&"function"==typeof(null===(a=s.current)||void 0===a?void 0:a.parse)&&(s.current.parse(r.arrayBufferToString(E.response)),s.current.versionId=E.headers.version),s.links=ae(E);const e=V(t);return e&&e.setValueWithAsset(s.links,s),u}if(304===E.statusCode)return u.manifest.response=E,u;if(404===E.statusCode)return u.manifest.error=e._responseToError(E)||new e.DCXError(e.DCXError.NO_COMPOSITE,"Composite missing or deleted",void 0,E),u;if(E.headers[exports.HeaderKeys.CONTENT_TYPE]===f&&E.response.type===e.ProblemTypes.RESPONSE_TOO_LARGE){try{const e=E.headers.location?E.headers.location:r.getLinkHrefTemplated(s.links,p.BLOCK_DOWNLOAD,{resource:JSON.stringify({reltype:p.MANIFEST})}),t=yield Ze(l,e,void 0,void 0,"json",!0,void 0,d);u.manifest.data=t.response,u.manifest.response=t,N(s)&&"function"==typeof(null===(c=s.current)||void 0===c?void 0:c.parse)&&s.current.parse(JSON.stringify(t.response)),s.links=ae(t)}catch(t){u.manifest.error=t instanceof e.DCXError?t:new e.DCXError(e.DCXError.UNEXPECTED,"Error fetching manifest via block download",t)}return u}return u.manifest.error=e._responseToError(E)||new e.DCXError(e.DCXError.UNEXPECTED_RESPONSE,E.response.title||"Failed to fetch manifest. Operation failed.",void 0,E),u}))),Promise.resolve({manifest:{},components:{},responses:[]})))}))))}function Ls(t,s){if(!t.headers[exports.HeaderKeys.CONTENT_ID])throw new e.DCXError(e.DCXError.UNEXPECTED_RESPONSE,"Sub-response is missing content-id header",void 0,t);const r=s.find((({href:e})=>e===t.headers[exports.HeaderKeys.CONTENT_ID]));if(!r)throw new e.DCXError(e.DCXError.UNEXPECTED_RESPONSE,"Bulk sub-response content-id did not match any bulk request",void 0,t);return r}function Bs(t,s,o){if(!C(t))return t;switch(s){case"text":return r.arrayBufferToString(t);case"json":return JSON.parse(r.arrayBufferToString(t));case"blob":return new Blob([t],{type:o});case"buffer":case"defaultbuffer":return t;case"arraybuffer":return t.buffer}throw new e.DCXError(e.DCXError.INVALID_PARAMS,"requested response type is not supported")}function Ms(e,t,s,o){return ms("getCompositeComponentUrl()"),r.validateParams(["svc",e,"object"],["asset",t,"object"],["componentId",s,"string"],["componentRevision",o,"string",!0]),F(t.links,[p.COMPONENT]),r.getLinkHrefTemplated(t.links,p.COMPONENT,{component_id:s,revision:o})}function ws(t,s,o,n){return ms("getPresignedUrl()"),r.validateParams(["svc",t,"object"],["asset",s,"object"]),jt(t,s,[p.BLOCK_DOWNLOAD],void 0,n).then((e=>{const s=o?JSON.stringify(o):void 0,i=r.getLinkHrefTemplated(e,p.BLOCK_DOWNLOAD,{resource:s});return(w(t)?t.service:t).invoke(exports.HTTPMethods.GET,i,Object.assign({priority:"u=1"},n),void 0,{isStatusValid:K(),responseType:"json",retryOptions:{pollCodes:[202],pollHeader:"location",pollMethod:exports.HTTPMethods.GET}})})).then((t=>{if("string"!=typeof t.response.href)throw new e.DCXError(e.DCXError.INVALID_DATA,"Direct download URL not found.",void 0,t);return{response:t,result:t.response.href}}))}function Hs(e,t,s,o,n){return ms("getCompositeComponentPresignedUrl()"),r.validateParams(["svc",e,"object"],["asset",t,"object"],["componentId",s,"string"],["componentRevision",o,"string"]),ws(e,t,{reltype:p.COMPONENT,revision:o,component_id:s},n)}function js(e,t,s,o="defaultbuffer",n,i){return r.validateParams(["svc",e,"object"],["asset",t,"object"],["componentPath",s,"string"],["responseType",o,"string",!0],["additionalHeaders",n,"object",!0]),jt(e,t,[p.COMPONENT,p.PAGE],void 0,n).then((r=>{if(t.links=r,t.version)return Ss(U(e),t,s)})).then((a=>tt(U(e),t,null!=a?a:r.getLinkHrefTemplated(t.links,p.COMPONENT,{component_path:s}),p.COMPONENT,o,void 0,void 0,n,i)))}function Us(e,t,s,o,n="defaultbuffer",i,a){ms("getCompositeComponent()"),r.validateParams(["svc",e,"object"],["asset",t,"object"],["componentId",s,"string"],["componentRevision",o,"string"],["responseType",n,"string",!0],["additionalHeaders",i,"object",!0],["componentSize",a,"number",!0]);const d={};if(!a||a<Ve()){const r=Ms(e,t,s,o);return tt.call(d,e,t,r,p.COMPONENT,n,s,o,i)}return Hs(e,t,s,o,i).then((({response:t,result:s})=>Ze.call(d,e,s,void 0,void 0,n,!0,t.response.size,i)))}function Vs(t,s,o,n,i=1,a,d={}){if(ms("updateCompositeManifest() ",n,a),r.validateParams(["svc",t,"object"],["asset",s,"object"],["manifest",o,["object","string"]],["overwrite",n,"boolean"],["validationLevel",i,"+number"],["etag",a,"string",!0]),i<1)throw new e.DCXError(e.DCXError.INVALID_PARAMS,"ValidationLevel must be >=1");return F(s.links,[p.BULK_REQUEST,p.REPO_METADATA]),Rs(t,s,void 0,d).then((c=>v(this,void 0,void 0,(function*(){const l=Object.assign({},d);n?l[exports.HeaderKeys.IF_MATCH]="*":a&&(l[exports.HeaderKeys.IF_MATCH]=a);const u=`${h}; validation-level=${i}`;l[exports.HeaderKeys.CONTENT_TYPE]=u;const f="string"==typeof o?o:JSON.stringify(o),E=[{method:exports.HTTPMethods.PUT,href:c,headers:l,body:f}];if(s.deviceModifyDate){const e=JSON.stringify([{op:"add",path:`/${[exports.Properties.REPO_DEVICE_MODIFY_DATE]}`,value:s.deviceModifyDate}]),t={[exports.HeaderKeys.CONTENT_TYPE]:_};E.push({method:exports.HTTPMethods.PATCH,href:r.getLinkHref(s.links,p.REPO_METADATA),headers:t,body:e})}const{result:T,response:g}=yield lt(t,s,E,void 0,d,!0),{manifestResponse:I,repoMetadataResponse:P}=function(t,s){const r={manifestResponse:{},repoMetadataResponse:{}};return s.forEach((s=>{const o=t.find((e=>e.headers[exports.HeaderKeys.CONTENT_ID]===s.href));if(!o)throw new e.DCXError(e.DCXError.UNEXPECTED_RESPONSE,"Bulk sub-response content-id did not match any bulk request",void 0,o);s.href.includes(":repometadata")?r.repoMetadataResponse=o:r.manifestResponse=o})),r}(T,E);if(ms("uCM() status code for manifest response: ",I.statusCode),412===I.statusCode&&n)return ms("uCM() retry 412 without overwrite"),Vs(t,s,o,!1,i,void 0,d);if(409===I.statusCode&&n)return ms("uCM() retry 409 without overwrite"),Vs(t,s,o,!1,i,a,d);if(409===I.statusCode)throw new e.DCXError(e.DCXError.UPDATE_CONFLICT,"Manifest has been changed",void 0,I);if(412===I.statusCode)throw new e.DCXError(e.DCXError.PRECONDITION_FAILED,"Precondition failed",void 0,I);if(400===I.statusCode){const t=e._responseToError(I);throw new e.DCXError(null==t?void 0:t.code,null==t?void 0:t.message,void 0,I)}{const t=K()(I.statusCode,I);if(!0!==t)throw new e.DCXError(t.code||e.DCXError.UNEXPECTED_RESPONSE,t._message||t.message,t.underlyingError,I)}if(ms("uCM() status code for metadata response: ",P.statusCode),s.deviceModifyDate&&200!==P.statusCode&&201!==P.statusCode&&204!==P.statusCode)throw new e.DCXError(e.DCXError.UNEXPECTED_RESPONSE,"Unexpected HTTP Response",void 0,P);return I.xhr=g.xhr,I}))))}function Xs(t,s,o,n,i,a,d,c,l,h,u){if(r.validateParams(["service",t,"object"],["asset",s,"object"],["componentId",o,"string"],["contentType",i,"string"],["maybeIsNew",a,"boolean",!0],["size",d,"number",!0],["blockSize",u,"number",!0],["md5",c,"string",!0]),a&&!r.verifyUuid(o))throw new e.DCXError(e.DCXError.INVALID_PARAMS,"Component id is not a uuid");r.verifyUuid(o)||vs.warn("Existing component id is not a uuid");return Wt({svc:t,asset:s,dataOrSliceCallback:n,contentType:i,relation:p.COMPONENT,size:d,componentId:o,md5:c,maybeIsNew:a,additionalHeaders:h,progressCb:l,blockSize:u}).then((({response:e,result:t,isBlockUpload:s,asset:r})=>{const n={response:e,result:Object.assign(Object.assign({},t),{id:o,type:i}),isBlockUpload:s,asset:r};return Object.defineProperty(n,"compositeAsset",{get:()=>r}),n}))}const Ks=t.newDebug("dcx:assets:directory"),Fs=t.newDebug("dcx:assets:directory:leaf");class Gs extends Tt{constructor(e,t,s){super(e,t,s),this.type=a.Directory,this.children=[],this.children=e[exports.Properties.CHILDREN]}getPagedChildren(e,t){return Ks("getPagedChildren()"),this.fetchLinksIfMissing([p.PAGE],t).then((()=>qs(this._svc,this,e,t)))}createAsset(e,t,s,r,o,n,i,a,d){return Ks("createAsset()"),$s(this._svc,this,e,t,s,r,o,n,i,a,d).then((e=>({result:new Tt(e.result,this.serviceConfig),response:e.response})))}copy(e,t,s){return super.copy(e,t,s).then((({response:e,result:t})=>({response:e,result:new Gs(t,this.serviceConfig)})))}}function zs(e){var t;Fs("directoryTransformer()");const s=se(e,null===(t=e[exports.Properties.PAGE])||void 0===t?void 0:t.embed);s.links=r.merge({},e.links,e._links);const o=e.children||e[exports.Properties.CHILDREN];return o&&o.length>0?s.children=o.map((e=>se(e))):s.children=[],[s.assetId,s]}function Ys(e,t){return Fs("getDirectoryByURL()"),e.invoke(exports.HTTPMethods.GET,t,void 0,void 0,{responseType:"json",isStatusValid:K()}).then((e=>({result:e.response,response:e})))}function qs(t,s,r={},o){if(Fs("getPagedChildren()"),F(s.links,[p.PAGE]),r&&r.embed&&r.embed.includes(p.REPOSITORY))throw new e.DCXError(e.DCXError.INVALID_PARAMS,"Repository Resource embeds on directory listings are not supported");try{return new ls(s.links,t,zs,"api:primary").getPage(r,o)}catch(e){return i.default.reject(e)}}function $s(t,s,o,a,d,c,l={},h,u,f,_){Fs("createAsset()"),r.validateParams(["service",t,"object"],["parentDir",s,"object"],["relPath",o,"string"],["createIntermediates",a,"boolean"],["contentType",d,"string"],["respondWith",c,["string","object"],!0],["additionalHeaders",l,"object",!0],["repoMetaPatch",f,"object",!0]);const E=r.isObject(c)?JSON.stringify(c):c;return jt(t,s,[p.CREATE]).then((T=>{const g=r.getLinkHrefTemplated(T,p.CREATE,{path:o,intermediates:a.toString(),respondWith:E,mode:"id",repoMetaPatch:f}),I=Object.assign({},{[exports.HeaderKeys.CONTENT_TYPE]:d},l),P=U(t),A=h?Ue(h,u):void 0,y=A?je(A):0;return h&&Me(s,y)?Zt({service:P,contentType:d,relation:p.PRIMARY,asset:s,dataOrSliceCallback:h,size:y,relPath:o,createIntermediates:a,respondWith:c,repoMetaPatch:f,additionalHeaders:l,progressCb:_}).then((({result:e,response:t})=>{const s=o.split("/").slice(-1);return{result:r.pruneUndefined(r.mergeDeep({name:s},e)),response:t}})):i.default.resolve().then((()=>v(this,void 0,void 0,(function*(){const i=r.isAnyFunction(h)?yield h(0,y):A;return P.invoke(exports.HTTPMethods.POST,g,I,i,{responseType:"json",isStatusValid:K([413]),reuseRequestDesc:{id:"createAsset",method:exports.HTTPMethods.POST,href:g,headers:I,progress:_}}).then((i=>{var E;if(413===i.statusCode)return Zt({service:P,contentType:d,relation:p.PRIMARY,asset:s,dataOrSliceCallback:h,size:je(Ue(h,u)),relPath:o,createIntermediates:a,respondWith:c,repoMetaPatch:f,additionalHeaders:l,progressCb:_}).catch((t=>{var s;if(t.problemType===e.ProblemTypes.ASSET_NAME_CONFLICT){const e={assetId:null===(s=t.response.response)||void 0===s?void 0:s["repo:assetId"],links:ae(t.response)};return Zt({service:P,contentType:d,relation:p.PRIMARY,asset:e,dataOrSliceCallback:h,size:je(Ue(h,u)),relPath:o,createIntermediates:a,respondWith:c,repoMetaPatch:f,additionalHeaders:l,progressCb:_})}throw t})).then((({result:e,response:t})=>{const s=o.split("/")[o.split("/").length-1];return{result:r.pruneUndefined(r.mergeDeep({name:s},e)),response:t}}));const T=o.split("/")[o.split("/").length-1];let g;s.path&&(g=r.appendPathElements(s.path,o));const I=ae(i),A=i.headers;if(null===(E=A[exports.HeaderKeys.CONTENT_TYPE])||void 0===E?void 0:E.includes("multipart/mixed")){const t=it(i)[1];throw 404===t.statusCode?new n.default(e.DCXError.ASSET_NOT_FOUND,"Asset was created successfully but repository metadata could not be found.",void 0,i):403===t.statusCode?new n.default(e.DCXError.FORBIDDEN,"Asset was created successfully but Permission denied for fetching repository metadata.",void 0,i):e.unexpectedResponse("Unexpected Server Response",void 0,i)}const y=r.isObject(i.response)?i.response:{etag:"",md5:""},k=A["asset-id"]||A["x-resource-id"],D=s.repositoryId;let m=y.etag,v=y.md5;null==c&&(m=A.etag,v=A["content-md5"]);const b=r.isObject(i.response)&&c&&(c===p.REPO_METADATA||r.isObject(c)&&c.reltype===p.REPO_METADATA)?se(i.response):{},x=V(t);return x&&x.setValueWithAsset(I,b),{result:r.pruneUndefined(r.mergeDeep({name:T},b,r.pruneUndefined({links:I,assetId:k,etag:m,md5:v,repositoryId:D,format:d,path:g}))),response:i}}))}))))}))}const Ws=t.newDebug("dcx:assets:discoverable");function Zs(e){Ws("discoverableAssetTransformer()");const t=e[exports.Properties.EMBEDDED][p.REPO_METADATA],s=se(t,e[exports.Properties.EMBEDDED]);return s.links=r.merge({},e.links,t._links),[s.assetId,s]}function Js(e){Ws("discoverableReposTransformer()");const t=e[exports.Properties.EMBEDDED][p.PRIMARY],s=re(t);return s.links=t._links,[s.repositoryId,s]}const Qs=t.newDebug("dcx:assets:factory");function er(e,t){Qs("hydrateAsset()"),r.validateParams(["asset",e,"object"],["svc",t,"object"]);const s=e.format||"",o=s.endsWith("+dcx")?a.Composite:s===l?a.Directory:s.split("/").length>1?a.File:a.Asset;switch(o){case a.Directory:return e.type===o&&e instanceof Gs?e:new Gs(e,t);case a.Composite:return e.type===o&&e instanceof bs?e:new bs(e,t);case a.File:return e.type===o&&e instanceof Ps?e:new Ps(e,t);case a.Asset:return e.type===o&&e instanceof Tt?e:new Tt(e,t);default:return new Tt(e,t)}}const tr=t.newDebug("dcx:assets:indexdocument");function sr(e){tr("deserializeIndexDocument()");const t=e.children.map((e=>{const t=se(e[exports.Properties.EMBEDDED][p.REPO_METADATA]),s=re(e[exports.Properties.EMBEDDED][p.REPOSITORY]);return t.embedded={RepositoryResource:s},t}));return{regions:e[exports.Properties.REPO_REGIONS],assignedDirectories:t,links:e._links}}const rr=1e5;class or{constructor(t=1e5,s="SESSION"){if(this.values={},this.maxEntries=rr,this.promiseToResolveMap=new Map,t<=0)throw new e.DCXError(e.DCXError.INVALID_PARAMS,"Cache Max enteries must be great than 0.");this.maxEntries=t,this.defaultSessionKey=s}clear(){this.promiseToResolveMap.forEach((e=>{e.call(void 0)}));for(const e in this.values)this.values[e].clear();this.values={}}getKey(e){if(e.assetId||"object"!=typeof e)return e.assetId}getValueWithAsset(e){if(!e.assetId&&"object"==typeof e)return;const t=this.getKey(e);return t?this.get(t,e.repositoryId):void 0}setPending(e,t=this.defaultSessionKey){let s;this.values[t]||(this.values[t]=new Map);const r=this.values[t].get(e);if(r&&r instanceof Promise)return this.promiseToResolveMap.get(r);const o=new Promise((e=>{s=e}));return this.values[t].set(e,o),this.promiseToResolveMap.set(o,s),o.then((()=>this.promiseToResolveMap.delete(o))).catch((()=>this.promiseToResolveMap.delete(o))),s}get(e,t=this.defaultSessionKey){if(this.values[t]&&t in this.values)return this.values[t].get(e)}setValueWithAsset(e,t){if(!e)return;const s=this.getKey(t);if(s){const r=t.repositoryId||this.defaultSessionKey;this.set(e,s,r)}}set(e,t,s=this.defaultSessionKey){if(this.values[s]){if(this.values[s]&&this.values[s].get(t)instanceof Promise){const r=this.values[s].get(t),o=this.promiseToResolveMap.get(r);this.promiseToResolveMap.delete(r),o&&o(e)}}else this.values[s]=new Map;if(this.values[s].size>=this.maxEntries){const e=this.values[s].keys().next().value;this.values[s].delete(e)}this.values[s].set(t,Promise.resolve(e))}delete(e,t=this.defaultSessionKey){this.values[t]&&this.values[t].delete(e)}deleteWithAsset(e){const t=this.getKey(e);t&&this.delete(t,e.repositoryId)}}const nr=2592e6;var ir;exports.RenditionType=void 0,(ir=exports.RenditionType||(exports.RenditionType={})).IMAGE_JPG="image/jpg",ir.IMAGE_PNG="image/png",ir.IMAGE_GIF="image/gif",ir.VIDEO_MP4="video/mp4",ir.VIDEO_METADATA="application/vnd.adobe.ccv.videometadata";const ar=t.newDebug("dcx:assets:versionset"),dr=t.newDebug("dcx:assets:versionset:leaf");Object.defineProperty(exports,"ProblemTypes",{enumerable:!0,get:function(){return e.ProblemTypes}}),exports.ACLPolicyMediaType="application/vnd.adobecloud.accesscontrolpolicy+json",exports.Asset=Tt,exports.AssetFactory=class{constructor(e){this._svc=e}hydrate(e){return er(e,this._svc)}},exports.AssetTypes=a,exports.BlockTransferMediaType=E,exports.BlockUpload=qt,exports.COPY_RESOURCES_RESOURCE_LIMIT=30,exports.Composite=bs,exports.DEFAULT_BLOCK_DOWNLOAD_THRESHOLD=Ne,exports.DEFAULT_BLOCK_UPLOAD_THRESHOLD=Ce,exports.DEFAULT_CACHE_MAX_ENTRIES=rr,exports.DEFAULT_MAX_CONCURRENT_REQUESTS=4,exports.DEFAULT_STRING_LENGTH_CHECK=Le,exports.Directory=Gs,exports.DirectoryMediaType=l,exports.File=Ps,exports.GenericCache=or,exports.JSONLDMediaType="application/ld+json",exports.JSONMediaType=u,exports.JSONPatchMediaType=_,exports.JSONProblemMediaType=f,exports.LinkRelation=p,exports.MAX_CACHE_PERIOD_MS=nr,exports.ManifestMediaType=h,exports.OperationDocumentBuilder=ye,exports.OperationDocumentMediaType=T,exports.PageResource=ls,exports.RepositoryLinksCache=class extends or{constructor(e=1e5,t=2592e6){super(e,"SESSION"),this.timestampsOnLinkCreation=0,this.maxCachePeriodMS=0,this.maxCachePeriodMS=t}isLinkExpired(){return this.maxCachePeriodMS<Date.now()-this.timestampsOnLinkCreation}setIndexLinks(e){this.set(e,"INDEX","SESSION"),this.timestampsOnLinkCreation=Date.now()}getIndexLinks(){if(!this.isLinkExpired())return this.get("INDEX","SESSION")}setIndexRepository(e){this.indexRepository=e}getIndexRepository(){return this.indexRepository}setRepositoryLinks(e){this.set(e,"/Repositories","SESSION"),this.timestampsOnLinkCreation=Date.now()}getRepositoryLinks(){if(!this.isLinkExpired())return this.get("/Repositories","SESSION")}},exports.STREAMABLE_RESPONSE_TYPES=D,exports.Version=fs,exports.VersionSet=class{constructor(e,t,s){this._svc=t,this.versionCount=e.versionCount||e[exports.VersionProperties.TOTAL_CHILDREN],this.repositoryId=e.repositoryId||e[exports.Properties.REPO_REPOSITORY_ID],this.assetId=e.assetId||e[exports.Properties.REPO_ASSET_ID],this.versions=[];for(const s in e.versions||e[exports.Properties.CHILDREN])this.versions.push(new fs(e.versions&&e.versions[s]?e.versions[s]:e[exports.Properties.CHILDREN][s],t));this.links=r.merge({},e.links,e._links,s)}versionByVersionId(e){return ar("versionByVersionId()"),this.versions.find((t=>t.version===e))}versionsByLabel(e){return ar("versionsByLabel()"),this.versions.filter((t=>!(!t.milestone||t.milestone.label!==e)))}},exports._copyResources=Re,exports._getComponentPathUrl=Ss,exports._getUrl=Cs,exports._parseUploadableData=Ue,exports.adobeVersionTransformer=_s,exports.assertLinksContain=F,exports.assertLinksContainAny=G,exports.assertValidBulkRequest=pt,exports.assetTransformer=function(e){Et("assetTransformer()");const t=se(e);return t.links=r.merge({},e.links,e._links),[t.assetId,t]},exports.blockTransferManager=Jt,exports.bodyToUint8Array=nt,exports.buildRangeHeader=Qe,exports.checkACLPrivilege=Bt,exports.constructMultipartRequestBody=ot,exports.constructServiceEndpoint=X,exports.convertToACPRepoMetadataResource=function(e){te("convertToACPRepoMetadataResource()");const t={};return t[exports.Properties.REPO_REPOSITORY_ID]=e[exports.Properties.REPO_REPOSITORY_ID]||e.repositoryId,t[exports.Properties.REPO_ASSET_ID]=e[exports.Properties.REPO_ASSET_ID]||e.assetId,t[exports.Properties.REPO_NAME]=e[exports.Properties.REPO_NAME]||e.name,t[exports.Properties.REPO_SIZE]=null!=e[exports.Properties.REPO_SIZE]?e[exports.Properties.REPO_SIZE]:e.size,t[exports.Properties.REPO_PATH]=e[exports.Properties.REPO_PATH]||e.path,t[exports.Properties.REPO_ASSET_CLASS]=e[exports.Properties.REPO_ASSET_CLASS]||e.etag,t[exports.Properties.REPO_ETAG]=e[exports.Properties.REPO_ETAG]||e.etag,t[exports.Properties.REPO_VERSION]=e[exports.Properties.REPO_VERSION]||e.version,t[exports.Properties.DC_FORMAT]=e[exports.Properties.DC_FORMAT]||e.format,t[exports.Properties.REPO_CREATE_DATE]=e[exports.Properties.REPO_CREATE_DATE]||e.createDate,t[exports.Properties.REPO_MODIFY_DATE]=e[exports.Properties.REPO_MODIFY_DATE]||e.modifyDate||e.modifiedDate,t[exports.Properties.REPO_DISCARD_DATE]=e[exports.Properties.REPO_DISCARD_DATE]||e.discardDate,t[exports.Properties.REPO_CREATED_BY]=e[exports.Properties.REPO_CREATED_BY]||e.createdBy,t[exports.Properties.REPO_MODIFIED_BY]=e[exports.Properties.REPO_MODIFIED_BY]||e.modifiedBy,t[exports.Properties.REPO_DISCARDED_BY]=e[exports.Properties.REPO_DISCARDED_BY]||e.discardedBy,t[exports.Properties.REPO_DEVICE_CREATE_DATE]=e[exports.Properties.REPO_DEVICE_CREATE_DATE]||e.deviceCreateDate,t[exports.Properties.REPO_DEVICE_MODIFY_DATE]=e[exports.Properties.REPO_DEVICE_MODIFY_DATE]||e.deviceModifyDate,t[exports.Properties.REPO_DEFAULT_SCHEDULED_DELETION_DURATION]=e[exports.Properties.REPO_DEFAULT_SCHEDULED_DELETION_DURATION]||e.defaultScheduledDeletionDuration,t[exports.Properties.REPO_SCHEDULED_DELETION_DATE]=e[exports.Properties.REPO_SCHEDULED_DELETION_DATE]||e.scheduledDeletionDate,t[exports.Properties.REPO_BASE_ASSET_ID]=e[exports.Properties.REPO_BASE_ASSET_ID]||e.baseAssetId,t[exports.Properties.REPO_STATE]=e[exports.Properties.REPO_STATE]||e.state,t[exports.Properties.LINKS]=e[exports.Properties.LINKS]||e.links,t[exports.Properties.IMAGE_WIDTH]=e[exports.Properties.IMAGE_WIDTH]||e.width,t[exports.Properties.IMAGE_LENGTH]=e[exports.Properties.IMAGE_LENGTH]||e.length,r.pruneUndefined(t)},exports.copyAsset=he,exports.copyAssetResources=function(e,t,s,r,o,n,i){return Re(e,t,s,r,o,n,i)},exports.copyResources=function(e,t,s,r,o,n,i){return pe("copyResource()"),Re(e,t,s,r,o,n,i).then((e=>e.response)).then(be)},exports.createAsset=$s,exports.defaultBufferResponseType=Qt,exports.deleteACLPolicy=wt,exports.deleteAsset=Ee,exports.deserializeAsset=se,exports.deserializeIndexDocument=sr,exports.deserializeRepository=re,exports.deserializeUploadComponentRecord=Xe,exports.deserializeVersion=Ts,exports.deserializeVersionSet=function(e){dr("deserializeVersionSet()");const t={versionCount:e[exports.VersionProperties.TOTAL_CHILDREN],repositoryId:e[exports.VersionProperties.REPO_ID],assetId:e[exports.Properties.REPO_ASSET_ID],links:{},versions:[]},s=e.children||e[exports.Properties.CHILDREN];return s&&s.length>0&&(t.versions=s.map((e=>Ts(e)))),t.links=e._links,t},exports.directoryTransformer=zs,exports.discardAsset=_e,exports.discoverableAssetTransformer=Zs,exports.discoverableReposTransformer=Js,exports.doBatchOperation=function(e,t,s,r){return Ae(e,t,s,r).then(Ie)},exports.doBlockDownload=ds,exports.doLinksContain=Y,exports.doOperation=Ae,exports.doesAssetContainLinks=q,exports.fetchLinksForAsset=Dt,exports.fetchLinksForAssetWithResponse=mt,exports.fetchLinksIfMissing=jt,exports.getACLPolicy=Lt,exports.getAppMetadata=Rt,exports.getBaseDirectoryMetadata=bt,exports.getBlockDownloadThreshold=Ve,exports.getCompositeComponent=Us,exports.getCompositeComponentByPath=js,exports.getCompositeComponentPresignedUrl=Hs,exports.getCompositeComponentUrl=Ms,exports.getCompositeComponentsUrlsForUpload=function(t,s,o,n){return jt(t,s,[p.COMPONENT,p.BLOCK_UPLOAD_INIT],void 0,n).then((a=>{var d;const c=U(t);null===(d=V(t))||void 0===d||d.setValueWithAsset(a,s),s.links=Object.assign(Object.assign({},s.links),a);const l=r.normalizeHeaders(r.pruneUndefined(Object.assign(Object.assign({},n),{[exports.HeaderKeys.AUTHORIZATION]:c.authProvider.authToken,[exports.HeaderKeys.X_API_KEY]:c.authProvider.apiKey})));return Promise.all(o.map((t=>Me(s,t.size)?function(t,s,o,n){const i=r.pruneUndefined({"repo:reltype":p.COMPONENT,"repo:size":o.size,"dc:format":o.contentType,component_id:o.componentId});return $t(t,s,i,n).then((t=>{if(200!==t.response.statusCode)throw new e.DCXError(e.DCXError.UNEXPECTED_RESPONSE,"Unexpected response from block upload init",t.response);const s=t.result;return{blockSize:s[exports.BlockTransferProperties.REPO_BLOCK_SIZE],uploadRequestParameters:s[exports.Properties.LINKS][p.BLOCK_TRANSFER].map((({href:e})=>({href:e,method:exports.HTTPMethods.PUT}))),finalizeRequestParameters:{href:r.getLinkHrefTemplated(s[exports.Properties.LINKS],p.BLOCK_FINALIZE,{}),method:exports.HTTPMethods.POST,headers:n,body:`${JSON.stringify(s)}`}}})).catch((t=>{throw new e.DCXError(e.DCXError.UNEXPECTED_RESPONSE,"Unexpected response from block upload init",t)}))}(c,s,t,l):function(e,t,s,r){return i.default.resolve({blockSize:s.size,uploadRequestParameters:[{href:Ms(e,t,s.componentId),method:exports.HTTPMethods.PUT,headers:r}]})}(c,s,t,l))))}))},exports.getCompositeManifest=Os,exports.getCompositeManifestUrl=Rs,exports.getDataLength=je,exports.getDirectory=function(e,t){return Fs("directoryTransformer()"),jt(e,t,[p.PRIMARY]).then((t=>Ys(U(e),r.getLinkHref(t,p.PRIMARY))))},exports.getDirectoryByURL=Ys,exports.getDiscoverableAssets=function(e,t={},s){Ws("getDiscoverableAssets()"),r.validateParams(["svc",e,"object"],["pageOpts",t,"object"]);const o=U(e);return ie(e,s).then((e=>new ls(e.assetLinks,o,Zs,"api:primary").getPage(t,s))).then((e=>({result:e.response.response,paged:e.paged,response:e.response})))},exports.getDiscoverableRepos=function(e,t={},s){Ws("getDiscoverableRepos()"),r.validateParams(["svc",e,"object"],["pageOpts",t,"object"]);const o=U(e),n=X("/repositories",o);return i.default.resolve(void 0).then((()=>v(this,void 0,void 0,(function*(){const r=V(e);let i;if(r&&(i=yield r.getRepositoryLinks()),!i){i=ae(yield o.invoke(exports.HTTPMethods.HEAD,n,s,void 0,{isStatusValid:K()}))}r&&r.setRepositoryLinks(i);return new ls(i,o,Js).getPage(t,s)})))).then((e=>({result:e.response.response,paged:e.paged,response:e.response})))},exports.getEffectivePrivileges=Nt,exports.getEmbeddedMetadata=es,exports.getHTTPResource=ee,exports.getIndexDocument=function(e,t){tr("getIndexDocument()"),r.validateParams(["svc",e,"object"]);const s=U(e),o=X("/index",s);return s.invoke(exports.HTTPMethods.GET,o,t,void 0,{responseType:"json",isStatusValid:K()}).then((e=>({result:sr(e.response),response:e.response})))},exports.getIndexLinks=ne,exports.getIndexRepository=ie,exports.getLinksForAsset=vt,exports.getLinksFromCache=Ft,exports.getManifestAndComponentsByPath=Ns,exports.getOpsHref=ce,exports.getPagedChildren=qs,exports.getPagedVersions=ks,exports.getPresignedUrl=ws,exports.getPrimaryResource=gt,exports.getPubsAsset=function(e,t){oe("getPubsAsset()");const s=U(e),r=X("/index-pubs",s);return s.invoke(exports.HTTPMethods.GET,r,t,void 0,{responseType:"json",isStatusValid:K()}).then((t=>{const s=se(t.response.newPubsParentDir[exports.Properties.EMBEDDED]["http://ns.adobe.com/adobecloud/rel/metadata/repository"]),r=V(e);return r&&r.setValueWithAsset(s.links,s),s}))},exports.getRendition=as,exports.getRepoMetadata=function(e,t,s){Et("getRepoMetadata()"),r.validateParams(["svc",e,"object"],["asset",t,"object"]),F(t.links,[p.REPO_METADATA]);const o=r.getLinkHref(t.links,p.REPO_METADATA);return e.invoke(exports.HTTPMethods.GET,o,s,void 0,{responseType:"json",isStatusValid:K()}).then((e=>{const t=ae(e),s=e.response;return s[exports.Properties.LINKS]=r.merge({},s[exports.Properties.LINKS],t),{result:s,response:e}}))},exports.getRepositoryResource=xt,exports.getReposityLinksCache=V,exports.getResolveByIdHref=function(t){if(r.isObject(this)){if("string"==typeof this.resolveByIdHref)return i.default.resolve(this.resolveByIdHref);if(r.isFunction(this.resolveByIdHref))return i.default.resolve(this.resolveByIdHref())}return ne(t).then((t=>{try{return r.getLinkHref(t,p.RESOLVE_BY_ID)}catch(t){throw new e.DCXError(e.DCXError.UNEXPECTED,"Could not get ResolveByID href.",t)}}))},exports.getResolveByPathHref=function(t){if(r.isObject(this)){if("string"==typeof this.resolveByPathHref)return i.default.resolve(this.resolveByPathHref);if(r.isFunction(this.resolveByPathHref))return i.default.resolve(this.resolveByPathHref())}return ne(t).then((t=>{try{return r.getLinkHref(t,p.RESOLVE_BY_PATH)}catch(t){throw new e.DCXError(e.DCXError.UNEXPECTED,"Could not get ResolveByPath href.",t)}}))},exports.getResolveLinkForAsset=yt,exports.getService=U,exports.getVersionResource=ys,exports.headAppMetadata=Ot,exports.headCompositeManifest=xs,exports.headHTTPResource=Q,exports.headPrimaryResource=It,exports.hydrateAsset=er,exports.isAdobeCopyResourcesDocument=e=>"copy_resources"===e.op,exports.isAdobeDCXBranchLike=function(e){return r.isObject(e)&&(["compositeId","compositeAssetId","compositeRepositoryId"].some((t=>t in e))||r.isObject(e._core))},exports.isAdobeDCXCompositeLike=N,exports.isAdobeResponseLike=O,exports.isBlob=L,exports.isBufferLike=C,exports.isComponentResourceDesignator=function(e){return r.isObject(e)&&"component_id"in e},exports.isHttpService=M,exports.isMinimalAdobeAsset=function(e){return r.isObject(e)&&(r.isObject(e.links)||"string"==typeof e.repositoryId&&("string"==typeof e.path||"string"==typeof e.assetId))},exports.isRepoResponseLike=R,exports.isRepoResponseResultLike=S,exports.isResolvableAsset=B,exports.isServiceConfig=w,exports.isTransferDocument=H,exports.maybeGetBlockTransfer=Ke,exports.moveAsset=fe,exports.newBlockDownload=We,exports.newOperationDocBuilder=ke,exports.normalizeCopyResourcesDesignator=e=>{if((e=>e.hasOwnProperty("source")&&e.hasOwnProperty("target"))(e))return{source:ue(e.source),target:ue(e.target)};const t=ue(e);return{source:t,target:t}},exports.packageAssets=ge,exports.parseHttpResponseContent=ct,exports.parseLinkString=de,exports.parseLinksFromResponseHeader=ae,exports.parseMultipartResponseParts=it,exports.patchACLPolicy=Mt,exports.patchAppMetadata=Ct,exports.patchEmbeddedMetadata=ss,exports.patchVersions=As,exports.pauseBlockTransfer=function(e,t){return v(this,void 0,void 0,(function*(){const s=yield Ke(e);if(s)return t&&s.on("stateChanged",t),yield s.pause(),s}))},exports.performBulkRequest=lt,exports.putAppMetadata=St,exports.putCompositeComponent=Xs,exports.putEmbeddedMetadata=ts,exports.resolveAsset=kt,exports.restoreAsset=Te,exports.setBlockDownloadThreshold=t=>{if(Number.isNaN(t)||"number"!=typeof t||t<=0)throw new e.DCXError(e.DCXError.INVALID_PARAMS,"Invalid block download threshold, must be positive integer");Be=t},exports.shouldUseBlockTransferForDownload=(e,t=52428800)=>((e,t)=>e>=t)(e,t),exports.shouldUseBlockTransferForUpload=Me,exports.streamToGetSliceCallback=function(t,s,o,n=4){var i;const a=null!==(i=He(o))&&void 0!==i?i:Ce,d=a*n,c=new ArrayBuffer(d),p=new Uint8Array(c);let l=0;const h=r.isWHATWGReadableStream(t)?t.pipeThrough(function(e,t){let s;const r=new ByteLengthQueuingStrategy({highWaterMark:e*t});return{writable:new WritableStream({write(t){if(Se("Chunk Received:",t.byteLength),t.byteLength<e)s.enqueue(t);else{const r=Math.ceil(t.byteLength/e),o=[...Array(r).keys()].map((s=>t.subarray(s*e,Math.min((s+1)*e,t.byteLength))));for(const e of o)Se("enqueue smaller chunk:",e.byteLength),s.enqueue(e)}},close(){s.close()}},r),readable:new ReadableStream({start(e){s=e}},r)}}(a,n)).getReader():t;let u=!1,f=Promise.resolve();return function(t,s){return v(this,void 0,void 0,(function*(){if(u)return new Uint8Array([]);try{let e;const o=new Promise(((n,i)=>v(this,void 0,void 0,(function*(){function a(e){const r=l%d;if(e.byteLength+r>d){const t=d-r;p.set(e.subarray(0,t),r),p.set(e.subarray(t),0)}else p.set(e,r);if(l+=e.byteLength,Se(`chunk ${t}-${s} progress: ${l-t}/${s-t}`),l>=s){const e=p.subarray(t%d,s%d||s);Se(`resolving slice - start:  ${t}, end: ${s}, length: ${e.byteLength}`),n(e)}}if(r.isNodeReadableStream(h)){function c(){return v(this,void 0,void 0,(function*(){const e=h.read(s-l);null!==e&&a(e)}))}const _=()=>{u=!0,n(p.subarray(t%d,l%d||d))},E=()=>{h.off("readable",c),h.off("end",_),h.off("error",i)},T=()=>{h.on("readable",c),h.on("end",_),h.on("error",i)};e=()=>v(this,void 0,void 0,(function*(){T(),yield c(),o.finally(E)}))}else{function g(){return v(this,void 0,void 0,(function*(){const{value:e,done:r}=yield h.read();return r?(u=!0,Se("End of stream",t,l),n(p.subarray(t%d,l%d||d))):(a(e),l<=s?yield g():void 0)}))}e=()=>(Se("starting read for slice",t,s),g())}f=f.then((()=>v(this,void 0,void 0,(function*(){e(),yield o}))))}))));return o}catch(t){throw new e.DCXError(e.DCXError.UNEXPECTED,t.message,t)}}))}},exports.updateCompositeManifest=Vs,exports.updatePrimaryResource=cs,exports.useLinkOrResolveResource=Ht,exports.versionTransformer=Es,exports.waitForBlockDownloadToStart=function(e){return v(this,void 0,void 0,(function*(){yield Ke(e)}))};
//# sourceMappingURL=index.js.map
