/// <reference types="node" />

import { ACPAccessControlList } from '@dcx/common-types';
import { ACPCopyResourceDesignator } from '@dcx/common-types';
import { ACPIndexDocument } from '@dcx/common-types';
import { ACPProblemResponse } from '@dcx/common-types';
import { ACPRepoMetadataResource } from '@dcx/common-types';
import { ACPRepository } from '@dcx/common-types';
import { ACPTransferDocument } from '@dcx/common-types';
import { ACPVersion } from '@dcx/common-types';
import { ACPVersions } from '@dcx/common-types';
import { AdobeAsset } from '@dcx/common-types';
import { AdobeAssetEmbedded } from '@dcx/common-types';
import { AdobeAssetWithLinks } from '@dcx/common-types';
import { AdobeBlockDownload } from '@dcx/common-types';
import { AdobeBlockUpload } from '@dcx/common-types';
import { AdobeComponentUploadRecord } from '@dcx/common-types';
import { AdobeDCXBranch } from '@dcx/common-types';
import { AdobeDCXComposite } from '@dcx/common-types';
import { AdobeDCXError } from '@dcx/common-types';
import { default as AdobeDCXError_2 } from '@dcx/error';
import { AdobeHTTPService } from '@dcx/common-types';
import { AdobeMinimalAsset } from '@dcx/common-types';
import AdobePromise from '@dcx/promise';
import { AdobeRepoMetadata } from '@dcx/common-types';
import { AdobeRepository } from '@dcx/common-types';
import { AdobeRepoUploadResult } from '@dcx/common-types';
import { AdobeResponse } from '@dcx/common-types';
import { AdobeResponseType } from '@dcx/common-types';
import { AssetWithRepoAndPathOrId } from '@dcx/common-types';
import { BlockTransferDocument } from '@dcx/common-types';
import { BlockTransferState } from '@dcx/common-types';
import { ComponentResourceDesignator } from '@dcx/common-types';
import { ComponentUploadInfo } from '@dcx/common-types';
import { CopyResourceDesignator } from '@dcx/common-types';
import { DCXError } from '@dcx/error';
import { EffectivePrivileges } from '@dcx/common-types';
import { EmbeddableResource } from '@dcx/common-types';
import { EventEmitter } from '@dcx/util';
import { GetSliceCallback } from '@dcx/common-types';
import { HTTPMethod } from '@dcx/common-types';
import { IndexDocument } from '@dcx/common-types';
import { JSONPatchDocument } from '@dcx/common-types';
import { Link } from '@dcx/common-types';
import { LinkedResource } from '@dcx/common-types';
import { LinkMode } from '@dcx/common-types';
import { LinkProvider } from '@dcx/util';
import { LinkRelationKey as LinkRelationKey_2 } from '@dcx/common-types';
import { LinkSet } from '@dcx/common-types';
import { ManifestData } from '@dcx/common-types';
import { Privilege } from '@dcx/common-types';
import { ProblemTypes } from '@dcx/error';
import { ProgressCallback } from '@dcx/common-types';
import { RenditionOptions } from '@dcx/common-types';
import { RepoDownloadStreamableReturn } from '@dcx/common-types';
import { RepoMetaPatch } from '@dcx/common-types';
import { RequestDescriptor } from '@dcx/common-types';
import { RequireAtLeastOne } from '@dcx/common-types';
import { ResolvableResourceRelations } from '@dcx/common-types';
import { ResourceDesignator } from '@dcx/common-types';
import { ResponseTypeMap } from '@dcx/common-types';
import { SliceableData } from '@dcx/common-types';
import { UploadProgressCallback } from '@dcx/common-types';
import { UploadRecipe } from '@dcx/common-types';

/**
 * ACL Policy media type
 */
export declare const ACLPolicyMediaType = "application/vnd.adobecloud.accesscontrolpolicy+json";

export { AdobeAsset }

export declare interface AdobeComposite extends File_2 {
    headManifest(additionalHeaders?: Record<string, string>): AdobePromise<AdobeResponse<'void'>, AdobeDCXError>;
    getManifest<T = Record<string, unknown>>(version: string, etag: string, additionalHeaders: Record<string, string>): AdobePromise<RepoResponse<AdobeManifestResult<T>, 'json'>, AdobeDCXError>;
    getManifestUrl(versionId?: string): AdobePromise<string, AdobeDCXError>;
    getManifestAndComponentsByPath<C extends ComponentRequestByPath[]>(components: C, version?: string, etag?: string, additionalHeaders?: Record<string, string>): AdobePromise<ManifestAndComponentsByPathResponse<C>, AdobeDCXError>;
    getComponentUrl(componentId: string, version?: string): AdobePromise<string, AdobeDCXError>;
    getComponent<T extends AdobeResponseType = 'defaultbuffer'>(componentId: string, version?: string, responseType?: T, additionalHeaders?: Record<string, string>, componentSize?: number): RepoDownloadStreamableReturn<T>;
    updateManifest<T = string | Record<string, unknown>>(manifest: T, overwrite: boolean, validationLevel?: number, etag?: string, additionalHeaders?: Record<string, string>): AdobePromise<AdobeResponse, AdobeDCXError>;
    putComponent(componentId: string, data: Buffer | ArrayBuffer | Blob | string, contentType: string, maybeIsNew?: boolean, size?: number, md5?: string, progressCb?: UploadProgressCallback, additionalHeaders?: Record<string, string>): AdobePromise<AdobeRepoUploadResult, AdobeDCXError, {
        blockUpload?: AdobeBlockUpload;
    }>;
    putComponent(componentId: string, getSliceCallback: GetSliceCallback, contentType: string, maybeIsNew?: boolean, size?: number, md5?: string, progressCb?: UploadProgressCallback, additionalHeaders?: Record<string, string>): AdobePromise<AdobeRepoUploadResult, AdobeDCXError, {
        blockUpload?: AdobeBlockUpload;
    }>;
    putEmbeddedMetadata<T = Record<string, unknown>>(data: T, etag: string | undefined, format: EmbeddedMetadataRepresentation, additionalHeaders?: Record<string, string>): AdobePromise<AdobeResponse<'void'>>;
    patchEmbeddedMetadata(data: JSONPatchDocument | string, etag?: string, additionalHeaders?: Record<string, string>): AdobePromise<AdobeResponse<'void'>>;
    copy(destAsset: PathOrIdAssetDesignator, createIntermediates: boolean, overwriteExisting: boolean, additionalHeaders?: Record<string, string>, manifestPatch?: JSONPatchDocument): AdobePromise<RepoResponseResult<Composite, 'json'>, AdobeDCXError>;
}

declare type AdobeCompositeData = AdobeAsset;

export declare interface AdobeCopyResourcesDocument extends Omit<AdobeOperationDocument, 'target'> {
    op: 'copy_resources';
    source: PathOrIdAssetDesignator;
    target: PathOrIdAssetDesignator;
    resources: CopyResourceDesignator[];
}

export declare interface AdobeDirectory extends Asset<AdobeDirectoryData> {
    children: AdobeAsset[];
    /**
     * Returns a paged set of results for the directory listing
     * @param {PageOptions} pageOpts              Page options
     */
    getPagedChildren<T extends EmbeddableResource = never>(pageOpts?: PageOptions<T>): AdobePromise<RepoResponse<AdobeGetPageResult<AdobeAsset>>>;
    /**
     * Create an asset relative to the current directory.2
     *
     * @param {string} relPath                                      Path2 relative to current directory.
     * @param {boolean} createIntermediates                         Whether to create intermediate directories if they don't exist.
     * @param {string} contentType                                  Content type of the new asset.
     * @param {ResourceDesignator} [resourceDesignator]             Resource to be included in response.
     * @param {Record<string, string[]>} [additionalHeaders = {}]   Additional headers for the request.
     */
    createAsset(relPath: string, createIntermediates: boolean, contentType: string, resourceDesignator?: ResourceDesignator, additionalHeaders?: Record<string, string>): AdobePromise<RepoResponseResult<Asset>, AdobeDCXError_2>;
    /**
     * Copy the asset to some destination.
     *
     * @note
     * To copy to a new repositoryId, it must be specified in the destAsset.
     * If no repositoryId is specified, it will be moved to the same repository as the source asset instance.
     *
     * @param {AdobeAsset} destAsset            Asset containing either path or assetId
     * @param {boolean} createIntermediates     Whether to create intermediate directories if missing.
     * @param {boolean} overwriteExisting       Whether to overwrite an existing asset.
     *
     * @returns {AdobePromise<RepoResponseResult<Asset, 'json'>, AdobeDCXError>}
     */
    copy(destAsset: PathOrIdAssetDesignator, createIntermediates: boolean, overwriteExisting: boolean): AdobePromise<RepoResponseResult<Directory, 'json'>, AdobeDCXError_2>;
}

export declare type AdobeDirectoryData = AdobeAsset & Page;

export declare interface AdobeDiscardRestoreDocument extends AdobeOperationDocument {
    op: 'discard' | 'delete' | 'restore';
    recursive?: boolean;
    name?: string;
}

declare interface AdobeFileBase extends Asset<AdobeFileData> {
    getRendition<T extends AdobeResponseType>(opts?: RenditionOptions, responseType?: T, linkProvider?: LinkProvider<RenditionOptions>, additionalHeaders?: Record<string, string>): AdobePromise<RepoResponseResult<T>>;
    blockDownload<T extends AdobeResponseType>(startByte?: number, endByte?: number, resource?: LinkRelationKey_2, componentId?: string, version?: string, responseType?: T): RepoDownloadStreamableReturn<T>;
    /**
     * ******************************************************************************
     * Embedded metadata APIs
     * ******************************************************************************
     */
    /**
     * Get embedded metadata for the composite.
     *
     * @param {'json' | 'xml'}          format              Whether to return as JSON or XML.
     * @param {Record<string, string>}  additionalHeaders   Additional headers to be applied to HTTP requests
     */
    getEmbeddedMetadata<T = any>(format?: EmbeddedMetadataRepresentation, additionalHeaders?: Record<string, string>): AdobePromise<RepoResponseResult<T>>;
    /**
     * Update entire embedded/XMP metadata resource.
     *
     * @note
     * Replaces existing XMP resource.
     *
     * @note
     * Currently only supported on composites.
     *
     * @note
     * Currently the service requires an etag, but spec states unguarded updates should be possible.
     * The argument `etag` will be updated to optional when the service supports it.
     * See {@link https://jira.corp.adobe.com/browse/SYSE-7940|ticket}
     * and {@link https://jira.corp.adobe.com/browse/SYSE-5943|another ticket}
     *
     * @param {T = Record<string, unknown>} data            New embedded metadata
         * @param {string}                      etag            ETag of metadata resource to update.
         * @param {'json'|'xml'}                [format='json'] Defines the representation of the body, either XML or JSON.
         *                                                      If using XML, clients must pass the data as a string.
         *                                                      If using XML with TypeScript, clients must specify the generic as `string`.
         *                                                      Defaults to json.
         * @param {Record<string, string>}      additionalHeaders     Additional headers to attach to HTTP Requests
         */
     putEmbeddedMetadata<T = Record<string, unknown>>(data: T, etag: string /** TODO: Revisit optional etag, see: https://jira.corp.adobe.com/browse/SYSE-5943 */, format?: EmbeddedMetadataRepresentation, additionalHeaders?: Record<string, string>): AdobePromise<AdobeResponse<'void'>>;
     /**
      * Update embedded/XMP metadata using JSON Patch document.
      *
      * @see
      * https://tools.ietf.org/html/rfc6902#page-6
      *
      * @note
      * Currently the service requires an etag, but spec states unguarded updates should be possible.
      * The argument `etag` will be updated to optional when the service supports it.
      * see: https://jira.corp.adobe.com/browse/SYSE-7940
      * and: https://jira.corp.adobe.com/browse/SYSE-5943
      *
      * @param {JSONPatchDocument | string}      data      Data to use as PATCH body
      * @param {string}                          etag      ETag of the embedded metadata resource to be updated
      * @param {Record<string, string>}          additionalHeaders     Additional headers to attach to HTTP Requests
      */
     patchEmbeddedMetadata(data: JSONPatchDocument | string, etag: string /** TODO: Revisit optional etag, see: https://jira.corp.adobe.com/browse/SYSE-5943 */, additionalHeaders?: Record<string, string>): AdobePromise<AdobeResponse<'void'>>;
     /**
      * Update the asset's primary resource.
      *
      * @note Implicitly creates a new version of the asset.
      *
      * @param dataOrSliceCallback   Data to use for update, or callback to provide blocks for block upload.
      *                              If a callback is used, block upload will be used, regardless of size of the asset.
      * @param contentType           The content type of the resource to upload.
      * @param [size]                The size of the resource in bytes.
      * @param [etag]                The etag of the existing resource.
      * @param [md5]                 The MD5 hash of the resource, used for block upload finalize.
      * @param [additionalHeaders]   Additional headers to attach to HTTP Requests
      */
     updatePrimaryResource(dataOrSliceCallback: SliceableData | GetSliceCallback, contentType: string, size?: number, etag?: string, md5?: string, additionalHeaders?: Record<string, string>): AdobePromise<AdobeRepoUploadResult, AdobeDCXError, {
         blockUpload?: AdobeBlockUpload;
     }>;
    }

    declare abstract class AdobeFileBase extends Asset<AdobeFileData> implements AdobeFileBase {
        constructor(data: AdobeFileData, svc: AdobeHTTPService | ServiceConfig, links?: LinkSet);
        get width(): number | undefined;
        get length(): number | undefined;
        get renderable(): boolean | undefined;
    }

    declare interface AdobeFileData extends AdobeAsset {
        format?: string;
        version?: string;
        width?: number;
        height?: number;
        renderable?: boolean;
    }

    export declare interface AdobeGenericCache<T> {
        /**
         * Return the key for the passed asset
         * @param asset     The asset to get the key for
         */
        getKey(asset: AdobeAsset): string | undefined;
        /**
         * Returns a value for the asset from the cache
         * @param asset     The asset key
         */
        getValueWithAsset(asset: AdobeAsset): Promise<T> | undefined;
        /**
         * Sets a promise for the key that can be resolved with the value
         * @param key       The key
         * @param repoId    The repoId
         */
        setPending(key: string, repoId?: string): void;
        /**
         * Returns value for key from cache
         * @param key       Cache key
         * @param repoId    The repositoryId
         */
        get(key: string, repoId?: string): Promise<T> | undefined;
        /**
         * Sets value for asset as key, if no repoId is set on the asset the asset will be stored in the session
         * @param value     The value to set
         * @param asset     The asset to use as the key
         */
        setValueWithAsset(value: T, asset: AdobeAsset): void;
        /**
         * Sets the key value pair
         * @param value     The value
         * @param key       The key
         * @param repoId    The repoId
         */
        set(value: T, key: string, repoId?: string): void;
        /**
         * Delete entry at key
         * @param {string} key
         */
        delete(key: string): void;
        /**
         * Delete entry with asset key
         * @param {AdobeAsset} asset
         */
        deleteWithAsset(asset: AdobeAsset): void;
    }

    export declare interface AdobeGetDirectoryDataResult {
        result: AdobeDirectoryData;
    }

    /**
     * Instance type is returned (From instance method or session)
     */
    export declare interface AdobeGetDirectoryResult {
        result: Directory;
    }

    export declare interface AdobeGetPageResult<T> {
        paged: PageResource<T>;
        result: any;
    }

    export declare interface AdobeManifestResult<T> {
        manifestData: T;
        manifestEtag: string;
    }

    export declare interface AdobeMoveCopyDocument extends AdobeOperationDocument {
        op: 'move' | 'copy';
        source: AdobeOperationSource | AdobeOperationSource[];
        intermediates?: boolean;
        asset?: AdobeAsset | ACPRepoMetadataResource;
    }

    export declare type AdobeOperation = 'move' | 'copy' | 'discard' | 'restore' | 'package' | 'delete' | 'copy_resources';

    export declare interface AdobeOperationDocument {
        op: AdobeOperation;
        target: AdobeOperationSource | AdobeOperationSource[];
        [key: string]: unknown;
    }

    export declare type AdobeOperationResult = Omit<OperationResult, 'error'> & {
        error?: AdobeDCXError<ACPProblemResponse>;
        _additionalData?: ACPProblemResponse;
    };

    declare type AdobeOperationSource = OperationSource & RequireAtLeastOne<{
        repositoryId?: string;
        'repo:repositoryId'?: string;
    }, 'repositoryId' | 'repo:repositoryId'>;

    /**
     * Scope for leaf methods calling ops or resolve APIs.
     *
     * Allows bypassing caching while still using
     * common links that can be retained for long times.
     *
     * ie. operations endpoint and resolve API
     */
    export declare interface AdobeOpsContext {
        opsHref?: string | (() => string) | (() => Promise<string>);
        resolveByPathHref?: string | (() => string) | (() => Promise<string>);
        resolveByIdHref?: string | (() => string) | (() => Promise<string>);
    }

    export declare interface AdobePackageDocument extends AdobeOperationDocument {
        op: 'package';
        source?: AdobeOperationSource | AdobeOperationSource[];
    }

    declare interface AdobeRepoResponse<U extends AdobeResponseType> {
        response: AdobeResponse<U>;
    }

    export declare interface AdobeRepositoryLinksCache<LinkSet> extends AdobeGenericCache<LinkSet> {
        /**
         * Set the index links
         * @param value     The value to cache
         */
        setIndexLinks(value: LinkSet): void;
        /**
         * Returns the index links, these links contain the resolve and ops links
         */
        getIndexLinks(): Promise<LinkSet> | undefined;
        /**
         * Set the index document links
         * @param value     The value to cache
         */
        setIndexRepository(values: IndexRepository): void;
        /**
         * Returns the index document links
         */
        getIndexRepository(): IndexRepository | undefined;
        /**
         * Set the repository links
         * @param value     The value to cache
         */
        setRepositoryLinks(value: LinkSet): void;
        /**
         * Get the repository links
         */
        getRepositoryLinks(): Promise<LinkSet> | undefined;
    }

    /**
     * Defines the possible context provided to a leaf function that may use streaming.
     *
     * If in streaming mode (responseType='stream'), and if previous asynchronous methods
     * were called before reaching the leaf method, a stream would have been created synchronously
     * and attached to the AdobePromise source object.
     *
     * If a stream exists in the context, it should be used instead of creating a new stream.
     */
    export declare type AdobeStreamableContext = {
        blockDownload?: AdobeBlockDownload;
    };

    export declare interface AdobeSuccessResult {
        success: boolean;
    }

    export declare interface AdobeVersion extends Partial<Omit<AdobeAsset, 'name' | 'path'>> {
        milestone?: AdobeVersionMilestone;
    }

    export declare interface AdobeVersionMilestone {
        label: string;
        description?: string;
    }

    export declare interface AdobeVersionPatchOperation {
        op: 'add' | 'replace' | 'remove';
        path: string;
        value?: AdobeVersionMilestone;
    }

    export declare interface AdobeVersionSet {
        repositoryId: string | undefined;
        assetId: string | undefined;
        versions: AdobeVersion[];
        versionCount: number | undefined;
        links?: LinkSet;
    }

    export declare function adobeVersionTransformer(data: AdobeVersion & ACPVersion): [string, AdobeVersion];

    export declare type AnyOperationDocument = AdobeMoveCopyDocument | AdobeCopyResourcesDocument | AdobeDiscardRestoreDocument | AdobePackageDocument;

    export declare const assertLinksContain: (links: LinkSet | undefined, requiredLinkTypes?: LinkRelationKey_2[], errorCode?: string, errorMessage?: string) => void;

    export declare const assertLinksContainAny: (links?: LinkSet, anyOneLinkRequiredInPreferredOrder?: LinkRelationKey_2[]) => LinkRelationKey_2;

    export declare function assertValidBulkRequest(requests: BulkRequestDescriptor[]): void;

    export declare interface Asset<T extends AdobeAsset> extends AdobeAsset {
        readonly type: AssetType;
        /**
         * Performs a HEAD operation on the Asset
         * @param additionalHeaders Additional headers to be applied to HTTP requests
         */
        headPrimaryResource(additionalHeaders?: Record<string, string>): AdobePromise<AdobeResponse<'void'>>;
        /**
         * Downloads an asset's primary resource
         * @param responseType - Type to tranform response into
         * @param additionalHeaders Additional headers to be applied to HTTP requests
         */
        getPrimaryResource<R extends AdobeResponseType>(responseType?: R, additionalHeaders?: Record<string, string>): RepoDownloadStreamableReturn<R>;
        /**
         * Retrieves the repository metadata resource for the asset
         * @param additionalHeaders Additional headers to be applied to HTTP requests
         */
        getRepoMetadata(additionalHeaders?: Record<string, string>): AdobePromise<RepoResponseResult<AdobeRepoMetadata>, AdobeDCXError>;
        /**
         * @hidden
         * Retrieves the repository metadata for the base directory of the asset
         */
        getBaseDirectoryMetadata(): AdobePromise<AdobeRepoMetadata>;
        /**
         * Fetches, Hydrates and returns the assets links
         *
         * @returns {AdobePromise<LinkSet>}
         */
        getLinks(additionalHeaders?: Record<string, string>): AdobePromise<LinkSet>;
        /**
         * Get the repository resource for an asset
         * @param additionalHeaders Additional headers to be applied to HTTP requests
         */
        getRepositoryResource(additionalHeaders?: Record<string, string>): AdobePromise<RepoResponseResult<ACPRepository>, AdobeDCXError>;
        /**
         * Performs a HEAD request on the application metadata resource.
         * @param additionalHeaders Additional headers to be applied to HTTP requests
         */
        headAppMetadata(additionalHeaders?: Record<string, string>): AdobePromise<AdobeResponse<'void'>, AdobeDCXError>;
        /**
         * Returns the application metadata associated with the asset.
         *
         * @example
         * ```ts
         * const { result, etag, response } = await asset.getAppMetadata(etag);
         * // result is type object, the app metadata (undefined if etag was provided and not modified)
         * // etag is type string, the app metadata's etag
         * // response is type AdobeResponse
         * ```
         *
         * @note
         * Browser clients may prefer *not* using the etag parameter, instead relying on
         * the browser's HTTP cache to add the header, unless you are managing a cache yourself.
         *
         * @note
         * If etag provided and resource has not been modified, result will be `null`.
         *
         * @param etag    If specified, will be passed as the If-None-Match header value.
         *                  Note: this etag refers to the application metadata resource.
         *
         * @param additionalHeaders Additional headers to be applied to HTTP requests
         */
        getAppMetadata<R = any>(etag?: string, additionalHeaders?: Record<string, string>): AdobePromise<RepoResponseResult<R> & {
            etag: string;
        }, AdobeDCXError>;
        /**
         * Creates application metadata for an asset.
         * @example
         * ```ts
         * const { result, response } = await asset.putAppMetadata(obj, etag);
         * // result is type object, shape: { etag: string }, with etag being the
         * //                        value of the new app metadata resource's etag
         * // response is type AdobeResponse
         * ```
         *
         * @note Replaces the entire resource.
         *
         * @param metadata  New application metadata JSON object
         * @param etag      If specified, will be passed as the If-Match header value.
         *                      Note: this etag refers to the application metadata resource.
         * @param additionalHeaders Additional headers to be applied to HTTP requests
         */
        putAppMetadata<R = string | Record<string, unknown>>(metadata: R, etag?: string, additionalHeaders?: Record<string, string>): AdobePromise<RepoResponseResult<{
            etag: string;
        }>, AdobeDCXError>;
        /**
         * Update application metadata associated with the asset.
         *
         * @param patchDoc              JSON Patch Document to apply.
         *                              {@link https://git.corp.adobe.com/pages/caf/api-spec/#patch|RFC 6902}
         * @param etag                  ETag of the application metadata resource.
         *                              Used as the If-Match header value.
         *                              For unconditional update, use wildcard "*".
         *
         * @param additionalHeaders Additional headers to be applied to HTTP requests
         * @returns {AdobePromise<RepoResponseResult<{ etag: string }>, AdobeDCXError>}
         */
        patchAppMetadata<R = string | JSONPatchDocument>(patchDoc: R, etag: string, additionalHeaders?: Record<string, string>): AdobePromise<RepoResponseResult<{
            etag: string;
        }>, AdobeDCXError>;
        /**
         * Retrieves the effective privileges for the various resources of the asset
         * @param additionalHeaders Additional headers to be applied to HTTP requests
         */
        getEffectivePrivileges(additionalHeaders?: Record<string, string>): AdobePromise<RepoResponseResult<EffectivePrivileges>, AdobeDCXError>;
        /**
         * Executes a bulk request that allows clients to combine multiple read or write operations into a single HTTP request.
         *
         * Bulk Requests have the limitations below:
         * 1) Bulk requests must pertain to the Resources of a single Asset.
         * 2) User agents can either read multiple Resources (with HEAD and GET requests) or write multiple Resources
         *    (with POST, PUT, PATCH, and DELETE requests), but cannot mix these.
         * 3) Bulk requests may be issued using both ID-based and path-based Links, but these may not be mixed in
         *    a single request. The addressing mode used in each sub-request must match that of the bulk request.
         *
         * @note Currently only supports bulk READ Operations
         *
         * @param requests      A list of BulkRequestDescriptor's to be included as part of the bulk request
         * @param linkMode      The link mode used by the requests
         * @param additionalHeaders Additional headers to be applied to HTTP requests
         */
        performBulkRequest(requests: BulkRequestDescriptor[], linkMode?: LinkMode, additionalHeaders?: Record<string, string>): AdobePromise<RepoResponseResult<AdobeResponse[]>, AdobeDCXError>;
        /**
         * Fetch's the links for the asset if the optionally provded link relation is missing from the instance
         * @param linksToPopulate       The link relation that is needed
         * @param additionalHeaders Additional headers to be applied to HTTP requests
         */
        fetchLinksIfMissing(linksToPopulate: LinkRelationKey[], additionalHeaders?: Record<string, string>): AdobePromise<Asset, AdobeDCXError, RequestDescriptor>;
        /**
         * Retrieves the ACL resource for an asset
         * @param additionalHeaders Additional headers to be applied to HTTP requests
         */
        getACLPolicy(additionalHeaders?: Record<string, string>): AdobePromise<RepoResponseResult<ACPAccessControlList>, AdobeDCXError>;
        /**
         * Checks whether the current user has the requested Privilege on the specified Resource of an Asset.
         * @param privilege             The Privilege to be checked. Legal values are read, write, delete, and ack.
         * @param relation              The LinkRelation type of the Resource whose Privilege will be checked.
         * @param additionalHeaders Additional headers to be applied to HTTP requests
         */
        checkACLPrivilege(privilege: Omit<Privilege, 'none'>, relation: LinkRelationKey, additionalHeaders?: Record<string, string>): AdobePromise<RepoResponseResult<boolean>, AdobeDCXError>;
        /**
         * Patch the ACL policy for this asset using a JSON Patch Document or stringified representation.
         * @param policy A JSON Patch Document in string on JSON format representing the patch operations to perform on the ACL
         * @param etag Optional etag for the ACL policy. If supplied, the patch will only be performed if the remote policy's etag matches the one provided.
         * @param additionalHeaders Additional headers to be applied to HTTP requests
         * @see {@link https://acpcs.corp.adobe.com/apis/?choose=aclfrontservice#operation/jsonPatchPolicy patch documentation}
         */
        patchACLPolicy(policy: JSONPatchDocument | string, etag?: string, additionalHeaders?: Record<string, string>): AdobePromise<RepoResponseResult<ACPAccessControlList>, AdobeDCXError>;
        /**
         * Issues a DELETE request against an asset's ACL Policy removing all ACEs.
         *
         * @param additionalHeaders Additional headers to be applied to HTTP requests
         * @returns {AdobePromise<RepoResponseResult<'json'>, AdobeDCXError>}
         */
        deleteACLPolicy(additionalHeaders?: Record<string, string>): AdobePromise<RepoResponseResult<'json'>, AdobeDCXError>;
        /**
         * ******************************************************************************
         * Operations
         * ******************************************************************************
         */
        /**
         * Copy the asset to some destination.
         *
         * @note
         * To copy to a new repositoryId, it must be specified in the destAsset.
         * If no repositoryId is specified, it will be moved to the same repository as the source asset instance.
         *
         * @param destAsset             Asset containing either path or assetId
         * @param createIntermediates   Whether to create intermediate directories if missing.
         * @param overwriteExisting     Whether to overwrite an existing asset.
         * @param additionalHeaders     Additional headers to apply to HTTP Requests
         * @param manifestPatch         A JSON Patch Document to be applied to the target asset's manifest.
         */
        copy(destAsset: PathOrIdAssetDesignator, createIntermediates: boolean, overwriteExisting: boolean, additionalHeaders?: Record<string, string>, manifestPatch?: JSONPatchDocument): AdobePromise<RepoResponseResult<Asset, 'json'>, AdobeDCXError>;
        /**
         * Move the asset, uses the operation endpoint.
         *
         * @note
         * To move to a new repositoryId, it must be specified in the destAsset.
         * If no repositoryId is specified, it will be moved to the same repository as the source asset instance.
         *
         * @param {AdobeAsset} destAsset - Asset containing either path or assetId
         * @param {boolean} createIntermediates - Whether to create intermediate directories if missing.
         * @param {boolean} overwriteExisting - Whether to overwrite the existing asset.
         * @param {Record<string, string>} additionalHeaders - Additional headers to apply to HTTP Requests
         *
         * @returns {AdobePromise<RepoResponseResult<Asset, 'json'>, AdobeDCXError>}
         */
        move(destAsset: PathOrIdAssetDesignator, createIntermediates: boolean, overwriteExisting: boolean, additionalHeaders?: Record<string, string>): AdobePromise<RepoResponseResult<Asset, 'json'>, AdobeDCXError>;
        /**
         * Deletes the asset, irreversible.
         * If the asset is a directory, recursive is a required parameter.
         *
         * @param {string}  [etag]              Etag of asset to delete, if undefined will delete unconditionally.
         * @param {boolean} [recursive]         Whether the delete should delete subdirectories recursively, required for directory.
         * @param {Record<string, string>} additionalHeaders    Additional headers to apply to HTTP Requests.
         *
         * @returns AdobePromise<RepoResponseSuccessResult<'json'>, AdobeDCXError>
         */
        delete(etag?: string, recursive?: boolean, additionalHeaders?: Record<string, string>): AdobePromise<RepoResponseSuccessResult<'json'>, AdobeDCXError>;
        /**
         * Discards the asset, can be reversed with restore.
         *
         * @param {boolean} [etag]              Etag of the asset to discard, if undefined will discard unconditionally.
         * @param {boolean} [recursive]         Whether the delete should delete subdirectories recursively, required for directory.
         * @param {Record<string, string>} [additionalHeaders]    Additional headers to apply to HTTP Requests.
         *
         * @returns {AdobePromise<RepoResponseSuccessResult<'json'>, AdobeDCXError>}
         */
        discard(etag?: string, recursive?: boolean, additionalHeaders?: Record<string, string>): AdobePromise<RepoResponseSuccessResult<'json'>, AdobeDCXError>;
        /**
         * Restores the asset, can only be performed on discarded assets.
         *
         * @param {Record<string, string>} [additionalHeaders]    Additional headers to apply to HTTP Requests.
         *
         * @returns {AdobePromise<RepoResponseResult<Asset, 'json'>, AdobeDCXError>}
         */
        restore(additionalHeaders?: Record<string, string>): AdobePromise<RepoResponseResult<Asset, 'json'>, AdobeDCXError>;
        /**
         * Package the asset into a zip file.
         *
         * @note
         * To package to a new repositoryId, it must be specified in the destAsset.
         * If no repositoryId is specified, it will be packaged to the same repository as the source asset instance.
         *
         * @param {AdobeAsset} destAsset - Asset containing either path or assetId.
         * @param {boolean} createIntermediates - Whether to create intermediate directories if missing.
         * @param {boolean} overwriteExisting - Whether to overwrite the existing asset.
         * @param {Record<string, string>} additionalHeaders - Additional headers to apply to HTTP Requests.
         *
         * @returns {AdobePromise<RepoResponseSuccessResult<'json'>, AdobeDCXError>}
         */
        package(destAsset: PathOrIdAssetDesignator, createIntermediates: boolean, overwriteExisting: boolean, additionalHeaders?: Record<string, string>): AdobePromise<RepoResponseSuccessResult<'json'>, AdobeDCXError>;
        /**
         * Copies resources from source to target asset using the COPY_RESOURCES operation.
         * See {@link https://git.corp.adobe.com/pages/caf/api-spec/chapters/operations/copying_resources.html}
         *
         *
         * @param {PathOrIdAssetDesignator} sourceAsset                     The source asset
         * @param {PathOrIdAssetDesignator} targetAsset                     The destination asset
         * @param {CopyResourceDesignator[]} resources                      An array of resource designators to be copied from the source to the target asset.
         * @param {boolean} [intermediates]                                 Whether to create intermediate directories if missing.
         * @param {JSONPatchDocument} [manifestPatch]                       A JSON Patch Document to be applied to the target asset's manifest.
         * @param {Record<string, string>} [additionalHeaders]              Additional headers to apply to HTTP Requests.
         *
         * @returns {AdobePromise<RepoResponseResult<AdobeAsset, 'json'>, AdobeDCXError>}
         */
        copyResources(targetAsset: PathOrIdAssetDesignator, resources: CopyResourceDesignator[], intermediates?: boolean, manifestPatch?: JSONPatchDocument, additionalHeaders?: Record<string, string>): AdobePromise<RepoResponseResult<CopyResourcesOperationResult, 'json'>, AdobeDCXError>;
    }

    export declare class Asset<T extends AdobeAsset = AdobeAsset> implements Asset<T>, LinkedResource {
        readonly type: AssetType;
        /**
         * Underlying Data Source
         */
        protected _data: T;
        /**
         * Service Instance
         */
        protected _svc: AdobeHTTPService;
        /**
         * Links Cache
         */
        protected _cache: AdobeRepositoryLinksCache<LinkSet> | undefined;
        /**
         * The assets links
         */
        private _links;
        constructor(data: T | ACPRepoMetadataResource, svcOrSvcConfig: AdobeHTTPService | ServiceConfig, links?: LinkSet);
        /**
         * ******************************************************************************
         * LinkedResource Interface Implementation
         * ******************************************************************************
         */
        /**
         * Set links on asset
         * @param links
         */
        setLinks(links: LinkSet): void;
        /**
         * Returns the links for this asset if they have been hydrated
         *
         * @returns {LinkSet}
         */
        get links(): LinkSet;
        set links(links: LinkSet);
        /**
         * Sets the links
         * @param {string} relationship     The link relation key
         * @param {Link} link               The link
         */
        setLink(relationship: string, link: Link): void;
        /**
         * Returns a Link by relation
         * @param {stirng} relationship     The link relation key
         *
         * @returns {Link}
         */
        getLink(relationship: string): Link;
        /**
         * Removes a link
         * @param relationship      The relation key of the link to remove
         *
         * @returns {void}
         */
        removeLink(relationship: string): void;
        /**
         * @private
         *
         * Updates the cache with the assets links
         *
         * @returns {void}
         */
        private _updateCachedLinks;
        /**
         * Gets a property for a link relationship
         * @param relationship      The link relation key
         * @param property          The property to fetch
         * @param linkMode          The link mode
         *
         * @returns {string | undefined}
         */
        getLinkProperty(relationship: string, property: string, linkMode?: LinkMode): string | undefined;
        /**
         * Returns a Link Href for a templated link
         * @param {string} relationship                                                                                   The link relation key
         * @param {Record<string, (string | number) | (string | number)[] | Record<string, string | number>>} values      The values to populate the template with
         * @param {LinkMode} linkMode                                                                                     The link mode
         *
         * @returns {string | undefined}
         */
        getLinkHrefTemplated(relationship: string, values: Record<string, (string | number) | (string | number)[] | Record<string, string | number>>, linkMode?: LinkMode): string | undefined;
        /**
         * Returns the href of a link
         * @param relationship      The link relation key
         * @param linkMode          The link mode
         *
         * @returns {string | undefined}
         */
        getLinkHref(relationship: string, linkMode?: LinkMode): string | undefined;
        /**
         * ******************************************************************************
         * Getters/Setters
         * ******************************************************************************
         */
        /**
         * Returns an AdobeAsset representation of this Asset instance
         *
         * @returns {AdobeAsset}
         */
        get asset(): AdobeAsset;
        /**
         * Creates a ServiceConfig object
         *
         * @returns {ServiceConfig}
         */
        get serviceConfig(): ServiceConfig;
        /**
         * The Repository ID of the Repository storing the Asset.
         *
         * @returns {string | undefined}
         */
        get repositoryId(): string | undefined;
        /**
         * Sets the repositoryId of the asset
         *
         * @returns {void}
         */
        set repositoryId(val: string | undefined);
        /**
         * A unique identifier given to every addressable Asset in a given Repository.
         */
        get assetId(): string | undefined;
        set assetId(val: string | undefined);
        /**
         * An Asset's location in the Directory hierarchy.
         */
        get path(): string | undefined;
        set path(val: string | undefined);
        /**
         * The name of the Asset.
         */
        get name(): string | undefined;
        /**
         * An ETag is an HTTP response header returned by an HTTP/1.1-compliant web server, used to determine change in content of a Resource at a given URL. This property is required if the Asset has a Primary Resource.
         */
        get etag(): string | undefined;
        set etag(val: string | undefined);
        /**
         * Identifier of the head version of the Asset. Not present for an Asset which does not yet have a version.
         */
        get version(): string | undefined;
        set version(val: string | undefined);
        /**
         * The media type of the Resource.
         */
        get format(): string | undefined;
        set format(val: string | undefined);
        /**
         * The class of an Asset is inferred from its Media Type at the time the Asset is created.
         */
        get assetClass(): string | undefined;
        /**
         * The server date and time when the Resource was created in the Repository, such as when a File is first uploaded or a Directory is created by the server as the parent of a new Asset.
         */
        get createDate(): string | undefined;
        /**
         * The server date and time when the Resource was last modified in the Repository, such as when a new version of an Asset is uploaded or a Directory's child Resource is added or removed.
         */
        get modifyDate(): string | undefined;
        /**
         * Time the asset was discarded directly or by inheritance. Does not exist for active assets.
         */
        get discardDate(): string | undefined;
        /**
         * The ID of the user who initiated the action that caused the Resource to be created in the Repository
         */
        get createdBy(): string | undefined;
        /**
         * The ID of the user who initiated the action that most recently caused the Resource to be modified in the Repository.
         */
        get modifiedBy(): string | undefined;
        /**
         * Identifier of the user that discarded the asset directly or by inheritance. Does not exist for active assets.
         */
        get discardedBy(): string | undefined;
        /**
         * A timestamp capturing the time at which this Asset was created on the client, and which may therefore precede the time at which it was created in the Repository. (It can also be later, due to clock skew.) Can be set only at the time of Asset creation and, if not set, defaults to repo:createDate.
         */
        get deviceCreateDate(): string | undefined;
        /**
         * A timestamp capturing the time at which this Asset was last modified on the client, and which may therefore precede the time at which the corresponding modification was uploaded to the Repository. (It can also be later, due to clock skew.) If not specified with any request that creates a new version of the Asset, it will be updated to repo:modifyDate.
         */
        get deviceModifyDate(): string | undefined;
        /**
         * ID of the root asset
         */
        get baseAssetId(): string | undefined;
        set baseAssetId(val: string | undefined);
        /**
         * The Asset's state, indicating whether the Asset is active, discarded, or deleted.
         */
        get state(): string | undefined;
        /**
         * The size of the Asset in bytes.
         */
        get size(): number | undefined;
        set size(val: number | undefined);
        get md5(): string | undefined;
        set defaultScheduledDeletionDuration(val: number | undefined);
        get defaultScheduledDeletionDuration(): number | undefined;
        set scheduledDeletionDate(val: string | undefined);
        get scheduledDeletionDate(): string | undefined;
        set width(val: number | undefined);
        get width(): number | undefined;
        set length(val: number | undefined);
        get length(): number | undefined;
        useLinkOrResolveResource<R extends AdobeResponseType = AdobeResponseType>(resource: ResolvableResourceRelations, responseType?: R): AdobePromise<RepoResponseResult<AdobeAsset, R>, AdobeDCXError>;
        /**
         * Update internal data object with response from mutating API call.
         *
         * @param response
         * @returns {AdobeResponse}
         */
        protected _updateDataWithResponse(response: AdobeResponse): AdobeResponse;
        protected _withSourcePromise<T extends Record<string | number | symbol, unknown>>(source: T): AdobePromise<void, AdobeDCXError, T>;
    }

    export declare class AssetFactory {
        private _svc;
        constructor(svc: AdobeHTTPService | ServiceConfig);
        hydrate<T extends Asset>(asset: AdobeAsset): T;
    }

    export declare function assetTransformer(data: ACPRepoMetadataResource): [string, AdobeAsset];

    export declare type AssetType = 'asset' | 'file' | 'directory' | 'composite' | 'version';

    /**
     * Asset types.
     * @note This does not completely align with the Repository API Specification which defines 3 Asset Classes, "Composite", "File", and "Directory".
     * An `Asset` is the broad term that captures any of these classes.  `Version` is actually a Resource of an `Asset`.
     *
     * @see {@link https://git.corp.adobe.com/pages/caf/api-spec/chapters/assets/assets.html#asset-classes | Asset Classes}
     * @internal
     */
    export declare const AssetTypes: {
        readonly Asset: "asset";
        readonly Composite: "composite";
        readonly File: "file";
        readonly Directory: "directory";
        readonly Version: "version";
    };

    declare interface AsyncData<T extends SliceableData = SliceableData> {
        getSlice: GetSliceCallback<T>;
        size: number;
    }

    declare class BlockDownload extends EventEmitter<BlockDownloadEvents> implements AdobeBlockDownload {
        private _contentType?;
        private _dbgId;
        /** Current state of the transfer. */
        private _state;
        /** Error object when in ERROR state. */
        private _error;
        /** The size for each individual block request. */
        private _blockSize;
        /** Collected bytes, only used for buffer responseType */
        private _bytes;
        /** Blocks not yet handled due to arriving out of order. */
        private _cachedBlocks;
        /** Index of block requests made */
        private _blockRequestIndex;
        /** Index of block data pushed to stream or added to buffer. */
        private _blockHandledIndex;
        /** First byte to download. */
        private _startByte?;
        /** Last byte to download. If not provided, becomes totalSize. */
        private _endByte?;
        /** The byte range to use for the next request. */
        private _currentByteRange;
        /** Number of concurrent requests to issue. */
        private _maxConcurrentRequests;
        /** Total size of the asset. */
        private _totalSize?;
        /** Block download presigned URL. */
        private _url?;
        /** Pending requests. */
        private _pending;
        private _resolve;
        private _reject;
        private _promise;
        private _service;
        constructor(svc: AdobeHTTPService, responseType: 'buffer', options?: BlockDownloadOptions);
        /**
         * The content type of the retrieved asset.
         */
        get contentType(): string;
        /**
         * The size of the content or undefined if not known.
         */
        get totalSize(): number | undefined;
        /**
         * The download byte array.
         *
         * @type {Uint8Array}
         */
        get buffer(): Uint8Array;
        /**
         * The current state of the transfer.
         */
        get state(): BlockTransferState;
        /**
         * Get promise that resolves when the BlockDownload completes.
         */
        get promise(): AdobePromise<AdobeBlockDownload>;
        /**
         * Make a request for a single block.
         *
         * @param {number | undefined}  startByte    - First byte to download.
         *                                             May be undefined if downloading last N bytes, or entire asset.
         * @param {number}              endByte      - Last byte to download.
         *                                             If negative, downloads the last <lastByte> bytes.
         * @param {number}              blockIndex   - The order index of the current block.
         * @param {number}              laneIndex    - The download lane to use.
         */
        private _requestBlock;
        /**
         * Initialize block download.
         * If provided with all required properties during construction,
         * this method only moves to the next state.
         *
         * It's possible a BlockDownload is constructed without a totalSize,
         * in which case this method will download the first block (if possible)
         * to determine the total size.
         *
         * @param {string} url          - Presigned direct download URL
         * @param {number} totalSize    - Total size of the asset to download
         */
        init(url?: string, totalSize?: number): AdobePromise<AdobeBlockDownload>;
        /**
         * Start download loop.
         */
        start(): AdobePromise<BlockDownload, AdobeDCXError>;
        pause(): AdobePromise<BlockDownload, AdobeDCXError>;
        resume(): BlockDownload;
        cancel(): AdobePromise<BlockDownload, AdobeDCXError>;
        /**
         * Set current state to waiting.
         * Done by the BlockTransferManager.
         *
         * @internal
         */
        _setWaiting(): void;
        /**
         * Start main loop.
         */
        private _start;
        /**
         * Check if transfer is complete.
         */
        private get _loopShouldContinue();
        /**
         * Main control loop.
         *
         * Loop through requests until no more data to read.
         */
        private _loop;
        private _nextBlockData;
        /**
         * Initialize the current byte range, total size, and start/end byte.
         *
         * startByte == undefined && endByte == undefined
         *  => download entire asset
         *
         * startByte == N && endByte == undefined
         *  => download N-end
         *
         * startByte == undefined && endByte == N
         *  => download first N bytes
         *
         * startByte == undefined && endByte == -N
         *  => download last N bytes
         *
         * @param totalSize
         */
        private _initByteRange;
        /**
         * Move to complete state after all pending blocks are complete.
         */
        private _finalize;
        /**
         * Attempt to parse and set totalSize from the Content-Range header value.
         *
         * @param blockRes - The block response
         * @returns {BlockResolution}
         */
        private _updateTotalSize;
        /**
         * Handle async error.
         *
         * @param err
         */
        private _handleError;
        /**
         * Handle error by rejecting outer promise and pass along to next catch.
         *
         * @param err
         */
        private _handleErrorAndThrow;
        /**
         * Handle a block response.
         * Add the data to the collector, or push to stream if it is the current block
         * Otherwise cache the block to be handled in-order at a later time.
         *
         * @param blockResponse
         * @returns
         */
        private _handleBlock;
        /**
         * Increment _blockHandledIndex and handle that block if it is cached.
         */
        private _markCurrentBlockHandled;
        /**
         * If the current block is cached, handle it.
         */
        private _checkCachedBlocks;
        /**
         * Push downloaded block to stream or buffer.
         *
         * @param {AdobeResponse} response
         */
        private _pushBlockData;
        /**
         * Move to a new state, finalize if needed.
         * Skips state change if already in complete or error states.
         *
         * @param newState
         */
        private _shiftState;
        /**
         * Check current state is valid for method call.
         *
         * @throws {AdobeDCXError}
         *
         * @param method
         * @param currentState
         */
        private _assertStateIsValid;
    }

    declare interface BlockDownloadEvents {
        stateChanged: (state: BlockTransferState, blockDownload: AdobeBlockDownload) => void;
        [key: string]: (...args: any[]) => unknown;
    }

    export declare interface BlockDownloadOptions {
        startByte?: number;
        endByte?: number;
        blockSize?: number;
        url?: string;
        totalSize?: number;
        maxConcurrentRequests?: number;
    }

    /**
     * BlockTransferManager manages the queuing ans sequencing of mulitple active BlockUploads/Downloads
     */
    declare interface BlockTransferManager {
        /**
         * Ordered array of promises for all block uploads
         */
        readonly uploads: BlockUpload[];
        /**
         * Ordered array of promises for all block uploads
         */
        readonly downloads: BlockDownload[];
        /**
         * Block size to use.
         * Defaults to 1024*1024*10 bytes.
         */
        downloadChunkSize: number;
        /**
         * Array of the currently pending block upload HTTP requests
         */
        pendingUploadRequests: AdobePromise[];
        /**
         * Array of currently pending block download HTTP requests
         */
        pendingDownloadRequests: AdobePromise[];
    }

    export declare const blockTransferManager: BlockTransferManager;

    /**
     * Block Transfer Document media type
     */
    export declare const BlockTransferMediaType = "application/vnd.adobecloud.bulk-transfer+json";

    export declare enum BlockTransferProperties {
        REPO_SIZE = "repo:size",
        REPO_BLOCK_SIZE = "repo:blocksize",
        REPO_REL_TYPE = "repo:reltype",
        COMPONENT_ID = "component_id",
        DC_FORMAT = "dc:format",
        REPO_MD5 = "repo:md5",
        REPO_EXPIRES = "repo:expires",
        REPO_IF_MATCH = "repo:if-match",
        MAX_SINGLE_TRANSFER_SIZE = "repo:maxSingleTransferSize",
        REPO_MIN_BLOCK_TRANSFER_SIZE = "repo:minBlockTransferSize"
    }

    /*************************************************************************
     *
     * ADOBE CONFIDENTIAL
     * ___________________
     *
     * @license
     * Copyright 2021 Adobe Inc.
     * All Rights Reserved.
     *
     * NOTICE:  All information contained herein is, and remains
     * the property of Adobe Inc. and its suppliers,
     * if any.  The intellectual and technical concepts contained
     * herein are proprietary to Adobe Inc. and its
     * suppliers and are protected by trade secret or copyright law.
     * Dissemination of this information or reproduction of this material
     * is strictly forbidden unless prior written permission is obtained
     * from Adobe Inc.
     **************************************************************************/
    /**
     * Possible states of a BlockTransfer
     */
    export declare enum BlockTransferStates {
        NOT_INITIALIZED = "NOT_INITIALIZED",
        INITIALIZING = "INITIALIZING",
        INITIALIZED = "INITIALIZED",
        WAITING = "WAITING",
        STARTED = "STARTED",
        PAUSING = "PAUSING",
        PAUSED = "PAUSED",
        CANCELED = "CANCELED",
        ERROR = "ERROR",
        FINALIZING = "FINALIZING",
        COMPLETE = "COMPLETE"
    }

    /**
     * The BlockUpload class manages block transfers of large documents
     */
    export declare class BlockUpload extends EventEmitter<BlockUploadEvents> implements AdobeBlockUpload {
        /**
         * Contains the result of the BlockUpload
         */
        uploadRecord: AdobeComponentUploadRecord;
        createdAsset?: AdobeAsset;
        /**
         * Contains the result of the BlockUpload
         */
        finalizeResponse: AdobeResponse | undefined;
        /**
         * An internal id assigned to every instance of this class.
         */
        private _internalBlockUploadId;
        /**
         * The HTTPService to make requests
         */
        private _service;
        /**
         * The promise resolve method that indicates completion for all blocks
         */
        private _resolve;
        /**
         * The promise rejection method that indicates an error during upload
         */
        private _reject;
        /**
         * The overall promise which resolves when all blocks are uploaded
         */
        private _promise;
        /**
         * Current state of block upload
         */
        private _state;
        /**
         * Holds the index of the next block to be requested
         */
        private _currentBlockIndex;
        /**
         * The BlockTransferDocument which specifies things like the blockSize and transfer urls
         * Links are expected to be on the transfer document once initialized. During an assetmoved
         * operation, the links are removed from an existing transfer document so that the
         * transfer document can be re-used while only the links are re-generated.
         */
        private _blockTransferDocument;
        /**
         * A accessor convenience for storing the block transfer urls
         */
        private _transferBlockLinks;
        /**
         * An array of the currently active block upload requests
         */
        private _pendingBlockRequests;
        /**
         * A user provided callback responsible for slicing the buffer in chunks for block upload
         */
        private _getSliceCallback;
        /**
         * The number of bytes that have been currently uploaded
         */
        private _bytesUploaded;
        /**
         * The total number of blocks that were uploaded. Used to trim unused transfer url's from finalize body
         */
        private _totalBlocksUploaded;
        /**
         * Transfer is indeterminate if the TransferDocument has been extended
         */
        private _indeterminateTransfer;
        /**
         * Maximum number of Concurrent upload block requests
         */
        private _maxConcurrentRequests;
        /**
         * On progress callback handler, if transfer is extended going into an indeterminate state
         */
        onProgress?: UploadProgressCallback;
        /**
         * Optional Params required when clients don't call blockInit themselves
         */
        private _asset;
        private _dataSize;
        private _relationType;
        private _contentType;
        private _componentId;
        private _md5?;
        private _ifMatch?;
        private _relPath?;
        private _createIntermediates?;
        private _respondWith?;
        private _repoMetaPatch?;
        /**
         * This class can be initialized with an existing blockTransferDocument acquired via the HLA or leaf methods
         * @param {AdobeHTTPService} service                            The HTTPService
         * @param {GetSliceCallback} getSliceCallback               The callback to slice the data buffer
         * @param {BlockTransferDocument} blockTransferDocument     The BlockTransferDocument which defined the blocks and block size
         */
        constructor(service: AdobeHTTPService, getSliceCallback: GetSliceCallback, blockTransferDocument: BlockTransferDocument);
        /**
         * This class can be initialized with an existing blockTransferDocument acquired via the HLA or leaf methods with additional parameters
         * @param {AdobeHTTPService} service                The HTTPService
         * @param {GetSliceCallback} getSliceCallback   The callback to slice the data buffer, data sh
         * @param {Required<BlockTransferDocument>} blockTransferDocument     The BlockTransferDocument which defined the blocks and block size
         * @param {LinkRelation} relationType           (optional) The block upload relation type
         * @param {number} dataSize                     (optional) The total size of the component
         * @param {string} contentType                  (optional) The content type of the component being uploaded
         * @param {string} componentId                  (optional) The componentId to upload the component against
         * @param {string} md5                          (optional) MD5 of the data being uploaded
         * @param relPath                               (optional) the relative path must be specified.
         * @param createIntermediates                   (optional) should intermediate directories be automatically created.
         * @param respondWith                           (optional) Resource of the newly-created Asset to return in the response, if any.
         * @see {@link https://git.corp.adobe.com/pages/caf/api-spec/chapters/advanced/block.html#completing-a-block-transfer Completing a Block Transfer}
         */
        constructor(service: AdobeHTTPService, getSliceCallback: GetSliceCallback, blockTransferDocument: Required<BlockTransferDocument>, relationType?: LinkRelationKey_2, dataSize?: number, contentType?: string, componentId?: string, md5?: string, etag?: string, relPath?: string, createIntermediates?: boolean, respondWith?: ResourceDesignator, repoMetaPatch?: RepoMetaPatch, maxConcurrentRequests?: number);
        /**
         * This class can also be initialized with the parameters required to initialize the block transfer. The init method
         * will handle calling blockInit for clients.
         * @param {AdobeHTTPService} service                The HTTPService
         * @param {GetSliceCallback} getSliceCallback   The callback to slice the data buffer, data sh
         * @param {AdobeAsset} asset                    The asset associated with the block upload
         * @param {LinkRelation} relationType           The block upload relation type
         * @param {number} dataSize                     The total size of the component
         * @param {string} contentType                  The content type of the component being uploaded
         * @param {string} componentId                  (optional) The componentId to upload the component against
         * @param {string} md5                          (optional) MD5 of the data being uploaded
         * @param relPath                               (optional) When creating an asset, the relative path must be specified.
         * @param createIntermediates                   (optional) When creating an asset, should intermediate directories be automatically created.
         * @param respondWith                           (optional) When creating an asset, Resource of the newly-created Asset to return in the response, if any.
         * @param repoMetaPatch                         (optional) When creating an asset, it is possible to patch select fields from the Repository Metadata Resource.
         * @see {@link https://git.corp.adobe.com/pages/caf/api-spec/chapters/advanced/block.html#completing-a-block-transfer Completing a Block Transfer}
         */
        constructor(service: AdobeHTTPService, getSliceCallback: GetSliceCallback, asset: AdobeAsset, relationType: LinkRelationKey_2, dataSize: number, contentType: string, componentId?: string, md5?: string, etag?: string, relPath?: string, createIntermediates?: boolean, respondWith?: ResourceDesignator, repoMetaPatch?: RepoMetaPatch, maxConcurrentRequests?: number);
        /**
         * Initializes the block transfer, only needs to be called if a BlockTransferDocument is not provided to the constructor
         */
        init(additionalHeaders?: Record<string, string>): AdobePromise<AdobeBlockUpload, AdobeDCXError>;
        /**
         * Getter for the current state of the block_transfer
         */
        get state(): BlockTransferState;
        get promise(): AdobePromise<AdobeBlockUpload>;
        /**
         * Called by clients when they wish to start the block transfer
         */
        start(): AdobePromise<AdobeBlockUpload>;
        /**
         * Pauses the block transfers
         */
        pause(): AdobePromise<AdobeBlockUpload>;
        /**
         * Resumes the block transfers
         */
        resume(): AdobeBlockUpload;
        /**
         * Cancels the block requests
         */
        cancel(): void;
        /**
         * Set current state to waiting.
         * Done by the BlockTransferManager.
         *
         * @internal
         */
        _setWaiting(): void;
        /**
         * Uploads the next block and adds to pendingBlockRequests
         */
        uploadNextBlock(data: SliceableData): AdobePromise<AdobeResponse>;
        /**
         * Returns the number of currently active transfer requests across any BlockUpload instance
         */
        private get _pendingBlocksCount();
        /**
         * Returns the blockLockPromise which indicates if we are blocked from any new requests
         */
        private _nextBlockLock;
        /**
         * Handles the assetmoved problem type returned by ACP when an asset has migrated from one
         * region to another before the block upload process has finished. When the assetmoved
         * problem type is encountered, it is necessary to repeat the entire block upload process,
         * including initialization. This is being done within the block upload class to maintain
         * priority order with the block transfer manager and re-use any existing objects created
         * on the heap for the purposes of this upload.
         */
        private _handleAssetMoved;
        /**
         * Recursive function which attempts to add the next block for upload.
         */
        private _uploadLoop;
        /**
         * Returns the buffer slice for the block at an index
         * @param blockIndex    The block index to get the slice for
         */
        private _getBlockAtIndex;
        /**
         * Uploads the block
         * @param body    Data frame to upload
         * @param href      The upload href
         */
        private _uploadBlock;
        /**
         * Returns true if the buffer passed is empty or invalid
         * @param block     The data to check for validity
         */
        private _isEmptyBlock;
        /**
         * Extends the block transfer by 150%
         */
        private _extend;
        /**
         * Adds the blockRequest to the pending array and returns a cleanup method
         * @param blockRequest     The block request to add
         */
        private _pushPendingBlockRequest;
        /**
         * Send progress event.
         *
         * If incrementOrDone is true, send the final progress event with 100% completion.
         * If it's a number, add it to bytes sent.
         *
         * @param incrementOrDone
         *
         */
        private _updateProgress;
        /**
         * Private cancel method
         */
        private _cancel;
        /**
         * Asserts if the current state is valid
         * @param method    The method asserting
         */
        private _assertStateIsValid;
        private _continueBlockUploads;
        /**
         * Finalize the blockupload, calls finalize and polls for result
         */
        private _finalize;
        /**
         * Move to a new state, finalize if needed.
         * Skips state change if already in complete or error states.
         *
         * @param newState
         */
        private _shiftState;
    }

    declare type BlockUploadEvents = {
        stateChanged: (state: BlockTransferState) => void;
    };

    export declare function bodyToUint8Array(body: string | ArrayBuffer | Buffer): Uint8Array;

    /**
     * Build a range request header object
     *
     * @example
     * const headers = buildRangeHeader(10, 100);
     * // headers == { range: bytes=10-100 }
     *
     * const headers = buildRangeHeader(undefined, 100);
     * // headers == { range: bytes=0-100 }
     *
     * const headers = buildRangeHeader(10, undefined);
     * // headers == { range: bytes=10- }
     *
     * const headers = buildRangeHeader(undefined, -10);
     * // headers == { range: bytes=-10 }
     *
     * @param startByte
     * @param endByte
     * @returns
     */
    export declare function buildRangeHeader(startByte?: number, endByte?: number): Record<string, string>;

    export declare interface BulkRequestDescriptor {
        method: HTTPMethod;
        href: string;
        headers?: Record<string, string | number>;
        body?: string | Buffer | ArrayBuffer;
    }

    export declare const enum CACHE_KEYS {
        SESSION_KEY = "SESSION",
        INDEX_KEY = "INDEX",
        INDEX_DOCUMENT_KEY = "/Index.json",
        REPOSITORY_DOCUMENT_KEY = "/Repositories.json",
        REPOSITORIES_LINK_KEY = "/Repositories",
        ASSETS_DOCUMENT_KEY = "/Assets.json"
    }

    /**
     * Checks whether the current user has the requested Privilege on the specified Resource of an Asset.
     *
     * @param svc               HTTP Service or ServiceConfig
     * @param asset             Asset to check the ACL privilege against
     * @param privilege         The Privilege to be checked. Legal values are read, write, delete, and ack.
     * @param relation          The LinkRelation type of the Resource whose Privilege will be checked.
     * @param additionalHeaders Additional headers to be applied to HTTP requests
     */
    export declare function checkACLPrivilege(svc: AdobeHTTPService, asset: AdobeAsset, privilege: Omit<Privilege, 'none'>, relation: LinkRelationKey, additionalHeaders?: Record<string, string>): AdobePromise<RepoResponseResult<boolean>, AdobeDCXError>;

    export declare type ComponentRequestByPath = {
        component_path: string;
        responseType?: AdobeResponseType;
        skipBlockDownload?: boolean;
        subrequestHeaders?: Record<string, string>;
    };

    declare type ComponentResponse<C extends ComponentRequestByPath> = C & RepoResponse<{
        data?: C['responseType'] extends AdobeResponseType ? ResponseTypeMap[C['responseType']] : ResponseTypeMap['defaultbuffer'];
        error?: DCXError;
    }>;

    export declare class Composite extends File_2 implements AdobeComposite {
        readonly type: AssetType;
        constructor(data: AdobeCompositeData, svc: AdobeHTTPService | ServiceConfig, links?: LinkSet);
        /**
         * Performs a HEAD operation on the composites manifest
         */
        headManifest(additionalHeaders?: Record<string, string>): AdobePromise<AdobeResponse<'void'>, AdobeDCXError>;
        /**
         * Returns the composites manifest
         * @param {string} version                              The version of the manifest to fetch
         * @param {string} etag                                 ETag of manifest version
         * @param {Object} additionalHeaders                    Additional headers to be applied to RAPI requests
         */
        getManifest<T = Record<string, unknown>>(version?: string, etag?: string, additionalHeaders?: Record<string, string>): AdobePromise<RepoResponse<AdobeManifestResult<T>, 'json'>, AdobeDCXError>;
        /**
         * Returns the URL of the composites manfest
         * @param {string} versionId                            The version of the manifest to return a link for
         */
        getManifestUrl(versionId: string): AdobePromise<string, AdobeDCXError>;
        /**
         * @param components An array of ComponentRequestsByPath. NOTE: Paths are restricted to well-known paths only as determined by specific composite media type.
         * @see {@link https://wiki.corp.adobe.com/display/CA/Proposal%3A+Download+Components+by+DCX+Path Proposal: Download DCX Components by Path}
         * If using components that do not exist on the given well-known paths, please use @see performBulkRequest
         * @example
         *  ```
         *  const components = [
         *    {
         *      component_path: "/model/database.json",
         *      responseType: "json" // default value "defaultbuffer",
         *      skipBlockDownload: true  // To Skip block download in case of large asset and get presigned url instead
         *    }
         *  ]
         *  ```
         * @param version           Version of the composite manifest to fetch (components all come from this version of the manifest)
         * @param etag              Etag to use within the if-match header of the request
         * @param additionalHeaders Additional headers to attach to HTTP requests
         * @example
         * ```
         * {
         *   manifest: {
         *     data?: ManifestData // JSON parsed manifest data
         *     error?: DCXError // present if there was an error fetching the manifest
         *     response: AdobeResponse // response for the manifest sub-request (or secondary follow-up manifest request)
         *   },
         *   components: {
         *     "/model/database.json": { // component paths are the keys
         *       component_path: "/model/database.json",
         *       data?: ResponseTypeMap[ResponseType], // parsed into the requested responseType
         *       error?: DCXError, // present if there was an error fetching the manifest
         *       response: AdobeResponse // response for component sub-request (or follow-up request)
         *     }
         *   },
         *   responses: AdobeResponse[] // array of Bulk request responses (1 response per bulk request issued)
         * }
         * ```
         */
        getManifestAndComponentsByPath<C extends ComponentRequestByPath[]>(components: C, version?: string, etag?: string, additionalHeaders?: Record<string, string>): AdobePromise<ManifestAndComponentsByPathResponse<C>, AdobeDCXError>;
        /**
         * Returns a component from a composite
         * @param componentId       Component ID to fetch
         * @param componentRevision Component revision to fetch
         * @param responseType      Type to tranform response into
         *                              (defaults to Buffer on Node, ArrayBuffer on browser)
         * @param additionalHeaders Additional headers to add to request
         * @param componentSize component size
         */
        getComponent<T extends AdobeResponseType = 'defaultbuffer'>(componentId: string, componentRevision: string, responseType?: T, additionalHeaders?: Record<string, string>, componentSize?: number): RepoDownloadStreamableReturn<T>;
        /**
         * Returns a component from a composite by path
         *
         * @see {@link https://wiki.corp.adobe.com/display/CA/Proposal%3A+Download+Components+by+DCX+Path Proposal: Download DCX Components by Path}
         *
         * @param componentPath     Component path to fetch
         * @param responseType      Type to tranform response into
         *                             (defaults to Buffer on Node, ArrayBuffer on browser)
         * @param additionalHeaders Additional headers to add to request
         *
         * @example
         * ```
         * const component = await composite.getComponentByPath('/model/database.json', 'json');
         * ```
         **/
        getComponentByPath<T extends AdobeResponseType = 'defaultbuffer'>(componentPath: string, responseType?: T, additionalHeaders?: Record<string, string>): RepoDownloadStreamableReturn<T>;
        /**
         * Return the URL of a composite component. The revision is required if the URL will be used for a GET operation.
         * When using the URL to upload a component (PUT), revision is not required.
         * @param componentId       Component ID to return URL for
         * @param componentRevision           The component revision.
         * @param additionalHeaders Additional headers to attach to HTTP requests
         */
        getComponentUrl(componentId: string, componentRevision?: string, additionalHeaders?: Record<string, string>): AdobePromise<string, AdobeDCXError>;
        updateManifest<T = string | Record<string, unknown>>(manifest: T, overwrite: boolean, validationLevel?: number, etag?: string, additionalHeaders?: Record<string, string>): AdobePromise<AdobeResponse, AdobeDCXError>;
        /**
         * Uploads a composite component. If the size of the data is less then repo:maxSingleTransferSize data can be directly uploaded.
         * @param componentId       The componentId of the component to be uploaded, componentId supposes to be an uuid
         * @param data              A buffer containing the data to be uploaded
         * @param contentType       The contentType of the component being uploaded
         * @param maybeIsNew        Do we think this is a new component?
         * @param size              The expected size of this component
         * @param md5               The md5 of the component
         * @param progressCb        A Callback to be invoked with upload progress updates
         * @param additionalHeaders Additional headers to attach to HTTP Requests
         */
        putComponent(componentId: string, data: Buffer | ArrayBuffer | Blob | string, contentType: string, maybeIsNew?: boolean, size?: number, md5?: string, progressCb?: UploadProgressCallback, additionalHeaders?: Record<string, string>): AdobePromise<AdobeRepoUploadResult, AdobeDCXError, {
            blockUpload?: AdobeBlockUpload;
        }>;
        /**
         * Uploads a composite component. If the size of the data is greater then repo:maxSingleTransferSize a GetSliceCallback should be provided instead of the data.
         * @param componentId           The componentId of the component to be uploaded. componentId supposes to be an uuid.
         * @param getSliceCallback      A callback function to return a slice of data to upload
         *                                  The GetSliceCallback function accepts a start byte where the buffer slice should start and an end byte where
         *                                  the buffer slice should end (not inclusive). The callback should return a Promise containing the buffer slice or a buffer
         *                                  of length 0 indicating the end of the buffer.
         * @param contentType           The contentType of the component being uploaded
         * @param maybeIsNew            Do we think this is a new component?
         * @param size                  The expected size of this component
         * @param md5                   The md5 of the component
         * @param progressCb            A Callback to be invoked with upload progress updates
         * @param additionalHeaders     Additional headers to attach to HTTP Requests
         */
        putComponent(componentId: string, getSliceCallback: GetSliceCallback, contentType: string, maybeIsNew?: boolean, size?: number, md5?: string, progressCb?: UploadProgressCallback, additionalHeaders?: Record<string, string>): AdobePromise<AdobeRepoUploadResult, AdobeDCXError, {
            blockUpload?: AdobeBlockUpload;
        }>;
        /**
         * Update entire embedded/XMP metadata resource.
         *
         * @note
         * Replaces existing XMP resource.
         *
         * @note
         * Currently only supported on composites.
         *
         * @note
         * Currently the service requires an etag, but spec states unguarded updates should be possible.
         * The argument `etag` will be updated to optional when the service supports it.
         * See {@link https://jira.corp.adobe.com/browse/SYSE-7940|ticket}
         * and {@link https://jira.corp.adobe.com/browse/SYSE-5943|another ticket}
         *
         * @param {T = Record<string, unknown>} data            New embedded metadata
             * @param {string}                      etag            ETag of metadata resource to update.
             * @param {'json'|'xml'}                [format='json'] Defines the representation of the body, either XML or JSON.
             *                                                      If using XML, clients must pass the data as a string.
             *                                                      If using XML with TypeScript, clients must specify the generic as `string`.
             *                                                      Defaults to json.
             * @param {Record<string, string>}      additionalHeaders     Additional headers to attach to HTTP Requests
             */
         putEmbeddedMetadata<T = Record<string, unknown>>(data: T, etag?: string, format?: EmbeddedMetadataRepresentation, additionalHeaders?: Record<string, string>): AdobePromise<AdobeResponse<'void'>>;
         /**
          * Update embedded/XMP metadata using JSON Patch document.
          *
          * @see
          * https://tools.ietf.org/html/rfc6902#page-6
          *
          * @note
          * Currently the service requires an etag, but spec states unguarded updates should be possible.
          * The argument `etag` will be updated to optional when the service supports it.
          * see: https://jira.corp.adobe.com/browse/SYSE-7940
          * and: https://jira.corp.adobe.com/browse/SYSE-5943
          *
          * @param {JSONPatchDocument | string}      data      Data to use as PATCH body
          * @param {string}                          etag      ETag of the embedded metadata resource to be updated
          * @param {Record<string, string>}          additionalHeaders     Additional headers to attach to HTTP Requests
          */
         patchEmbeddedMetadata(data: JSONPatchDocument | string, etag?: string, additionalHeaders?: Record<string, string>): AdobePromise<AdobeResponse<'void'>>;
         copy(destAsset: PathOrIdAssetDesignator, createIntermediates: boolean, overwriteExisting: boolean, additionalHeaders?: Record<string, string>, manifestPatch?: JSONPatchDocument): AdobePromise<RepoResponseResult<Composite, 'json'>, AdobeDCXError>;
        }

        /**
         * Constructs a Multipart request body given a list of reuqests
         * @param requests List of requests to put in the bulk request body
         * @param boundary Boundary token
         */
        export declare function constructMultipartRequestBody(requests: BulkRequestDescriptor[], boundary: string): Uint8Array;

        export declare function constructServiceEndpoint(url: string, service: AdobeHTTPService): string;

        export declare function convertToACPRepoMetadataResource(data: AdobeAsset & ACPRepoMetadataResource): ACPRepoMetadataResource;

        /**
         * @private Limit of resources that can be copied in a single COPY_RESOURCES operation.
         * {@see {@link https://git.corp.adobe.com/pages/caf/api-spec/chapters/responses/service_responses.html#limit-resource-count | Limit Resource Count Problem Type}}
         * {@see  {@link https://wiki.corp.adobe.com/pages/viewpage.action?spaceKey=dcxteam&title=Composite+Service+Resource+Copy+API+Spec#CompositeServiceResourceCopyAPISpec-HTTPResponseStatusCodes | CoS Resources Copy API Spec}}
         **/
        export declare const COPY_RESOURCES_RESOURCE_LIMIT = 30;

        /**
         * Copies an asset for the src to the destination
         * User cannot copy component resources using this method
         *
         * @this [OptionalLeafContext] Optional `this` scope that can provide an operations href.
         *
         * @param svc                   The http service
         * @param srcAsset              The source asset
         * @param destAsset             The destination asset
         * @param createIntermediates   Should intermediates be created?
         * @param overwriteExisting     Should an existing asset in dest be overwritten
         * @param additionalHeaders     Additional headers to attach to HTTP requests
         * @param manifestPatch         A JSON Patch Document to be applied to the target asset's manifest.
         */
        export declare function copyAsset(this: OptionalContext<AdobeOpsContext>, svc: AdobeHTTPService | ServiceConfig, srcAsset: PathOrIdAssetDesignator, destAsset: PathOrIdAssetDesignator, createIntermediates: boolean, overwriteExisting?: boolean, additionalHeaders?: Record<string, string>, manifestPatch?: JSONPatchDocument): AdobePromise<RepoResponseResult<AdobeAsset, 'json'>, AdobeDCXError>;

        export declare function copyAssetResources(svc: AdobeHTTPService | ServiceConfig, sourceAsset: PathOrIdAssetDesignator, targetAsset: PathOrIdAssetDesignator, resources: CopyResourceDesignator[], intermediates?: boolean, manifestPatch?: JSONPatchDocument, additionalHeaders?: Record<string, string>): AdobePromise<RepoResponseResult<CopyResourcesOperationResult, 'json'>, AdobeDCXError>;

        /**
         * Trigger server copy resources, and won't fall back to client copy on error 501
         * https://git.corp.adobe.com/pages/caf/api-spec/chapters/operations/copying_resources.html
         *
         *
         * @this [OptionalLeafContext] Optional `this` scope that can provide an operations href.
         *
         * @param svc               The http service
         * @param srcAsset          The source asset
         * @param destAsset         The destination asset
         * @param resources         List of resources designators
         * @param intermediates     Whether to create intermediate directories if missing.
         * @param manifestPatch     A JSON Patch Document to be applied to the target asset's manifest.
         * @param additionalHeaders Any additional headers to include in the request
         *
         * @returns {AdobePromise<RepoResponseResult<CopyResourcesOperationResult, 'json'>, AdobeDCXError>}
         */
        export declare function copyResources(this: OptionalContext<AdobeOpsContext>, svc: AdobeHTTPService | ServiceConfig, srcAsset: PathOrIdAssetDesignator, targetAsset: PathOrIdAssetDesignator, resources: CopyResourceDesignator[], intermediates?: boolean, manifestPatch?: JSONPatchDocument, additionalHeaders?: Record<string, string>): AdobePromise<RepoResponseResult<{
            success: boolean;
        }, 'json'>, AdobeDCXError>;

        export declare function _copyResources(svc: AdobeHTTPService | ServiceConfig, sourceAsset: PathOrIdAssetDesignator, targetAsset: PathOrIdAssetDesignator, resources: CopyResourceDesignator[], intermediates?: boolean, manifestPatch?: JSONPatchDocument, additionalHeaders?: Record<string, string>): AdobePromise<RepoResponseResult<CopyResourcesOperationResult, 'json'>, AdobeDCXError>;

        export declare type CopyResourcesOperationResult = {
            source: OperationResultSource;
            target: OperationResultSource;
            resources: ACPCopyResourceDesignator[];
            asset?: AdobeAsset;
        };

        /**
         * Create an asset relative to the current directory.
         *
         * @param service               The HTTPService
         * @param parentDir             The parent directory to create the asset in
         * @param relPath               Path relative to current directory.
         * @param createIntermediates   Whether to create intermediate directories if they don't exist.
         * @param contentType           Content type of the new asset.
         * @param respondWith           Resource to be included in response.
         * @param additionalHeaders     Additional headers for the request.
         * @param primaryResource       The primary resource to be uploaded.
         * @param primaryResourceSize   The size of the primary resource.
         * @param repoMetaPatch         Patch to apply to repository metadata immediately after create.
         * @see {@link https://git.corp.adobe.com/pages/caf/api-spec/single.html#repository-metadata-patch-support Repository Metadata Patch Support}
         *
         * @returns {AdobePromise<RepoResponseResult<AdobeAsset>, AdobeDCXError, RequestDescriptor>}
         */
        export declare function createAsset(svc: AdobeHTTPService | ServiceConfig, parentDir: AdobeAsset, relPath: string, createIntermediates: boolean, contentType: string, respondWith?: ResourceDesignator, additionalHeaders?: Record<string, string>, primaryResource?: SliceableData | GetSliceCallback, primaryResourceSize?: number, repoMetaPatch?: RepoMetaPatch, progressCb?: ProgressCallback): AdobePromise<RepoResponseResult<AdobeAsset>, AdobeDCXError_2, RequestDescriptor>;

        export declare const DEFAULT_BLOCK_DOWNLOAD_THRESHOLD = 52428800;

        export declare const DEFAULT_BLOCK_UPLOAD_THRESHOLD = 10485760;

        export declare const DEFAULT_CACHE_MAX_ENTRIES = 100000;

        export declare const DEFAULT_MAX_CONCURRENT_REQUESTS = 4;

        export declare const DEFAULT_STRING_LENGTH_CHECK: number;

        export declare function defaultBufferResponseType<T extends AdobeResponseType>(responseType: T | undefined): T;

        /**
         * Issues a DELETE request against an asset's ACL Policy removing all ACEs.
         *
         * @param {AdobeHTTPService} svc                        HTTP Service or ServiceConfig
         * @param {AdobeAsset} asset                            Asset object
         * @param {Record<string, string>} additionalHeaders    Additional headers to be applied to HTTP requests
         *
         * @returns {AdobePromise<RepoResponseResult<'json'>, AdobeDCXError>}
         */
        export declare function deleteACLPolicy(svc: AdobeHTTPService | ServiceConfig, asset: AdobeAsset, additionalHeaders?: Record<string, string>): AdobePromise<RepoResponseResult<'json'>, AdobeDCXError>;

        /**
         * Delete an asset.
         *
         * @this [OptionalLeafContext] Optional `this` scope that can provide an operations href.
         *
         * @param {AdobeHTTPService | ServiceConfig} svc        HTTPService to use.
         * @param {PathOrIdAssetDesignator} asset          Asset to delete.
         * @param {string} etag                                 Optional etag. If not provided will use "*", an unconditional delete.
         * @param {boolean} recursive                           Whether to delete the asset recursively. Required for directory assets.
         * @param {Record<string, string>} additionalHeaders                                          Any additional headers to include in the request
         *
         * @returns {AdobePromise<RepoResponseResult<{ success: boolean }, 'json'>, AdobeDCXError>}
         */
        export declare function deleteAsset(this: OptionalContext<AdobeOpsContext>, svc: AdobeHTTPService | ServiceConfig, asset: PathOrIdAssetDesignator, etag?: string, recursive?: boolean, additionalHeaders?: Record<string, string>): AdobePromise<RepoResponseResult<{
            success: boolean;
        }, 'json'>, AdobeDCXError>;

        export declare function deserializeAsset(data: AdobeAsset & ACPRepoMetadataResource & {
            _embedded?: {
                'http://ns.adobe.com/rel/ac/effective'?: EffectivePrivileges;
                'http://ns.adobe.com/rel/repository'?: AdobeRepository;
            };
        }, embedded?: {
            'http://ns.adobe.com/rel/ac/effective'?: EffectivePrivileges;
            'http://ns.adobe.com/rel/repository'?: AdobeRepository;
            'http://ns.adobe.com/adobecloud/rel/metadata/application'?: string | Record<string, unknown>;
        }): AdobeAsset;

        /**
         * Deserialize an ACPIndexDocument into an IndexDocument
         *
         * @param {ACPIndexDocument} data       JSON representation of an IndexDocument
         *
         * @returns {IndexDocument}
         */
        export declare function deserializeIndexDocument(data: ACPIndexDocument): IndexDocument;

        export declare function deserializeRepository(data?: Partial<ACPRepository>): Partial<AdobeRepository>;

        export declare function deserializeUploadComponentRecord(type: string, id: string, length: number, data: string): AdobeComponentUploadRecord;

        export declare function deserializeVersion(data: AdobeVersion & ACPVersion): AdobeVersion;

        /**
         * Deserialize a raw version set into an AdobeVersionSet
         *
         * @param {ACPVersions} data  JSON raw version set
         *
         * @returns {AdobeVersionSet}
         */
        export declare function deserializeVersionSet(data: ACPVersions): AdobeVersionSet;

        export declare class Directory extends Asset<AdobeDirectoryData> implements AdobeDirectory {
            readonly type: AssetType;
            children: AdobeAsset[];
            constructor(data: Partial<AdobeDirectoryData | ACPRepoMetadataResource>, svc: AdobeHTTPService | ServiceConfig, links?: LinkSet);
            /**
             * Returns a paged set of results for the directory listing
             * @param pageOpts          Page options
             * @param additionalHeaders Additional headers to be provided with HTTP requests
             */
            getPagedChildren<T extends EmbeddableResource = never>(pageOpts?: PageOptions<T>, additionalHeaders?: Record<string, string>): AdobePromise<RepoResponse<AdobeGetPageResult<AdobeAssetEmbedded<T>>>>;
            /**
             *
             * Create an asset relative to the current directory.
             *
             * @param {string} relPath                                      Path relative to current directory.
             * @param {boolean} createIntermediates                         Whether to create intermediate directories if they don't exist.
             * @param {string} contentType                                  Content type of the new asset.
             * @param {ResourceDesignator} [resourceDesignator]             Resource to be included in response.
             * @param {Record<string, string[]>} [additionalHeaders = {}]   Additional headers for the request.
             */
            createAsset(relPath: string, createIntermediates: boolean, contentType: string, resourceDesignator?: ResourceDesignator, additionalHeaders?: Record<string, string>, primaryResource?: SliceableData | GetSliceCallback, primaryResourceSize?: number, repoMetaPatch?: RepoMetaPatch, progressCb?: UploadProgressCallback): AdobePromise<RepoResponseResult<Asset>, AdobeDCXError_2>;
            /**
             * Move the asset, uses the operation endpoint.
             *
             * @note
             * To move to a new repositoryId, it must be specified in the destAsset.
             * If no repositoryId is specified, it will be moved to the same repository as the source asset instance.
             *
             * @param {AdobeAsset} destination          Asset containing either path or assetId
             * @param {boolean} createIntermediates     Whether to create intermediate directories if missing.
             * @param {boolean} overwriteExisting       Whether to overwrite the existing asset.
             *
             * @returns {AdobePromise<RepoResponseResult<Asset, 'json'>, AdobeDCXError>}
             */
            copy(destination: PathOrIdAssetDesignator, createIntermediates: boolean, overwriteExisting: boolean): AdobePromise<RepoResponseResult<Directory, 'json'>, AdobeDCXError_2>;
        }

        /**
         * Directory media type
         */
        export declare const DirectoryMediaType = "application/vnd.adobecloud.directory+json";

        /**
         * Transforms a raw Directory JSON representation into an AdobeAsset
         *
         * @param {ACPRepoMetadataResource} data        JSON representation of a directory
         *
         * @returns {[string, AdobeAsset]}
         */
        export declare function directoryTransformer(data: ACPRepoMetadataResource): [string, AdobeAsset];

        /**
         * Discards an asset
         *
         * @this [OptionalLeafContext] Optional `this` scope that can provide an operations href.
         *
         * @param {AdobeHTTPService | ServiceConfig} svc        The http service
         * @param {PathOrIdAssetDesignator} asset          The asset to be discarded
         * @param {string} etag                                 The etag of the asset to be discarded
         * @param {boolean} recursive                           If asset has children, discard recursively?
         * @param {Record<string, string>} additionalHeaders                                          Any additional headers to include in the request
         *
         * @returns {AdobePromise<RepoResponseResult<{ success: boolean }, 'json'>, AdobeDCXError>}
         */
        export declare function discardAsset(this: OptionalContext<AdobeOpsContext>, svc: AdobeHTTPService | ServiceConfig, asset: PathOrIdAssetDesignator, etag?: string, recursive?: boolean, additionalHeaders?: Record<string, string>): AdobePromise<RepoResponseResult<{
            success: boolean;
        }, 'json'>, AdobeDCXError>;

        /**
         * Transforms a ACPRepoMetadataResource to an AdobeAsset for use in paging
         *
         * @param {ACPRepoMetadataResource} data    Raw json of an ACPRepoMetadataResource
         *
         * @returns {[string, AdobeAsset]}
         */
        export declare function discoverableAssetTransformer(data: ACPRepoMetadataResource): [string, AdobeAsset];

        /**
         * Transforms a ACPRepository to an AdobeRepository for use in paging
         *
         * @param {ACPRepository} data              Raw json of an ACPRepository
         *
         * @returns {[string, AdobeRepository]}
         */
        export declare function discoverableReposTransformer(data: ACPRepository): [string, AdobeRepository];

        /**
         * Execute a POST on the ops href provided using the operation document as body.
         * Also split the response into an array of results, creating a DCX error for each failed operation.
         *
         * @param {AdobeHTTPService | ServiceConfig} svc                                        HTTPService to use.
         * @param {string} opsEndpoint                                                          Operations endpoint
         * @param {AnyOperationDocument | AnyOperationDocument[] | string} operationDocument    Operations document
         * @param {Record<string, string>} additionalHeaders                                          Any additional headers to include in the request
         */
        export declare function doBatchOperation(svc: AdobeHTTPService, opsEndpoint: string, operationDocument: AnyOperationDocument | AnyOperationDocument[] | string, additionalHeaders?: Record<string, string>): AdobePromise<RepoResponseResult<AdobeOperationResult[], 'json'>, AdobeDCXError>;

        /**
         * Perform block download of specified byte range.
         * @this
         * @param svc
         * @param assetOrPresignedUrl
         * @param startByte
         * @param endByte
         * @param resource
         * @param componentId
         * @param version
         * @param responseType
         * @returns
         */
        export declare function doBlockDownload<T extends AdobeResponseType = 'defaultbuffer'>(this: OptionalContext<AdobeStreamableContext>, svc: AdobeHTTPService, assetOrPresignedUrl: AdobeAsset | string, startByte?: number, endByte?: number, resource?: LinkRelationKey_2, componentId?: string, version?: string, responseType?: T, additionalHeaders?: Record<string, string>): RepoDownloadStreamableReturn<T>;

        export declare const doesAssetContainLinks: (asset: unknown, linksToCheck?: LinkRelationKey_2[]) => asset is AdobeAssetWithLinks;

        export declare const doLinksContain: (links: LinkSet | undefined, linksToCheck?: LinkRelationKey_2[]) => boolean;

        /**
         * Execute a POST on the ops href provided using the operation document as body.
         *
         * @param {AdobeHTTPService | ServiceConfig} svc                                        HTTPService to use.
         * @param {string} opsEndpoint                                                          Operations endpoint
         * @param {AnyOperationDocument | AnyOperationDocument[] | string} operationDocument    Operations document
         * @param {Record<string, string>} additionalHeaders                                          Additional headers to include in the POST
         *
         * @returns {AdobePromise<AdobeResponse<'json'>, AdobeDCXError>}
         */
        export declare function doOperation(svc: AdobeHTTPService, opsEndpoint: string, operationDocument: AnyOperationDocument | AnyOperationDocument[] | string, additionalHeaders?: Record<string, string>): AdobePromise<AdobeResponse<'json'>, AdobeDCXError>;

        export declare enum EmbeddedMetadataMediaTypes {
            XML = "application/rdf+xml",
            JSON = "application/ld+json"
        }

        export declare type EmbeddedMetadataRepresentation = 'json' | 'xml';

        /**
         * Same as `fetchLinksForAssetWithResponse()`, but only returns LinkSet object.
         *
         * @see fetchLinksForAssetWithResponse
         *
         * @param svc        Service or service config
         * @param asset                     The asset
         * @param additionalHeaders Additional headers to be applied to HTTP requests
         */
        export declare function fetchLinksForAsset(svc: AdobeHTTPService | ServiceConfig, asset: AdobeMinimalAsset, additionalHeaders?: Record<string, string>): AdobePromise<LinkSet>;

        /**
         * Fetch asset's Repository Metadata using one of (in order of preference):
         * 1. HEAD ResolveBy* API
         * 2. HEAD api:id
         * 3. HEAD api:repo_metadata
         * 4. HEAD api:primary
         * 5. HEAD api:path
         *
         * @note
         * Always makes an API call. Does not fetch links from cache.
         * To fetch links from cache, use `fetchLinksIfMissing()` and provide
         * a list of LinkRelations required.
         *
         * @param svc        Service or service config
         * @param asset              The asset
         * @param additionalHeaders Additional headers to be applied to HTTP requests
         */
        export declare function fetchLinksForAssetWithResponse(svc: AdobeHTTPService | ServiceConfig, asset: AdobeMinimalAsset, additionalHeaders?: Record<string, string>): AdobePromise<RepoResponseResult<AdobeAsset & Required<Pick<AdobeAsset, 'links'>>, 'void'>>;

        /**
         * Fetch set of links if required link array does not exist in links property or cache.
         *
         * @param svc                   Service or service config
         * @param asset                 Asset with or without links
         * @param linksToPopulate       Required links
         * @param suppressMissingErrors Suppress error when links fetched but not found
         * @param additionalHeaders     Additional headers to be applied to HTTP requests
         */
        export declare function fetchLinksIfMissing(svc: AdobeHTTPService | ServiceConfig, asset: AdobeAsset, linksToPopulate?: LinkRelationKey[], suppressMissingErrors?: boolean, additionalHeaders?: Record<string, string>): AdobePromise<LinkSet, AdobeDCXError, RequestDescriptor>;

        declare interface File_2 extends AdobeFileBase {
            /**
             * Retrieves a paged list of versions for the asset
             * @param pageOpts          Optional paging and embedding parameters
             * @param additionalHeaders Additional headers to be applied to HTTP requests
             *
             * @returns {AdobePromise<RepoResponse<AdobeGetPageResult<Version>>>}
             */
            getPagedVersions(pageOpts: Omit<PageOptions<never>, 'embed'>, additionalHeaders?: Record<string, string>): AdobePromise<RepoResponse<AdobeGetPageResult<Version>>>;
            /**
             * Retrieves a specific version of the asset
             * @param version              Resource version
             * @param additionalHeaders    Additional headers to be applied to HTTP requests
             *
             * @returns {AdobePromise<RepoResponseResult<Version>>}
             */
            getVersionResource(version: string, additionalHeaders?: Record<string, string>): AdobePromise<RepoResponseResult<Version>>;
            /**
             * Update a version
             *
             * @param {string | AdobeVersionPatchOperation[]} patchDoc      The patch document to update the version with
             * @param {string} etag                                         The etag3 of the version to update
             * @param {Record<string, string>} additionalHeaders            Additional headers to be applied to HTTP requests
             *
             * @returns {AdobePromise<AdobeResponse, AdobeDCXError>}
             */
            patchVersions(etag: string, patchDoc: string, additionalHeaders?: Record<string, string>): AdobePromise<AdobeResponse>;
            /**
             * Initializes a control message (via the Block Initiate URL), in which the user agent
             * tells the service that it wishes to transfer content, and the service tells the user
             * agent how to go about doing that.
             * @param transferDocument          The transfer document which is used to initialize, process, and complete block uploads.
             * @param additionalHeaders         Any additional header to include in the request
             *
             * @returns {AdobePromise<RepoResponseResult<Required<BlockTransferDocument>>, AdobeDCXError>}
             */
            initBlockUpload(transferDocument: ACPTransferDocument, additionalHeaders?: Record<string, string>): AdobePromise<RepoResponseResult<Required<BlockTransferDocument>>, AdobeDCXError>;
            /**
             * Copy the file to some destination.
             *
             * @note
             * To copy to a new repositoryId, it must be specified in the destAsset.
             * If no repositoryId is specified, it will be moved to the same repository as the source asset instance.
             *
             * @param destAsset             Asset containing either path or assetId
             * @param createIntermediates   Whether to create intermediate directories if missing.
             * @deprecated File overriding using copy operation is no longer supported by the API
             * @param overwriteExisting     Whether to overwrite an existing asset.
             * @param additionalHeaders     Additional headers to apply to HTTP Requests
             */
            copy(destAsset: PathOrIdAssetDesignator, createIntermediates: boolean, overwriteExisting: boolean, additionalHeaders?: Record<string, string>, manifestPatch?: JSONPatchDocument): AdobePromise<RepoResponseResult<File_2, 'json'>, AdobeDCXError>;
        }

        declare class File_2 extends AdobeFileBase implements File_2 {
            readonly type: AssetType;
            constructor(data: AdobeFileData, svc: AdobeHTTPService | ServiceConfig, links?: LinkSet);
        }
        export { File_2 as File }

        /**
         * A cache that holds references to a limited number of values. Each time a value is accessed, it is moved to the head of a queue.
         * When a value is added to a full cache, the value at the end of that queue is evicted.
         */
        export declare class GenericCache<T> implements AdobeGenericCache<T> {
            private values;
            private maxEntries;
            private defaultSessionKey;
            private promiseToResolveMap;
            constructor(maxEntries?: number, defaultSessionKey?: string);
            /**
             * Clear cache, resolve all pending promises to undefined
             */
            clear(): void;
            /**
             * Return the key for the passed asset
             * @param asset     The asset to get the key for
             */
            getKey(asset: AdobeAsset): string | undefined;
            /**
             * Returns a value for the asset from the cache
             * @param asset     The asset key
             */
            getValueWithAsset(asset: AdobeAsset): Promise<T> | undefined;
            /**
             * Sets a promise for the key that can be resolved with the value
             * @param key       The key
             * @param repoId    The repoId
             */
            setPending(key: string, repoId?: string): any;
            /**
             * Returns value for key from cache
             * @param key       Cache key
             * @param repoId    The repositoryId
             */
            get(key: string, repoId?: any): Promise<T> | undefined;
            /**
             * Sets value for asset as key, if no repoId is set on the asset the asset will be stored in the session
             * @param value     The value to set
             * @param asset     The asset to use as the key
             */
            setValueWithAsset(value: T | undefined, asset: AdobeAsset): void;
            /**
             * Sets the key value pair
             * @param value     The value
             * @param key       The key
             * @param repoId    The repoId
             */
            set(value: T, key: string, repoId?: any): void;
            delete(key: string, repoId?: any): void;
            deleteWithAsset(asset: AdobeAsset): void;
        }

        /**
         * Retrieves the ACL resource for an asset
         *
         * @param svc    HTTP Service or ServiceConfig
         * @param asset        Asset whose links to retrieve
         * @param additionalHeaders Additional headers to be applied to HTTP requests
         */
        export declare function getACLPolicy(svc: AdobeHTTPService, asset: AdobeAsset, additionalHeaders?: Record<string, string>): AdobePromise<RepoResponseResult<ACPAccessControlList>, AdobeDCXError>;

        /**
         * Returns the application metadata associated with the asset.
         *
         * @note
         * Browser clients may prefer *not* using the etag parameter, instead relying on
         * the browser's HTTP cache to add the header, unless you are managing a cache yourself.
         *
         * @note
         * If etag provided and resource has not been modified, result will be `null`.
         *
         * @param svc               HTTP Service or ServiceConfig
         * @param asset             The asset to fetch the app metadata for
         * @param etag              If specified, will be passed as the If-None-Match header value.
         *                             Note: this etag refers to the application metadata resource.
         * @param additionalHeaders Additional headers to be applied to HTTP requests
         */
        export declare function getAppMetadata<T = any>(svc: AdobeHTTPService, asset: AdobeAsset, etag?: string, additionalHeaders?: Record<string, string>): AdobePromise<RepoResponseResult<T, 'json'> & {
            etag: string;
        }, AdobeDCXError>;

        export declare function getBaseDirectoryMetadata(svc: AdobeHTTPService | ServiceConfig, asset: AdobeAsset): AdobePromise<AdobeRepoMetadata, AdobeDCXError>;

        /**
         * Returns the current block download threshold
         * @returns the current block download threshold
         */
        export declare const getBlockDownloadThreshold: () => number;

        /**
         * Get the component download url by path, which has to be composite version specific.
         *
         * @internal
         *
         * @param svc                   Service or service config
         * @param asset                 Asset with a version
         * @param component_path        Component path
         * @param additionalHeaders     Additional headers to be applied to HTTP requests
         */
        export declare function _getComponentPathUrl(svc: AdobeHTTPService, asset: AdobeAsset, component_path: string, additionalHeaders?: Record<string, string>): AdobePromise<string, AdobeDCXError>;

        /**
         * Get a composite component by id and revision.
         * @param svc - AdobeHTTPService instance or ServiceConfig object
         * @param asset - AdobeAsset instance
         * @param componentId - component id
         * @param componentRevision - component revision
         * @param responseType - response type
         * @param additionalHeaders - additional headers
         * @param componentSize - component size
         * @returns - AdobePromise<RepoResponseResult<T, AdobeResponseType>, AdobeDCXError>
         */
        export declare function getCompositeComponent<T extends AdobeResponseType = 'defaultbuffer'>(svc: AdobeHTTPService, asset: AdobeAsset, componentId: string, componentRevision: string, responseType?: T, additionalHeaders?: Record<string, string>, componentSize?: number): RepoDownloadStreamableReturn<T>;

        /**
         * Get a composite component by path. Must be a well-known path for a given composite type.
         *
         * @see {@link https://wiki.corp.adobe.com/display/CA/Proposal%3A+Download+Components+by+DCX+Path Proposal: Download DCX Components by Path}
         *
         * @param svc - AdobeHTTPService instance or ServiceConfig object
         * @param asset - AdobeAsset instance
         * @param componentPath - path to the component
         * @param responseType - response type
         * @param additionalHeaders - additional headers
         * @param skipBlockDownload - to skip block download & get presignedURL instead
         * @returns - AdobePromise<RepoResponseResult<T, AdobeResponseType>, AdobeDCXError>
         *
         * @example
         * ```
         * const response = await getCompositeComponentByPath(
         *   serviceConfig,
         *   asset,
         *   '/path/to/component',
         *   'blob',
         *   { 'x-foo': 'bar' },
         * );
         * ```
         */
        export declare function getCompositeComponentByPath<T extends AdobeResponseType = 'defaultbuffer'>(svc: AdobeHTTPService | ServiceConfig, asset: AdobeAsset, componentPath: string, responseType?: T, additionalHeaders?: Record<string, string>, skipBlockDownload?: boolean): RepoDownloadStreamableReturn<T>;

        /**
         * Fetch pre-signed URL for a composite component
         * @param svc                   Service or service config
         * @param asset                 Asset object that identifies the asset
         * @param componentId           Component id
         * @param componentRevision     Component revision
         * @param additionalHeaders     Additional headers to be applied to HTTP requests
         */
        export declare function getCompositeComponentPresignedUrl(svc: AdobeHTTPService | ServiceConfig, asset: AdobeAsset, componentId: string, componentRevision: string, additionalHeaders?: Record<string, string>): AdobePromise<RepoResponseResult<string, 'json'>, AdobeDCXError>;

        /**
         * For returning the information necessary to perform the uploads either direct to ACP or via block upload.
         * @param svc  An HTTPService instance
         * @param asset The asset associated with the PUT request
         * @param uploads An array of ComponentUploadInfo
         * @param additionalHeaders Additional headers to attach to HTTP Requests
         * @returns An array of UploadRecipe
         */
        export declare function getCompositeComponentsUrlsForUpload(svc: AdobeHTTPService | ServiceConfig, asset: AdobeAsset, uploads: ComponentUploadInfo[], additionalHeaders?: Record<string, string>): AdobePromise<UploadRecipe[], AdobeDCXError>;

        export declare function getCompositeComponentUrl(svc: AdobeHTTPService, asset: AdobeAsset, componentId: string, componentRevision?: string): string;

        export declare function getCompositeManifest<T = unknown>(svc: AdobeHTTPService, asset: AdobeAsset, version?: string, etag?: string, additionalHeaders?: Record<string, string>): AdobePromise<RepoResponse<AdobeManifestResult<T>, 'json'>, AdobeDCXError>;

        export declare function getCompositeManifestUrl(svc: AdobeHTTPService, asset: AdobeAsset, versionId?: string, additionalHeaders?: Record<string, string>): AdobePromise<string, AdobeDCXError>;

        /**
         * Returns the size in bytes of the data param
         * @internal
         * @param data      The data to get the size for
         * @returns         The size of the data
         */
        export declare const getDataLength: (data: UploadableTypes) => number;

        /**
         * Returns a Directory object
         *
         * @param {AdobeHTTPService} svc        HTTP Service
         * @param {AdobeAsset} dirAsset         The asset
         *
         * @returns {AdobePromise<RepoResponse<AdobeGetDirectoryDataResult>, AdobeDCXError>}
         */
        export declare function getDirectory(svc: AdobeHTTPService | ServiceConfig, dirAsset: AdobeAsset): AdobePromise<RepoResponse<AdobeGetDirectoryDataResult>, AdobeDCXError_2>;

        /**
         * Returns a Directory object by URL
         *
         * @param {AdobeHTTPService} svc        HTTP Service
         * @param {AdobeAsset} dirAsset         The asset
         *
         * @returns {AdobePromise<RepoResponse<AdobeGetDirectoryDataResult>, AdobeDCXError>}
         */
        export declare function getDirectoryByURL(svc: AdobeHTTPService, url: string): AdobePromise<RepoResponse<AdobeGetDirectoryDataResult>, AdobeDCXError_2>;

        /**
         * Returns a paged resource of Discoverable Assets
         *
         * @param svc               The http service
         * @param pageOpts          Paging options
         * @param additionalHeaders Additional headers to attach to HTTP requests
         */
        export declare function getDiscoverableAssets<T extends EmbeddableResource = never>(svc: AdobeHTTPService | ServiceConfig, pageOpts?: Omit<PageOptions<T>, 'itemTransformer'>, additionalHeaders?: Record<string, string>): AdobePromise<RepoResponse<AdobeGetPageResult<AdobeAssetEmbedded<T>>>>;

        /**
         * Returns a paged resource of Discoverable Repos
         *
         * @param svc               The http service
         * @param pageOpts          Paging options
         * @param additionalHeaders Additional headers to apply to HTTP Requests
         */
        export declare function getDiscoverableRepos(svc: AdobeHTTPService | ServiceConfig, pageOpts?: Omit<PageOptions<never>, 'itemTransformer' | 'embed'>, additionalHeaders?: Record<string, string>): AdobePromise<RepoResponse<AdobeGetPageResult<AdobeRepository>>>;

        /**
         * Retrieves the effective privileges for the various resources of the asset
         *
         * @param svc    HTTP Service or ServiceConfig
         * @param asset        Asset whose links to retrieve
         * @param additionalHeaders Additional headers to be applied to HTTP requests
         */
        export declare function getEffectivePrivileges(svc: AdobeHTTPService, asset: AdobeAsset, additionalHeaders?: Record<string, string>): AdobePromise<RepoResponseResult<EffectivePrivileges>, AdobeDCXError>;

        /**
         * Get embedded metadata for an asset.
         *
         * @param {AdobeHTTPService}        svc                 HTTPService to use
         * @param {AdobeAsset}              asset               Asset whose embedded metadata to fetch, must contain embedded link.
         * @param {'json' | 'xml'}          format              Whether to return as JSON or XML.
         * @param {Record<string, string>}  additionalHeaders   Additional headers to be applied to HTTP requests
         *
         * @returns {AdobePromise<RepoResponseResult<T>>}
         */
        export declare function getEmbeddedMetadata<T = any>(svc: AdobeHTTPService, asset: AdobeAsset, format?: EmbeddedMetadataRepresentation, additionalHeaders?: Record<string, string>): AdobePromise<RepoResponseResult<T>>;

        export declare function getHTTPResource<T extends AdobeResponseType = AdobeResponseType>(svc: AdobeHTTPService, href: string, additionalHeaders?: Record<string, string>, responseType?: T): AdobePromise<AdobeResponse<T>, AdobeDCXError, RequestDescriptor>;

        /**
         * Returns the ACP Index document
         *
         * @param svc               The http service
         * @param additionalHeaders Additional headers to attach to HTTP requests
         */
        export declare function getIndexDocument(svc: AdobeHTTPService | ServiceConfig, additionalHeaders?: Record<string, string>): AdobePromise<RepoResponseResult<IndexDocument>>;

        export declare function getIndexLinks(svc: AdobeHTTPService | ServiceConfig, additionalHeaders?: Record<string, string>): AdobePromise<LinkSet>;

        export declare function getIndexRepository(svc: AdobeHTTPService | ServiceConfig, additionalHeaders?: Record<string, string>): AdobePromise<IndexRepository>;

        /**
         * Returns cached links or fetches if none cached.
         * If partial links are cached, will return them.
         *
         * @param svc        Service or service config
         * @param asset                            The asset
         * @param additionalHeaders Additional headers to be applied to HTTP requests
         */
        export declare function getLinksForAsset(svc: AdobeHTTPService | ServiceConfig, asset: AdobeAsset, additionalHeaders?: Record<string, string>): AdobePromise<LinkSet>;

        /**
         * Fetches an assets links from the provided cache
         *
         * @param {AdobeAsset} asset                                            Asset object that identifies the composite asset.
         * @param {AdobeRepositoryLinksCache<LinkSet> | undefined} cache        The cache
         * @param {LinkRelationKey[]} requiredLinks                             The expected links
         * @param {boolean} setPending                                          Put the asset key in the cache in a pending state to prevent it being loaded multiple times.
         *
         * @returns {AdobePromise<LinkSet | undefined, AdobeDCXError, RequestDescriptor>}
         */
        export declare function getLinksFromCache(asset: AdobeAsset, cache: AdobeRepositoryLinksCache<LinkSet> | undefined, requiredLinks?: LinkRelationKey[], setPending?: boolean): AdobePromise<LinkSet | undefined, AdobeDCXError, RequestDescriptor>;

        /**
         * @param components An array of ComponentRequestsByPath. NOTE: Paths are restricted to well-known paths only as determined by specific composite media type.
         * @see {@link https://wiki.corp.adobe.com/display/CA/Proposal%3A+Download+Components+by+DCX+Path Proposal: Download DCX Components by Path}
         * If using components that do not exist on the given well-known paths, please use @see  performBulkRequest
         * @example
         *  ```
         *  const components = [
         *    {
         *      component_path: "/model/database.json",
         *      responseType: "json" // Optional, default value "defaultbuffer",
         *      skipBlockDownload: true  // To skip block download of large asset and get presigned url instead
         *    }
         *  ]
         *  ```
         * @param version Version of the composite manifest to fetch (components all come from this version of the manifest)
         * @param etag Etag to use within the if-match header of the request
         * @param additionalHeaders Additional headers to attach to HTTP requests
         * @example
         * ```
         * {
         *   manifest: {
         *     data?: ManifestData // JSON parsed manifest data
         *     error?: DCXError // present if there was an error fetching the manifest
         *     response: AdobeResponse // response for the manifest sub-request (or secondary follow-up manifest request)
         *   },
         *   components: {
         *     "/model/database.json": { // component paths are the keys
         *       component_path: "/model/database.json",
         *       data?: ResponseTypeMap[ResponseType], // parsed into the requested responseType
         *       error?: DCXError, // present if there was an error fetching the manifest
         *       response: AdobeResponse // response for component sub-request (or follow-up request)
         *     }
         *   },
         *   responses: AdobeResponse[] // array of Bulk request responses (1 response per bulk request issued)
         * }
         * ```
         */
        export declare function getManifestAndComponentsByPath<C extends ComponentRequestByPath[] = []>(svc: AdobeHTTPService | ServiceConfig, asset: AdobeAsset | AdobeDCXComposite, components: C, version?: string, etag?: string, additionalHeaders?: Record<string, string>): AdobePromise<ManifestAndComponentsByPathResponse<C>, AdobeDCXError>;

        /**
         * Get ops endpoint URL from context or API.
         *
         * @this {OptionalContext<AdobeOpsContext>}
         * @param svc               The http service
         * @param additionalHeaders Additional headers to attach to HTTP Requests`
         */
        export declare function getOpsHref(this: OptionalContext<AdobeOpsContext>, svc: AdobeHTTPService | ServiceConfig, additionalHeaders?: Record<string, string>): AdobePromise<string, AdobeDCXError>;

        /**
         * Returns a PageResource object that allows for traversing a paged set of results
         *
         * @param {AdobeHTTPService} svc        HTTP Service
         * @param {AdobeAsset} dirAsset         The asset
         * @param {PageOptions} pageOpts        Paging options
         *
         * @returns {AdobePromise<RepoResponse<AdobeGetPageResult<AdobeAssetEmbedded<T>>>>}
         */
        export declare function getPagedChildren<T extends EmbeddableResource = never>(svc: AdobeHTTPService, dirAsset: AdobeAsset, pageOpts?: Omit<PageOptions<T>, 'itemTransformer'>, additionalHeaders?: Record<string, string>): AdobePromise<RepoResponse<AdobeGetPageResult<AdobeAssetEmbedded<T>>>>;

        /**
         * Returns a paged list of an assets versions
         *
         * @param svc                 - The http service
         * @param asset               - Asset object that identifies the asset
         * @param pageOpts            - The paging object.
         *                              @see {@link https://developers.corp.adobe.com/storage-api/docs/reference/page.md Page Object Referece }
         * @param additionalHeaders   Additional headers to be applied to HTTP requests
         */
        export declare function getPagedVersions(svc: AdobeHTTPService, asset: AdobeAsset, pageOpts?: Omit<PageOptions<never>, 'embed'>, additionalHeaders?: Record<string, string>): AdobePromise<RepoResponse<AdobeGetPageResult<AdobeVersion>>>;

        /**
         * Fetch pre-signed URL for a regular file asset
         * @param svc                   Service or service config
         * @param asset                 Asset object that identifies the asset
         * @param componentResource     If provided, generate presignedUrl for this component resource instead of asset primary resource
         * @param additionalHeaders     Additional headers to be applied to HTTP requests
         * @see {@link https://git.corp.adobe.com/pages/caf/api-spec/chapters/advanced/block.html#block-download Block Download Specification}
         */
        export declare function getPresignedUrl(svc: AdobeHTTPService | ServiceConfig, asset: AdobeAsset, componentResource?: ComponentResourceDesignator, additionalHeaders?: Record<string, string>): AdobePromise<RepoResponseResult<string, 'json'>, AdobeDCXError>;

        /**
         * Downloads an asset's primary resource
         * @this [OptionalContext<AdobeStreamableContext>] Optional this binding for AdobeStreamableContext
         * @param svc               HTTPService
         * @param asset             The asset
         * @param responseType      Type to tranform response into
         * @param additionalHeaders Additional headers to apply to HTTP Requests
         */
        export declare function getPrimaryResource<T extends AdobeResponseType = 'defaultbuffer'>(this: OptionalContext<AdobeStreamableContext>, svc: AdobeHTTPService, asset: AdobeAsset, responseType?: T, additionalHeaders?: Record<string, string>): RepoDownloadStreamableReturn<T>;

        export declare function getPubsAsset(svc: AdobeHTTPService | ServiceConfig, additionalHeaders?: Record<string, string>): AdobePromise<AdobeAsset>;

        export declare function getRendition<T extends AdobeResponseType = 'defaultbuffer'>(svc: AdobeHTTPService, asset: AdobeAsset, renditionOptions?: RenditionOptions, responseType?: T, linkProvider?: LinkProvider<RenditionOptions>, additionalHeaders?: Record<string, string>): AdobePromise<RepoResponseResult<ResponseTypeMap[T], T>>;

        /**
         * Retrieves the repository metadata resource for the asset
         *
         * @param svc        Service or service config
         * @param asset            The asset
         * @param additionalHeaders Additional headers to be applied to HTTP requests
         */
        export declare function getRepoMetadata(svc: AdobeHTTPService, asset: AdobeAsset, additionalHeaders?: Record<string, string>): AdobePromise<RepoResponseResult<AdobeRepoMetadata>, AdobeDCXError>;

        /**
         * Get the repository resource for an asset
         *
         * @param svc    HTTP Service or ServiceConfig
         * @param asset        Asset whose links to retrieve
         * @param additionalHeaders Additional headers to be applied to HTTP requests
         */
        export declare function getRepositoryResource(svc: AdobeHTTPService, asset: AdobeAsset, additionalHeaders?: Record<string, string>): AdobePromise<RepoResponseResult<ACPRepository>, AdobeDCXError>;

        export declare const getReposityLinksCache: (svc: AdobeHTTPService | ServiceConfig) => AdobeRepositoryLinksCache<LinkSet> | undefined;

        /**
         * Get resolveById URL from context or API.
         *
         * @this {OptionalContext<AdobeOpsContext>}
         * @param {AdobeHTTPService} svc    The http service
         *
         * @returns {AdobePromise<string, AdobeDCXError>}
         */
        export declare function getResolveByIdHref(this: OptionalContext<AdobeOpsContext>, svc: AdobeHTTPService | ServiceConfig): AdobePromise<string, AdobeDCXError>;

        /**
         * Get resolveByPath URL from context or API.
         *
         * @this {OptionalContext<AdobeOpsContext>}
         * @param {AdobeHTTPService} svc    The http service
         *
         * @returns {AdobePromise<string, AdobeDCXError>}
         */
        export declare function getResolveByPathHref(this: OptionalContext<AdobeOpsContext>, svc: AdobeHTTPService | ServiceConfig): AdobePromise<string, AdobeDCXError>;

        /**
         * Returns the resolve link for an Asset
         *
         * @note Resolve link is classified as well known by CA-771 https://jira.corp.adobe.com/browse/CA-771?src=confmacro
         *
         * @param svc               Service or service config
         * @param asset             The asset
         * @param mode              The resolve by mode to return
         * @param resource          Optional resource
         * @param additionalHeaders Additional headers to apply to HTTP Requests
         */
        export declare function getResolveLinkForAsset(svc: AdobeHTTPService | ServiceConfig, asset: AssetWithRepoAndPathOrId, mode?: 'id' | 'path', resource?: ResourceDesignator, additionalHeaders?: Record<string, string>): AdobePromise<string>;

        export declare const getService: (svc: AdobeHTTPService | ServiceConfig) => AdobeHTTPService;

        /**
         * Get the resource url based on link relation, which could be version specific or not
         *
         * @internal
         *
         * @param svc                   Service or service config
         * @param asset                 Asset
         * @param relation              Link relation
         * @param versionid             Optional asset version, which is to get version specific url
         * @param additionalHeaders     Additional headers to be applied to HTTP requests
         */
        export declare function _getUrl(svc: AdobeHTTPService, asset: AdobeAsset, relation: LinkRelationKey_2, versionId?: string, additionalHeaders?: Record<string, string>): AdobePromise<string, AdobeDCXError>;

        /**
         * Returns a version of an Asset
         *
         * @param svc               - The http service
         * @param asset             - Asset object that identifies the asset
         * @param version           - The version to retrieve
         * @param additionalHeaders Additional headers to be applied to HTTP requests
         */
        export declare function getVersionResource(svc: AdobeHTTPService, asset: AdobeAsset, version: string, additionalHeaders?: Record<string, string>): AdobePromise<RepoResponseResult<ACPVersion>>;

        /**
         * Performs a HEAD request on the application metadata resource.
         *
         * @param svc    HTTP Service or ServiceConfig
         * @param asset        The asset to HEAD the app metadata for
         * @param additionalHeaders Additional headers to be applied to HTTP requests
         */
        export declare function headAppMetadata(svc: AdobeHTTPService | ServiceConfig, asset: AdobeAsset, additionalHeaders?: Record<string, string>): AdobePromise<AdobeResponse<'void'>, AdobeDCXError>;

        export declare function headCompositeManifest(svc: AdobeHTTPService, asset: AdobeAsset, additionalHeaders?: Record<string, string>): AdobePromise<AdobeResponse>;

        /*************************************************************************
         *
         * ADOBE CONFIDENTIAL
         * ___________________
         *
         * @license
         * Copyright 2021 Adobe Inc.
         * All Rights Reserved.
         *
         * NOTICE:  All information contained herein is, and remains
         * the property of Adobe Inc. and its suppliers,
         * if any.  The intellectual and technical concepts contained
         * herein are proprietary to Adobe Inc. and its
         * suppliers and are protected by trade secret or copyright law.
         * Dissemination of this information or reproduction of this material
         * is strictly forbidden unless prior written permission is obtained
         * from Adobe Inc.
         **************************************************************************/
        /**
         * Common header key strings
         */
        export declare enum HeaderKeys {
            CONTENT_ID = "content-id",
            CONTENT_LENGTH = "content-length",
            CONTENT_RANGE = "content-range",
            CONTENT_TYPE = "content-type",
            IF_MATCH = "if-match",
            IF_NONE_MATCH = "if-none-match",
            AUTHORIZATION = "authorization",
            X_API_KEY = "x-api-key"
        }

        export declare function headHTTPResource(svc: AdobeHTTPService | ServiceConfig, href: string, additionalHeaders?: Record<string, string>): AdobePromise<AdobeResponse<'void'>, AdobeDCXError, RequestDescriptor>;

        /**
         * Performs a HEAD operation on the Asset
         *
         * @param svc                Service or service config
         * @param asset              The asset
         * @param additionalHeaders  Additional headers to apply to HTTP Requests
         */
        export declare function headPrimaryResource(svc: AdobeHTTPService | ServiceConfig, asset: AdobeAsset, additionalHeaders?: Record<string, string>): AdobePromise<AdobeResponse<'void'>, AdobeDCXError>;

        /*************************************************************************
         *
         * ADOBE CONFIDENTIAL
         * ___________________
         *
         * @license
         * Copyright 2021 Adobe Inc.
         * All Rights Reserved.
         *
         * NOTICE:  All information contained herein is, and remains
         * the property of Adobe Inc. and its suppliers,
         * if any.  The intellectual and technical concepts contained
         * herein are proprietary to Adobe Inc. and its
         * suppliers and are protected by trade secret or copyright law.
         * Dissemination of this information or reproduction of this material
         * is strictly forbidden unless prior written permission is obtained
         * from Adobe Inc.
         **************************************************************************/
        /**
         * HTTP Methods
         */
        export declare enum HTTPMethods {
            GET = "GET",
            PUT = "PUT",
            PATCH = "PATCH",
            HEAD = "HEAD",
            POST = "POST",
            DELETE = "DELETE"
        }

        /**
         * Create an HLA instance type from AdobeAsset or Asset
         *
         * @param {AdobeAsset | Asset} asset        Asset object
         * @param {AdobeHTTPService} svc            The http service
         *
         * @returns {T}
         */
        export declare function hydrateAsset<T extends Asset = Asset>(asset: AdobeAsset | Asset, svc: AdobeHTTPService | ServiceConfig): T;

        export declare type IDBasedOperationSource = RequireAtLeastOne<AdobeOperationSource, 'assetId' | 'repo:assetId'>;

        export declare interface IndexRepository {
            indexLinks: LinkSet;
            repositoryLinks: LinkSet;
            assetLinks: LinkSet;
        }

        /**
         * Used to narrow Any Operation Document to AdobeCopyResourcesDocument
         * @param doc Any Operation Document
         * @returns true if doc is AdobeCopyResourcesDocument
         */
        export declare const isAdobeCopyResourcesDocument: (doc: AnyOperationDocument) => doc is AdobeCopyResourcesDocument;

        export declare function isAdobeDCXBranchLike(obj: unknown): obj is AdobeDCXBranch;

        export declare function isAdobeDCXCompositeLike(asset: unknown): asset is AdobeDCXComposite;

        /**
         * Returns true if the object contains the properties: headers, responseType, xhr, and statusCode
         * @param {unknown} p
         */
        export declare function isAdobeResponseLike(p: unknown): p is AdobeResponse;

        export declare function isBlob(thing: unknown): thing is Blob;

        export declare function isBufferLike(p: unknown): p is Buffer;

        /**
         * Returns true if object has component_id property that is ComponentResourceDesignator
         * @param {unknown} p
         */
        export declare function isComponentResourceDesignator(p: unknown): p is ComponentResourceDesignator;

        export declare function isHttpService(o: unknown): o is AdobeHTTPService;

        /**
         * Returns true if the asset is minimal.
         * Contains either:
         * 1. Links
         * 2. Repository ID + {assetId || path}
         *
         * @param {unknown} asset
         */
        export declare function isMinimalAdobeAsset(asset: unknown): asset is AdobeMinimalAsset;

        /**
         * Returns true if object has response property that is AdobeResponseLike
         * @param {unknown} p
         */
        export declare function isRepoResponseLike(p: unknown): p is RepoResponse;

        /**
         * Returns true if object is RepoResponseLike and contains property `result` of any type.
         * @param {unknown} p
         */
        export declare function isRepoResponseResultLike(p: unknown): p is RepoResponseResult;

        /**
         * Returns true if the asset is resolvable.
         * Contains Repository ID + {assetId || path}
         *
         * @param {unknown} asset
         */
        export declare function isResolvableAsset(asset: unknown): asset is AssetWithRepoAndPathOrId;

        export declare function isServiceConfig(o: unknown): o is ServiceConfig;

        export declare function isTransferDocument(transferDoc: unknown): transferDoc is BlockTransferDocument;

        /**
         * JSON-LD media type
         */
        export declare const JSONLDMediaType = "application/ld+json";

        /**
         * JSON media type
         */
        export declare const JSONMediaType = "application/json";

        /**
         * JSON Patch media type
         */
        export declare const JSONPatchMediaType = "application/json-patch+json";

        /**
         * JSON problem media type
         */
        export declare const JSONProblemMediaType = "application/problem+json";

        /**
         * LinkRelation enumeration
         * Defines the possible relation types for HAL links
         */
        export declare const LinkRelation: {
            readonly ACCESS_CHECK: "http://ns.adobe.com/adobecloud/rel/ac/check";
            readonly ACL_POLICY: "http://ns.adobe.com/adobecloud/rel/ac/policy";
            readonly ANNOTATIONS: "http://ns.adobe.com/adobecloud/rel/annotations";
            readonly APP_METADATA: "http://ns.adobe.com/adobecloud/rel/metadata/application";
            readonly BASE_DIRECTORY: "http://ns.adobe.com/adobecloud/rel/directory/base";
            readonly BLOCK_DOWNLOAD: "http://ns.adobe.com/adobecloud/rel/download";
            readonly BLOCK_EXTEND: "http://ns.adobe.com/adobecloud/rel/block/extend";
            readonly BLOCK_FINALIZE: "http://ns.adobe.com/adobecloud/rel/block/finalize";
            readonly BLOCK_TRANSFER: "http://ns.adobe.com/adobecloud/rel/block/transfer";
            readonly BLOCK_UPLOAD_INIT: "http://ns.adobe.com/adobecloud/rel/block/init";
            readonly BULK_REQUEST: "http://ns.adobe.com/adobecloud/rel/bulk";
            readonly COMPONENT: "http://ns.adobe.com/adobecloud/rel/component";
            readonly CREATE: "http://ns.adobe.com/adobecloud/rel/create";
            readonly DESCRIBED_BY: "describedBy";
            readonly DIRECTORY: "http://ns.adobe.com/adobecloud/rel/directory";
            readonly DISCARD: "http://ns.adobe.com/adobecloud/rel/discard";
            readonly EFFECTIVE_PRIVILAGES: "http://ns.adobe.com/adobecloud/rel/ac/effective";
            readonly EMBEDDED_METADATA: "http://ns.adobe.com/adobecloud/rel/metadata/embedded";
            readonly ID: "http://ns.adobe.com/adobecloud/rel/id";
            readonly MANIFEST: "http://ns.adobe.com/adobecloud/rel/manifest";
            readonly PAGE: "http://ns.adobe.com/adobecloud/rel/page";
            readonly PATH: "http://ns.adobe.com/adobecloud/rel/path";
            readonly PRIMARY: "http://ns.adobe.com/adobecloud/rel/primary";
            readonly RENDITION: "http://ns.adobe.com/adobecloud/rel/rendition";
            readonly REPO_METADATA: "http://ns.adobe.com/adobecloud/rel/metadata/repository";
            readonly REPO_OPS: "http://ns.adobe.com/adobecloud/rel/ops";
            readonly REPOSITORY: "http://ns.adobe.com/adobecloud/rel/repository";
            readonly RESOLVE_BY_ID: "http://ns.adobe.com/adobecloud/rel/resolve/id";
            readonly RESOLVE_BY_PATH: "http://ns.adobe.com/adobecloud/rel/resolve/path";
            readonly RESTORE: "http://ns.adobe.com/adobecloud/rel/restore";
            readonly VERSION_HISTORY: "version-history";
        };

        export declare type LinkRelationKey = (typeof LinkRelation)[keyof typeof LinkRelation];

        declare type ListResource = 'api:primary' | 'version-history';

        export declare type ManifestAndComponentsByPathResponse<C extends ComponentRequestByPath[]> = {
            manifest: RepoResponse<{
                data?: ManifestData;
                error?: DCXError<unknown>;
            }>;
            components: UnionToIntersection<{
                [I in keyof C]: ToResponseObject<C[I]>;
            }[number]>;
            responses: AdobeResponse[];
        };

        /**
         * DCX Manifest media type
         */
        export declare const ManifestMediaType = "application/vnd.adobe.dcx-manifest+json";

        export declare const MAX_CACHE_PERIOD_MS: number;

        export declare function maybeGetBlockTransfer(promise: AdobePromise): Promise<AdobeBlockUpload | AdobeBlockDownload | undefined>;

        /**
         * Moves an asset from src to dest
         *
         * @this [OptionalLeafContext] Optional `this` scope that can provide an operations href.
         *
         * @param {AdobeHTTPService | ServiceConfig} svc        The http service
         * @param {PathOrIdAssetDesignator} srcAsset       The source asset
         * @param {PathOrIdAssetDesignator} destAsset      The destination asset
         * @param {boolean} createIntermediates                 Should intermediates be created?
         * @param {boolean} overwriteExisting                   Should an existing asset in dest be overwritten
         * @param {Record<string, string>} additionalHeaders                                          Any additional headers to include in the request
         *
         * @returns {AdobePromise<RepoResponseResult<AdobeAsset, 'json'>, AdobeDCXError>}
         */
        export declare function moveAsset(this: OptionalContext<AdobeOpsContext>, svc: AdobeHTTPService | ServiceConfig, srcAsset: PathOrIdAssetDesignator, destAsset: PathOrIdAssetDesignator, createIntermediates: boolean, overwriteExisting?: boolean, additionalHeaders?: Record<string, string>): AdobePromise<RepoResponseResult<AdobeAsset, 'json'>, AdobeDCXError>;

        export declare function newBlockDownload(svc: AdobeHTTPService, responseType: 'buffer', options?: BlockDownloadOptions): BlockDownload;

        export declare function newOperationDocBuilder(): OperationDocumentBuilder;

        /**
         * Normalize a CopyResource Designator, the returned format will always include both source and target, in the normalizedResource designator
         */
        export declare const normalizeCopyResourcesDesignator: (resourceDesignator: CopyResourceDesignator) => {
            source: NormalizedResourceDesignator;
            target: NormalizedResourceDesignator;
        };

        /**
         * Normalized ResourceDesignator format.
         */
        declare type NormalizedResourceDesignator = {
            reltype: LinkRelationKey_2;
            component_id: string;
            revision: string;
        };

        declare interface OperationDocTypeMap {
            move: AdobeMoveCopyDocument;
            copy: AdobeMoveCopyDocument;
            copy_resources: AdobeCopyResourcesDocument;
            discard: AdobeDiscardRestoreDocument;
            delete: AdobeDiscardRestoreDocument;
            restore: AdobeDiscardRestoreDocument;
            package: AdobePackageDocument;
        }

        /**
         * OperationDocumentBuilder
         */
        export declare class OperationDocumentBuilder {
            readonly opBatchLimit = 100;
            private _docs;
            private _batchSourceType;
            private _batchTargetType;
            getDocumentEntry<T extends AdobeOperation = AdobeOperation>(id: number): OperationDocTypeMap[T];
            getDocument(): AnyOperationDocument[];
            get entryCount(): number;
            copyResources(srcAsset: PathOrIdAssetDesignator, targetAsset: PathOrIdAssetDesignator, resources: CopyResourceDesignator[], intermediates?: boolean, manifestPatch?: JSONPatchDocument, additionalHeaders?: Record<string, string>): OperationDocumentBuilder;
            copy(srcAsset: PathOrIdAssetDesignator, destAsset: PathOrIdAssetDesignator, createIntermediates: boolean, overwriteExisting?: boolean, addlFields?: Record<string, unknown>): OperationDocumentBuilder;
            move(srcAsset: PathOrIdAssetDesignator, destAsset: PathOrIdAssetDesignator, createIntermediates: boolean, overwriteExisting?: boolean, addlFields?: Record<string, unknown>): OperationDocumentBuilder;
            package(sources: PathOrIdAssetDesignator | PathOrIdAssetDesignator[], destination: PathOrIdAssetDesignator, createIntermediates: boolean, overwriteExisting?: boolean, addlFields?: Record<string, unknown>): OperationDocumentBuilder;
            discard(target: PathOrIdAssetDesignator, recursive: boolean, addlFields?: Record<string, unknown>): OperationDocumentBuilder;
            restore(target: IDBasedOperationSource, addlFields?: Record<string, unknown>): OperationDocumentBuilder;
            delete(target: PathOrIdAssetDesignator, recursive: boolean, addlFields?: Record<string, unknown>): OperationDocumentBuilder;
            private _assertUnderLimit;
            private _checkTargetType;
            private _checkSourceType;
            private _checkSourceOrTargetType;
            private _getSourceType;
        }

        /**
         * Operation document media type
         */
        export declare const OperationDocumentMediaType = "application/vnd.adobe.asset-operation+json";

        declare interface OperationResult {
            op: AdobeOperation;
            source?: OperationResultSource | OperationResultSource[];
            target?: OperationResultSource;
            asset?: ACPRepoMetadataResource;
            intermediates?: boolean;
            error?: ACPProblemResponse;
            resources?: ACPCopyResourceDesignator[];
        }

        declare type OperationResultSource = Omit<OperationSource, 'assetId' | 'baseAssetId' | 'path' | 'etag' | 'format'>;

        declare interface OperationSource {
            assetId?: string;
            path?: string;
            'repo:assetId'?: string;
            'repo:path'?: string;
            'if-none-match'?: string;
            'if-match'?: string;
            'repo:baseAssetId'?: string;
            baseAssetId?: string;
            version?: string;
            etag?: string;
            format?: string;
            'dc:format'?: string;
            'repo:version'?: string;
        }

        /**
         * Optional context.
         */
        export declare type OptionalContext<T> = Partial<T> | undefined | void;

        /**
         * Package an asset (zip) and store at destination
         *
         * @this [OptionalLeafContext] Optional `this` scope that can provide an operations href.
         *
         * @param {AdobeHTTPService | ServiceConfig} svc                                    HTTPService to use.
         * @param {PathOrIdAssetDesignator | PathOrIdAssetDesignator[]} sources   Source(s) to package
         * @param {PathOrIdAssetDesignator} destination                                Destination for zipped package
         * @param {boolean} createIntermediates                                             Should intermediates be created?
         * @param {boolean} overwriteExisting                                               Should an existing asset in dest be overwritten
         * @param {Record<string, string>} additionalHeaders                                          Any additional headers to include in the request
         *
         * @returns {AdobePromise<RepoResponseResult<{ success: boolean }, 'json'>, AdobeDCXError>}
         */
        export declare function packageAssets(this: OptionalContext<AdobeOpsContext>, svc: AdobeHTTPService | ServiceConfig, sources: PathOrIdAssetDesignator | PathOrIdAssetDesignator[], destination: PathOrIdAssetDesignator, createIntermediates: boolean, overwriteExisting: boolean, additionalHeaders?: Record<string, string>): AdobePromise<RepoResponseResult<{
            success: boolean;
        }, 'json'>, AdobeDCXError>;

        export declare interface Page {
            page?: PageData;
            children: AdobeAsset[];
        }

        export declare interface PageData {
            orderBy?: string;
            start?: string;
            next?: string;
            property?: string;
            state?: string;
            type?: string;
            count?: number;
        }

        export declare interface PageOptions<T extends EmbeddableResource = never> {
            /**
             * Specifies the beginning of the desired page. This is the value from which the page will start. When not specified, the first page is given.
             * @see [rel/page](https://developers.corp.adobe.com/storage-api/docs/reference/page.md#query-parameters)
             */
            start?: string;
            /**
             * Specifies a positive integer as a hint as to the maximum number of items that should be returned for a given request.
             * The actual response size may be smaller or larger, as constrained by the need to provide reliable operation of the start parameter.
             * @see [rel/page](https://developers.corp.adobe.com/storage-api/docs/reference/page.md#query-parameters)
             */
            limit?: number;
            count?: number;
            /**
             * A comma-separated, ordered list of properties by which the Resource is sorted.
             * The first property is used for primary sorting, the second property to resolve ties in primary sorting, and so on.
             * The name of a property may be prefixed with a + to indicate ascending ordering or a - to indicate
             * descending ordering by that property. If the property name is not prefixed, the result is sorted in ascending order.
             * A Resource can be sorted by the following properties: repo:name, repo:createDate, repo:modifyDate.
             * @see [rel/page](https://developers.corp.adobe.com/storage-api/docs/reference/page.md#query-parameters)
             */
            orderBy?: string;
            next?: string;
            embed?: T[];
            itemTransformer?: (item: any, svc: AdobeHTTPService) => [string, any];
            type?: string;
        }

        export declare interface PageResource<T> {
            currentPage: PageData | undefined;
            listResource?: string;
            /**
             * Returns true if another page exists
             */
            hasNextPage(): boolean;
            /**
             * Get a page of data based on PageOptions
             * @param opts      The page options of data to load
             */
            getPage<U extends EmbeddableResource = never>(opts: PageOptions<U>): AdobePromise<RepoResponse<AdobeGetPageResult<T>>>;
            /**
             * Get's the next page in a pagedResource
             */
            getNextPage(): AdobePromise<RepoResponse<AdobeGetPageResult<T>>>;
        }

        export declare class PageResource<T = AdobeAsset> implements AsyncIterator<AdobeGetPageResult<T>> {
            private _links;
            private _svc;
            private _transformer;
            private _items;
            private _nextPageLink;
            private _data;
            currentPage: PageData | undefined;
            ListResource?: ListResource;
            constructor(_links: LinkSet, _svc: AdobeHTTPService, _transformer: (pre: any, svc: AdobeHTTPService) => [string, T], ListResource?: ListResource);
            get items(): T[];
            get data(): any;
            [Symbol.iterator](): Generator<T, void, unknown>;
            [Symbol.asyncIterator](): AsyncGenerator<any, void, unknown>;
            next(): Promise<IteratorResult<AdobeGetPageResult<T>>>;
            private parseResponse;
        }

        /**
         * Will parse the provided httpContent into an object containing the headers and data (does not parse out data into requested content-type)
         * @param httpContent
         * @param isMultiPartResponsePart
         * @returns
         * @see {@link https://tools.ietf.org/html/rfc7230#section-3 RFC-7230}
         */
        export declare function parseHttpResponseContent(httpContent: Uint8Array, isMultiPartResponsePart?: boolean | undefined): AdobeResponse<any>;

        export declare function parseLinksFromResponseHeader(response: AdobeResponse): LinkSet;

        export declare function parseLinkString(linkString: string): LinkSet;

        /**
         * Parses a multipart response object and returns an array of AdobeResponse objects
         * @param result            The response object
         * @param expectedParts     The number of expected parts
         */
        export declare function parseMultipartResponseParts(result: AdobeResponse, expectedParts?: number): AdobeResponse[];

        /**
         * @internal
         * @param data      The data to parse
         * @param size      The size of the data
         * @returns         The parsed data
         */
        export declare const _parseUploadableData: (data: SliceableData | GetSliceCallback, size?: number) => UploadableTypes;

        /**
         * Patch the ACL policy for this asset using a JSON Patch Document or stringified representation.
         * @param svc HTTP Service or ServiceConfig
         * @param asset Asset to issue the ACL PATCH on
         * @param policy A JSON Patch Document representing the patch operations to perform on the ACL
         * @param etag Optional etag for the ACL policy. If supplied, the patch will only be performed if the remote policy's etag matches the one provided.
         * @param additionalHeaders Additional headers to be applied to HTTP requests
         * @see {@link https://acpcs.corp.adobe.com/apis/?choose=aclfrontservice#operation/jsonPatchPolicy patch documentation}
         */
        export declare function patchACLPolicy(svc: AdobeHTTPService | ServiceConfig, asset: AdobeAsset, policy: JSONPatchDocument | string, etag?: string, additionalHeaders?: Record<string, string>): AdobePromise<RepoResponseResult<ACPAccessControlList>, AdobeDCXError>;

        /**
         * Update application metadata associated with the asset.
         *
         * @param {AdobeHTTPService} svc    HTTP Service or ServiceConfig
         * @param {AdobeAsset} asset        Asset whose links to retrieve
         * @param patchDoc                  JSON Patch Document to apply.
         *                                  {@link https://git.corp.adobe.com/pages/caf/api-spec/#patch|RFC 6902}
         * @param etag                      ETag of the application metadata resource.
         *                                    Used as the If-Match header value.
         *                                    For unconditional update, use wildcard "*".
         * @param additionalHeaders         Additional headers to be applied to HTTP requests
         *
         * @returns {AdobePromise<RepoResponseResult<{ etag: string }>, AdobeDCXError>}
         */
        export declare function patchAppMetadata<T = string | JSONPatchDocument>(svc: AdobeHTTPService, asset: AdobeAsset, patchDoc: T, etag: string, additionalHeaders?: Record<string, string>): AdobePromise<RepoResponseResult<{
            etag: string;
        }>, AdobeDCXError>;

        /**
         * Update embedded/XMP metadata using JSON Patch document.
         *
         * @see
         * https://tools.ietf.org/html/rfc6902#page-6
         *
         * @note
         * Currently the service requires an etag, but spec states unguarded updates should be possible.
         * see {@link https://jira.corp.adobe.com/browse/SYSE-7940}
         * and {@link https://jira.corp.adobe.com/browse/SYSE-5943}
         *
         * @param {AdobeHTTPService}                        svc       HTTPService to use
         * @param {AdobeAsset}                              asset     Asset to update, must be composite
         * @param {JSONPatchDocument | string}              data      Data to use as PATCH body
         * @param {string}                                  [etag]    ETag of the embedded metadata resource to be updated
         * @param {Record<string, string>}                  additionalHeaders   Additional headers to attach to HTTP Requests
         *
         * @returns {AdobePromise<AdobeResponse<'void'>>}
         */
        export declare function patchEmbeddedMetadata(svc: AdobeHTTPService, asset: AdobeAsset, data: JSONPatchDocument | string, etag?: string, additionalHeaders?: Record<string, string>): AdobePromise<AdobeResponse<'void'>>;

        /**
         * Issues a PATCH request against the specified version in the patchDoc.
         *
         * @param svc               - The http service
         * @param asset             - Asset object that identifies the asset
         * @param patchDoc          - A JSON Patch Document (RFC 6902 and https://git.corp.adobe.com/pages/caf/api-spec/#patch)
         * @param etag              - If specified then its value will be passed with the If-Match header.
         *                              Version resource will only be updated if eTag matches what is on the server.
         *                              Note that this etag refers to the Versions resource. The etag property on the asset argument is ignored.
         */
        export declare function patchVersions(svc: AdobeHTTPService, asset: AdobeAsset, patchDoc: string | AdobeVersionPatchOperation[], etag?: string, additionalHeaders?: Record<string, string>): AdobePromise<AdobeResponse, AdobeDCXError>;

        /**
         * Path or ID based source for Operation API.
         */
        export declare type PathOrIdAssetDesignator = RequireAtLeastOne<AdobeOperationSource, 'path' | 'repo:path' | 'assetId' | 'repo:assetId'> | AdobeDCXComposite;

        export declare function pauseBlockTransfer(promise: AdobePromise, stateChangeCb?: (state: any) => void): Promise<AdobeBlockDownload | AdobeBlockUpload | undefined>;

        export declare function performBulkRequest(svc: AdobeHTTPService, asset: AdobeAsset, requests: BulkRequestDescriptor[], linkMode?: LinkMode, additionalHeaders?: Record<string, string>, retrySubrequests?: boolean): AdobePromise<RepoResponseResult<AdobeResponse[]>, AdobeDCXError_2>;

        export declare enum PolicyPrincipalProperties {
            XDM_PROVIDER = "xdm:provider",
            ID = "@id",
            TYPE = "@type"
        }

        export declare enum PolicyProperties {
            REPO_ACL = "repo:acl",
            REPO_PRINCIPLE = "repo:principal",
            REPO_MODIFIER = "repo:modifier",
            REPO_PRIVILEGES = "repo:privileges",
            REPO_RELATIONS = "repo:relations",
            REPO_INHERITANCE = "repo:inheritance"
        }

        export { ProblemTypes }

        /*************************************************************************
         *
         * ADOBE CONFIDENTIAL
         * ___________________
         *
         * @license
         * Copyright 2020 Adobe Inc.
         * All Rights Reserved.
         *
         * NOTICE:  All information contained herein is, and remains
         * the property of Adobe Inc. and its suppliers,
         * if any.  The intellectual and technical concepts contained
         * herein are proprietary to Adobe Inc. and its
         * suppliers and are protected by trade secret or copyright law.
         * Dissemination of this information or reproduction of this material
         * is strictly forbidden unless prior written permission is obtained
         * from Adobe Inc.
         **************************************************************************/
        /**
         * Properties that might exist on an Asset of varying classes.
         */
        export declare enum Properties {
            DC_FORMAT = "dc:format",
            DC_TITLE = "dc:title",
            LINKS = "_links",
            PAGE = "_page",
            CHILDREN = "children",
            EMBEDDED = "_embedded",
            REPO_ASSET_ID = "repo:assetId",
            REPO_REPOSITORY_ID = "repo:repositoryId",
            REPO_REPOSITORY_TYPE = "repo:repositoryType",
            REPO_BASE_ASSET_ID = "repo:baseAssetId",
            REPO_SIZE = "repo:size",
            REPO_NAME = "repo:name",
            REPO_PATH = "repo:path",
            REPO_ASSET_CLASS = "repo:assetClass",
            REPO_CREATE_DATE = "repo:createDate",
            REPO_MODIFY_DATE = "repo:modifyDate",
            REPO_DISCARD_DATE = "repo:discardDate",
            REPO_ETAG = "repo:etag",
            REPO_CREATED_BY = "repo:createdBy",
            REPO_MODIFIED_BY = "repo:modifiedBy",
            REPO_DISCARDED_BY = "repo:discardedBy",
            REPO_DEVICE_CREATE_DATE = "storage:deviceCreateDate",
            REPO_DEVICE_MODIFY_DATE = "storage:deviceModifyDate",
            REPO_DEFAULT_SCHEDULED_DELETION_DURATION = "repo:defaultScheduledDeletionDuration",
            REPO_SCHEDULED_DELETION_DATE = "repo:scheduledDeletionDate",
            REPO_VERSION = "repo:version",
            REPO_STATE = "repo:state",
            REPO_AVAILABLE_REGIONS = "repo:availableRegions",
            REPO_REGIONS = "repo:regions",
            REPO_OWNER = "repo:owner",
            REPO_OWNER_ID = "id",
            REPO_OWNER_TYPE = "type",
            STORAGE_ASSIGNEE = "storage:assignee",
            STORAGE_ASSIGNEE_ID = "id",
            STORAGE_ASSIGNEE_TYPE = "type",
            IMAGE_LENGTH = "tiff:imageLength",
            IMAGE_WIDTH = "tiff:imageWidth",
            NUM_OF_PAGES = "xmpTPg:NPages",
            PAGE_START = "start",
            PAGE_ORDER_BY = "orderBy",
            PAGE_NEXT = "next",
            PAGE_COUNT = "count",
            PAGE_LIMIT = "limit"
        }

        /**
         * Update application metadata associated with the asset.
         *
         * @example
         * ```ts
         * const { result, response } = await asset.putAppMetadata(obj, etag);
         * // result is type object, shape: { etag: string }, with etag being the
         * //                        value of the new app metadata resource's etag
         * // response is type AdobeResponse
         * ```
         *
         * @note Replaces the entire resource.
         *
         * @param svc               HTTP Service or ServiceConfig
         * @param asset             Asset whose links to retrieve
         * @param metadata          New application metadata JSON object
         * @param etag              If specified, will be passed as the If-None-Match header value.
         *                              Note: this etag refers to the application metadata resource.
         * @param additionalHeaders Additional headers to be applied to HTTP requests
         */
        export declare function putAppMetadata<T = any>(svc: AdobeHTTPService, asset: AdobeAsset, metadata: T, etag?: string, additionalHeaders?: Record<string, string>): AdobePromise<RepoResponseResult<{
            etag: string;
        }>, AdobeDCXError>;

        /**
         *
         *
         * Uploads a composite component
         * @remarks Service can override the block size client specified @see {@link https://git.corp.adobe.com/caf/api-spec/blob/gh-pages/schemas/repository/transfer-document.schema.json#L45}
         * @param service                                       An HTTPService instance
         * @param asset                                         The asset associated with the PUT request
         * @param componentId                                   The componentId of the component to be uploaded. ComponentId supposes to be uuid.
         * @param dataOrSliceCallback                           Either the component data or a GetSliceCallback.
         *                                                       If the size of the data is greater then repo:maxSingleTransferSize a GetSliceCallback should be provided instead of the data.
         *                                                       The GetSliceCallback function accepts a start byte where the buffer slice should start and an end byte where
         *                                                       the buffer slice should end (not inclusive). The callback should return a Promise containing the buffer slice or a buffer
         *                                                       of length 0 indicating the end of the buffer.
         * @param contentType                                   The contentType of the component being uploaded
         * @param maybeIsNew                                    Do we think this is a new component?
         * @param size                                          The expected size of this component
         * @param md5                                           The md5 of the component
         * @param progressCb                                    A progress callback that will be invoked with updates to upload progress
         * @param additionalHeaders                             Additional headers to attach to HTTP Requests
         * @param blockSize                                     Desired block size for the upload in bytes
         */
        export declare function putCompositeComponent(svc: AdobeHTTPService | ServiceConfig, asset: AdobeAsset, componentId: string, dataOrSliceCallback: SliceableData | GetSliceCallback, contentType: string, maybeIsNew?: boolean, size?: number, md5?: string, progressCb?: UploadProgressCallback, additionalHeaders?: Record<string, string>, blockSize?: number): AdobePromise<AdobeRepoUploadResult, AdobeDCXError, {
            blockUpload?: AdobeBlockUpload;
        }>;

        /**
         * Update entire embedded/XMP metadata resource.
         *
         * @note
         * Replaces existing XMP resource.
         *
         * @note
         * Currently the service requires an etag, but spec states unguarded updates should be possible.
         * see: https://jira.corp.adobe.com/browse/SYSE-7940
         * and: https://jira.corp.adobe.com/browse/SYSE-5943
         *
         * @param {AdobeHTTPService}            svc             HTTPService to use
         * @param {AdobeAsset}                  asset           Asset whose embedded metadata should be updated
         * @param {T = Record<string, unknown>} data            New embedded metadata
             * @param {string}                      [etag]          ETag of metadata resource to update.
             * @param {'json'|'xml'}                [format='json'] Defines the representation of the body, either XML or JSON.
             *                                                      If using XML, clients must pass the data as a string.
             *                                                      If using XML with TypeScript, clients must specify the generic as `string`.
             *                                                      Defaults to json.
             * @param {Record<string, string>}      additionalHeaders Additional headers to be applied to HTTP requests
             *
             * @returns {AdobePromise<AdobeResponse<'void'>>}
             */
         export declare function putEmbeddedMetadata<T = Record<string, unknown>>(svc: AdobeHTTPService, asset: AdobeAsset, data: T, etag?: string, format?: EmbeddedMetadataRepresentation, additionalHeaders?: Record<string, string>): AdobePromise<AdobeResponse<'void'>>;

         export declare enum RenditionType {
             IMAGE_JPG = "image/jpg",
             IMAGE_PNG = "image/png",
             IMAGE_GIF = "image/gif",
             VIDEO_MP4 = "video/mp4",
             VIDEO_METADATA = "application/vnd.adobe.ccv.videometadata"
         }

         export declare type RepoResponse<T = unknown, U extends AdobeResponseType = AdobeResponseType> = T & AdobeRepoResponse<U>;

         /**
          * RepoResponse with only 1 additional property, named result.
          * T -> Type of result property
          * U -> ResponseType of AdobeResponse
          */
         export declare type RepoResponseResult<T = unknown, U extends AdobeResponseType = AdobeResponseType> = RepoResponse<{
             result: T;
         }, U>;

         export declare type RepoResponseSuccessResult<U extends AdobeResponseType = AdobeResponseType> = RepoResponseResult<AdobeSuccessResult, U>;

         /**
          * A cache that holds references to a limited number of values. Each time a value is accessed, it is moved to the head of a queue.
          * When a value is added to a full cache, the value at the end of that queue is evicted.
          */
         export declare class RepositoryLinksCache extends GenericCache<LinkSet> implements AdobeRepositoryLinksCache<LinkSet> {
             indexRepository?: IndexRepository;
             private timestampsOnLinkCreation;
             private maxCachePeriodMS;
             constructor(maxEntries?: number, maxCachePeriodMS?: number);
             private isLinkExpired;
             /**
              * Set the index links
              * @param value     The value to cache
              */
             setIndexLinks(value: LinkSet): void;
             /**
              * Returns the index links
              */
             getIndexLinks(): Promise<LinkSet> | undefined;
             /**
              * Set the index document links
              * @param value     The value to cache
              */
             setIndexRepository(value: IndexRepository): void;
             /**
              * Returns the index document links
              */
             getIndexRepository(): IndexRepository | undefined;
             /**
              * Set the repositories links
              * @param value     The value to cache
              */
             setRepositoryLinks(value: LinkSet): void;
             /**
              * Returns the repositories links
              */
             getRepositoryLinks(): Promise<LinkSet> | undefined;
         }

         /**
          * Call resolveByID or resolveByPath on an asset.
          * If resource is specified (and valid) the additional resource will be included in the response object.
          *
          * @note
          * This method currently only takes a LinkRelationKey as the resource argument.
          * It will be updated with support for Resource Designator objects with https://jira.corp.adobe.com/browse/DCX-4232.
          *
          * @param svc               Service or service config
          * @param asset             The asset to resolve, must be resolvable
          * @param mode              Whether to return path- or id-based links
          * @param resource          Additional resource to include in the response
          * @param responseType      Optional parsing of additional resource, defaults to 'json'
          * @param additionalHeaders Additional headers to apply to HTTP Requests
          */
         export declare function resolveAsset<T extends AdobeResponseType = 'json'>(svc: AdobeHTTPService | ServiceConfig, asset: AssetWithRepoAndPathOrId, mode?: 'path' | 'id', resource?: ResourceDesignator, responseType?: T, additionalHeaders?: Record<string, string>): AdobePromise<RepoResponseResult<AdobeAsset, T | 'void'>, AdobeDCXError>;

         /**
          * Restore a discarded asset
          *
          * @this [OptionalLeafContext] Optional `this` scope that can provide an operations href.
          *
          * @param {AdobeHTTPService | ServiceConfig} svc        HTTPService to use.
          * @param {IDBasedOperationSource} asset                The asset to restore
          * @param {Record<string, string>} additionalHeaders    Any additional headers to include in the request
          *
          * @returns {AdobePromise<RepoResponseResult<AdobeAsset, 'json'>, AdobeDCXError>}
          */
         export declare function restoreAsset(this: OptionalContext<AdobeOpsContext>, svc: AdobeHTTPService | ServiceConfig, asset: IDBasedOperationSource, additionalHeaders?: Record<string, string>): AdobePromise<RepoResponseResult<AdobeAsset, 'json'>, AdobeDCXError>;

         export declare interface ServiceConfig {
             service: AdobeHTTPService;
             cache?: AdobeRepositoryLinksCache<LinkSet>;
         }

         /**
          * Sets the current block download threshold
          * @param threshold     The new threshold
          */
         export declare const setBlockDownloadThreshold: (threshold: number) => void;

         /**
          * Check whether block download should be used
          *
          * @param {number} size - size of asset in bytes
          * @param {number} [threshold = 52428800] - threshold at which to use block download
          */
         export declare const shouldUseBlockTransferForDownload: (size: number, threshold?: number) => boolean;

         /**
          * @internal
          */
         export declare function shouldUseBlockTransferForUpload(asset: AdobeAsset, size: number): boolean;

         /**
          * Streamable Response Types
          * @internal
          */
         export declare const STREAMABLE_RESPONSE_TYPES: string[];

         /**
          * Convert a stream to GetSliceCallback. This should be seen as a temporary placeholder until request body streams are available.
          * See (Send ReadableStream in request body) {@link https://developer.mozilla.org/en-US/docs/Web/API/Request#browser_compatibility}
          * See {@link https://web.dev/fetch-upload-streaming/}
          */
         export declare function streamToGetSliceCallback(stream: AdobeResponse<'stream'>['response'], resourceSize: number, targetAsset: AdobeAsset, maxOutstandingTransfers?: number): GetSliceCallback;

         declare type ToResponseObject<C> = C extends ComponentRequestByPath ? {
             [P in C['component_path']]: ComponentResponse<C>;
         } : never;

         declare type UnionToIntersection<U> = (U extends any ? (k: U) => any : never) extends (k: infer I) => any ? I : never;

         export declare function updateCompositeManifest<T = string | Record<string, unknown>>(svc: AdobeHTTPService, asset: AdobeAsset, manifest: T, overwrite: boolean, validationLevel?: number, etag?: string, additionalHeaders?: Record<string, string>): AdobePromise<AdobeResponse<'json'>, AdobeDCXError>;

         /**
          * Update an asset's primary resource.
          *
          * @note Implicitly creates a new version of the asset.
          *
          * @param service               HTTPService to use.
          * @param asset                 Asset whose primary resource to update.
          * @param dataOrSliceCallback   Data to use for update, or callback to provide blocks for block upload.
          *                              If a callback is used, block upload will be used, regardless of size of the asset.
          * @param contentType           The content type of the resource to upload.
          * @param size                  The size of the resource in bytes.
          * @param etag                  The etag of the existing resource.
          * @param md5                   The MD5 hash of the resource, used for block upload finalize.
          * @param additionalHeaders     Additional headers to attach to HTTP requests
          */
         export declare function updatePrimaryResource(svc: AdobeHTTPService | ServiceConfig, asset: AdobeAsset, dataOrSliceCallback: SliceableData | GetSliceCallback, contentType: string, size?: number, etag?: string, md5?: string, additionalHeaders?: Record<string, string>): AdobePromise<AdobeRepoUploadResult, AdobeDCXError, {
             blockUpload?: AdobeBlockUpload;
         }>;

         declare type UploadableTypes = SliceableData | AsyncData;

         /**
          * Issues GET on a resource link if it exists in either the asset object
          * or in the links cache. If neither exists, use the resolve API to fetch
          * the resource in a single request.
          *
          * @note The list of relations that can be fetched using the resolve API will likely
          * change over time. `ResolvableResourceRelations` will have to be updated with
          * each new valid resource.
          *
          * @param svc               HTTP Service or ServiceConfig
          * @param asset             Asset object
          * @param resource
          * @param additionalHeaders Additional headers to be applied to HTTP requests
          */
         export declare function useLinkOrResolveResource<T extends AdobeResponseType = AdobeResponseType>(svc: AdobeHTTPService | ServiceConfig, asset: AdobeAsset, resource: ResolvableResourceRelations, responseType?: T, additionalHeaders?: Record<string, string>): AdobePromise<RepoResponseResult<AdobeAsset, T>, AdobeDCXError>;

         export declare class Version extends AdobeFileBase implements AdobeVersion {
             protected _svc: AdobeHTTPService;
             readonly type: "version";
             protected _data: AdobeVersion;
             constructor(data: AdobeVersion & ACPVersion, _svc: AdobeHTTPService, links?: LinkSet);
             get milestone(): AdobeVersionMilestone | undefined;
             /**
              * @hidden
              * Not found on version links
              */
             getRepositoryResource(): AdobePromise<RepoResponseResult<ACPRepository>, AdobeDCXError>;
             /**
              * @hidden
              * Not found on version links
              */
             getEffectivePrivileges(): AdobePromise<RepoResponseResult<EffectivePrivileges>, AdobeDCXError>;
             /**
              * @hidden
              * Not found on version links
              */
             performBulkRequest(requests: BulkRequestDescriptor[], linkMode?: LinkMode): AdobePromise<RepoResponseResult<AdobeResponse[]>, AdobeDCXError>;
             /**
              * @hidden
              * Not found on version links
              */
             checkACLPrivilege(privilege: Omit<Privilege, 'none'>, relation: LinkRelationKey_2): AdobePromise<RepoResponseResult<boolean>, AdobeDCXError>;
             /**
              * @hidden
              * Not found on version links
              */
             getACLPolicy(): AdobePromise<RepoResponseResult<ACPAccessControlList>, AdobeDCXError>;
         }

         export declare enum VersionProperties {
             REPO_ID = "repo:id",
             CREATED = "created",
             CREATED_BY = "created_by",
             MILESTONE = "milestone",
             VERSION = "version",
             TOTAL_CHILDREN = "total_children"
         }

         export declare class VersionSet implements AdobeVersionSet {
             protected _svc: AdobeHTTPService;
             /**
              * The repository Id of the asset
              */
             repositoryId: string | undefined;
             /**
              * The asset Id of the asset
              */
             assetId: string | undefined;
             /**
              * An array of versions for the asset
              */
             versions: Version[];
             /**
              * A count of versions for the asset
              */
             versionCount: number | undefined;
             /**
              * The assets links
              */
             links?: LinkSet;
             constructor(data: ACPVersions & AdobeVersionSet, _svc: AdobeHTTPService, links?: LinkSet);
             /**
              * Returns a version from the version set by Id
              *
              * @param {string}versionId     The version Id
              *
              * @returns {Version | undefined}
              */
             versionByVersionId(versionId: string): Version | undefined;
             /**
              * Returns all versions containing a label
              *
              * @param {string} label    The label to search for
              *
              * @returns {AdobeVersion[]}
              */
             versionsByLabel(label: string): AdobeVersion[];
         }

         export declare function versionTransformer(data: AdobeVersion & ACPVersion, svc: AdobeHTTPService): [string, Version];

         export declare type VVersion = Partial<Omit<Asset, 'name' | 'path'>> & {
             created_at?: Date;
             updated_at?: Date;
         };

         /**
          * Wait for a transfer that may use BlockDownload.
          * Resolves when either the download is complete, or the blockDownload property becomes available.
          * @deprecated - waitForBlockDownloadToStart has deprecated using maybeGetBlockTransfer instead.
          * @param res
          */
         export declare function waitForBlockDownloadToStart<T extends RepoDownloadStreamableReturn<any>>(res: T): Promise<void>;

         export declare enum XDMProviderProperties {
             ID = "@id"
         }

         export { }
