/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * @license
 * Copyright 2020 Adobe Inc.
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Inc. and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Inc. and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Inc.
 **************************************************************************/

import { AdobeHTTPService, LinkSet } from '@dcx/common-types';
import { newDebug } from '@dcx/logger';
import { AdobeRepositoryLinksCache } from './cache/RepositoryLinksCache';
import { isServiceConfig } from './util/duck_type';

const dbg = newDebug('dcx:assets:service');

export interface ServiceConfig {
    service: AdobeHTTPService;
    cache?: AdobeRepositoryLinksCache<LinkSet>;
}

export const getService = (svc: AdobeHTTPService | ServiceConfig): AdobeHTTPService => {
    return isServiceConfig(svc) ? svc.service : svc;
};

export const getReposityLinksCache = (
    svc: AdobeHTTPService | ServiceConfig,
): AdobeRepositoryLinksCache<LinkSet> | undefined => {
    return isServiceConfig(svc) ? svc.cache : undefined;
};

export function constructServiceEndpoint(url: string, service: AdobeHTTPService) {
    dbg('constructServiceEndpoint()', url);

    // If the service has the _repoAPIBaseUrl property, use it as the url root.
    // Otherwise, no RepoAPISession was created, and it's up to the client to set the
    // HTTPService's `server` property accordingly.
    const repoUrl: string = (service as unknown as Record<string, string>)._repoAPIBaseUrl;
    if (repoUrl) {
        url = `${repoUrl.endsWith('/') ? repoUrl.substr(0, repoUrl.length - 1) : repoUrl}${url}`;
    }

    dbg('cSE()', url);
    return url;
}
