/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * @license
 * Copyright 2020 Adobe Inc.
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Inc. and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Inc. and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Inc.
 **************************************************************************/

import { AdobeResponse, AdobeResponseType } from '@dcx/common-types';

interface AdobeRepoResponse<U extends AdobeResponseType> {
    response: AdobeResponse<U>;
}

export type RepoResponse<T = unknown, U extends AdobeResponseType = AdobeResponseType> = T & AdobeRepoResponse<U>;

/**
 * RepoResponse with only 1 additional property, named result.
 * T -> Type of result property
 * U -> ResponseType of AdobeResponse
 */
export type RepoResponseResult<T = unknown, U extends AdobeResponseType = AdobeResponseType> = RepoResponse<
    { result: T },
    U
>;

export interface AdobeSuccessResult {
    success: boolean;
}

export type RepoResponseSuccessResult<U extends AdobeResponseType = AdobeResponseType> = RepoResponseResult<
    AdobeSuccessResult,
    U
>;

export function defaultBufferResponseType<T extends AdobeResponseType>(responseType: T | undefined): T {
    if (!responseType) {
        return 'defaultbuffer' as T;
    }

    return responseType;
}
