/**
 * LinkRelation enumeration
 * Defines the possible relation types for HAL links
 */
export const LinkRelation = {
    ACCESS_CHECK: 'http://ns.adobe.com/adobecloud/rel/ac/check',
    ACL_POLICY: 'http://ns.adobe.com/adobecloud/rel/ac/policy',
    ANNOTATIONS: 'http://ns.adobe.com/adobecloud/rel/annotations',
    APP_METADATA: 'http://ns.adobe.com/adobecloud/rel/metadata/application',
    BASE_DIRECTORY: 'http://ns.adobe.com/adobecloud/rel/directory/base',
    BLOCK_DOWNLOAD: 'http://ns.adobe.com/adobecloud/rel/download',
    BLOCK_EXTEND: 'http://ns.adobe.com/adobecloud/rel/block/extend',
    BLOCK_FINALIZE: 'http://ns.adobe.com/adobecloud/rel/block/finalize',
    BLOCK_TRANSFER: 'http://ns.adobe.com/adobecloud/rel/block/transfer',
    BLOCK_UPLOAD_INIT: 'http://ns.adobe.com/adobecloud/rel/block/init',
    BULK_REQUEST: 'http://ns.adobe.com/adobecloud/rel/bulk',
    COMPONENT: 'http://ns.adobe.com/adobecloud/rel/component',
    CREATE: 'http://ns.adobe.com/adobecloud/rel/create',
    DESCRIBED_BY: 'describedBy',
    DIRECTORY: 'http://ns.adobe.com/adobecloud/rel/directory',
    DISCARD: 'http://ns.adobe.com/adobecloud/rel/discard',
    EFFECTIVE_PRIVILAGES: 'http://ns.adobe.com/adobecloud/rel/ac/effective',
    EMBEDDED_METADATA: 'http://ns.adobe.com/adobecloud/rel/metadata/embedded',
    ID: 'http://ns.adobe.com/adobecloud/rel/id',
    MANIFEST: 'http://ns.adobe.com/adobecloud/rel/manifest',
    PAGE: 'http://ns.adobe.com/adobecloud/rel/page',
    PATH: 'http://ns.adobe.com/adobecloud/rel/path',
    PRIMARY: 'http://ns.adobe.com/adobecloud/rel/primary',
    RENDITION: 'http://ns.adobe.com/adobecloud/rel/rendition',
    REPO_METADATA: 'http://ns.adobe.com/adobecloud/rel/metadata/repository',
    REPO_OPS: 'http://ns.adobe.com/adobecloud/rel/ops',
    REPOSITORY: 'http://ns.adobe.com/adobecloud/rel/repository',
    RESOLVE_BY_ID: 'http://ns.adobe.com/adobecloud/rel/resolve/id',
    RESOLVE_BY_PATH: 'http://ns.adobe.com/adobecloud/rel/resolve/path',
    RESTORE: 'http://ns.adobe.com/adobecloud/rel/restore',
    VERSION_HISTORY: 'version-history',
} as const;
export type LinkRelationKey = (typeof LinkRelation)[keyof typeof LinkRelation];
