/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * @license
 * Copyright 2021 Adobe Inc.
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Inc. and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Inc. and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Inc.
 **************************************************************************/
import { AdobeDCXError } from '@dcx/error';

export const DEFAULT_LOCALSTORAGE_MAX_SIZE = 5 * 1024 * 1024;
export const KEY_FOR_EMPTY_STRING = '---.EMPTY_STRING.---';

export class LocalStorage {
    quota: number;
    private _bytesInUse: number;

    constructor(quota = DEFAULT_LOCALSTORAGE_MAX_SIZE) {
        this.quota = quota;
        this._bytesInUse = 0;
    }

    setItem(key, value?) {
        const oldObj = window.localStorage.getItem(JSON.stringify(key));
        const obj = {
            value,
            timestamp: new Date().getTime(),
        };
        const oldValStrLen = !!oldObj ? JSON.stringify(oldObj).length : 0;
        const valStr = JSON.stringify(obj);
        const valStrLen = valStr.length;
        if (this._bytesInUse - oldValStrLen + valStrLen > this.quota) {
            throw new AdobeDCXError(AdobeDCXError.EXCEEDS_QUOTA, 'EXCEEDS THE QUOTA OF LOCAL STORAGE.');
        }
        window.localStorage.setItem(JSON.stringify(key), valStr);
        this._bytesInUse += valStrLen - oldValStrLen;
    }

    getItem(key, expirationPeriodMS) {
        const val = window.localStorage.getItem(JSON.stringify(key));
        const object = JSON.parse(val || '{}');
        if (typeof object.timestamp !== 'number' || Date.now() - object.timestamp > expirationPeriodMS) {
            return null;
        }
        return object.value;
    }

    removeItem(key) {
        const val = window.localStorage.getItem(JSON.stringify(key));
        const valLen = val == null ? 0 : val.length;
        this._bytesInUse -= valLen;
        window.localStorage.removeItem(JSON.stringify(key));
    }

    clear() {
        window.localStorage.clear();
    }
}
