/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * @license
 * Copyright 2020 Adobe Inc.
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Inc. and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Inc. and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Inc.
 **************************************************************************/

import {
    AdobeDCXError,
    AdobeHTTPService,
    AdobeResponse,
    AdobeResponseType,
    RequestDescriptor,
} from '@dcx/common-types';
import { newDebug } from '@dcx/logger';
import AdobePromise from '@dcx/promise';
import { ServiceConfig, getService } from '../Service';
import { HTTPMethods } from '../enum/http_methods';
import { makeStatusValidator } from './validation';

const dbg = newDebug('dcx:assets:util:http');

export function headHTTPResource(
    svc: AdobeHTTPService | ServiceConfig,
    href: string,
    additionalHeaders?: Record<string, string>,
): AdobePromise<AdobeResponse<'void'>, AdobeDCXError, RequestDescriptor> {
    dbg('headHTTPResource()');
    const service = getService(svc);
    return service.invoke<'void'>(HTTPMethods.HEAD, href, additionalHeaders, undefined, {
        isStatusValid: makeStatusValidator(),
    });
}

export function getHTTPResource<T extends AdobeResponseType = AdobeResponseType>(
    svc: AdobeHTTPService,
    href: string,
    additionalHeaders?: Record<string, string>,
    responseType?: T,
): AdobePromise<AdobeResponse<T>, AdobeDCXError, RequestDescriptor> {
    const service = getService(svc);
    return service.invoke<T>(HTTPMethods.GET, href, additionalHeaders, undefined, {
        isStatusValid: makeStatusValidator(),
        responseType: responseType,
    });
}
