/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * @license
 * Copyright 2021 Adobe Inc.
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Inc. and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Inc. and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Inc.
 **************************************************************************/
import AdobePromise from '@dcx/promise';
import { BlockDownload } from './BlockDownload';
import { BlockUpload } from './BlockUpload';
/**
 * BlockTransferManager manages the queuing ans sequencing of mulitple active BlockUploads/Downloads
 */
export interface BlockTransferManager {
    /**
     * Ordered array of promises for all block uploads
     */
    readonly uploads: BlockUpload[];
    /**
     * Ordered array of promises for all block uploads
     */
    readonly downloads: BlockDownload[];
    /**
     * Block size to use.
     * Defaults to 1024*1024*10 bytes.
     */
    downloadChunkSize: number;
    /**
     * Array of the currently pending block upload HTTP requests
     */
    pendingUploadRequests: AdobePromise[];
    /**
     * Array of currently pending block download HTTP requests
     */
    pendingDownloadRequests: AdobePromise[];
}
/**
 * Private/internal BlockTransferManager API
 */
declare class BlockTransferManagerImpl implements BlockTransferManager {
    private _uploads;
    private _downloads;
    private _pendingUploadRequests;
    private _pendingDownloadRequests;
    private _downloadChunkSize;
    get downloads(): BlockDownload[];
    get uploads(): BlockUpload[];
    set downloadChunkSize(val: number);
    get downloadChunkSize(): number;
    get pendingUploadRequests(): AdobePromise[];
    get pendingDownloadRequests(): AdobePromise[];
    resetUploads(): void;
    /**
     * Add BlockUpload to pending list.
     * If none others are active, start it.
     * If there are queued & running requests, set the state to waiting.
     *
     * @param upload
     */
    addAndStartUpload(upload: BlockUpload): AdobePromise<BlockUpload>;
    /**
     * Add BlockDownload to pending list.
     * If none others are active, start it.
     * If there are queued & running requests, set the state to waiting.
     *
     * @param download
     */
    addAndStartDownload(download: BlockDownload): AdobePromise<BlockDownload>;
    startNextWaiting(type: 'upload' | 'download'): void;
    private _addAndStart;
}
export declare const blockTransferManager: BlockTransferManagerImpl;
export {};
//# sourceMappingURL=BlockTransferManager.d.ts.map