/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * @license
 * Copyright 2020 Adobe Inc.
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Inc. and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Inc. and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Inc.
 **************************************************************************/
/// <reference types="node" />
import { AdobeAsset, AdobeBlockUpload, AdobeDCXComposite, AdobeDCXError, AdobeHTTPService, AdobeRepoUploadResult, AdobeResponse, AdobeResponseType, ComponentResourceDesignator, ComponentUploadInfo, GetSliceCallback, JSONPatchDocument, LinkRelationKey, LinkSet, ManifestData, RepoDownloadStreamableReturn, ResponseTypeMap, SliceableData, UploadProgressCallback, UploadRecipe } from '@dcx/common-types';
import { DCXError } from '@dcx/error';
import AdobePromise from '@dcx/promise';
import { File } from './File';
import { ServiceConfig } from './Service';
import { RepoResponse, RepoResponseResult } from './common';
import { EmbeddedMetadataRepresentation } from './embedded_metadata';
import { AssetType } from './enum/asset_types';
import { PathOrIdAssetDesignator } from './operations';
type AdobeCompositeData = AdobeAsset;
export interface AdobeManifestResult<T> {
    manifestData: T;
    manifestEtag: string;
}
export type ComponentRequestByPath = {
    component_path: string;
    responseType?: AdobeResponseType;
    skipBlockDownload?: boolean;
    subrequestHeaders?: Record<string, string>;
};
type ComponentResponse<C extends ComponentRequestByPath> = C & RepoResponse<{
    data?: C['responseType'] extends AdobeResponseType ? ResponseTypeMap[C['responseType']] : ResponseTypeMap['defaultbuffer'];
    error?: DCXError;
}>;
type UnionToIntersection<U> = (U extends any ? (k: U) => any : never) extends (k: infer I) => any ? I : never;
type ToResponseObject<C> = C extends ComponentRequestByPath ? {
    [P in C['component_path']]: ComponentResponse<C>;
} : never;
export type ManifestAndComponentsByPathResponse<C extends ComponentRequestByPath[]> = {
    manifest: RepoResponse<{
        data?: ManifestData;
        error?: DCXError<unknown>;
    }>;
    components: UnionToIntersection<{
        [I in keyof C]: ToResponseObject<C[I]>;
    }[number]>;
    responses: AdobeResponse[];
};
export interface AdobeComposite extends File {
    headManifest(additionalHeaders?: Record<string, string>): AdobePromise<AdobeResponse<'void'>, AdobeDCXError>;
    getManifest<T = Record<string, unknown>>(version: string, etag: string, additionalHeaders: Record<string, string>): AdobePromise<RepoResponse<AdobeManifestResult<T>, 'json'>, AdobeDCXError>;
    getManifestUrl(versionId?: string): AdobePromise<string, AdobeDCXError>;
    getManifestAndComponentsByPath<C extends ComponentRequestByPath[]>(components: C, version?: string, etag?: string, additionalHeaders?: Record<string, string>): AdobePromise<ManifestAndComponentsByPathResponse<C>, AdobeDCXError>;
    getComponentUrl(componentId: string, version?: string): AdobePromise<string, AdobeDCXError>;
    getComponent<T extends AdobeResponseType = 'defaultbuffer'>(componentId: string, version?: string, responseType?: T, additionalHeaders?: Record<string, string>, componentSize?: number): RepoDownloadStreamableReturn<T>;
    updateManifest<T = string | Record<string, unknown>>(manifest: T, overwrite: boolean, validationLevel?: number, etag?: string, additionalHeaders?: Record<string, string>): AdobePromise<AdobeResponse, AdobeDCXError>;
    putComponent(componentId: string, data: Buffer | ArrayBuffer | Blob | string, contentType: string, maybeIsNew?: boolean, size?: number, md5?: string, progressCb?: UploadProgressCallback, additionalHeaders?: Record<string, string>): AdobePromise<AdobeRepoUploadResult, AdobeDCXError, {
        blockUpload?: AdobeBlockUpload;
    }>;
    putComponent(componentId: string, getSliceCallback: GetSliceCallback, contentType: string, maybeIsNew?: boolean, size?: number, md5?: string, progressCb?: UploadProgressCallback, additionalHeaders?: Record<string, string>): AdobePromise<AdobeRepoUploadResult, AdobeDCXError, {
        blockUpload?: AdobeBlockUpload;
    }>;
    putEmbeddedMetadata<T = Record<string, unknown>>(data: T, etag: string | undefined, format: EmbeddedMetadataRepresentation, additionalHeaders?: Record<string, string>): AdobePromise<AdobeResponse<'void'>>;
    patchEmbeddedMetadata(data: JSONPatchDocument | string, etag?: string, additionalHeaders?: Record<string, string>): AdobePromise<AdobeResponse<'void'>>;
    copy(destAsset: PathOrIdAssetDesignator, createIntermediates: boolean, overwriteExisting: boolean, additionalHeaders?: Record<string, string>, manifestPatch?: JSONPatchDocument): AdobePromise<RepoResponseResult<Composite, 'json'>, AdobeDCXError>;
}
export declare class Composite extends File implements AdobeComposite {
    readonly type: AssetType;
    constructor(data: AdobeCompositeData, svc: AdobeHTTPService | ServiceConfig, links?: LinkSet);
    /**
     * Performs a HEAD operation on the composites manifest
     */
    headManifest(additionalHeaders?: Record<string, string>): AdobePromise<AdobeResponse<'void'>, AdobeDCXError>;
    /**
     * Returns the composites manifest
     * @param {string} version                              The version of the manifest to fetch
     * @param {string} etag                                 ETag of manifest version
     * @param {Object} additionalHeaders                    Additional headers to be applied to RAPI requests
     */
    getManifest<T = Record<string, unknown>>(version?: string, etag?: string, additionalHeaders?: Record<string, string>): AdobePromise<RepoResponse<AdobeManifestResult<T>, 'json'>, AdobeDCXError>;
    /**
     * Returns the URL of the composites manfest
     * @param {string} versionId                            The version of the manifest to return a link for
     */
    getManifestUrl(versionId: string): AdobePromise<string, AdobeDCXError>;
    /**
     * @param components An array of ComponentRequestsByPath. NOTE: Paths are restricted to well-known paths only as determined by specific composite media type.
     * @see {@link https://wiki.corp.adobe.com/display/CA/Proposal%3A+Download+Components+by+DCX+Path Proposal: Download DCX Components by Path}
     * If using components that do not exist on the given well-known paths, please use @see performBulkRequest
     * @example
     *  ```
     *  const components = [
     *    {
     *      component_path: "/model/database.json",
     *      responseType: "json" // default value "defaultbuffer",
     *      skipBlockDownload: true  // To Skip block download in case of large asset and get presigned url instead
     *    }
     *  ]
     *  ```
     * @param version           Version of the composite manifest to fetch (components all come from this version of the manifest)
     * @param etag              Etag to use within the if-match header of the request
     * @param additionalHeaders Additional headers to attach to HTTP requests
     * @example
     * ```
     * {
     *   manifest: {
     *     data?: ManifestData // JSON parsed manifest data
     *     error?: DCXError // present if there was an error fetching the manifest
     *     response: AdobeResponse // response for the manifest sub-request (or secondary follow-up manifest request)
     *   },
     *   components: {
     *     "/model/database.json": { // component paths are the keys
     *       component_path: "/model/database.json",
     *       data?: ResponseTypeMap[ResponseType], // parsed into the requested responseType
     *       error?: DCXError, // present if there was an error fetching the manifest
     *       response: AdobeResponse // response for component sub-request (or follow-up request)
     *     }
     *   },
     *   responses: AdobeResponse[] // array of Bulk request responses (1 response per bulk request issued)
     * }
     * ```
     */
    getManifestAndComponentsByPath<C extends ComponentRequestByPath[]>(components: C, version?: string, etag?: string, additionalHeaders?: Record<string, string>): AdobePromise<ManifestAndComponentsByPathResponse<C>, AdobeDCXError>;
    /**
     * Returns a component from a composite
     * @param componentId       Component ID to fetch
     * @param componentRevision Component revision to fetch
     * @param responseType      Type to tranform response into
     *                              (defaults to Buffer on Node, ArrayBuffer on browser)
     * @param additionalHeaders Additional headers to add to request
     * @param componentSize component size
     */
    getComponent<T extends AdobeResponseType = 'defaultbuffer'>(componentId: string, componentRevision: string, responseType?: T, additionalHeaders?: Record<string, string>, componentSize?: number): RepoDownloadStreamableReturn<T>;
    /**
     * Returns a component from a composite by path
     *
     * @see {@link https://wiki.corp.adobe.com/display/CA/Proposal%3A+Download+Components+by+DCX+Path Proposal: Download DCX Components by Path}
     *
     * @param componentPath     Component path to fetch
     * @param responseType      Type to tranform response into
     *                             (defaults to Buffer on Node, ArrayBuffer on browser)
     * @param additionalHeaders Additional headers to add to request
     *
     * @example
     * ```
     * const component = await composite.getComponentByPath('/model/database.json', 'json');
     * ```
     **/
    getComponentByPath<T extends AdobeResponseType = 'defaultbuffer'>(componentPath: string, responseType?: T, additionalHeaders?: Record<string, string>): RepoDownloadStreamableReturn<T>;
    /**
     * Return the URL of a composite component. The revision is required if the URL will be used for a GET operation.
     * When using the URL to upload a component (PUT), revision is not required.
     * @param componentId       Component ID to return URL for
     * @param componentRevision           The component revision.
     * @param additionalHeaders Additional headers to attach to HTTP requests
     */
    getComponentUrl(componentId: string, componentRevision?: string, additionalHeaders?: Record<string, string>): AdobePromise<string, AdobeDCXError>;
    updateManifest<T = string | Record<string, unknown>>(manifest: T, overwrite: boolean, validationLevel?: number, etag?: string, additionalHeaders?: Record<string, string>): AdobePromise<AdobeResponse, AdobeDCXError>;
    /**
     * Uploads a composite component. If the size of the data is less then repo:maxSingleTransferSize data can be directly uploaded.
     * @param componentId       The componentId of the component to be uploaded, componentId supposes to be an uuid
     * @param data              A buffer containing the data to be uploaded
     * @param contentType       The contentType of the component being uploaded
     * @param maybeIsNew        Do we think this is a new component?
     * @param size              The expected size of this component
     * @param md5               The md5 of the component
     * @param progressCb        A Callback to be invoked with upload progress updates
     * @param additionalHeaders Additional headers to attach to HTTP Requests
     */
    putComponent(componentId: string, data: Buffer | ArrayBuffer | Blob | string, contentType: string, maybeIsNew?: boolean, size?: number, md5?: string, progressCb?: UploadProgressCallback, additionalHeaders?: Record<string, string>): AdobePromise<AdobeRepoUploadResult, AdobeDCXError, {
        blockUpload?: AdobeBlockUpload;
    }>;
    /**
     * Uploads a composite component. If the size of the data is greater then repo:maxSingleTransferSize a GetSliceCallback should be provided instead of the data.
     * @param componentId           The componentId of the component to be uploaded. componentId supposes to be an uuid.
     * @param getSliceCallback      A callback function to return a slice of data to upload
     *                                  The GetSliceCallback function accepts a start byte where the buffer slice should start and an end byte where
     *                                  the buffer slice should end (not inclusive). The callback should return a Promise containing the buffer slice or a buffer
     *                                  of length 0 indicating the end of the buffer.
     * @param contentType           The contentType of the component being uploaded
     * @param maybeIsNew            Do we think this is a new component?
     * @param size                  The expected size of this component
     * @param md5                   The md5 of the component
     * @param progressCb            A Callback to be invoked with upload progress updates
     * @param additionalHeaders     Additional headers to attach to HTTP Requests
     */
    putComponent(componentId: string, getSliceCallback: GetSliceCallback, contentType: string, maybeIsNew?: boolean, size?: number, md5?: string, progressCb?: UploadProgressCallback, additionalHeaders?: Record<string, string>): AdobePromise<AdobeRepoUploadResult, AdobeDCXError, {
        blockUpload?: AdobeBlockUpload;
    }>;
    /**
     * Update entire embedded/XMP metadata resource.
     *
     * @note
     * Replaces existing XMP resource.
     *
     * @note
     * Currently only supported on composites.
     *
     * @note
     * Currently the service requires an etag, but spec states unguarded updates should be possible.
     * The argument `etag` will be updated to optional when the service supports it.
     * See {@link https://jira.corp.adobe.com/browse/SYSE-7940|ticket}
     * and {@link https://jira.corp.adobe.com/browse/SYSE-5943|another ticket}
     *
     * @param {T = Record<string, unknown>} data            New embedded metadata
     * @param {string}                      etag            ETag of metadata resource to update.
     * @param {'json'|'xml'}                [format='json'] Defines the representation of the body, either XML or JSON.
     *                                                      If using XML, clients must pass the data as a string.
     *                                                      If using XML with TypeScript, clients must specify the generic as `string`.
     *                                                      Defaults to json.
     * @param {Record<string, string>}      additionalHeaders     Additional headers to attach to HTTP Requests
     */
    putEmbeddedMetadata<T = Record<string, unknown>>(data: T, etag?: string, format?: EmbeddedMetadataRepresentation, additionalHeaders?: Record<string, string>): AdobePromise<AdobeResponse<'void'>>;
    /**
     * Update embedded/XMP metadata using JSON Patch document.
     *
     * @see
     * https://tools.ietf.org/html/rfc6902#page-6
     *
     * @note
     * Currently the service requires an etag, but spec states unguarded updates should be possible.
     * The argument `etag` will be updated to optional when the service supports it.
     * see: https://jira.corp.adobe.com/browse/SYSE-7940
     * and: https://jira.corp.adobe.com/browse/SYSE-5943
     *
     * @param {JSONPatchDocument | string}      data      Data to use as PATCH body
     * @param {string}                          etag      ETag of the embedded metadata resource to be updated
     * @param {Record<string, string>}          additionalHeaders     Additional headers to attach to HTTP Requests
     */
    patchEmbeddedMetadata(data: JSONPatchDocument | string, etag?: string, additionalHeaders?: Record<string, string>): AdobePromise<AdobeResponse<'void'>>;
    copy(destAsset: PathOrIdAssetDesignator, createIntermediates: boolean, overwriteExisting: boolean, additionalHeaders?: Record<string, string>, manifestPatch?: JSONPatchDocument): AdobePromise<RepoResponseResult<Composite, 'json'>, AdobeDCXError>;
}
export declare function headCompositeManifest(svc: AdobeHTTPService, asset: AdobeAsset, additionalHeaders?: Record<string, string>): AdobePromise<AdobeResponse>;
export declare function getCompositeManifest<T = unknown>(svc: AdobeHTTPService, asset: AdobeAsset, version?: string, etag?: string, additionalHeaders?: Record<string, string>): AdobePromise<RepoResponse<AdobeManifestResult<T>, 'json'>, AdobeDCXError>;
export declare function getCompositeManifestUrl(svc: AdobeHTTPService, asset: AdobeAsset, versionId?: string, additionalHeaders?: Record<string, string>): AdobePromise<string, AdobeDCXError>;
/**
 * Get the component download url by path, which has to be composite version specific.
 *
 * @internal
 *
 * @param svc                   Service or service config
 * @param asset                 Asset with a version
 * @param component_path        Component path
 * @param additionalHeaders     Additional headers to be applied to HTTP requests
 */
export declare function _getComponentPathUrl(svc: AdobeHTTPService, asset: AdobeAsset, component_path: string, additionalHeaders?: Record<string, string>): AdobePromise<string, AdobeDCXError>;
/**
 * Get the resource url based on link relation, which could be version specific or not
 *
 * @internal
 *
 * @param svc                   Service or service config
 * @param asset                 Asset
 * @param relation              Link relation
 * @param versionid             Optional asset version, which is to get version specific url
 * @param additionalHeaders     Additional headers to be applied to HTTP requests
 */
export declare function _getUrl(svc: AdobeHTTPService, asset: AdobeAsset, relation: LinkRelationKey, versionId?: string, additionalHeaders?: Record<string, string>): AdobePromise<string, AdobeDCXError>;
/**
 * @param components An array of ComponentRequestsByPath. NOTE: Paths are restricted to well-known paths only as determined by specific composite media type.
 * @see {@link https://wiki.corp.adobe.com/display/CA/Proposal%3A+Download+Components+by+DCX+Path Proposal: Download DCX Components by Path}
 * If using components that do not exist on the given well-known paths, please use @see  performBulkRequest
 * @example
 *  ```
 *  const components = [
 *    {
 *      component_path: "/model/database.json",
 *      responseType: "json" // Optional, default value "defaultbuffer",
 *      skipBlockDownload: true  // To skip block download of large asset and get presigned url instead
 *    }
 *  ]
 *  ```
 * @param version Version of the composite manifest to fetch (components all come from this version of the manifest)
 * @param etag Etag to use within the if-match header of the request
 * @param additionalHeaders Additional headers to attach to HTTP requests
 * @example
 * ```
 * {
 *   manifest: {
 *     data?: ManifestData // JSON parsed manifest data
 *     error?: DCXError // present if there was an error fetching the manifest
 *     response: AdobeResponse // response for the manifest sub-request (or secondary follow-up manifest request)
 *   },
 *   components: {
 *     "/model/database.json": { // component paths are the keys
 *       component_path: "/model/database.json",
 *       data?: ResponseTypeMap[ResponseType], // parsed into the requested responseType
 *       error?: DCXError, // present if there was an error fetching the manifest
 *       response: AdobeResponse // response for component sub-request (or follow-up request)
 *     }
 *   },
 *   responses: AdobeResponse[] // array of Bulk request responses (1 response per bulk request issued)
 * }
 * ```
 */
export declare function getManifestAndComponentsByPath<C extends ComponentRequestByPath[] = []>(svc: AdobeHTTPService | ServiceConfig, asset: AdobeAsset | AdobeDCXComposite, components: C, version?: string, etag?: string, additionalHeaders?: Record<string, string>): AdobePromise<ManifestAndComponentsByPathResponse<C>, AdobeDCXError>;
export declare function getCompositeComponentUrl(svc: AdobeHTTPService, asset: AdobeAsset, componentId: string, componentRevision?: string): string;
/**
 * Fetch pre-signed URL for a regular file asset
 * @param svc                   Service or service config
 * @param asset                 Asset object that identifies the asset
 * @param componentResource     If provided, generate presignedUrl for this component resource instead of asset primary resource
 * @param additionalHeaders     Additional headers to be applied to HTTP requests
 * @see {@link https://git.corp.adobe.com/pages/caf/api-spec/chapters/advanced/block.html#block-download Block Download Specification}
 */
export declare function getPresignedUrl(svc: AdobeHTTPService | ServiceConfig, asset: AdobeAsset, componentResource?: ComponentResourceDesignator, additionalHeaders?: Record<string, string>): AdobePromise<RepoResponseResult<string, 'json'>, AdobeDCXError>;
/**
 * Fetch pre-signed URL for a composite component
 * @param svc                   Service or service config
 * @param asset                 Asset object that identifies the asset
 * @param componentId           Component id
 * @param componentRevision     Component revision
 * @param additionalHeaders     Additional headers to be applied to HTTP requests
 */
export declare function getCompositeComponentPresignedUrl(svc: AdobeHTTPService | ServiceConfig, asset: AdobeAsset, componentId: string, componentRevision: string, additionalHeaders?: Record<string, string>): AdobePromise<RepoResponseResult<string, 'json'>, AdobeDCXError>;
/**
 * Get a composite component by path. Must be a well-known path for a given composite type.
 *
 * @see {@link https://wiki.corp.adobe.com/display/CA/Proposal%3A+Download+Components+by+DCX+Path Proposal: Download DCX Components by Path}
 *
 * @param svc - AdobeHTTPService instance or ServiceConfig object
 * @param asset - AdobeAsset instance
 * @param componentPath - path to the component
 * @param responseType - response type
 * @param additionalHeaders - additional headers
 * @param skipBlockDownload - to skip block download & get presignedURL instead
 * @returns - AdobePromise<RepoResponseResult<T, AdobeResponseType>, AdobeDCXError>
 *
 * @example
 * ```
 * const response = await getCompositeComponentByPath(
 *   serviceConfig,
 *   asset,
 *   '/path/to/component',
 *   'blob',
 *   { 'x-foo': 'bar' },
 * );
 * ```
 */
export declare function getCompositeComponentByPath<T extends AdobeResponseType = 'defaultbuffer'>(svc: AdobeHTTPService | ServiceConfig, asset: AdobeAsset, componentPath: string, responseType?: T, additionalHeaders?: Record<string, string>, skipBlockDownload?: boolean): RepoDownloadStreamableReturn<T>;
/**
 * Get a composite component by id and revision.
 * @param svc - AdobeHTTPService instance or ServiceConfig object
 * @param asset - AdobeAsset instance
 * @param componentId - component id
 * @param componentRevision - component revision
 * @param responseType - response type
 * @param additionalHeaders - additional headers
 * @param componentSize - component size
 * @returns - AdobePromise<RepoResponseResult<T, AdobeResponseType>, AdobeDCXError>
 */
export declare function getCompositeComponent<T extends AdobeResponseType = 'defaultbuffer'>(svc: AdobeHTTPService, asset: AdobeAsset, componentId: string, componentRevision: string, responseType?: T, additionalHeaders?: Record<string, string>, componentSize?: number): RepoDownloadStreamableReturn<T>;
export declare function updateCompositeManifest<T = string | Record<string, unknown>>(svc: AdobeHTTPService, asset: AdobeAsset, manifest: T, overwrite: boolean, validationLevel?: number, etag?: string, additionalHeaders?: Record<string, string>): AdobePromise<AdobeResponse<'json'>, AdobeDCXError>;
/**
 *
 *
 * Uploads a composite component
 * @remarks Service can override the block size client specified @see {@link https://git.corp.adobe.com/caf/api-spec/blob/gh-pages/schemas/repository/transfer-document.schema.json#L45}
 * @param service                                       An HTTPService instance
 * @param asset                                         The asset associated with the PUT request
 * @param componentId                                   The componentId of the component to be uploaded. ComponentId supposes to be uuid.
 * @param dataOrSliceCallback                           Either the component data or a GetSliceCallback.
 *                                                       If the size of the data is greater then repo:maxSingleTransferSize a GetSliceCallback should be provided instead of the data.
 *                                                       The GetSliceCallback function accepts a start byte where the buffer slice should start and an end byte where
 *                                                       the buffer slice should end (not inclusive). The callback should return a Promise containing the buffer slice or a buffer
 *                                                       of length 0 indicating the end of the buffer.
 * @param contentType                                   The contentType of the component being uploaded
 * @param maybeIsNew                                    Do we think this is a new component?
 * @param size                                          The expected size of this component
 * @param md5                                           The md5 of the component
 * @param progressCb                                    A progress callback that will be invoked with updates to upload progress
 * @param additionalHeaders                             Additional headers to attach to HTTP Requests
 * @param blockSize                                     Desired block size for the upload in bytes
 */
export declare function putCompositeComponent(svc: AdobeHTTPService | ServiceConfig, asset: AdobeAsset, componentId: string, dataOrSliceCallback: SliceableData | GetSliceCallback, contentType: string, maybeIsNew?: boolean, size?: number, md5?: string, progressCb?: UploadProgressCallback, additionalHeaders?: Record<string, string>, blockSize?: number): AdobePromise<AdobeRepoUploadResult, AdobeDCXError, {
    blockUpload?: AdobeBlockUpload;
}>;
/**
 * For returning the information necessary to perform the uploads either direct to ACP or via block upload.
 * @param svc  An HTTPService instance
 * @param asset The asset associated with the PUT request
 * @param uploads An array of ComponentUploadInfo
 * @param additionalHeaders Additional headers to attach to HTTP Requests
 * @returns An array of UploadRecipe
 */
export declare function getCompositeComponentsUrlsForUpload(svc: AdobeHTTPService | ServiceConfig, asset: AdobeAsset, uploads: ComponentUploadInfo[], additionalHeaders?: Record<string, string>): AdobePromise<UploadRecipe[], AdobeDCXError>;
export {};
//# sourceMappingURL=Composite.d.ts.map