/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * @license
 * Copyright 2020 Adobe Inc.
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Inc. and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Inc. and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Inc.
 **************************************************************************/
import { ACPRepoMetadataResource, ACPRepository, AdobeAsset, AdobeAssetEmbedded, AdobeHTTPService, AdobeRepository, EmbeddableResource } from '@dcx/common-types';
import AdobePromise from '@dcx/promise';
import { AdobeGetPageResult, PageOptions } from './Pagination';
import { ServiceConfig } from './Service';
import { RepoResponse } from './common';
/**
 * Returns a paged resource of Discoverable Assets
 *
 * @param svc               The http service
 * @param pageOpts          Paging options
 * @param additionalHeaders Additional headers to attach to HTTP requests
 */
export declare function getDiscoverableAssets<T extends EmbeddableResource = never>(svc: AdobeHTTPService | ServiceConfig, pageOpts?: Omit<PageOptions<T>, 'itemTransformer'>, additionalHeaders?: Record<string, string>): AdobePromise<RepoResponse<AdobeGetPageResult<AdobeAssetEmbedded<T>>>>;
/**
 * Transforms a ACPRepoMetadataResource to an AdobeAsset for use in paging
 *
 * @param {ACPRepoMetadataResource} data    Raw json of an ACPRepoMetadataResource
 *
 * @returns {[string, AdobeAsset]}
 */
export declare function discoverableAssetTransformer(data: ACPRepoMetadataResource): [string, AdobeAsset];
/**
 * Transforms a ACPRepository to an AdobeRepository for use in paging
 *
 * @param {ACPRepository} data              Raw json of an ACPRepository
 *
 * @returns {[string, AdobeRepository]}
 */
export declare function discoverableReposTransformer(data: ACPRepository): [string, AdobeRepository];
/**
 * Returns a paged resource of Discoverable Repos
 *
 * @param svc               The http service
 * @param pageOpts          Paging options
 * @param additionalHeaders Additional headers to apply to HTTP Requests
 */
export declare function getDiscoverableRepos(svc: AdobeHTTPService | ServiceConfig, pageOpts?: Omit<PageOptions<never>, 'itemTransformer' | 'embed'>, additionalHeaders?: Record<string, string>): AdobePromise<RepoResponse<AdobeGetPageResult<AdobeRepository>>>;
//# sourceMappingURL=Discoverable.d.ts.map