/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * @license
 * Copyright 2020 Adobe Inc.
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Inc. and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Inc. and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Inc.
 **************************************************************************/
import { AdobeAsset, AdobeHTTPService } from '@dcx/common-types';
import { Asset } from './Asset';
import { ServiceConfig } from './Service';
/**
 * Create an HLA instance type from AdobeAsset or Asset
 *
 * @param {AdobeAsset | Asset} asset        Asset object
 * @param {AdobeHTTPService} svc            The http service
 *
 * @returns {T}
 */
export declare function hydrateAsset<T extends Asset = Asset>(asset: AdobeAsset | Asset, svc: AdobeHTTPService | ServiceConfig): T;
export declare class AssetFactory {
    private _svc;
    constructor(svc: AdobeHTTPService | ServiceConfig);
    hydrate<T extends Asset>(asset: AdobeAsset): T;
}
//# sourceMappingURL=Factory.d.ts.map