/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * @license
 * Copyright 2020 Adobe Inc.
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Inc. and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Inc. and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Inc.
 **************************************************************************/
import { ACPIndexDocument, AdobeHTTPService, IndexDocument } from '@dcx/common-types';
import AdobePromise from '@dcx/promise';
import { ServiceConfig } from './Service';
import { RepoResponseResult } from './common';
/**
 * Returns the ACP Index document
 *
 * @param svc               The http service
 * @param additionalHeaders Additional headers to attach to HTTP requests
 */
export declare function getIndexDocument(svc: AdobeHTTPService | ServiceConfig, additionalHeaders?: Record<string, string>): AdobePromise<RepoResponseResult<IndexDocument>>;
/**
 * Deserialize an ACPIndexDocument into an IndexDocument
 *
 * @param {ACPIndexDocument} data       JSON representation of an IndexDocument
 *
 * @returns {IndexDocument}
 */
export declare function deserializeIndexDocument(data: ACPIndexDocument): IndexDocument;
//# sourceMappingURL=IndexDocument.d.ts.map