/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * @license
 * Copyright 2021 Adobe Inc.
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Inc. and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Inc. and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Inc.
 **************************************************************************/
import { AdobeBlockDownload, AdobeDCXError, AdobeHTTPService } from '@dcx/common-types';
import AdobePromise from '@dcx/promise';
import { ServiceConfig } from './Service';
/**
 * Optional context.
 */
export type OptionalContext<T> = Partial<T> | undefined | void;
/**
 * Scope for leaf methods calling ops or resolve APIs.
 *
 * Allows bypassing caching while still using
 * common links that can be retained for long times.
 *
 * ie. operations endpoint and resolve API
 */
export interface AdobeOpsContext {
    opsHref?: string | (() => string) | (() => Promise<string>);
    resolveByPathHref?: string | (() => string) | (() => Promise<string>);
    resolveByIdHref?: string | (() => string) | (() => Promise<string>);
}
/**
 * Defines the possible context provided to a leaf function that may use streaming.
 *
 * If in streaming mode (responseType='stream'), and if previous asynchronous methods
 * were called before reaching the leaf method, a stream would have been created synchronously
 * and attached to the AdobePromise source object.
 *
 * If a stream exists in the context, it should be used instead of creating a new stream.
 */
export type AdobeStreamableContext = {
    blockDownload?: AdobeBlockDownload;
};
/**
 * Get ops endpoint URL from context or API.
 *
 * @this {OptionalContext<AdobeOpsContext>}
 * @param svc               The http service
 * @param additionalHeaders Additional headers to attach to HTTP Requests`
 */
export declare function getOpsHref(this: OptionalContext<AdobeOpsContext>, svc: AdobeHTTPService | ServiceConfig, additionalHeaders?: Record<string, string>): AdobePromise<string, AdobeDCXError>;
/**
 * Get resolveByPath URL from context or API.
 *
 * @this {OptionalContext<AdobeOpsContext>}
 * @param {AdobeHTTPService} svc    The http service
 *
 * @returns {AdobePromise<string, AdobeDCXError>}
 */
export declare function getResolveByPathHref(this: OptionalContext<AdobeOpsContext>, svc: AdobeHTTPService | ServiceConfig): AdobePromise<string, AdobeDCXError>;
/**
 * Get resolveById URL from context or API.
 *
 * @this {OptionalContext<AdobeOpsContext>}
 * @param {AdobeHTTPService} svc    The http service
 *
 * @returns {AdobePromise<string, AdobeDCXError>}
 */
export declare function getResolveByIdHref(this: OptionalContext<AdobeOpsContext>, svc: AdobeHTTPService | ServiceConfig): AdobePromise<string, AdobeDCXError>;
//# sourceMappingURL=LeafContext.d.ts.map