/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * @license
 * Copyright 2020 Adobe Inc.
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Inc. and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Inc. and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Inc.
 **************************************************************************/
import { AdobeAsset, AdobeHTTPService, EmbeddableResource, LinkSet } from '@dcx/common-types';
import AdobePromise from '@dcx/promise';
import { RepoResponse } from './common';
export interface PageData {
    orderBy?: string;
    start?: string;
    next?: string;
    property?: string;
    state?: string;
    type?: string;
    count?: number;
}
export interface Page {
    page?: PageData;
    children: AdobeAsset[];
}
export interface AdobeGetPageResult<T> {
    paged: PageResource<T>;
    result: any;
}
export interface PageResource<T> {
    currentPage: PageData | undefined;
    listResource?: string;
    /**
     * Returns true if another page exists
     */
    hasNextPage(): boolean;
    /**
     * Get a page of data based on PageOptions
     * @param opts      The page options of data to load
     */
    getPage<U extends EmbeddableResource = never>(opts: PageOptions<U>): AdobePromise<RepoResponse<AdobeGetPageResult<T>>>;
    /**
     * Get's the next page in a pagedResource
     */
    getNextPage(): AdobePromise<RepoResponse<AdobeGetPageResult<T>>>;
}
export interface PageOptions<T extends EmbeddableResource = never> {
    /**
     * Specifies the beginning of the desired page. This is the value from which the page will start. When not specified, the first page is given.
     * @see [rel/page](https://developers.corp.adobe.com/storage-api/docs/reference/page.md#query-parameters)
     */
    start?: string;
    /**
     * Specifies a positive integer as a hint as to the maximum number of items that should be returned for a given request.
     * The actual response size may be smaller or larger, as constrained by the need to provide reliable operation of the start parameter.
     * @see [rel/page](https://developers.corp.adobe.com/storage-api/docs/reference/page.md#query-parameters)
     */
    limit?: number;
    count?: number;
    /**
     * A comma-separated, ordered list of properties by which the Resource is sorted.
     * The first property is used for primary sorting, the second property to resolve ties in primary sorting, and so on.
     * The name of a property may be prefixed with a + to indicate ascending ordering or a - to indicate
     * descending ordering by that property. If the property name is not prefixed, the result is sorted in ascending order.
     * A Resource can be sorted by the following properties: repo:name, repo:createDate, repo:modifyDate.
     * @see [rel/page](https://developers.corp.adobe.com/storage-api/docs/reference/page.md#query-parameters)
     */
    orderBy?: string;
    next?: string;
    embed?: T[];
    itemTransformer?: (item: any, svc: AdobeHTTPService) => [string, any];
    type?: string;
}
type ListResource = 'api:primary' | 'version-history';
export declare class PageResource<T = AdobeAsset> implements AsyncIterator<AdobeGetPageResult<T>> {
    private _links;
    private _svc;
    private _transformer;
    private _items;
    private _nextPageLink;
    private _data;
    currentPage: PageData | undefined;
    ListResource?: ListResource;
    constructor(_links: LinkSet, _svc: AdobeHTTPService, _transformer: (pre: any, svc: AdobeHTTPService) => [string, T], ListResource?: ListResource);
    get items(): T[];
    get data(): any;
    [Symbol.iterator](): Generator<T, void, unknown>;
    [Symbol.asyncIterator](): AsyncGenerator<any, void, unknown>;
    next(): Promise<IteratorResult<AdobeGetPageResult<T>>>;
    private parseResponse;
}
export {};
//# sourceMappingURL=Pagination.d.ts.map