/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * @license
 * Copyright 2020 Adobe Inc.
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Inc. and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Inc. and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Inc.
 **************************************************************************/
import { ACPAccessControlList, ACPRepository, ACPVersion, AdobeAsset, AdobeDCXError, AdobeHTTPService, AdobeResponse, EffectivePrivileges, LinkMode, LinkRelationKey, LinkSet, Privilege } from '@dcx/common-types';
import AdobePromise from '@dcx/promise';
import { Asset } from './Asset';
import { AdobeFileBase } from './FileBase';
import { RepoResponseResult } from './common';
import { BulkRequestDescriptor } from './util/bulk';
export interface AdobeVersionPatchOperation {
    op: 'add' | 'replace' | 'remove';
    path: string;
    value?: AdobeVersionMilestone;
}
export interface AdobeVersionMilestone {
    label: string;
    description?: string;
}
export interface AdobeVersion extends Partial<Omit<AdobeAsset, 'name' | 'path'>> {
    milestone?: AdobeVersionMilestone;
}
export type VVersion = Partial<Omit<Asset, 'name' | 'path'>> & {
    created_at?: Date;
    updated_at?: Date;
};
export declare class Version extends AdobeFileBase implements AdobeVersion {
    protected _svc: AdobeHTTPService;
    readonly type: "version";
    protected _data: AdobeVersion;
    constructor(data: AdobeVersion & ACPVersion, _svc: AdobeHTTPService, links?: LinkSet);
    get milestone(): AdobeVersionMilestone | undefined;
    /**
     * @hidden
     * Not found on version links
     */
    getRepositoryResource(): AdobePromise<RepoResponseResult<ACPRepository>, AdobeDCXError>;
    /**
     * @hidden
     * Not found on version links
     */
    getEffectivePrivileges(): AdobePromise<RepoResponseResult<EffectivePrivileges>, AdobeDCXError>;
    /**
     * @hidden
     * Not found on version links
     */
    performBulkRequest(requests: BulkRequestDescriptor[], linkMode?: LinkMode): AdobePromise<RepoResponseResult<AdobeResponse[]>, AdobeDCXError>;
    /**
     * @hidden
     * Not found on version links
     */
    checkACLPrivilege(privilege: Omit<Privilege, 'none'>, relation: LinkRelationKey): AdobePromise<RepoResponseResult<boolean>, AdobeDCXError>;
    /**
     * @hidden
     * Not found on version links
     */
    getACLPolicy(): AdobePromise<RepoResponseResult<ACPAccessControlList>, AdobeDCXError>;
}
export declare function adobeVersionTransformer(data: AdobeVersion & ACPVersion): [string, AdobeVersion];
export declare function versionTransformer(data: AdobeVersion & ACPVersion, svc: AdobeHTTPService): [string, Version];
export declare function deserializeVersion(data: AdobeVersion & ACPVersion): AdobeVersion;
//# sourceMappingURL=Version.d.ts.map