/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * @license
 * Copyright 2020 Adobe Inc.
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Inc. and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Inc. and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Inc.
 **************************************************************************/
import { ACPVersions, AdobeHTTPService, LinkSet } from '@dcx/common-types';
import { AdobeVersion, Version } from './Version';
export interface AdobeVersionSet {
    repositoryId: string | undefined;
    assetId: string | undefined;
    versions: AdobeVersion[];
    versionCount: number | undefined;
    links?: LinkSet;
}
export declare class VersionSet implements AdobeVersionSet {
    protected _svc: AdobeHTTPService;
    /**
     * The repository Id of the asset
     */
    repositoryId: string | undefined;
    /**
     * The asset Id of the asset
     */
    assetId: string | undefined;
    /**
     * An array of versions for the asset
     */
    versions: Version[];
    /**
     * A count of versions for the asset
     */
    versionCount: number | undefined;
    /**
     * The assets links
     */
    links?: LinkSet;
    constructor(data: ACPVersions & AdobeVersionSet, _svc: AdobeHTTPService, links?: LinkSet);
    /**
     * Returns a version from the version set by Id
     *
     * @param {string}versionId     The version Id
     *
     * @returns {Version | undefined}
     */
    versionByVersionId(versionId: string): Version | undefined;
    /**
     * Returns all versions containing a label
     *
     * @param {string} label    The label to search for
     *
     * @returns {AdobeVersion[]}
     */
    versionsByLabel(label: string): AdobeVersion[];
}
/**
 * Deserialize a raw version set into an AdobeVersionSet
 *
 * @param {ACPVersions} data  JSON raw version set
 *
 * @returns {AdobeVersionSet}
 */
export declare function deserializeVersionSet(data: ACPVersions): AdobeVersionSet;
//# sourceMappingURL=VersionSet.d.ts.map