/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * @license
 * Copyright 2020 Adobe Inc.
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Inc. and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Inc. and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Inc.
 **************************************************************************/
/**
 * Asset types.
 * @note This does not completely align with the Repository API Specification which defines 3 Asset Classes, "Composite", "File", and "Directory".
 * An `Asset` is the broad term that captures any of these classes.  `Version` is actually a Resource of an `Asset`.
 *
 * @see {@link https://git.corp.adobe.com/pages/caf/api-spec/chapters/assets/assets.html#asset-classes | Asset Classes}
 * @internal
 */
export declare const AssetTypes: {
    readonly Asset: "asset";
    readonly Composite: "composite";
    readonly File: "file";
    readonly Directory: "directory";
    readonly Version: "version";
};
export type AssetType = 'asset' | 'file' | 'directory' | 'composite' | 'version';
//# sourceMappingURL=asset_types.d.ts.map