/**
 * LinkRelation enumeration
 * Defines the possible relation types for HAL links
 */
export declare const LinkRelation: {
    readonly ACCESS_CHECK: "http://ns.adobe.com/adobecloud/rel/ac/check";
    readonly ACL_POLICY: "http://ns.adobe.com/adobecloud/rel/ac/policy";
    readonly ANNOTATIONS: "http://ns.adobe.com/adobecloud/rel/annotations";
    readonly APP_METADATA: "http://ns.adobe.com/adobecloud/rel/metadata/application";
    readonly BASE_DIRECTORY: "http://ns.adobe.com/adobecloud/rel/directory/base";
    readonly BLOCK_DOWNLOAD: "http://ns.adobe.com/adobecloud/rel/download";
    readonly BLOCK_EXTEND: "http://ns.adobe.com/adobecloud/rel/block/extend";
    readonly BLOCK_FINALIZE: "http://ns.adobe.com/adobecloud/rel/block/finalize";
    readonly BLOCK_TRANSFER: "http://ns.adobe.com/adobecloud/rel/block/transfer";
    readonly BLOCK_UPLOAD_INIT: "http://ns.adobe.com/adobecloud/rel/block/init";
    readonly BULK_REQUEST: "http://ns.adobe.com/adobecloud/rel/bulk";
    readonly COMPONENT: "http://ns.adobe.com/adobecloud/rel/component";
    readonly CREATE: "http://ns.adobe.com/adobecloud/rel/create";
    readonly DESCRIBED_BY: "describedBy";
    readonly DIRECTORY: "http://ns.adobe.com/adobecloud/rel/directory";
    readonly DISCARD: "http://ns.adobe.com/adobecloud/rel/discard";
    readonly EFFECTIVE_PRIVILAGES: "http://ns.adobe.com/adobecloud/rel/ac/effective";
    readonly EMBEDDED_METADATA: "http://ns.adobe.com/adobecloud/rel/metadata/embedded";
    readonly ID: "http://ns.adobe.com/adobecloud/rel/id";
    readonly MANIFEST: "http://ns.adobe.com/adobecloud/rel/manifest";
    readonly PAGE: "http://ns.adobe.com/adobecloud/rel/page";
    readonly PATH: "http://ns.adobe.com/adobecloud/rel/path";
    readonly PRIMARY: "http://ns.adobe.com/adobecloud/rel/primary";
    readonly RENDITION: "http://ns.adobe.com/adobecloud/rel/rendition";
    readonly REPO_METADATA: "http://ns.adobe.com/adobecloud/rel/metadata/repository";
    readonly REPO_OPS: "http://ns.adobe.com/adobecloud/rel/ops";
    readonly REPOSITORY: "http://ns.adobe.com/adobecloud/rel/repository";
    readonly RESOLVE_BY_ID: "http://ns.adobe.com/adobecloud/rel/resolve/id";
    readonly RESOLVE_BY_PATH: "http://ns.adobe.com/adobecloud/rel/resolve/path";
    readonly RESTORE: "http://ns.adobe.com/adobecloud/rel/restore";
    readonly VERSION_HISTORY: "version-history";
};
export type LinkRelationKey = (typeof LinkRelation)[keyof typeof LinkRelation];
//# sourceMappingURL=link.d.ts.map