/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * @license
 * Copyright 2020 Adobe Inc.
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Inc. and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Inc. and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Inc.
 **************************************************************************/
/**
 * Properties that might exist on an Asset of varying classes.
 */
export declare enum Properties {
    DC_FORMAT = "dc:format",
    DC_TITLE = "dc:title",
    LINKS = "_links",
    PAGE = "_page",
    CHILDREN = "children",
    EMBEDDED = "_embedded",
    REPO_ASSET_ID = "repo:assetId",
    REPO_REPOSITORY_ID = "repo:repositoryId",
    REPO_REPOSITORY_TYPE = "repo:repositoryType",
    REPO_BASE_ASSET_ID = "repo:baseAssetId",
    REPO_SIZE = "repo:size",
    REPO_NAME = "repo:name",
    REPO_PATH = "repo:path",
    REPO_ASSET_CLASS = "repo:assetClass",
    REPO_CREATE_DATE = "repo:createDate",
    REPO_MODIFY_DATE = "repo:modifyDate",
    REPO_DISCARD_DATE = "repo:discardDate",
    REPO_ETAG = "repo:etag",
    REPO_CREATED_BY = "repo:createdBy",
    REPO_MODIFIED_BY = "repo:modifiedBy",
    REPO_DISCARDED_BY = "repo:discardedBy",
    REPO_DEVICE_CREATE_DATE = "storage:deviceCreateDate",
    REPO_DEVICE_MODIFY_DATE = "storage:deviceModifyDate",
    REPO_DEFAULT_SCHEDULED_DELETION_DURATION = "repo:defaultScheduledDeletionDuration",
    REPO_SCHEDULED_DELETION_DATE = "repo:scheduledDeletionDate",
    REPO_VERSION = "repo:version",
    REPO_STATE = "repo:state",
    REPO_AVAILABLE_REGIONS = "repo:availableRegions",
    REPO_REGIONS = "repo:regions",
    REPO_OWNER = "repo:owner",
    REPO_OWNER_ID = "id",
    REPO_OWNER_TYPE = "type",
    STORAGE_ASSIGNEE = "storage:assignee",
    STORAGE_ASSIGNEE_ID = "id",
    STORAGE_ASSIGNEE_TYPE = "type",
    IMAGE_LENGTH = "tiff:imageLength",
    IMAGE_WIDTH = "tiff:imageWidth",
    NUM_OF_PAGES = "xmpTPg:NPages",
    PAGE_START = "start",
    PAGE_ORDER_BY = "orderBy",
    PAGE_NEXT = "next",
    PAGE_COUNT = "count",
    PAGE_LIMIT = "limit"
}
export declare enum VersionProperties {
    REPO_ID = "repo:id",
    CREATED = "created",
    CREATED_BY = "created_by",
    MILESTONE = "milestone",
    VERSION = "version",
    TOTAL_CHILDREN = "total_children"
}
export declare enum PolicyProperties {
    REPO_ACL = "repo:acl",
    REPO_PRINCIPLE = "repo:principal",
    REPO_MODIFIER = "repo:modifier",
    REPO_PRIVILEGES = "repo:privileges",
    REPO_RELATIONS = "repo:relations",
    REPO_INHERITANCE = "repo:inheritance"
}
export declare enum PolicyPrincipalProperties {
    XDM_PROVIDER = "xdm:provider",
    ID = "@id",
    TYPE = "@type"
}
export declare enum XDMProviderProperties {
    ID = "@id"
}
export declare enum EmbeddedMetadataMediaTypes {
    XML = "application/rdf+xml",
    JSON = "application/ld+json"
}
export declare enum BlockTransferProperties {
    REPO_SIZE = "repo:size",
    REPO_BLOCK_SIZE = "repo:blocksize",
    REPO_REL_TYPE = "repo:reltype",
    COMPONENT_ID = "component_id",
    DC_FORMAT = "dc:format",
    REPO_MD5 = "repo:md5",
    REPO_EXPIRES = "repo:expires",
    REPO_IF_MATCH = "repo:if-match",
    MAX_SINGLE_TRANSFER_SIZE = "repo:maxSingleTransferSize",
    REPO_MIN_BLOCK_TRANSFER_SIZE = "repo:minBlockTransferSize"
}
//# sourceMappingURL=properties.d.ts.map