/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * @license
 * Copyright 2020 Adobe Inc.
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Inc. and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Inc. and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Inc.
 **************************************************************************/
import { AdobeAsset, AdobeDCXError, AdobeHTTPService, AdobeResponse, AdobeResponseType, LinkRelationKey, RepoDownloadStreamableReturn, SliceableData } from '@dcx/common-types';
import AdobePromise from '@dcx/promise';
import { AdobeStreamableContext, OptionalContext } from './LeafContext';
/**
 * A default slice callback used if clients to not provide one and block transfer is required
 * @internal
 * @data    {Buffer | Blob | ArrayBuffer | string}               Bound this scope containing the buffer to be sliced
 */
export declare function getDefaultSliceCallback(data: SliceableData): (start: number, end: number) => Promise<SliceableData>;
/**
 * Fetch a URL that may return a 400 with Response Too Large problem type.
 * If that occurs, get the Location header from the response and fetch that.
 * Redact authorization from that call, as it goes directly to another origin.
 *
 * @this {OptionalContext<AdobeStreamableContext>}
 * @param {AdobeHTTPService} svc
 * @param {string} url
 * @param {AdobeResponseType} [responseType = 'buffer']
 * @param {Record<string, string>} [additionalHeaders = {}]
 * @param {boolean} [skipBlockDownload = false]
 */
export declare function _getUrlFallbackDirect<T extends AdobeResponseType = 'defaultbuffer'>(this: OptionalContext<AdobeStreamableContext>, svc: AdobeHTTPService, asset: AdobeAsset, url: string, resource: LinkRelationKey, responseType?: T, componentId?: string, version?: string, additionalHeaders?: Record<string, string>, skipBlockDownload?: boolean): RepoDownloadStreamableReturn<T>;
/**
 * @internal
 * @private
 */
type _DirectUploadParams = {
    additionalHeaders?: Record<string, string>;
    asset: AdobeAsset;
    contentType?: string;
    data: SliceableData;
    etag?: string;
    headHref: string;
    href: string;
    maybeIsNew?: boolean;
    relation: LinkRelationKey;
    service: AdobeHTTPService;
};
/**
 * Perform a direct upload to RAPI
 * @internal
 * @private
 */
export declare function _directUpload({ additionalHeaders, asset, contentType, data, etag, headHref, href, maybeIsNew, relation, service, }: _DirectUploadParams, isRetry?: boolean): AdobePromise<AdobeResponse, AdobeDCXError>;
export {};
//# sourceMappingURL=private.d.ts.map