/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * @license
 * Copyright 2020 Adobe Inc.
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Inc. and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Inc. and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Inc.
 **************************************************************************/
import { AdobeAsset, AdobeBlockDownload, AdobeBlockUpload, AdobeComponentUploadRecord, AdobeResponse, GetSliceCallback, SliceableData } from '@dcx/common-types';
import { AdobePromise } from '@dcx/promise';
export declare const DEFAULT_BLOCK_UPLOAD_THRESHOLD = 10485760;
export declare const DEFAULT_BLOCK_DOWNLOAD_THRESHOLD = 52428800;
export declare const DEFAULT_MAX_CONCURRENT_REQUESTS = 4;
export declare const DEFAULT_STRING_LENGTH_CHECK: number;
/**
 * @internal
 */
export declare function shouldUseBlockTransferForUpload(asset: AdobeAsset, size: number): boolean;
/**
 * Check whether block download should be used
 *
 * @param {number} size - size of asset in bytes
 * @param {number} [threshold = 52428800] - threshold at which to use block download
 */
export declare const shouldUseBlockTransferForDownload: (size: number, threshold?: number) => boolean;
interface AsyncData<T extends SliceableData = SliceableData> {
    getSlice: GetSliceCallback<T>;
    size: number;
}
type UploadableTypes = SliceableData | AsyncData;
/**
 * Returns the size in bytes of the data param
 * @internal
 * @param data      The data to get the size for
 * @returns         The size of the data
 */
export declare const getDataLength: (data: UploadableTypes) => number;
/**
 * @internal
 * @param data      The data to parse
 * @param size      The size of the data
 * @returns         The parsed data
 */
export declare const _parseUploadableData: (data: SliceableData | GetSliceCallback, size?: number) => UploadableTypes;
/**
 * Returns the current block download threshold
 * @returns the current block download threshold
 */
export declare const getBlockDownloadThreshold: () => number;
/**
 * Sets the current block download threshold
 * @param threshold     The new threshold
 */
export declare const setBlockDownloadThreshold: (threshold: number) => void;
/**
 * Convert a stream to GetSliceCallback. This should be seen as a temporary placeholder until request body streams are available.
 * See (Send ReadableStream in request body) {@link https://developer.mozilla.org/en-US/docs/Web/API/Request#browser_compatibility}
 * See {@link https://web.dev/fetch-upload-streaming/}
 */
export declare function streamToGetSliceCallback(stream: AdobeResponse<'stream'>['response'], resourceSize: number, targetAsset: AdobeAsset, maxOutstandingTransfers?: number): GetSliceCallback;
export declare function deserializeUploadComponentRecord(type: string, id: string, length: number, data: string): AdobeComponentUploadRecord;
export declare function maybeGetBlockTransfer(promise: AdobePromise): Promise<AdobeBlockUpload | AdobeBlockDownload | undefined>;
export declare function pauseBlockTransfer(promise: AdobePromise, stateChangeCb?: (state: any) => void): Promise<AdobeBlockDownload | AdobeBlockUpload | undefined>;
export {};
//# sourceMappingURL=block_transfer.d.ts.map