/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * @license
 * Copyright 2020 Adobe Inc.
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Inc. and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Inc. and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Inc.
 **************************************************************************/
/// <reference types="node" />
import { AdobeAsset, AdobeHTTPService, AdobeResponse, HTTPMethod, LinkMode } from '@dcx/common-types';
import { AdobeDCXError } from '@dcx/error';
import AdobePromise from '@dcx/promise';
import { RepoResponseResult } from '../common';
export interface BulkRequestDescriptor {
    method: HTTPMethod;
    href: string;
    headers?: Record<string, string | number>;
    body?: string | Buffer | ArrayBuffer;
}
/**
 * Constructs a Multipart request body given a list of reuqests
 * @param requests List of requests to put in the bulk request body
 * @param boundary Boundary token
 */
export declare function constructMultipartRequestBody(requests: BulkRequestDescriptor[], boundary: string): Uint8Array;
export declare function bodyToUint8Array(body: string | ArrayBuffer | Buffer): Uint8Array;
/**
 * Parses a multipart response object and returns an array of AdobeResponse objects
 * @param result            The response object
 * @param expectedParts     The number of expected parts
 */
export declare function parseMultipartResponseParts(result: AdobeResponse, expectedParts?: number): AdobeResponse[];
/**
 * Will parse the provided httpContent into an object containing the headers and data (does not parse out data into requested content-type)
 * @param httpContent
 * @param isMultiPartResponsePart
 * @returns
 * @see {@link https://tools.ietf.org/html/rfc7230#section-3 RFC-7230}
 */
export declare function parseHttpResponseContent(httpContent: Uint8Array, isMultiPartResponsePart?: boolean | undefined): AdobeResponse<any>;
export declare function assertValidBulkRequest(requests: BulkRequestDescriptor[]): void;
export declare function performBulkRequest(svc: AdobeHTTPService, asset: AdobeAsset, requests: BulkRequestDescriptor[], linkMode?: LinkMode, additionalHeaders?: Record<string, string>, retrySubrequests?: boolean): AdobePromise<RepoResponseResult<AdobeResponse[]>, AdobeDCXError>;
//# sourceMappingURL=bulk.d.ts.map