/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * @license
 * Copyright 2020 Adobe Inc.
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Inc. and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Inc. and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Inc.
 **************************************************************************/
/// <reference types="node" />
import { AdobeDCXBranch, AdobeDCXComposite, AdobeHTTPService, AdobeMinimalAsset, AdobeResponse, AssetWithRepoAndPathOrId, BlockTransferDocument, ComponentResourceDesignator } from '@dcx/common-types';
import { ServiceConfig } from '../Service';
import { RepoResponse, RepoResponseResult } from '../common';
/**
 * Returns true if the object contains the properties: headers, responseType, xhr, and statusCode
 * @param {unknown} p
 */
export declare function isAdobeResponseLike(p: unknown): p is AdobeResponse;
/**
 * Returns true if object has response property that is AdobeResponseLike
 * @param {unknown} p
 */
export declare function isRepoResponseLike(p: unknown): p is RepoResponse;
/**
 * Returns true if object has component_id property that is ComponentResourceDesignator
 * @param {unknown} p
 */
export declare function isComponentResourceDesignator(p: unknown): p is ComponentResourceDesignator;
/**
 * Returns true if object is RepoResponseLike and contains property `result` of any type.
 * @param {unknown} p
 */
export declare function isRepoResponseResultLike(p: unknown): p is RepoResponseResult;
export declare function isBufferLike(p: unknown): p is Buffer;
export declare function isAdobeDCXCompositeLike(asset: unknown): asset is AdobeDCXComposite;
export declare function isAdobeDCXBranchLike(obj: unknown): obj is AdobeDCXBranch;
/**
 * Returns true if the asset is minimal.
 * Contains either:
 * 1. Links
 * 2. Repository ID + {assetId || path}
 *
 * @param {unknown} asset
 */
export declare function isMinimalAdobeAsset(asset: unknown): asset is AdobeMinimalAsset;
export declare function isBlob(thing: unknown): thing is Blob;
/**
 * Returns true if the asset is resolvable.
 * Contains Repository ID + {assetId || path}
 *
 * @param {unknown} asset
 */
export declare function isResolvableAsset(asset: unknown): asset is AssetWithRepoAndPathOrId;
export declare function isHttpService(o: unknown): o is AdobeHTTPService;
export declare function isServiceConfig(o: unknown): o is ServiceConfig;
export declare function isTransferDocument(transferDoc: unknown): transferDoc is BlockTransferDocument;
//# sourceMappingURL=duck_type.d.ts.map