/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * @license
 * Copyright 2020 Adobe Inc.
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Inc. and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Inc. and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Inc.
 **************************************************************************/
import { AdobeAsset, AdobeHTTPService, AdobeResponse, LinkSet } from '@dcx/common-types';
import AdobePromise from '@dcx/promise';
import { ServiceConfig } from '../Service';
export interface IndexRepository {
    indexLinks: LinkSet;
    repositoryLinks: LinkSet;
    assetLinks: LinkSet;
}
export declare function getIndexLinks(svc: AdobeHTTPService | ServiceConfig, additionalHeaders?: Record<string, string>): AdobePromise<LinkSet>;
export declare function getIndexRepository(svc: AdobeHTTPService | ServiceConfig, additionalHeaders?: Record<string, string>): AdobePromise<IndexRepository>;
export declare function parseLinksFromResponseHeader(response: AdobeResponse): LinkSet;
export declare function parseLinkString(linkString: string): LinkSet;
export declare function getPubsAsset(svc: AdobeHTTPService | ServiceConfig, additionalHeaders?: Record<string, string>): AdobePromise<AdobeAsset>;
//# sourceMappingURL=link.d.ts.map