/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * @license
 * Copyright 2020 Adobe Inc.
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Inc. and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Inc. and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Inc.
 **************************************************************************/
import { AdobeAsset, AdobeAssetWithLinks, AdobeDCXError, AdobeResponse, KeysOfUnion, LinkRelationKey, LinkSet } from '@dcx/common-types';
import { ErrorCodes } from '@dcx/error';
import { ExpectType } from '@dcx/util';
export declare const makeStatusValidator: (validCodes?: number[], statusToErrMsg?: Record<number, string>, statusToErrCode?: Record<number, keyof typeof ErrorCodes>) => (statusCode?: number, response?: AdobeResponse) => AdobeDCXError | boolean;
export declare const assertLinksContain: (links: LinkSet | undefined, requiredLinkTypes?: LinkRelationKey[], errorCode?: string, errorMessage?: string) => void;
export declare const assertLinksContainAny: (links?: LinkSet, anyOneLinkRequiredInPreferredOrder?: LinkRelationKey[]) => LinkRelationKey;
export declare const assertLinkProperty: (links: LinkSet, linkRelation: LinkRelationKey, property: string, value: string) => void;
export declare const doLinksContain: (links: LinkSet | undefined, linksToCheck?: LinkRelationKey[]) => boolean;
export declare const doesAssetContainLinks: (asset: unknown, linksToCheck?: LinkRelationKey[]) => asset is AdobeAssetWithLinks;
export declare const assertPathIsValid: (path: string, isAbsolute?: boolean) => boolean;
export declare function assertAssetHasIdOrPath(asset: AdobeAsset): void;
export declare function assertAssetIsResolvable(asset: AdobeAsset): void;
export declare function assertObjectContains<T = Record<string, unknown>>(o: T, requiredPropKey: KeysOfUnion<T>, requiredPropType?: ExpectType): void;
export declare function assertObjectContainsOneOf<T = Record<string, unknown>>(o: T, someRequiredKeys: KeysOfUnion<T>[], requiredPropType?: ExpectType): void;
export declare function assertEachObjectContainsOneOf<T = Record<string, unknown>[]>(arr: T[], someRequiredKeys: KeysOfUnion<T>[], requiredPropType?: ExpectType): void;
//# sourceMappingURL=validation.d.ts.map