/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * @license
 * Copyright 2021 Adobe Inc.
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Inc. and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Inc. and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Inc.
 **************************************************************************/

import { Duplex, Readable, Writable } from 'stream';
import { AdobeBlockDownload } from './BlockTransfer';
import { AdobeDCXError } from './error';
import { AdobeResponse, AdobeResponseType } from './http';
import { IAdobePromise } from './promise/AdobePromise';

/**
 * Union of platform-specific Readable stream types
 */
export type PlatformReadableStream = ReadableStream<Uint8Array> | Readable;

/**
 * Union of platform-specific Writable stream types
 */
export type PlatformWritableStream = WritableStream | Writable;

/**
 * Union of platform-specific Duplex stream types
 */
export type PlatformDuplexSteam = (ReadableStream<Uint8Array> & WritableStream) | Duplex;

/**
 * Defines the return type for a function that can return a readable stream.
 * If returning a stream, the promise resolves with the stream.
 *
 * When not requesting a stream, the promise may be extended with a blockDownload property, depending on the size of the transfer.
 */
export type RepoDownloadStreamableReturn<T extends AdobeResponseType = AdobeResponseType> = IAdobePromise<
    AdobeResponse<T>,
    AdobeDCXError,
    T extends 'stream' ? { blockDownload: never } : { blockDownload?: AdobeBlockDownload }
>;
