/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * @license
 * Copyright 2020 Adobe Inc.
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Inc. and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Inc. and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Inc.
 **************************************************************************/

import { BasicLink, LinkRelation, LinkRelationKey, LinkSet } from './link';

export interface ACPRepoMetadataResource {
    'repo:repositoryId'?: string;
    'repo:etag'?: string;
    'repo:client-op-id'?: string;
    'repo:id'?: string;
    'repo:size'?: number;
    'repo:version'?: string;
    'repo:baseAssetId'?: string;
    'repo:assetId'?: string;
    'repo:assetClass'?: string;
    'repo:name'?: string;
    'repo:path'?: string;
    'dc:format'?: string;
    'repo:createdBy'?: string; // doesn't exist for users/assets/etc. directories
    'repo:createDate'?: string;
    'repo:modifyDate'?: string;
    'repo:modifiedBy'?: string;
    'repo:createdDate'?: string;
    'repo:lastModifiedDate'?: string;
    'repo:state'?: string;
    'storage:region'?: string;
    md5?: string;

    'repo:discardDate'?: string;
    'repo:discardedBy'?: string;
    'storage:deviceCreateDate'?: string;
    'storage:deviceModifyDate'?: string;
    'repo:defaultScheduledDeletionDuration'?: number;
    'repo:scheduledDeletionDate'?: string;
    'tiff:imageWidth'?: number;
    'tiff:imageLength'?: number;

    _embedded?: any;
    children?: any;
    _page?: any;
    _links?: any;

    // [key: string]: string | number | any;
}

export interface ACPVersions {
    'repo:id'?: string;
    'repo:assetId'?: string;
    'repo:repositoryId'?: string;
    // eslint-disable-next-line camelcase
    total_children?: number;
    children?: any;
    _page?: any;
    _links?: LinkSet;
}

export interface ACPVersion {
    version?: string;
    created?: string;
    // eslint-disable-next-line camelcase
    created_by?: string;
    _links?: LinkSet;
}

export type ACEModifier = 'grant' | 'deny';

export type ACEInheritance = 'self' | 'deep';

export type ACEPrivilege = 'ack' | 'read' | 'write' | 'modify' | 'delete' | 'full';

export interface ACPAccessControlList {
    'repo:acl': ACPAccessControlEntry[];
}

export interface ACPAccessControlEntry {
    'repo:principal': ACPPrincipal;
    'repo:modifier': ACEModifier;
    'repo:privileges': ACEPrivilege[];
    'repo:relations': LinkRelationKey[];
    'repo:inheritance': ACEInheritance;
}

type CaseInsensitive<T extends string> = Uppercase<T> | Lowercase<T> | Capitalize<T> | Uncapitalize<T>;
type ACPPrincipal =
    | CaseInsensitive<'all'>
    | CaseInsensitive<'authenticated'>
    | CaseInsensitive<'unauthenticated'>
    | {
          'xdm:provider': ACPXDMProvider;
          '@id': string;
          '@type': string;
      };

export interface ACPXDMProvider {
    '@id': string;
}

export type RepositoryType = 'storage' | 'index';

export interface ACPRepositoryOwner {
    id: string;
    type: string;
}

export interface ACPRepository {
    'repo:repositoryId': string;
    'repo:repositoryType': RepositoryType;
    'dc:title': any;
    'repo:createDate': string;
    'repo:owner': ACPRepositoryOwner;
    'repo:availableRegions': string[];
    _embedded: any;
}

export type ACPProblemType =
    | 'http://ns.adobe.com/adobecloud/problem/responsetoolarge'
    | 'http://ns.adobe.com/adobecloud/problem/quotaexceeded'
    | 'http://ns.adobe.com/adobecloud/problem/dcxvalidation'
    | 'http://ns.adobe.com/adobecloud/problem/bulkrequestnotattempted';

export interface ACPProblemResponse {
    type: ACPProblemType;
    title: string;
    status: number;
}

export interface ACPResourceDesignator {
    reltype: LinkRelationKey;
    component_id?: string;
    revision?: string;
    etag?: string;
    content_md5?: string;
    content_length?: string;
}

export interface ACPCopyResourceDesignator {
    source: ACPResourceDesignator;
    target: Omit<ACPResourceDesignator, 'revision'> & { revision: string };
}

/**
 * Transfer Documents are used to initialize, process, and complete block uploads.
 */
export interface ACPTransferDocument {
    'repo:size': number;
    'dc:format': string;
    'repo:reltype'?: LinkRelationKey;
    'repo:blocksize'?: number;
    'repo:md5'?: string;
    'repo:if-match'?: string;
    'repo:expires'?: string;
    'repo:resource'?: ACPResourceDesignator;
    component_id?: string;
    links?: {
        [LinkRelation.BLOCK_FINALIZE]: BasicLink;
        [LinkRelation.BLOCK_EXTEND]: BasicLink;
        [LinkRelation.BLOCK_TRANSFER]: BasicLink[];
    };
}

export interface ACPIndexDocument {
    'repo:regions': string[];
    _links?: LinkSet;
    children?: any[];
}
