/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * @license
 * Copyright 2020 Adobe Inc.
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Inc. and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Inc. and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Inc.
 **************************************************************************/

/**
 * Common types
 */

export interface StringLike {
    toString(): string;
}

export type AnyObject = { [s: string]: any };

export type Overwrite<T1, T2> = {
    [P in Exclude<keyof T1, keyof T2>]: T1[P];
} & T2;

export type Optional<T> = T | unknown | undefined | void;

export type EnumMap<C, T> = { [P in keyof C]: T };

// eslint-disable-next-line @typescript-eslint/no-explicit-any
export type PartialRecord<K extends keyof any, T> = {
    [P in K]?: T;
};

export type RequireAtLeastOne<T, Keys extends keyof T = keyof T> = Pick<T, Exclude<keyof T, Keys>> &
    {
        [K in Keys]-?: Required<Pick<T, K>> & Partial<Record<Exclude<Keys, K>, T[K] | undefined>>;
    }[Keys];

export type RequireSome<T, R extends keyof T = keyof T> = Required<Pick<T, R>> & T;

export type KeysOfUnion<T> = T extends any ? keyof T : never;

export type InternalFunction<T extends (...args: any) => any> = (...args: Parameters<T>) => ReturnType<T>;

export type InternalClass<T extends new (...args: any) => any> = new (
    ...args: ConstructorParameters<T>
) => InstanceType<T>;

export type KeysOfType<O, T> = {
    [K in keyof O]: O[K] extends T ? K : never;
}[keyof O];
