/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * @license
 * Copyright 2020 Adobe Inc.
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Inc. and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Inc. and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Inc.
 **************************************************************************/

/**
 * Callback for monitoring progress of the letious transfer functions.
 * @callback ProgressCallback
 *    @param {Integer} bytesCompleted
 *    @param {Integer} totalBytes
 */
export type ProgressCallback = (bytesCompleted: number, totalBytes: number) => void;

export interface XferContext {
    failedComponents;
    aborted: boolean;
    bytesTransfered: number;
    bytesTotal: number;
    onProgress: ProgressCallback;

    abort: (error: Error) => void;
}
