/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * @license
 * Copyright 2020 Adobe Inc.
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Inc. and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Inc. and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Inc.
 **************************************************************************/

import { AdobeResponseType } from '.';
import { AdobeDCXError } from '../error';
import { HTTPMethod, InvokeOptions } from './AdobeHttpService';
import { AdobeResponse } from './AdobeResponse';

/**
 * Callback for monitoring progress of the letious transfer functions.
 * @callback ProgressCallback
 *    @param {Integer} bytesCompleted   - Bytes sent or received so far
 *    @param {Integer} totalBytes       - Total bytes to send or receive
 *    @param {boolean} [indeterminate]  - Specifies that the total bytes could not be determined
 */
export type ProgressCallback = (
    bytesCompleted: number,
    totalBytes: number,
    indeterminate?: boolean | undefined,
) => void;

export type BodyType = ArrayBufferView | ArrayBuffer | Buffer | Uint8Array | Blob | string;

/**
 * Gets return from methods that initiate a network request. With the exception of the `progress`
 * property clients must treat all properties as read-only.
 * @typedef {Object} RequestDescriptor
 *   @property {String}             method      The HTTP method.
 *   @property {String}             href        The href of the request.
 *   @property {Object}             headers     The HTTP request headers.
 *   @property {ProgressCallback}   [progress]  A function that gets called peridically with progress updates.
 */
export interface RequestDescriptor {
    id: string;
    method: HTTPMethod;
    href: string;
    headers: Record<string, string | number>;
    progress?: ProgressCallback;
    noSoonerThen?: number;
    // token?: XferContext;
    autoParseJson?: boolean;
    token?: any;
    queueStartTime?: number;
    startTime?: number;
    options?: InvokeOptions<any>;
    body?: any;
    watch?<T = any>(prop: string, handler: (next?: T, previous?: T) => void): void;
}

export interface AdobeRequest<T extends AdobeResponseType> {
    id: string;
    descriptor: RequestDescriptor;
    getPromise(): Promise<AdobeResponse<T>>;
    cancel: (err?: AdobeDCXError) => void;
}
