/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * @license
 * Copyright 2020 Adobe Inc.
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Inc. and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Inc. and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Inc.
 **************************************************************************/

import type { IncomingMessage } from 'http';
import { RequestDescriptor } from './AdobeRequest';
import { AdobeXhr } from './AdobeXhr';

export interface ResponseTypeMap {
    text: string;
    blob: Blob;
    json: any;
    defaultbuffer: Uint8Array | Buffer | ArrayBuffer;
    buffer: Buffer;
    arraybuffer: ArrayBuffer;
    stream: ReadableStream<Uint8Array> | IncomingMessage;
    any: any;
    void: null;
}

export type AdobeResponseType = keyof ResponseTypeMap;

export interface AdobeResponse<T extends AdobeResponseType = any> {
    statusCode: number;
    headers: Record<string, string>;
    responseType?: T;
    response: ResponseTypeMap[T];
    name?: string;
    message: string;
    code?: string;
    requestDesc?: RequestDescriptor;
    xhr?: AdobeXhr<T>;
}
