/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * @license
 * Copyright 2020 Adobe Inc.
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Inc. and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Inc. and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Inc.
 **************************************************************************/

import { AdobeResponseType, ResponseTypeMap } from '.';
import { HTTPMethod } from './AdobeHttpService';
import { BodyType } from './AdobeRequest';
import { AdobeResponse } from './AdobeResponse';
import { AdditionalNodeOptions, AdobeXhrNode } from './AdobeXhrNode';

export type ProgressListener = (
    sentOrReceivedBytes: number,
    totalBytes: number,
    indeterminateTotalBytes?: boolean | undefined,
) => void;

export type PrePostCallback<T extends AdobeResponseType> = (xhr?: AdobeXhr<T>) => void;

export interface XhrOptions<T extends AdobeResponseType> {
    withCredentials?: boolean;
    /**
     * @internal
     * @private
     */
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    forceXhr?: any;
    fetch?: typeof fetch;
    preCallback?: PrePostCallback<T>;
    postCallback?: PrePostCallback<T>;
    timeout?: number;
    autoParseJson?: boolean;
    additionalNodeOptions?: AdditionalNodeOptions;
    preferFetch?: boolean;
}

export type XhrResponse<T extends AdobeResponseType = AdobeResponseType> = Pick<
    AdobeResponse<T>,
    'statusCode' | 'headers' | 'responseType' | 'response' | 'message' | 'xhr'
> & {
    originalResponseData?: string;
};
export interface AdobeXhr<T extends AdobeResponseType = AdobeResponseType> {
    href: string;
    method: HTTPMethod;
    body?: BodyType;
    headers: Record<string, string | string[]>;
    xhr: XMLHttpRequest | AdobeXhrNode;

    getStatus(): number | undefined;
    isSent(): boolean;
    abort(): void;
    isAborted(): boolean;
    isError(): boolean;
    onProgress(handler: ProgressListener): () => void;
    getResponseData(): ResponseTypeMap[T] | undefined;
    getResponseHeader(header: string): string | undefined;
    getAllResponseHeaders(): Record<string, string | string[]>;
    getResponse(): AdobeResponse<T> | undefined;
    getResponseDataAsJSON(): Promise<any>;
    getErrorCode(): number | string;
    send(
        url: string,
        method: HTTPMethod,
        body?: BodyType,
        headers?: Record<string, string | string[]>,
        responseType?: AdobeResponseType,
        options?: XhrOptions<T>,
    ): Promise<AdobeXhr<T>>;
}
