/* tslint:disable */
/**
 * This file was automatically generated by json-schema-to-typescript.
 * DO NOT MODIFY IT BY HAND. Instead, modify the source JSONSchema file,
 * and run json-schema-to-typescript to regenerate this file.
 */

/**
 * All DCX composite manifests conform to this schema.
 */
export type ManifestData = Element & RootProperties;
export type Element = NodeElementProperties & {
    type: DcxType;
    children?: Children;
    components?: Components;
    [k: string]: unknown;
};
/**
 * Properties that are common to nodes and elements
 */
export type NodeElementProperties = CommonProperties & NodeProperties & MetadataProperties & CustomProperties;
export type Id = string;
/**
 * Name is equivalent to the text(localized) property of the default item in the dc:title array.
 */
export type Name = string;
export type HALResource = Hal;
/**
 * A Link Object stores or represents a link to a resource identified by a URL. Link Objects conform to the HAL Specification for representing links using JSON.
 *
 * This interface was referenced by `undefined`'s JSON-Schema definition
 * via the `patternProperty` "^[a-z]+[a-z0-9\.-]*$".
 */
export type LinkObject = LinkObject1 & LinkObject2;
export type LinkObject1 =
    | ((LinkTemplated | LinkNonTemplated) & LinkCommon)
    | ((LinkTemplated | LinkNonTemplated) & LinkCommon)[];
export type LinkObject2 =
    | (((LinkTemplated | LinkNonTemplated) & LinkCommon) | ((LinkTemplated | LinkNonTemplated) & LinkCommon)[])
    | ((((LinkTemplated | LinkNonTemplated) & LinkCommon) | ((LinkTemplated | LinkNonTemplated) & LinkCommon)[]) &
          unknown[]);
/**
 * This interface was referenced by `undefined`'s JSON-Schema definition
 * via the `patternProperty` "^.*://.*$".
 */
export type LinkObject3 = LinkObject1 & LinkObject2;
export type LinkObject4 = LinkObject1 & LinkObject2;
export type LinkObject5 = LinkObject1 & LinkObject2;
export type Rel = string;
export type TypeVersion = number;
export type Path = string & {
    [k: string]: unknown;
};
/**
 * The date and time the resource was created. For a digital file, this need not match a file-system creation time. For a freshly created resource, it should be close to that time, modulo the time taken to write the file. Later file transfer, copying, and so on, can make the file-system time arbitrarily different.
 */
export type CreateDate = string;
/**
 * The date and time the resource was last modified. NOTE: The value of this property is not necessarily the same as the file’s system modification date because it is typically set before the file is saved.
 */
export type ModifyDate = string;
/**
 * Set of descriptive phrases or keywords that describe the content of the resource.
 */
export type Subject =
    | {
          '@set': string[];
          [k: string]: unknown;
      }
    | string[];
/**
 * Unit used for artboard coordinates (`x`, `y`, `width` and `height`). For example: `inch`, `mm`, `pixel`, `pica`, `point` (default is `pixel`).
 */
export type Unit = string;
export type Width = number;
export type Height = number;
export type PixelsPerMeter = number;
export type DcxType = Format & {
    [k: string]: unknown;
};
/**
 * The file format, physical medium, or dimensions of the resource. Recommended best practice is to use a controlled vocabulary such as the list of Internet Media Types [MIME].
 */
export type Format = string;
export type Node = NodeElementProperties & {
    type?: NonDcxType;
    children?: Children;
    components?: Components;
    [k: string]: unknown;
};
export type NonDcxType = Format & {
    [k: string]: unknown;
};
export type Component = CommonProperties &
    ComponentProperties &
    BindingProperties &
    MetadataProperties &
    CustomProperties;
export type State = 'modified' | 'unmodified' | 'pendingDelete' | 'committedDelete';
export type Length = number;
export type Components = Component[];
export type Children = (Element | Node)[];
export type ManifestFormatVersion = number;

export interface CommonProperties {
    id: Id;
    name?: Name;
    _links?: HALResource;
    [k: string]: unknown;
}
export interface Hal {
    /**
     * It is an object whose property names are link relation types (as defined by [RFC5988](https://tools.ietf.org/html/rfc5988) and values are either a Link Object or an array of Link Objects.  The subject resource of these links is the Resource Object of which the containing `_links` object is a property.
     */
    _links?: Record<string, any>;
    /**
     * It is an object whose property names are link relation types (as defined by [RFC5988](https://tools.ietf.org/html/rfc5988)) and values are either a Resource Object or an array of Resource Objects.\n\nEmbedded Resources MAY be a full, partial, or inconsistent version of the representation served from the target URI.
     */
    _embedded?: Record<string, any>;
    [k: string]: unknown;
}
export interface LinkTemplated {
    /**
     * > If the value is a URI Template then the Link Object MUST have a `templated` attribute whose value is `true`
     */
    href: string;
    /**
     * > Its value is boolean and MUST be true when the Link Object's `href` property is a URI Template.
     */
    templated: true;
    [k: string]: unknown;
}
export interface LinkNonTemplated {
    /**
     * > If the value is a URI Template then the Link Object MAY have a `templated` attribute whose value is `false`
     */
    href: string;
    /**
     * > Its value is boolean and MUST be false when the Link Object's `href` property is a URI Reference.\n\nIts value SHOULD be considered false if it is undefined.
     */
    templated?: false;
    [k: string]: unknown;
}
export interface LinkCommon {
    /**
     * > Its value is boolean and SHOULD be true when the Link Object's `href` property is a URI Template.\n\nIts value SHOULD be considered false if it is undefined or any other value than `true`.
     */
    templated?: boolean;
    /**
     * > If the value is a URI Template then the Link Object SHOULD have a `templated` attribute whose value is `true`
     */
    href?: string;
    /**
     * > Its value is a string used as a hint to indicate the media type expected when dereferencing the target resource.
     */
    type?: string;
    /**
     * > Its presence indicates that the link is to be deprecated (i.e. removed) at a future date.  Its value is a URL that SHOULD provide further information about the deprecation.
     */
    deprecation?: string;
    /**
     * > Its value MAY be used as a secondary key for selecting Link Objects which share the same relation type.
     */
    name?: string;
    /**
     * > Its value is a string which is a URI that hints about the profile (as defined by [I-D.wilde-profile-link](https://tools.ietf.org/html/draft-wilde-profile-link-04) of the target resource.
     */
    profile?: string;
    /**
     * > Its value is a string and is intended for labelling the link with a human-readable identifier (as defined by [RFC5988](https://tools.ietf.org/html/rfc5988))
     */
    title?: string;
    /**
     * > Its value is a string and is intended for indicating the language of the target resource (as defined by [RFC5988](https://tools.ietf.org/html/rfc5988)
     */
    hreflang?: string;
    /**
     * The width of the resource identified by this link.
     */
    width?: number;
    /**
     * The height of the resource identified by this link.
     */
    height?: number;
    /**
     * The size of the resource identified by this link.
     */
    size?: number;
    /**
     * The page of the resource identified by this link.
     */
    page?: number;
    /**
     * The addressing mode of the link.
     */
    mode?: 'id' | 'path';
    [k: string]: unknown;
}
export interface NodeProperties {
    rel?: Rel;
    typeVersion?: TypeVersion;
    path?: Path;
    created?: CreateDate;
    modified?: ModifyDate;
    tags?: Subject;
    units?: Unit;
    [k: string]: unknown;
}
export interface MetadataProperties {
    width?: Width;
    height?: Height;
    pixelsPerMeter?: PixelsPerMeter;
    [k: string]: unknown;
}
export interface CustomProperties {
    /**
     * This interface was referenced by `CustomProperties`'s JSON-Schema definition
     * via the `patternProperty` "^(?=.{3,1024}$)[\x01-\x7F]+#{1}[\x01-\x7F]+$".
     */
    [k: string]:
        | string
        | {
              [k: string]: unknown;
          }
        | unknown[]
        | number
        | boolean
        | null;
}
export interface ComponentProperties {
    type?: NonDcxType;
    path?: Path;
    state?: State;
    length?: Length;
    rel?: Rel;
    [k: string]: unknown;
}
export interface BindingProperties {
    etag?: string;
    version?: string;
    md5?: string;
    [k: string]: unknown;
}
export interface RootProperties {
    created?: CreateDate;
    modified?: ModifyDate;
    typeVersion?: TypeVersion;
    'manifest-format-version': ManifestFormatVersion;
    [k: string]: unknown;
}
