/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * @license
 * Copyright 2021 Adobe Inc.
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Inc. and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Inc. and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Inc.
 **************************************************************************/

import { LinkRelation, LinkRelationKey } from '../link';

/**
 * Resource designator for a component.
 * In some cases revision is required, others optional,
 * those should be validated at runtime.
 */
export interface ComponentResourceDesignator {
    reltype: 'http://ns.adobe.com/adobecloud/rel/component';
    // eslint-disable-next-line camelcase
    component_id: string;
    revision?: string;
}

/**
 * Some resources can be specified using only the link href.
 */
type ResourceDesignatorNonTemplated = 'http://ns.adobe.com/adobecloud/rel/metadata/repository';

/**
 * see {@link | https://git.corp.adobe.com/pages/caf/api-spec/chapters/operations/copying_resources.html#eligible-resources}
 */
type CopyRelTypeForTarget = `${
    | LinkRelation.PRIMARY
    | LinkRelation.ACL_POLICY
    | LinkRelation.COMPONENT
    | LinkRelation.MANIFEST
    | LinkRelation.APP_METADATA
    | LinkRelation.EMBEDDED_METADATA}`;

type CopyRelTypeForSource = `${
    | CopyRelTypeForTarget
    | LinkRelation.EFFECTIVE_PRIVILAGES
    | LinkRelation.REPO_METADATA
    | LinkRelation.RENDITION
    | LinkRelation.VERSION_HISTORY}`;

/**
 * COPY_RESOURCES API Resource Designator
 * See {@link | https://git.corp.adobe.com/pages/caf/api-spec/chapters/operations/copying_resources.html#specifying-resources}
 */
export type CopyResourceDesignator =
    | {
          source: { reltype: CopyRelTypeForSource } | Required<ComponentResourceDesignator>;
          target: { reltype: CopyRelTypeForTarget } | Omit<ComponentResourceDesignator, 'revision'>;
      }
    | ResourceDesignator;

/**
 * Asset Designator
 * See Resource Designator without component link relation
 */
type AssetResourceDesignator = { reltype: Omit<LinkRelationKey, LinkRelation.COMPONENT> };

/**
 * Resource Designator
 * See {@link | https://git.corp.adobe.com/pages/caf/api-spec/chapters/syntax.html#resource-designators}
 */
export type ResourceDesignator =
    | ResourceDesignatorNonTemplated
    | ComponentResourceDesignator
    | AssetResourceDesignator;
