import { HTTPMethod } from './http/AdobeHttpService';
import { BodyType } from './http/AdobeRequest';

/**
 * `UploadRecipe`  includes the parameters required to issue requests to upload a component of a provided size.
 */
export type UploadRecipe = {
    /**
     * The size of the block to use for uploading.
     */
    blockSize: Readonly<number>;
    /**
     * The upload request parameters.
     */
    uploadRequestParameters: ComponentUploadRequestParameters[];
    /**
     * The finalize request parameters.
     */
    finalizeRequestParameters?: FinalizeBlockUploadRequestParameters;
};

/**
 * The parameters for an HTTP request.
 */
type HTTPRequestParameters = {
    /**
     * The URL to request.
     */
    readonly href: string;
    /**
     * The HTTP method to use.
     */
    readonly method: HTTPMethod;
    /**
     * The HTTP headers to use.
     */
    readonly headers?: Record<string, string>;
    /**
     * The HTTP body to use.
     */
    readonly body?: BodyType;
};

/**
 * The parameters for a component upload request.
 * The HTTP request parameters without body
 */
type ComponentUploadRequestParameters = Omit<HTTPRequestParameters, 'body'>;

/**
 * The parameters for a finalize block upload request. body is required.
 */
type FinalizeBlockUploadRequestParameters = HTTPRequestParameters & { readonly body: string };
