/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * @license
 * Copyright 2021 Adobe Inc.
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Inc. and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Inc. and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Inc.
 **************************************************************************/
import { IAdobePromise } from '../promise/AdobePromise';
import { AdobeBlockTransfer } from './BlockTransfer';
/**
 * Response body format from api/:download
 */
export interface BlockDownloadBody {
    /**
     * Presigned URL to download asset.
     * Allows use of Range requests
     */
    href: string;
    /**
     * Total size of the asset, in bytes.
     */
    size: number;
    /**
     * Media type of the asset.
     */
    type: string;
}
export interface AdobeBlockDownload extends AdobeBlockTransfer {
    /**
     * data for the Block download.
     */
    buffer: Uint8Array;
    /**
     * Initialize the BlockUpload.
     * If the total size of the transfer is not known,
     * upload a single block and update sizes.
     *
     * @note
     * This method is called implicitly when calling `start` in a NOT_INITIALIZED state.
     */
    init(url?: string, totalSize?: number): IAdobePromise<AdobeBlockDownload>;
    /**
     * Start the download loop.
     */
    start(): IAdobePromise<AdobeBlockDownload>;
    /**
     * Pause download loop.
     */
    pause(): IAdobePromise<AdobeBlockDownload>;
}
//# sourceMappingURL=BlockDownload.d.ts.map