/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * @license
 * Copyright 2021 Adobe Inc.
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Inc. and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Inc. and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Inc.
 **************************************************************************/
import { UploadProgressCallback } from '../dcx';
import { IAdobePromise } from '../promise/AdobePromise';
export type BlockTransferState = 'NOT_INITIALIZED' | 'INITIALIZING' | 'INITIALIZED' | 'WAITING' | 'STARTED' | 'PAUSING' | 'PAUSED' | 'CANCELED' | 'ERROR' | 'FINALIZING' | 'COMPLETE';
export interface AdobeBlockTransfer {
    /**
     * The current state of the transfer.
     */
    state: BlockTransferState;
    /**
     * If defined, called on each block completion.
     */
    onProgress?: UploadProgressCallback;
    /**
     * Initialize the transfer.
     */
    init(): IAdobePromise<AdobeBlockTransfer>;
    /**
     * Start the transfer loop.
     */
    start(): IAdobePromise<AdobeBlockTransfer>;
    /**
     * Pause the transfer loop.
     */
    pause(): IAdobePromise<AdobeBlockTransfer>;
    /**
     * Resume the transfer loop from a paused state.
     */
    resume(): AdobeBlockTransfer;
    /**
     * Cancel the transfer.
     *
     * @note
     * A canceled transfer cannot be resumed.
     */
    cancel(): void;
}
//# sourceMappingURL=BlockTransfer.d.ts.map