/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * @license
 * Copyright 2020 Adobe Inc.
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Inc. and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Inc. and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Inc.
 **************************************************************************/
/// <reference types="node" />
import { AdobeAsset } from '../AdobeAsset';
import { ACPTransferDocument } from '../acp';
import { AdobeComponentUploadRecord } from '../dcx';
import { AdobeDCXError } from '../error';
import { AdobeResponse } from '../http/AdobeResponse';
import { LinkSet } from '../link';
import { IAdobePromise } from '../promise/AdobePromise';
import { AdobeBlockTransfer } from './BlockTransfer';
export interface AdobeRepoUploadResult {
    /**
     * Whether block upload was used.
     * Defines what the other conditional properties hold.
     */
    isBlockUpload: boolean;
    /**
     * Response from the upload, or the response from the
     * block upload finalize call if block upload was used.
     */
    response: AdobeResponse<'json'>;
    /**
     * The uploaded data asset or component data.
     */
    result: Partial<AdobeComponentUploadRecord>;
    /**
     * The block upload instance, if block upload was used.
     */
    blockUpload?: AdobeBlockUpload;
    /**
     * The asset which was used for the upload.
     * May contain both repositoryId and assetId, OR links, OR all three,
     * depending on the asset used as an argument.
     */
    asset: {
        repositoryId?: string;
        assetId?: string;
        links?: LinkSet;
    };
}
export type BlockTransferDocument = ACPTransferDocument;
/**
 * Data that can be sliced
 */
export type SliceableData = ArrayBuffer | Blob | string | TypedArray;
type TypedArray = Int8Array | Uint8Array | Uint8ClampedArray | Int16Array | Uint16Array | Int32Array | Uint32Array | Float32Array | Float64Array | BigInt64Array | BigUint64Array;
/**
 * Get slice callback type
 * @param startByte         Where the buffer slice should start.
 * @param endByte           Where the buffer slice should end (not inclusive)
 */
export type GetSliceCallback<T extends SliceableData = SliceableData> = (startByte: number, endByte: number) => Promise<T>;
export interface AdobeBlockUpload extends AdobeBlockTransfer {
    createdAsset?: AdobeAsset;
    uploadRecord?: AdobeComponentUploadRecord;
    finalizeResponse?: AdobeResponse;
    init(): IAdobePromise<AdobeBlockUpload, AdobeDCXError>;
    start(): IAdobePromise<AdobeBlockUpload, AdobeDCXError>;
    pause(): IAdobePromise<AdobeBlockUpload, AdobeDCXError>;
    uploadNextBlock(data: Buffer | Blob): IAdobePromise<AdobeResponse, AdobeDCXError>;
}
export {};
//# sourceMappingURL=BlockUpload.d.ts.map