/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * @license
 * Copyright 2020 Adobe Inc.
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Inc. and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Inc. and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Inc.
 **************************************************************************/
import { PartialRecord } from './common';
import { HalLink } from './hal';
import { RenditionType } from './rendition';
export type LinkMode = 'id' | 'path';
export type BasicLink = HalLink & {
    mode?: LinkMode;
};
export type Link = BasicLink | BasicLink[];
export type RenditionLink = BasicLink & {
    type?: RenditionType;
    width?: number;
    height?: number;
};
/**
 * LinkRelation enumeration
 * Defines the possible relation types for HAL links
 */
export declare const enum LinkRelation {
    ACCESS_CHECK = "http://ns.adobe.com/adobecloud/rel/ac/check",
    ACL_POLICY = "http://ns.adobe.com/adobecloud/rel/ac/policy",
    ANNOTATIONS = "http://ns.adobe.com/adobecloud/rel/annotations",
    APP_METADATA = "http://ns.adobe.com/adobecloud/rel/metadata/application",
    BASE_DIRECTORY = "http://ns.adobe.com/adobecloud/rel/directory/base",
    BLOCK_DOWNLOAD = "http://ns.adobe.com/adobecloud/rel/download",
    BLOCK_EXTEND = "http://ns.adobe.com/adobecloud/rel/block/extend",
    BLOCK_FINALIZE = "http://ns.adobe.com/adobecloud/rel/block/finalize",
    BLOCK_TRANSFER = "http://ns.adobe.com/adobecloud/rel/block/transfer",
    BLOCK_UPLOAD_INIT = "http://ns.adobe.com/adobecloud/rel/block/init",
    BULK_REQUEST = "http://ns.adobe.com/adobecloud/rel/bulk",
    COMPONENT = "http://ns.adobe.com/adobecloud/rel/component",
    CREATE = "http://ns.adobe.com/adobecloud/rel/create",
    DESCRIBED_BY = "describedBy",
    DIRECTORY = "http://ns.adobe.com/adobecloud/rel/directory",
    DISCARD = "http://ns.adobe.com/adobecloud/rel/discard",
    EFFECTIVE_PRIVILAGES = "http://ns.adobe.com/adobecloud/rel/ac/effective",
    EMBEDDED_METADATA = "http://ns.adobe.com/adobecloud/rel/metadata/embedded",
    ID = "http://ns.adobe.com/adobecloud/rel/id",
    MANIFEST = "http://ns.adobe.com/adobecloud/rel/manifest",
    PAGE = "http://ns.adobe.com/adobecloud/rel/page",
    PATH = "http://ns.adobe.com/adobecloud/rel/path",
    PRIMARY = "http://ns.adobe.com/adobecloud/rel/primary",
    RENDITION = "http://ns.adobe.com/adobecloud/rel/rendition",
    REPO_METADATA = "http://ns.adobe.com/adobecloud/rel/metadata/repository",
    REPO_OPS = "http://ns.adobe.com/adobecloud/rel/ops",
    REPOSITORY = "http://ns.adobe.com/adobecloud/rel/repository",
    RESOLVE_BY_ID = "http://ns.adobe.com/adobecloud/rel/resolve/id",
    RESOLVE_BY_PATH = "http://ns.adobe.com/adobecloud/rel/resolve/path",
    RESTORE = "http://ns.adobe.com/adobecloud/rel/restore",
    VERSION_HISTORY = "version-history"
}
/**
 * Repository API HalLink keys
 */
export type LinkRelationKey = `${LinkRelation}`;
export type LinkSet = PartialRecord<LinkRelationKey, Link> & {
    [LinkRelation.RENDITION]?: RenditionLink | RenditionLink[];
};
/**
 * The set of links that can be fetched using the resolveBy API.
 * Currently only Repo Metadata is a valid param, but that will change over time.
 */
export type ResolvableResourceRelations = 'http://ns.adobe.com/adobecloud/rel/metadata/repository';
export interface LinkedResource {
    links?: LinkSet;
    /**
     * Sets the assets link
     * @param links   Links to set
     */
    setLinks(links: LinkSet): void;
    /**
     * Returns the link for the provided relationship
     * @param relationship      The link relationship to return the link for
     * @return                  The request link if exists
     */
    getLink(relationship: string): Link | undefined;
    /**
     * Sets the link for a relationship
     * @param relationship      The link relationship to set the link for
     * @param link              The link to set
     */
    setLink(relationship: string, link: Link): void;
    /**
     * Removes a relationship link
     * @param relationship      The link relationship to remove
     */
    removeLink(relationship: string): void;
    /**
     * Returns the href property of a link relationship
     * @param relationship      The relationship key
     * @param linkMode          If the relationship contains an array of links, allows specifying the exact mode to return the property for.
     * @return                  The href if the relationship and href exists on the provided links. Else undefined
     */
    getLinkHref(relationship: string, linkMode?: LinkMode): string | undefined;
    /**
     * Returns a specific property value from a link relationship
     * @param relationship      The relationship key
     * @param property          The property to pull from the relationship
     * @param linkMode          If the relationship contains an array of links, allows specifying the exact mode to return the property for.
     * @return                  The property if the relationship and property exist on the provided links. Else undefined
     */
    getLinkProperty(relationship: string, property: string, linkMode?: LinkMode): string | undefined;
    /**
     * Returns the result href from a templated link with values
     * @param relationship      The relationship key
     * @param values            The key/values to bind to the template
     * @param linkMode          If the relationship contains an array of links, allows specifying the exact mode to return the property for.
     * @return                  The expanded href template if the relationship exists and the link is marked as templated=true. Else undefined
     */
    getLinkHrefTemplated(relationship: string, values: Record<string, (string | number) | (string | number)[] | Record<string, string | number>>, linkMode?: LinkMode): string | undefined;
}
//# sourceMappingURL=link.d.ts.map