/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * @license
 * Copyright 2021 Adobe Inc.
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Inc. and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Inc. and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Inc.
 **************************************************************************/
/**
 * This type should be identical to that defined in AdobePromise.
 *
 * It should only be used as needed by APIs defined in common-types
 * to avoid dependencies on the promise module.
 */
/**
 * Resolved state handler function
 */
type onResolveFn<P = unknown, R = unknown> = (result: P) => R | PromiseLike<R>;
/**
 * Rejected state handler function
 */
type onRejectFn<P = unknown, R = unknown> = (reason: P) => R | PromiseLike<R>;
interface _IAdobePromise<T = any, E = any, X = unknown> {
    canceled: boolean;
    props: X;
    [Symbol.toStringTag]: string;
    /**
     * Get internal promise
     */
    getPromise<T2 = T>(): Promise<T2>;
    /**
     * Register then handler
     * @param onResolve
     * @param onReject
     */
    then<T2 = T, E2 = E, X2 = X>(onResolve: onResolveFn<T, T2> | null | undefined, onReject?: onRejectFn<E2> | null | undefined): IAdobePromise<T2, E2, X & X2>;
    /**
     * Return a new promise chain using global Promise instance.
     * @param onResolve
     * @param onReject
     */
    parallel<T2 = T, E2 = E>(onResolve: onResolveFn<T, T2>, onReject?: onRejectFn<E2, any>): Promise<T2>;
    /**
     * Register error handler
     * @param onReject
     */
    catch<E2 = E, R = void>(onReject: onRejectFn<E2, R>): IAdobePromise<T, E2, X>;
    /**
     * Register handler called after entire promise chain has completed.
     *
     * @note
     * Depends on global Promise's finally() method.
     *
     * @param fn
     */
    finally(fn: () => void): IAdobePromise<T, E, X>;
    /**
     * Call cancel handlers, mark promise as canceled.
     * @param {unknown} reason
     */
    cancel(reason?: unknown): void;
    /**
     * Alias to AdobePromise#cancel
     * @param {unknown} reason
     */
    abort(reason?: unknown): void;
    /**
     * Register a cancel handler
     * @param handler
     */
    onCancel(handler: (reason?: unknown) => void): void;
}
export type IAdobePromise<T = any, E = any, X = unknown> = _IAdobePromise<T, E, X> & X;
export {};
//# sourceMappingURL=AdobePromise.d.ts.map