/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * @license
 * Copyright 2020 Adobe Inc.
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Inc. and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Inc. and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Inc.
 **************************************************************************/
/**
 * Types related to Renditions
 */
export interface RenditionOptions {
    size?: number;
    type?: RenditionType;
    page?: number;
    fragment?: string;
    /**
     * deprecated in v8 - use `resource` instead
     * To be removed in v9
     * @deprecated
     */
    revision?: string;
    /**
     * deprecated in v8 - use `resource` instead
     * To be removed in v9
     * @deprecated
     */
    component_id?: string;
    /**
     * A Stringified resource designator.
     * This format is not compatible with the older top-level `component_id` and `revision` parameters.
     * @see {@link https://wiki.corp.adobe.com/display/CA/Proposal%3A+Add+resource+Parameter+to+api%3Arendition }
     */
    resource?: string;
}
export type RenditionType = 'image/jpeg' | 'image/jpg' | 'image/png' | 'image/gif' | 'application/vnd.adobe.ccv.videometadata';
//# sourceMappingURL=rendition.d.ts.map