import { AdobeDCXLogger } from '@dcx/logger';
import AdobePromise from '@dcx/promise';

declare interface AdobeDCXNamespace {
    modules: Record<string, DCXModule<any>>;
    getModule<T extends DCXModuleName_2 = any>(name: DCXModuleName_2): DCXModule<T>;
    registerModule<T extends DCXModuleName_2 = any>(name: DCXModuleName_2, module: ModuleMap[T]): void;
    logger?: typeof AdobeDCXLogger;
}

declare const dcxjs: AdobeDCXNamespace;
export { dcxjs }
export default dcxjs;

declare interface DCXModule<T extends DCXModuleName_2> {
    module: ModuleMap[T];
}

declare type DCXModuleName = 'AdobeDCXLogger' | 'AdobeDCXPromise';

declare type DCXModuleName_2 = 'AdobeDCXLogger' | 'AdobeDCXPromise';

export declare const getModule: <T extends DCXModuleName = any>(name: DCXModuleName) => ModuleMap[T];

declare interface ModuleMap {
    AdobeDCXLogger: typeof AdobeDCXLogger;
    AdobeDCXPromise: typeof AdobePromise;
}

export { }
