/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * @license
 * Copyright 2020 Adobe Inc.
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Inc. and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Inc. and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Inc.
 **************************************************************************/

import { AdobeDCXLogger } from '@dcx/logger';
import AdobePromise from '@dcx/promise';
import { AdobeDCXNamespace, ModuleMap } from './types/AdobeDCXNamespace';

export type DCXModuleName = 'AdobeDCXLogger' | 'AdobeDCXPromise';

export const DCXNamespaceKey = 'dcxjs';

let initialized = false;

const typedGlobal: typeof globalThis & { [DCXNamespaceKey]?: AdobeDCXNamespace } = globalThis;

export const registerModule = <T extends DCXModuleName = any>(name: DCXModuleName, module: ModuleMap[T]) => {
    const namespace = typedGlobal[DCXNamespaceKey];
    if (!namespace) {
        throw new Error(`[@dcx/core] Namespace not yet initialized.`);
    }
    if (name in namespace.modules) {
        throw new Error(`[@dcx/core] Module ${name} already registered.`);
    }
    namespace.modules[name] = { module };
};

export const getModule = <T extends DCXModuleName = any>(name: DCXModuleName) => {
    const namespace = typedGlobal[DCXNamespaceKey];
    if (!namespace) {
        throw new Error(`[@dcx/core] Namespace not yet initialized.`);
    }
    return namespace.getModule<T>(name)?.module;
};

export const initialize = () => {
    if (initialized) {
        return;
    }

    initialized = true;

    typedGlobal[DCXNamespaceKey] = {
        _modules: {},
    } as any;

    Object.assign(typedGlobal[DCXNamespaceKey]!, {
        getModule: <T extends DCXModuleName = DCXModuleName>(name: DCXModuleName) => {
            return typedGlobal[DCXNamespaceKey]?.modules[name];
        },
        registerModule,
    });

    Object.defineProperty(typedGlobal[DCXNamespaceKey], 'modules', {
        get: () => (typedGlobal[DCXNamespaceKey] as any)._modules,
    });

    typedGlobal[DCXNamespaceKey]?.registerModule('AdobeDCXLogger', AdobeDCXLogger);
    Object.defineProperty(typedGlobal[DCXNamespaceKey], 'logger', {
        get: () => typedGlobal[DCXNamespaceKey]?.getModule('AdobeDCXLogger').module,
        enumerable: true,
    });

    typedGlobal[DCXNamespaceKey]?.registerModule('AdobeDCXPromise', AdobePromise);
    // Object.defineProperty(typedGlobal[DCXNamespaceKey], 'AdobePromise', {
    //     get: () => typedGlobal[DCXNamespaceKey].getModule('AdobeDCXPromise').module,
    //     enumerable: true
    // });
};
