/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * @license
 * Copyright 2020 Adobe Inc.
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Inc. and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Inc. and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Inc.
 **************************************************************************/

import { AdobeDCXLogger } from '@dcx/logger';
import AdobePromise from '@dcx/promise';

export type DCXModuleName = 'AdobeDCXLogger' | 'AdobeDCXPromise';

export interface ModuleMap {
    AdobeDCXLogger: typeof AdobeDCXLogger;
    AdobeDCXPromise: typeof AdobePromise;
}

export interface DCXModule<T extends DCXModuleName> {
    module: ModuleMap[T];
}

export interface AdobeDCXNamespace {
    modules: Record<string, DCXModule<any>>;
    getModule<T extends DCXModuleName = any>(name: DCXModuleName): DCXModule<T>;
    registerModule<T extends DCXModuleName = any>(name: DCXModuleName, module: ModuleMap[T]): void;
    logger?: typeof AdobeDCXLogger;
}
