/// <reference types="node" />

import { AdobeAsset } from '@dcx/common-types';
import { AdobeAsset as AdobeAsset_2 } from '@dcx/assets';
import { AdobeAuthProvider } from '@dcx/common-types';
import { AdobeDCXBranch as AdobeDCXBranch_2 } from '@dcx/common-types';
import { AdobeDCXComponent as AdobeDCXComponent_2 } from '@dcx/common-types';
import { AdobeDCXComponentData } from '@dcx/common-types';
import { AdobeDCXComposite as AdobeDCXComposite_2 } from '@dcx/common-types';
import { AdobeDCXElement as AdobeDCXElement_2 } from '@dcx/common-types';
import { AdobeDCXError } from '@dcx/error';
import { AdobeDCXError as AdobeDCXError_2 } from '@dcx/common-types';
import { AdobeDCXLogger } from '@dcx/logger';
import { AdobeDCXNode as AdobeDCXNode_2 } from '@dcx/common-types';
import { AdobeDCXNodeData } from '@dcx/common-types';
import { AdobeDCXRootNodeData } from '@dcx/common-types';
import { AdobeDCXState } from '@dcx/common-types';
import * as _AdobeDCXUtil from '@dcx/util';
import { AdobeHTTPService } from '@dcx/http';
import { AdobeHTTPService as AdobeHTTPService_2 } from '@dcx/common-types';
import { AdobeHTTPServiceOptions } from '@dcx/common-types';
import AdobePromise from '@dcx/promise';
import { AdobeRepoAPISession } from '@dcx/repo-api-session';
import { AdobeResponse } from '@dcx/common-types';
import { AdobeResponseType } from '@dcx/http';
import { AdobeResponseType as AdobeResponseType_2 } from '@dcx/common-types';
import { AdobeSessionBase } from '@dcx/common-types';
import { AdobeUploadRecord } from '@dcx/common-types';
import { AdobeUploadResults } from '@dcx/common-types';
import { AuthenticationCallback } from '@dcx/common-types';
import { BranchCallback } from '@dcx/common-types';
import { ComponentCallback } from '@dcx/common-types';
import { ComponentRequestByPath } from '@dcx/assets';
import { Composite } from '@dcx/assets';
import { CompositeArchivalState } from '@dcx/common-types';
import { CompositeState } from '@dcx/common-types';
import { CopyResourceDesignator } from '@dcx/common-types';
import { CopyResourcesOperationResult } from '@dcx/assets';
import { createHTTPService } from '@dcx/http';
import { DCXError } from '@dcx/error';
import { FailedComponent } from '@dcx/common-types';
import { getGlobalLogger } from '@dcx/logger';
import { GetSliceCallback } from '@dcx/common-types';
import { HalLink } from '@dcx/common-types';
import { IAdobePromise } from '@dcx/common-types';
import { isAdobeDCXError } from '@dcx/error';
import { JSONPatchDocument } from '@dcx/common-types';
import { Link } from '@dcx/common-types';
import { LinkRelationKey } from '@dcx/common-types';
import { LinkSet } from '@dcx/common-types';
import { ManifestAndComponentsByPathResponse } from '@dcx/assets';
import { NodeCallback } from '@dcx/common-types';
import { PathOrIdAssetDesignator } from '@dcx/assets';
import { ProgressCallback } from '@dcx/common-types';
import { RepoResponseResult } from '@dcx/assets';
import { RequestDescriptor } from '@dcx/http';
import { RequestDescriptor as RequestDescriptor_2 } from '@dcx/common-types';
import { ResourceDesignator } from '@dcx/common-types';
import { ResponseCallback } from '@dcx/http';
import { SliceableData } from '@dcx/common-types';

declare type AbortHandler = (reason?: string | Error) => void;

declare class AdobeCommunityPlatform {
    private static pubsAsset;
    /**
     * @private
     */
    private constructor();
    /**
     Create composite at pubs location.
     @param session      The repo session to use
     @param relPath      Path at which new composite will be created in the cloud, relative to /pubs
     @param contentType  Content type of composite
     */
    static createCompositeAtPubs(session: AdobeRepoAPISession, relPath: string, contentType: string): Promise<RepoResponseResult<AdobeAsset>>;
    /**
     Publish composite to Community Platform.
     @param composite Composite to be published
     @param compositeHref Path of the composite directory in ccStorage
     @param pubRecord
     @param [remixData]
     @param [creatorTool]
     @param callback signature: callback(error, pubRecord)
     */
    static publishCompositeAlreadyPushedToPubs(composite: AdobeDCXComposite_2, pubRecord: AdobeCommunityPublicationRecord, remixData: AdobeRemixData | undefined, creatorTool: string | undefined, communitySession: AdobeCommunitySession, callback: any): XferContext;
    static getCpMetadata(communitySession: AdobeCommunitySession, pubRecord: AdobeCommunityPublicationRecord, callback: any): void;
}
export { AdobeCommunityPlatform }
export { AdobeCommunityPlatform as communityPlatform }

/**
 * @class
 * @classdesc AdobeCommunityPublicationRecord represents publishing data for the Community Platform.
 * <p>The constructor for AdobeCommunityPublicationRecord is private. Refer to {@link AdobeDCX} to learn how
 * to create instances of AdobeCommunityPublicationRecord.
 * @hideconstructor
 */
export declare class AdobeCommunityPublicationRecord {
    private _communityId;
    private _artworkComponentId;
    private _assetId;
    private _resourcePath;
    private _mainResource;
    private _mainResourceVersion;
    private _artworkResource;
    private _artworkResourceVersion;
    private _title;
    private _alias;
    private _tags;
    private _description;
    private _categoryId;
    private _subCategoryIds;
    private _creatorIds;
    private _undiscoverable;
    private _isPrivate;
    private _custom;
    get communityId(): string | null;
    set communityId(communityId: string | null);
    get artworkComponentId(): string | null;
    set artworkComponentId(artworkComponentId: string | null);
    get assetId(): string | null;
    set assetId(assetId: string | null);
    get resourcePath(): string | null;
    set resourcePath(resourcePath: string | null);
    get mainResource(): any;
    set mainResource(mainResource: any);
    get mainResourceVersion(): string | null;
    set mainResourceVersion(mainResourceVersion: string | null);
    get artworkResource(): string | null;
    set artworkResource(artworkResource: string | null);
    get artworkResourceVersion(): string | null;
    set artworkResourceVersion(artworkResourceVersion: string | null);
    get title(): string | null;
    set title(title: string | null);
    get alias(): string | null;
    set alias(alias: string | null);
    get tags(): string[];
    set tags(tags: string[]);
    get description(): string | null;
    set description(description: string | null);
    get categoryId(): string | null;
    set categoryId(categoryId: string | null);
    get subCategoryIds(): string[];
    set subCategoryIds(subCategoryIds: string[]);
    get creatorIds(): string[];
    set creatorIds(creatorIds: string[]);
    get undiscoverable(): boolean;
    set undiscoverable(undiscoverable: boolean);
    get isPrivate(): boolean;
    set isPrivate(isPrivate: boolean);
    get custom(): unknown;
    set custom(custom: unknown);
}

/**
 * @class
 * @classdesc  Session interface for the CP service.
 * <p>The constructor for AdobeCommunitySession is private. See {@link AdobeDCX}
 * to learn how to create an AdobeCommunitySession and what to use it for.</p>
 * @augments AdobeSessionBase
 * @hideconstructor
 * @param httpService the HTTP service
 * @param server      the url for the storage server
 */
declare class AdobeCommunitySession extends SessionBase {
    readonly name = "AdobeCommunitySession";
    constructor(httpService: AdobeHTTPService_2, server: string);
    /** @private */
    publishCompositeAtResource(type: string, pubRecord: AdobeCommunityPublicationRecord, callback: any): IAdobePromise<AdobeResponse<"text">, AdobeDCXError_2<unknown>, RequestDescriptor_2>;
    /** @internal */
    updateCpMetadataAtResource(type: string, pubRecord: AdobeCommunityPublicationRecord, callback: (error?: AdobeDCXError, result?: any) => void): IAdobePromise<AdobeResponse<"text">, AdobeDCXError_2<unknown>, RequestDescriptor_2>;
    /** @internal */
    getCpMetadata(pubRecord: AdobeCommunityPublicationRecord, callback: any): void;
    /** @private */
    updatePublicationRecordData(pubRecord: AdobeCommunityPublicationRecord, pushedBranch: AdobeDCXBranch_2): void;
    /**
     * Gets the href for the manifest of the given composite.
     * @private
     * @param composite the composite.
     */
    getCompositeManifestHref(composite: AdobeDCXComposite_2, versionId: string, getHrefCallback: any): string;
    /**
     * Gets a component from the server.
     * NOTE that this does not specify an If-Match header. We want to get the component
     * whether the etags match or not, for instance when we don't have the local file present.
     * @private
     * @param   {AdobeDCXComponent} component    The component to download.
     * @param   {String}            responseType The expected data type of the response.
     * @param   {Function}          callback     Callback
     * @returns {Object}            the requestDescriptor for the request.
     */
    getComponent(component: AdobeDCXComponent_2, responseType: AdobeResponseType_2, callback: any): RequestDescriptor_2;
    /**
     * Gets a rendition of a component from the server.
     * NOTE that this does not specify an If-Match header. We want to get the component
     * whether the etags match or not, for instance when we don't have the local file present.
     * @private
     * @param   {AdobeDCXComponent} component    The component to download.
     * @param   {String}            type         The media type of the rendition 'image/jpeg' or 'image/png'.
     * @param   {String}            dimension    'width' or 'height'
     * @param   {Integer}           size         The requested number of pixels in the dimension.
     * @param   {String}            responseType The expected data type of the response.
     * @param   {Function}          callback     Callback
     * @returns {Object}            the requestDescriptor for the request.
     */
    getRenditionOfComponent(component: AdobeDCXComponent_2, type: string, dimension: string, size: number, responseType: AdobeResponseType_2, callback: any): RequestDescriptor_2;
    /** @private */
    getCompositeManifest(composite: AdobeDCXComposite_2, versionId: string, etag: string, callback: any): any;
    /**
     * Issue a simple HEAD request.
     * @private
     * @return         the requestDesc
     * @param href     the URL
     * @param callback signature: callback(error, response)
     */
    headRequest(href: string, callback: (err: Error, response?: AdobeResponse) => void): RequestDescriptor_2;
    /** @internal */
    getComponentHref(component: AdobeDCXComponent_2, version: string, getHrefCallback: (err?: AdobeDCXError, href?: string) => void | RequestDescriptor_2): void;
    /** @internal */
    getComponentRenditionHref(component: AdobeDCXComponent_2, version: string, type: string, dimension: string, size: number, getHrefCallback: (err?: AdobeDCXError, href?: string) => void): void;
    /**
     * Checks string prefix to see if it conforms to a proper asset id (href) for the CCStorage service
     * @private
     * @param   {String} assetId The asset id in question
     * @returns {Boolean}
     */
    private isProperAssetId;
    /** @private */
    private _constructComponentHref;
    /** @private */
    private _constructComponentRenditionHref;
    /** @private */
    private _hrefUsesContentApis;
    /** @private */
    private assetIdFromSSResourceHref;
    /** @private */
    private metadataFromPubRecord;
}
export { AdobeCommunitySession }
export { AdobeCommunitySession as CommunitySession }

/**
 * @class
 * @classdesc A branch of a composite represents a specific version of the composite.
 * The main branch is the `current` branch, which also allows editing a composite.
 * Other branches are usually read-only and only available when running under Node.js.
 * These branches are `base`, `pushed` and `pulled`.
 *
 * The constructor for `AdobeDCXBranch` is private. Branch instances are getting
 * instantiated on an as needed-basis and can be accessed via an instance of
 * {@link AdobeDCXComposite}.</p>
 * @hideconstructor
 * @param {Object}  [data]      private
 * @param {Boolean} [readOnly]  private
 * @param {String} [assetId]  private
 */
export declare class AdobeDCXBranch implements AdobeDCXBranch_2 {
    originalManifestFormatVersion: number;
    compositeHref: string;
    /** @internal */
    _core: AdobeDCXBranchCore;
    /** @internal */
    _data: AdobeDCXRootNodeData & AdobeDCXLocalNodeData;
    /** @internal */
    protected _pendingElements: AdobeDCXElement[];
    /** @internal */
    _versionId?: string;
    /** @internal */
    _derivationType: DerivationType;
    /** @internal */
    _derivationDatetime?: string;
    constructor(data?: AdobeDCXRootNodeData, readOnly?: boolean, assetId?: string, repoId?: string);
    get data(): AdobeDCXRootNodeData;
    set data(data: AdobeDCXRootNodeData);
    /**
     * The id of the composite. Must be a unique among the nodes of the composite.
     *
     * <p>While not strictly read-only most clients do not ever have to modify this property.</p>
     * @memberof AdobeDCXBranch#
     * @type {String}
     */
    get compositeId(): string;
    set compositeId(id: string);
    /**
     * An AdobeDCXNode object that represents the root of the underlying manifest.
     * @type {AdobeDCXNode}
     * @memberof AdobeDCXBranch#
     * @readonly
     */
    get rootNode(): AdobeDCXNode;
    set rootNode(node: AdobeDCXNode);
    /**
     * The name of the composite.
     * @memberof AdobeDCXBranch#
     * @type {String}
     */
    get name(): string | undefined;
    set name(name: string | undefined);
    /**
     * The type of the composite.
     * @memberof AdobeDCXBranch#
     * @type {String}
     */
    get type(): string;
    set type(type: string);
    /**
     * The asset id of the composite that can be used to pull and push the composite.
     * <strong>Do not modify this for a bound composite.</strong>
     * @memberof AdobeDCXBranch#
     * @type {String}
     */
    get compositeAssetId(): string | undefined;
    set compositeAssetId(assetId: string | undefined);
    /**
     * The repository id of the composite that can be used to pull and push the composite.
     * <strong>Do not modify this for a bound composite.</strong>
     * @memberof AdobeDCXBranch#
     * @type {String}
     */
    get compositeRepositoryId(): string | undefined;
    set compositeRepositoryId(repoId: string | undefined);
    /**
     * The links of the composite.
     * @memberof AdobeDCXBranch#
     * @type {LinkSet}
     */
    get compositeLinks(): LinkSet | undefined;
    set compositeLinks(links: LinkSet | undefined);
    /**
     * @internal
     * Check if the branch is bound with a repositoryId.
     * If so, treat the composite as intended for R-API (no pendingArchive/pendingDelete states).
     */
    get _isRepoComposite(): boolean;
    /**
     * @private
     * @memberof AdobeDCXBranch#
     * @type {String}
     */
    get _collaborationType(): string | undefined;
    set _collaborationType(value: string | undefined);
    /**
     * Allow clients to set an arbitrary string containing local data to store on the branch. This is private because you
     * should always go through the DCXComposite API.
     * @private
     * @memberof AdobeDCXBranch#
     * @type {String}
     */
    get _clientDataString(): string | undefined;
    set _clientDataString(value: string | undefined);
    /**
     * The etag of the manifest of the composite.
     * @memberof AdobeDCXBranch#
     * @type {String}
     * @readonly
     */
    get manifestEtag(): string | undefined;
    set manifestEtag(etag: string | undefined);
    /**
     * The editing state of the composite. Can be <em>'unmodified'</em>, <em>'modified'</em>,
     * <em>'pendingDelete'</em> or <em>'committedDelete'</em>.
     * @memberof AdobeDCXBranch#
     * @type {String}
     */
    get compositeState(): CompositeState;
    set compositeState(state: CompositeState);
    /**
     * The archival state of the composite. Can be <em>'active'</em> (default), <em>'pending'</em>,
     * or <em>'archived'</em>.
     * @memberof AdobeDCXBranch#
     * @type {String}
     */
    get compositeArchivalState(): CompositeArchivalState;
    set compositeArchivalState(state: CompositeArchivalState);
    /**
     * Whether the composite is bound to a composite on a server. If <em>false</em> for newly
     * created empty composites that have never been pulled from or pushed to the server.
     * @memberof AdobeDCXBranch#
     * @readonly
     * @type {Boolean}
     */
    get isBound(): boolean;
    set isBound(_: boolean);
    /**
     * The version identifier of the banch.
     * Only valid if the branch has been pulled or pushed, undefined otherwise.
     *
     * @memberof AdobeDCXBranch#
     * @readonly
     * @type {String}
     */
    get versionId(): string | undefined;
    set versionId(versionId: string | undefined);
    /**
     * @private
     * @memberof AdobeDCXBranch#
     * @type {Boolean}
     */
    get _isDirty(): boolean;
    set _isDirty(value: boolean);
    /**
     * Whether the composite has has been modified in memory and needs to be committed to local
     * storage.
     * @memberof AdobeDCXBranch#
     * @readonly
     * @type {Boolean}
     */
    get isDirty(): boolean;
    set isDirty(value: boolean);
    /**
     * @memberof AdobeDCXBranch#
     * @internal
     */
    get localData(): string;
    set localData(_: string);
    /**
     * @memberof AdobeDCXBranch#
     * @internal
     */
    get remoteData(): string;
    set remoteData(_: string);
    /**
     * Lists any elements (type AdobeDCXElement) that have been created and have not yet
     * been used to update the corresponding child node or been abandoned.
     * @memberof AdobeDCXBranch#
     * @readonly
     * @type {Array}
     */
    get pendingElements(): AdobeDCXElement_2[];
    set pendingElements(_: AdobeDCXElement_2[]);
    /**
     * @memberof AdobeDCXBranch#
     * @private
     */
    get changeCount(): number;
    set changeCount(value: number);
    /**
     * @memberof AdobeDCXBranch#
     * @private
     */
    get readOnly(): boolean;
    set readOnly(value: boolean);
    /**
     * @internal
     */
    static _newBranchAsCopyOfCore(coreToCopy: AdobeDCXBranchCore): AdobeDCXBranch;
    /**
     * Restores the branch from its stringified representation (manifest). Throws if data is invalid.
     * @internal
     * @param   {String} data The stringified representation.
     * @returns {AdobeDCXBranch}.
     */
    parse(data: string): AdobeDCXBranch;
    /**
     * Returns the element with the given id or undefined if not found.
     * Throws if the node in question is not a valid element).
     * Notice that the branch keeps track of pending element objects. You must either call
     * updateElement or abandonElement when you are done with it so that the branch can update
     * its data and perform any necessary clean up tasks.
     * @param   {String } id The id of the child node to look up.
     * @returns {AdobeDCXElement}
     */
    getElementWithId(id: string): AdobeDCXElement_2 | undefined;
    /**
     * Returns the element with the given absolute path or undefined if not found.
     * Throws if the node in question is not a valid element).
     * Notice that the branch keeps track of pending element objects. You must either call
     * updateElement or abandonElement when you are done with it so that the branch can update
     * its data and perform any necessary clean up tasks.
     * @memberof AdobeDCXBranch#
     * @param   {String} path The absolute path.
     * @returns {AdobeDCXElement}
     */
    getElementWithAbsolutePath(path: string): AdobeDCXElement_2 | undefined;
    /**
     * Creates a new element node and inserts it into the children list of the given parent node or of the
     * root if no parent node is given.
     * Returns the new element.
     * Throws if the path is invalid.
     * Notice that the branch keeps track of pending element objects. You must either call
     * updateElement or abandonElement when you are done with it so that the branch can update
     * its data and perform any necessary clean up tasks.
     * @param   {String}                name            - The name of the new element.
     * @param   {String}                type            - The type of the new element.
     * @param   {String}                path            - The path of the new element.
     * @param   {String}                [nodeId]        - The id of the new child. If undefined the new child node will
     *                                                    get a random id.
     * @param   {Integer}               [index]         - If given and less than or equal to the current number of
     *                                                    children than the node gets inserted at the given index.
     *                                                    Otherwise it gets added to the end.
     * @param   {@link AdobeDCXNode}    [parentNode]    - The parent node to add the node to. Default parent is the
         *                                                    root node.
         * @returns {AdobeDCXElement}
         */
     addElement(name: string, type: string, path: string, nodeId?: string, index?: number, parentNode?: AdobeDCXNode_2): AdobeDCXElement_2;
     /**
      * Updates the data of the existing element in the branch.
      * Notice that the element object will no longer be tracked by the branch after updateElement
      * has been called. You will have to request the element again using getElementWithId or
      * getElementWithAbsolutePath if you want to keep working with it.
      * Throws if the element doesn't exist or if the update results in duplicate paths/ids.
      *
      * @param {AdobeDCXElement} element The modified element.
      * @returns {AdobeDCXNode} The updated node in the branch.
      */
     updateElement(element: AdobeDCXElement_2): AdobeDCXNode_2;
     /**
      * Cleans up an element that was previously created and has not been used to update the corresponding
      * node in the branch. Throws if the branch doesn't recognize the element (e.g. calling abandonElement
      * twice or after already having called updateElement).
      *
      * @param {AdobeDCXElement} element The element that is no longer needed.
      */
     abandonElement(element: AdobeDCXElement_2): void;
     /**
      * Returns the node with the given id or undefined if not found.
      * @param   {String } id The id of the child node to look up.
      * @returns {AdobeDCXNode}
      */
     getChildWithId(id: string): AdobeDCXNode_2 | undefined;
     /**
      * Returns the node with the given absolute path or undefined if not found.
      * @param   {String} path The absolute path.
      * @returns {AdobeDCXNode}
      */
     getChildWithAbsolutePath(path: string): AdobeDCXNode_2 | undefined;
     /**
      * Generates and returns an array of the child nodes of the given parent node.
      * @example
      * var rootNodes = branch.getChildrenOf(branch.rootNode);
      * @param   {AdobeDCXNode} parentNode The parent node to return the children for.
      * @returns {Array}
      */
     getChildrenOf(parentNode?: AdobeDCXNode_2): AdobeDCXNode_2[];
     /**
      * Creates a new node and inserts it into the children list of the given parent node or of the
      * root if no parent node is given.
      * Returns the new child node.
      * @param   {String}  [name]       The name of the new child. If undefined the child will not
      *                                 have a name.
      * @param   {String}  [nodeId]     The id of the new child. If undefined the new child node will
      *                                 get a random id.
      * @param   {Integer} [index]      If given and less than or equal to the current number of
      *                                 children than the node gets inserted at the given index.
      *                                 Otherwise it gets added to the end.
      * @param   {String}  [parentNode] The parent node to add the node to. Default parent is the
      *                                 root node.
      * @returns {AdobeDCXNode}
      */
     addChild(name?: string, nodeId?: string, index?: number, parentNode?: AdobeDCXNode_2): AdobeDCXNode_2;
     /**
      * Removes and returns the given child node from the branch.
      * @param   {AdobeDCXNode} node The child node to remove.
      * @returns {AdobeDCXNode}
      */
     removeChild(node: AdobeDCXNode_2): AdobeDCXNode_2;
     /**
      * Moves the existing child from its current parent/index to the given parent/index.
      * @param   {AdobeDCXNode} node         The child node to move
      * @param   {Integer}      [index]      If given and less than or equal to the current number of
      *                                      children than the node gets inserted at the given index.
      *                                      Otherwise it gets added to the end.
      * @param   {AdobeDCXNode} [parentNode] The parent node to move the node to. Default parent is
      *                                      the root.
      * @returns {AdobeDCXNode}
      */
     moveChild(node: AdobeDCXNode_2, index?: number | null, parentNode?: AdobeDCXNode_2 | null): AdobeDCXNode_2;
     /**
      * Copies the given child node as a new node into this branch. The node can be from the same or
      * from a different composite.
      *
      * <p>This function will try reuse the ids of any children and components of the copied node,
      * in order to minimize the amount of data that will later have to be uploaded, however, clients
      * must not rely on these ids being preserved in the copied objects.</p>
      *
      * <p>Fails if a node with the same id or same absolute path already exists.</p>
      *
      * <p>Notice: This method does not work without local storage (e.g. browser environment) if
      * used to copy between two composites stored at different endpoints.</p>
      *
      * @param   {AdobeDCXNode} node         The child node to copy. If it is the root node then
      *                                      newPath must be provided.
      * @param   {AdobeDCXNode} [parentNode] The parent node to copy the child node to. If undefined
      *                                      then the new child node will be added to the root of the
      *                                      branch.
      * @param   {Integer}      [index]      If provided and less than or equal to the current number of
      *                                      children of the parentNode (or root) the child node gets
      *                                      inserted at the given index. Otherwise it gets added to
      *                                      the end.
      * @param   {String}       [newPath]    <p>If provided, the copy of the child node will be assigned
      *                                      this a its path property and it will also receive a new
      *                                      random id (unless one is provided with the newId param).
      *                                      If left undefined then the copy of the node will keep
      *                                      the path of the original. In either case the function will
      *                                      fail if the resulting absolute path of the child or any
      *                                      of its children/components conflicts with an already
      *                                      existing absolute path.</p>
      *                                      <p>You must provide a newPath if you are copying the root
      *                                      node of a branch or element.</p>
      * @param   {String}       [newId]      If provided, the copy of the child node will be assigned
      *                                      this a its id. If left undefined (and the newPath param
      *                                      is also undefined) then the copy will retain the id of
      *                                      the original. In either case the function will
      *                                      fail if the resulting id of the child or any
      *                                      of its children/components conflicts with an already
      *                                      existing id.
      * @param   {NodeCallback} [callback]   Optional when not copying between different composites or
      *                                      when not using local storage.
      *                                      Gets called when the copy is done or has failed.
      * @returns {AdobeDCXNode}              Only returns the created child node if no callback is
      *                                      given.
      */
     copyChild(node: AdobeDCXNode_2, parentNode?: AdobeDCXNode_2, index?: number, newPath?: string, newId?: string, callback?: undefined): AdobeDCXNode_2;
     copyChild(node: AdobeDCXNode_2, parentNode: AdobeDCXNode_2 | undefined, index: number | undefined, newPath: string | undefined, newId: string | undefined, callback: NodeCallback): void;
     /**
      * <p>Replaces the child node in this branch with a copy of the given node or branch with the same
      * id (or, if provided, with the given id). Fails if the child node does not exist in this branch.</p>
      *
      * <p>This function will try reuse the ids of any children and components of the copied node,
      * in order to minimize the amount of data that will later have to be uploaded, however, clients
      * must not rely on these ids being preserved in the copied objects.</p>
      *
      * <p>Notice: This method does not work without local storage (e.g. browser environment) if
      * used to copy between two different composites.</p>
      *
      * @param   {AdobeDCXNode} node       The child node to update from.
      * @param   {String}       [newPath]  If provided the copy of the component will be assigned
      *                                    this a its path property. Otherwise it will retain its original path.
      * @param   {String}       [newId]    If provided the copy of the child node will be assigned
      *                                    this as its id. Otherwise it will retain its original id.
      * @param   {NodeCallback} [callback] Optional when not copying between different composites or
      *                                    when not using local storage.
      *                                    Gets called when the copy is done or has failed.
      * @returns {AdobeDCXNode}            Only returns the created child node if no callback is
      *                                    given.
      */
     replaceChild(node: AdobeDCXNode_2, newPath?: string, newId?: string): AdobeDCXNode_2;
     replaceChild(node: AdobeDCXNode_2, newPath: string | undefined, newId: string | undefined, callback: NodeCallback): void;
     /**
      * Returns an array of all components in the branch.
      * @returns {Array}.
      */
     allComponents(): AdobeDCXComponent_2[];
     /**
      * Returns the component with the given id or undefined if not found.
      * @param   {String} id The id of the component to look up.
      * @returns {AdobeDCXComponent}
      */
     getComponentWithId(id: string): AdobeDCXComponent_2 | undefined;
     /**
      * Returns the component with the given absolute path or undefined if not found.
      * @param   {String} path The absolute path of the desired component.
      * @returns {AdobeDCXComponent}
      */
     getComponentWithAbsolutePath(path: string): AdobeDCXComponent_2 | undefined;
     /**
      * Returns an array containing the components of the given node.
      * @param   {AdobeDCXNode} parentNode The node whose components to return.
      * @returns {Array}
      */
     getComponentsOf(parentNode?: AdobeDCXNode_2): AdobeDCXComponent_2[];
     /**
      * Given an INCOMPLETE_COMPOSITE DCXError, this will attempt to return the invalid components so they can be removed or updated
      * @param error An IMCOMPLETE_COMPOSITE error
      * @returns Array of components from this branch that are declared missing in the INCOMPLETE_COMPOSITE error report
      */
     getMissingComponentsFromError(error: AdobeDCXError_2): AdobeDCXComponent_2[];
     /**
      * <p>Creates and adds a component to the given parent node or to the root if no parent node is
      * given.</p>
      *
      * @param   {String}            name          The name of the new component.
      * @param   {String}            relationship  The relationship of the new component.
      * @param   {String}            path          The path of the new component. Must satisfy uniquenes
      *                                            rules for components.
      * @param   {AdobeDCXNode}      [parentNode]  The node to add the node to. Defaults to the root.
      * @param   {Object}            uploadResults The upload results object returned by a previous call
      *                                            to AdobeDCXCompositeXfer.uploadAssetForNewComponent().
      * @returns {AdobeDCXComponent}               The new component.
      */
     addComponentWithUploadResults(name: string, relationship: string, path: string, parentNode: AdobeDCXNode_2 | undefined, uploadResults: AdobeUploadResults): AdobeDCXComponent;
     /**
      * <p>Creates and adds a component to the given parent node or to the root if no parent node is
      * given.</p>
      *
      * @param componentDescriptor The serialized component descriptor to use.
      * @param name          The name of the new component.
      * @param path          The path of the new component. Must satisfy uniquenes rules for components.
      * @param relationship  The relationship of the new component.
      * @param parentNode  The node to add the node to. Defaults to the root.
      * @returns {AdobeDCXComponent}               The new component.
      */
     addComponentWithComponentDescriptor(componentDescriptor: string, name: string, path: string, relationship?: LinkRelationKey, parentNode?: AdobeDCXNode_2): AdobeDCXComponent;
     /**
      * <strong>XHR-only</strong>
      *
      * <p>Updates the component record with the results of a recent upload of said component.</p>
      *
      * @param   {AdobeDCXComponent} component     The component.
      * @param   {Object}            uploadResults The upload results object returned by a previous
      *                                            call to AdobeDCXCompositeXfer.uploadAssetForComponent().
      * @returns {AdobeDCXComponent} The updated component.
      */
     updateComponentWithUploadResults(component: AdobeDCXComponent_2, uploadResults: AdobeUploadResults): AdobeDCXComponent;
     /**
      * Removes the component from the branch.
      * @param   {AdobeDCXComponent} component The component to remove.
      * @returns {AdobeDCXComponent} The removed component.
      */
     removeComponent(component: AdobeDCXComponent_2): AdobeDCXComponent_2;
     /**
      * Moves the component to the given node or the root if node is undefined
      * @param   {AdobeDCXComponent} component    The component to move.
      * @param   {AdobeDCXNode}      [parentNode] The node to move the component to.
      * @returns {AdobeDCXComponent} The moved component.
      */
     moveComponent(component: AdobeDCXComponent_2, parentNode?: AdobeDCXNode_2): AdobeDCXComponent_2;
     /**
      * Copies the given component and adds it as a new component to this branch. Fails if the
      * component already exists.
      *
      * <p>Notice: This method does not work without local storage (browser environment) if
      * used to copy between two composites with different endpoints.</p>
      *
      * @param   {AdobeDCXComponent} component    The component to copy.
      * @param   {AdobeDCXNode}      [parentNode] The node to copy the component to. If none is
      *                                           provided then the component will be added to the
      *                                           root.
      * @param   {String}            [newPath]    If provided the copy of the component will be
      *                                           assigned this a its path property and it will also
      *                                           get assigned a random new id if none is provided via
      *                                           the <em>newId</em> param.
      * @param   {String}            [newId]      If provided the copy of the component will be assigned
      *                                           this a its id. If left undefined (and if newPath is
      *                                           undefined as well) then the copy of the component
      *                                           will retain the id of the original.
      *                                           This is useful when merging conflicting changes since
      *                                           it preserves the identity of components and avoids
      *                                           unnecessary network traffic.
      * @param   {ComponentCallback} [callback]   Optional when not copying between different
      *                                           composites or when copying without local storage.
      *                                           Gets called when the copy is done or has failed.
      * @returns {AdobeDCXComponent}              Only returns the new component when called without
      *                                           a callback.
      */
     copyComponent(component: AdobeDCXComponent_2, parentNode?: AdobeDCXNode_2, newPath?: string, newId?: string): AdobeDCXComponent_2;
     copyComponent(component: AdobeDCXComponent_2, parentNode: AdobeDCXNode_2 | undefined, newPath: string | undefined, newId: string | undefined, callback: ComponentCallback): void;
     /**
      * Replaces the matching component (same id) in this branch with a copy of the given component.
      * Fails if the component can't be found.
      *
      * <p>Notice: This method does not work without local storage (browser environment) if
      * used to copy between two different composites.</p>
      *
      * @param   {AdobeDCXComponent} component  The component to copy.
      * @param   {String}            [newPath]  If provided the copy of the component will be
      *                                         assigned this a its path property and it will also
      *                                         get assigned a new id if none is provided via the
      *                                         newId param.
      * @param   {String}            [newId]    If provided the copy of the component will be
      *                                         assigned this a its id property.
      * @param   {ComponentCallback} [callback] Optional when not copying between different
      *                                         composites. Gets called when the copy is done or has
      *                                         failed.
      * @returns {AdobeDCXComponent}            Only returns the new component when called without
      *                                         a callback.
      */
     replaceComponent(component: AdobeDCXComponent_2, newPath?: string, newId?: string): AdobeDCXComponent_2;
     replaceComponent(component: AdobeDCXComponent_2, newPath: string | undefined, newId: string | undefined, callback: ComponentCallback): void;
     /**
      * Creates and returns a read-write deep copy of the branch. The copy uses the same
      * local storage as the original. Use this to create a mutable copy of an otherwise
      * read-only branch like e.g. pulled.
      * @internal
      * @returns {AdobeDCXBranch}
      */
     copy(): AdobeDCXBranch;
     /**
      * Only checks that the type is object.
      * Should NOT be used for verifying contents of the object, unless modified.
      *
      * @param o
      */
     private _isNodeLike;
     /**
      * @private
      * @param {Object} node The node
      */
     private _createElement;
     /**
      * @private
      * @param {Object} element The element
      */
     private _deleteElement;
     /**
      * Returns an error if the passed in data is not a valid manifest. Returns null if everything is OK.
      * @private
      * @param   {Object} data The value object to verify.
      * @returns {Error}
      */
     private _verify;
     /**
      * Verifies and sets the new data and creates the caches. Throws if invalid data.
      * @private
      * @param   {Object}         data Data
      * @param {Boolean} readOnly Whether the branch is read-only.
      * @param {String}  assetId.
      * @returns {AdobeDCXBranch} The branch.
      */
     private _setData;
     /**
      * Resets the binding and (optionally) the identity of the branch
      * @private
      * @param {Boolean} retainId
      */
     private _reset;
     /**
      * Resets the binding of the branch while retaining its id.
      * @internal
      */
     _resetBinding(componentCallback?: (resetComponent: AdobeDCXComponentData) => void): void;
     /**
      * Resets the binding and ids of the branch.
      * @internal
      */
     _resetIdentity(componentCallback?: (resetComponent: AdobeDCXComponentData) => void): void;
     /** @internal */
     _local(): {
         version?: number | undefined;
         change?: number | undefined;
         collaborationType?: string | undefined;
         clientDataString?: string | undefined;
         archivalState?: "pending" | "archived" | undefined;
         manifestEtag?: string | undefined;
     };
     /**
      * Sets the dirty flag and (optionally) the compositeState
      * @internal
      * @param {Boolean} preserveCompositeState
      */
     _setDirty(preserveCompositeState?: boolean): void;
     /**
      * Updates the path of a node. Caller must dirty the branch.
      * @internal
      * @param {Object} node
      * @param {String} newPath
      */
     _setPathOfNode(node: AdobeDCXNode_2, newPath?: string): void;
     /**
      * Verifies the integrity of the in-memory structures of the branch. Looks for incorrect caches/lookup tables, incorrect
      * object references and cycles/duplicate objects. Also, optionally, verifies that all asset files exist locally.
      * @internal
      * @param   {Boolean}  shouldBeComplete Whether to check for the existence of all component assets. @Warning: This check is using synchronous file system calls.
      * @param   {Function} logger           Optional. A function that gets called for every error found. Signature: function (string)
      * @param   {Object}   fs               Optional. The file system object to use in the shouldBeComplete check
      * @returns {Array}    Array of errors or null if everything is OK.
      */
     _verifyIntegrity(shouldBeComplete?: boolean, logger?: any, fs?: any): AdobeDCXError_2<unknown>[] | null;
    }

    /**
     * @class
     * @hideconstructor
     * Internal helper class. Implements the core functionality shared by both AdobeDCXBranch and AdobeDCXElement.
     * @constructor
     * @private
     * @param {Object}  [data]     private
     * @param {Object}  [owner]    The branch or the element.
     * @param {Boolean} [readOnly] private
     */
    declare class AdobeDCXBranchCore {
        /** @internal */
        _owner: AdobeDCXBranch | AdobeDCXElement;
        private _allNodes;
        private _allComponents;
        private _absolutePaths;
        /** @internal */
        _readOnly: boolean;
        /** @internal */
        _data: AdobeDCXNodeData & AdobeDCXLocalNodeData;
        /** @internal */
        _isDirty: boolean;
        /** @internal */
        _compositeAssetId?: string;
        /** @internal */
        _compositeRepositoryId?: string;
        /** @internal */
        _compositeLinks?: LinkSet;
        /**
         * @internal
         * Dictionary of componentId to component/asset info.
         * Set during copy.
         */
        _sourceAssetInfoLookup: Record<string, SourceAssetInfoEntry>;
        /**
         * @internal
         * Source composite info.
         * Set during copy.
         */
        _sourceCompositeInfo: {
            links: LinkSet;
            assetId: string;
            repositoryId: string;
        } | undefined;
        constructor(data: AdobeDCXNodeData | AdobeDCXRootNodeData, owner: AdobeDCXBranch_2 | AdobeDCXElement_2, readOnly?: boolean);
        /**
         * @internal
         */
        get allNodes(): Record<string, AdobeDCXNode>;
        /**
         * An AdobeDCXNode object that represents the root node of the branch or element.
         * @type {AdobeDCXNode}
         * @internal
         * @readonly
         */
        get rootNode(): AdobeDCXNode;
        set rootNode(_: AdobeDCXNode);
        /**
         * Whether the branch or element has has been modified in memory.
         * @internal
         * @readonly
         * @type {Boolean}
         */
        get isDirty(): boolean;
        set isDirty(_: boolean);
        /**
         * @internal
         */
        get changeCount(): number;
        set changeCount(_: number);
        /**
         * Returns the node with the given id or undefined if not found.
         * @param   {String } id The id of the child node to look up.
         * @returns {AdobeDCXNode}
         */
        getChildWithId(id: string): AdobeDCXNode | undefined;
        /**
         * Returns the node with the given absolute path or undefined if not found.
         * @param   {String} path The absolute path.
         * @returns {AdobeDCXNode}
         */
        getChildWithAbsolutePath(path: string): AdobeDCXNode | undefined;
        /**
         * Generates and returns an array of the child nodes of the given parent node.
         * @example
         * var rootNodes = branch.getChildrenOf(branch.rootNode);
         * @param   {AdobeDCXNode} parentNode The parent node to return the children for.
         * @returns {Array}
         */
        getChildrenOf(pParentNode?: AdobeDCXNode_2): AdobeDCXNode_2[];
        /**
         * Creates a new node and inserts it into the children list of the given parent node or of the
         * root if no parent node is given.
         * Returns the new child node.
         * @param   {String}  [name]       The name of the new child. If undefined the child will not
         *                                 have a name.
         * @param   {String}  [nodeId]     The id of the new child. If undefined the new child node will
         *                                 get a random id.
         * @param   {Integer} [index]      If given and less than or equal to the current number of
         *                                 children than the node gets inserted at the given index.
         *                                 Otherwise it gets added to the end.
         * @param   {String}  [parentNode] The parent node to add the node to. Default parent is the
         *                                 root node.
         * @returns {AdobeDCXNode}
         */
        addChild(name?: string, nodeId?: string, index?: number, parentNode?: AdobeDCXNode_2): AdobeDCXNode;
        /**
         * Removes and returns the given child node from the branch.
         * @param   {AdobeDCXNode} node The child node to remove.
         * @returns {AdobeDCXNode}
         */
        removeChild(pNode: AdobeDCXNode_2): AdobeDCXNode;
        /**
         * Moves the existing child from its current parent/index to the given parent/index.
         * @param   {AdobeDCXNode} node         The child node to move
         * @param   {Integer}      index        If given and less than or equal to the current number of
         *                                      children than the node gets inserted at the given index.
         *                                      Otherwise it gets added to the end.
         * @param   {AdobeDCXNode} [parentNode] The parent node to move the node to. Default parent is
         *                                      the root.
         * @returns {AdobeDCXNode}
         */
        moveChild(pNode: AdobeDCXNode_2, index?: number | null, pParentNode?: AdobeDCXNode_2 | null): AdobeDCXNode_2;
        /**
         * Copies the given child node as a new node into this branch. The node can be from the same or
         * from a different composite.
         *
         * <p>This function will try reuse the ids of any children and components of the copied node,
         * in order to minimize the amount of data that will later have to be uploaded, however, clients
         * must not rely on these ids being preserved in the copied objects.</p>
         *
         * <p>Fails if a node with the same id or same absolute path already exists.</p>
         *
         * <p>Notice: This method does not work without local storage (e.g. browser environment) if
         * used to copy between two composites stored at different endpoints.</p>
         ** @param   {AdobeDCXNode} node         The child node to copy. If it is the root node then
         *                                      newPath must be provided.
         * @param   {AdobeDCXNode} [parentNode] The parent node to copy the child node to. If undefined
         *                                      then the new child node will be added to the root of the
         *                                      branch.
         * @param   {Integer}      [index]      If provided and less than or equal to the current number of
         *                                      children of the parentNode (or root) the child node gets
         *                                      inserted at the given index. Otherwise it gets added to
         *                                      the end.
         * @param   {String}       [newPath]    <p>If provided, the copy of the child node will be assigned
         *                                      this a its path property and it will also receive a new
         *                                      random id (unless one is provided with the newId param).
         *                                      If left undefined then the copy of the node will keep
         *                                      the path of the original. In either case the function will
         *                                      fail if the resulting absolute path of the child or any
         *                                      of its children/components conflicts with an already
         *                                      existing absolute path.</p>
         *                                      <p>You must provide a newPath if you are copying the root
         *                                      node of a branch or element.</p>
         * @param   {String}       [newId]      If provided, the copy of the child node will be assigned
         *                                      this a its id. If left undefined (and the newPath param
         *                                      is also undefined) then the copy will retain the id of
         *                                      the original. In either case the function will
         *                                      fail if the resulting id of the child or any
         *                                      of its children/components conflicts with an already
         *                                      existing id.
         * @param   {NodeCallback} [callback]   Optional when not copying between different composites or
         *                                      when not using local storage.
         *                                      Gets called when the copy is done or has failed.
         * @returns                             The copied Node if no callback specified.
         */
        copyChild(node: AdobeDCXNode_2, parentNode?: AdobeDCXNode_2, index?: number, newPath?: string, newId?: string): AdobeDCXNode_2;
        copyChild(node: AdobeDCXNode_2, parentNode: AdobeDCXNode_2 | undefined, index: number | undefined, newPath: string | undefined, newId: string | undefined, callback: NodeCallback): void;
        /**
         * <p>Replaces the child node in this branch with a copy of the given node or branch with the same
         * id (or, if provided, with the given id). Fails if the child node does not exist in this branch.</p>
         *
         * <p>This function will try reuse the ids of any children and components of the copied node,
         * in order to minimize the amount of data that will later have to be uploaded, however, clients
         * must not rely on these ids being preserved in the copied objects.</p>
         *
         * <p>Notice: This method does not work without local storage (e.g. browser environment) if
         * used to copy between two different composites.</p>
         *
         * @param   {AdobeDCXNode} node       The child node to update from.
         * @param   {String}       [newPath]  If provided the copy of the component will be assigned
         *                                    this a its path property. Otherwise it will retain its original path.
         * @param   {String}       [newId]    If provided the copy of the child node will be assigned
         *                                    this as its id. Otherwise it will retain its original id.
         * @param   {NodeCallback} [callback]   Optional when not copying between different composites or
         *                                    when not using local storage.
         *                                    Gets called when the copy is done or has failed.
         * @returns                           The replaced Node, or undefined if callback is
         *                                    given.
         */
        replaceChild(node: AdobeDCXNode_2, newPath?: string, newId?: string): AdobeDCXNode_2;
        replaceChild(node: AdobeDCXNode_2, newPath: string | undefined, newId: string | undefined, callback: NodeCallback): void;
        /**
         * Given an INCOMPLETE_COMPOSITE DCXError, this will attempt to return the invalid components so they can be removed or updated
         * @param error An IMCOMPLETE_COMPOSITE error
         * @returns Array of components from this branch that are declared missing in the INCOMPLETE_COMPOSITE error report
         */
        getMissingComponentsFromError(error: AdobeDCXError_2): AdobeDCXComponent_2[];
        /**
         * Returns an array of all components in the branch.
         * @returns {Array}.
         */
        allComponents(): AdobeDCXComponent[];
        /**
         * Returns the component with the given id or undefined if not found.
         * @param   {String} id The id of the component to look up.
         * @returns {AdobeDCXComponent}
         */
        getComponentWithId(id: string): AdobeDCXComponent | undefined;
        /**
         * Returns the component with the given absolute path or undefined if not found.
         * @param   {String} path The absolute path of the desired component.
         * @returns {AdobeDCXComponent}
         */
        getComponentWithAbsolutePath(path: string): AdobeDCXComponent | undefined;
        /**
         * Returns an array containing the components of the given node.
         * @param   {AdobeDCXNode} parentNode The node whose components to return.
         * @returns {Array}
         */
        getComponentsOf(pParentNode?: AdobeDCXNode_2): AdobeDCXComponent[];
        /**
         * Gets passed into addComponent(), updateComponent(), copyComponent(), replaceComponent() and
         * called back whenever the operation has finished.
         * @callback ComponentCallback@callback ComponentCallback
         *    @param {Error}                error
         *    @param {AdobeDCXComponent}    component
         */
        /**
         * <p>Creates and adds a component to the given parent node or to the root if no parent node is
         * given.</p>
         *
         * @param componentDescriptor The serialized component descriptor to use.
         * @param name          The name of the new component.
         * @param path          The path of the new component. Must satisfy uniquenes rules for components.
         * @param relationship  The relationship of the new component.
         * @param parentNode  The node to add the node to. Defaults to the root.
         * @returns {AdobeDCXComponent}               The new component.
         */
        addComponentWithComponentDescriptor(componentDescriptor: string, name: string, path: string, relationship?: LinkRelationKey, parentNode?: AdobeDCXNode_2): AdobeDCXComponent;
        /**
         * <p>Creates and adds a component to the given parent node or to the root if no parent node is
         * given.</p>
         *
         * @param   {String}            name          The name of the new component.
         * @param   {String}            relationship  The relationship of the new component.
         * @param   {String}            path          The path of the new component. Must satisfy uniquenes
         *                                            rules for components.
         * @param   {AdobeDCXNode}      [parentNode]  The node to add the node to. Defaults to the root.
         * @param   {Object}            uploadResults The upload results object returned by a previous call
         *                                            to AdobeDCXCompositeXfer.uploadAssetForComponent().
         * @returns {AdobeDCXComponent}               The new component.
         */
        addComponentWithUploadResults(name: string, relationship: string, path: string, parentNode: AdobeDCXNode_2 | undefined, uploadResults: AdobeUploadResults): AdobeDCXComponent;
        /**
         * <p>Updates the component record with the results of a recent upload of said component.</p>
         *
         * @param   {AdobeDCXComponent} component     The component.
         * @param   {Object}            uploadResults The upload results object returned by a previous
         *                                            call to AdobeDCXCompositeXfer.uploadAssetForComponent().
         * @returns {AdobeDCXComponent} The updated component.
         */
        updateComponentWithUploadResults(component: AdobeDCXComponent, uploadResults: AdobeUploadResults): AdobeDCXComponent;
        /**
         * Removes the component from the branch.
         * @param   {AdobeDCXComponent} component The component to remove.
         * @returns {AdobeDCXComponent} The removed component.
         */
        removeComponent(component: AdobeDCXComponent): AdobeDCXComponent;
        /**
         * Moves the component to the given node or the root if node is undefined
         * @param   {AdobeDCXComponent} component    The component to move.
         * @param   {AdobeDCXNode}      [parentNode] The node to move the component to.
         * @returns {AdobeDCXComponent} The moved component.
         */
        moveComponent(component: AdobeDCXComponent, parentNode?: AdobeDCXNode): AdobeDCXComponent;
        /**
         * Copies the given component and adds it as a new component to this branch. Fails if the
         * component already exists.
         *
         * @param   {AdobeDCXComponent} component    The component to copy.
         * @param   {AdobeDCXNode}      [parentNode] The node to copy the component to. If none is
         *                                           provided then the component will be added to the
         *                                           root.
         * @param   {String}            [newPath]    If provided the copy of the component will be
         *                                           assigned this a its path property and it will also
         *                                           get assigned a new id if none is provided via the
         *                                           <em>newId</em> param.
         * @param   {String}            [newId]      If provided the copy of the component will be
         *                                           assigned this a its id property.
         * @param   {ComponentCallback} [callback]   Optional when not copying between different
         *                                           composites. Gets called when the copy is done or
         *                                           has failed.
         * @returns {AdobeDCXComponent}              Only returns the new component when called without
         *                                           a callback.
         */
        copyComponent(component: AdobeDCXComponent, parentNode?: AdobeDCXNode, newPath?: string, newId?: string, callback?: any): AdobeDCXComponent | undefined;
        /**
         * Replaces the matching component (same id) in this branch with a copy of the given component.
         * Fails if the component can't be found.
         *
         * @param   {AdobeDCXComponent} component  The component to copy.
         * @param   {String}            [newPath]  If provided the copy of the component will be
         *                                         assigned this a its path property and it will also
         *                                         get assigned a new id if none is provided via the
         *                                         newId param.
         * @param   {String}            [newId]    If provided the copy of the component will be
         *                                         assigned this a its id property.
         * @param   {ComponentCallback} [callback] Optional when not copying between different
         *                                         composites. Gets called when the copy is done or has
         *                                         failed.
         * @returns {AdobeDCXComponent}            Only returns the new component when called without
         *                                         a callback.
         */
        replaceComponent(component: AdobeDCXComponent, newPath?: string, newId?: string, callback?: ComponentCallback): AdobeDCXComponent | undefined;
        /**
         * Gets passed into assetOfComponent() and called back whenever the operation has finished.
         * @callback FilePathCallback@callback FilePathCallback
         *    @param {Error}     error
         *    @param {String}    filePath
         */
        /**
         * @private
         */
        private _getHrefOfComponent;
        /**
         * Sets or clears the source asset info of the given component.
         * @internal
         * @param {Object}            sourceAssetInfo The asset and component ids to be used for S2SC
         * @param {AdobeDCXComponent} component  The component.
         * @param {Object}            [local]    Optional: The local data object to use.
         */
        _setSourceAssetInfoOfComponent(sourceAssetInfo: SourceAssetInfoEntry | undefined, component: AdobeDCXComponent | AdobeDCXComponentData): void;
        /**
         * Returns the source href of the given component if one has previously been recorded.
         * @internal
         * @param   {AdobeDCXComponent} component The component.
         * @param {Object}              [local]   Optional: The local data object to use.
         * @returns {Object|undefined}  The source asset info or undefined.
         */
        _getSourceAssetInfoOfComponent(component: AdobeDCXComponent | AdobeDCXComponentData): SourceAssetInfoEntry | undefined;
        /**
         * Copies over any source asset info from the given branch core. Overwrites or clears any
         * existing info.
         * @internal
         * @param {AdobeDCXBranchCore} otherCore The core to copy from
         */
        _copySourceHrefsFrom(otherCore: AdobeDCXBranchCore): void;
        /**
         * @private
         */
        private _getBranchOf;
        /**
         * Returns true if the given core is of the same composite.
         * @private
         * @param   {AdobeDCXBranchCore} otherCore The other core.
         * @returns {Boolean}            Whether the composites match.
         */
        private _isSameComposite;
        /**
         * Returns a stringified representation of the branch that can be used to persist
         * and later restore it.
         * @internal
         * @param   {Boolean} stripOutLocalData Whether to exclude the local data node.
         * @param   {Boolean} pretty            Whether to pretty print the JSON output.
         * @returns {String}
         */
        _stringify(stripOutLocalData: boolean, pretty?: boolean): string;
        /**
         * Verifies and sets the new data and creates the caches. Throws if invalid data.
         * @private
         * @param   {Object}         data Data
         * @returns {AdobeDCXBranch} The branch.
         */
        private _setData;
        /**
         * Recursively removes the given node and all its sub nodes and components from the caches.
         * @private
         * @param {Object} thisNodeData Data
         */
        private _removeNodeFromCachesRecursively;
        /**
         * Returns the local node, creating it if necessary.
         * @internal
         * @returns {Object}
         */
        _local(): Required<AdobeDCXLocalNodeData>['local'];
        /**
         * Recursively resets components.
         * @internal
         * @param {AdobeDCXNodeData} node
         */
        _recursiveReset(node: AdobeDCXNodeData, componentCallback?: (component: AdobeDCXComponentData) => unknown): void;
        /**
         * Figures out whether a node with id nodeId is a sub node of nodeData.
         * @private
         * @param   {String}  nodeId
         * @param   {Object}  nodeData
         * @returns {Boolean}
         */
        private _nodeIdIsDescendantOf;
        /**
         * Returns an array with all components of the given node and its descendants.
         * @internal
         * @param   {Object} node               The node.
         * @param   {Object} [allComponents=[]] USed for recursion. Leave undefined.
         * @returns {Object}
         */
        _recursivelyGetAllComponentsOfChild(node: AdobeDCXNode | AdobeDCXNodeData, allComponents?: AdobeDCXComponent[]): AdobeDCXComponent[];
        /**
         * Returns the node data of the parent node of the given node.
         * @private
         * @param   {Object}   node
         * @param   {Object}   [currentNodeData=this._data] Used for recursion. Don't set.
         * @returns {Object}     found an object of the form { parentNodeData: dataObject, index: integer }. Otherwise null.
         */
        private _nodeDataOfParentOfNode;
        /**
         * Returns the node data of the parent node of the given component.
         * @private
         * @param   {Object}   component
         * @param   {Object} [currentNodeData=this._data] Used for recursion. Don't set.
         * @returns {Object} found an object of the form { parentNodeData: dataObject, index: integer }. Otherwise null.
         */
        private _nodeDataOfParentOfComponent;
        /**
         * Collects all the updates necessary to update the absolute paths of all sub nodes and components.
         * @private
         * @param {Object} currentNodeData
         * @param {String} currentAbsolutePath
         * @param {Array}  updates
         */
        private _determineAbsolutePathChangesRecursively;
        /**
         * Updates the path of a node. Caller must dirty the branch.
         *
         * @throws {AdobeDCXError}
         * @internal
         * @param {Object} node
         * @param {String} newPath
         */
        _setPathOfNode(node: AdobeDCXNode, newPath?: string): void;
        /**
         * Updates the path of a component. Caller must dirty the branch.
         *
         * @throws {AdobeDCXError}
         *
         * @internal
         * @param {AdobeDCXComponent} component
         * @param {String} newPath
         */
        _setPathOfComponent(component: AdobeDCXComponent, newPath: string): void;
        /**
         * Sets the dirty flag and (optionally) the compositeState
         *
         * @throws {AdobeDCXError}
         *
         * @internal
         * @param {Boolean} [preserveCompositeState]
         */
        _setDirty(preserveCompositeState?: boolean): void;
        /**
         * Returns a normalized and lowercased copy of the absolute path of item.
         * @private
         * @param   {Object}   item
         * @param   {Object} newParent Optional. If given this parent will be used to determine the absolute path.
         * @returns {string}
         */
        private _normalizedAbsolutePathForItem;
        /**
         * @private
         */
        private _hasSameEndpoint;
        /**
         * <p>Deep copies the given component and adds it as a new component to this branch.</p>
         *
         * <p>This function gets called in various different situations and thus needs to work correctly or
         * fail with proper errors in the possible permutations of:</p>
         *
         * <p>- locality: whether the source and target are from the same branch, different branches of the
         * same composite, different composites or even composites with different endpoints.</p>
         * <p>- identity: whether the node should be a new node or replace (update) an existing one.</p>
         * <p>- state: whether the component is unmodified, or modified with a source href.</p>
         *
         * <p>After some initial verification and preparation the function first starts any necessary
         * asynchronous operations (i.e. the file copy). If none are necessary or once they all have
         * succeeded it calls _copyComponentModel to do the actual model changes, passing in a callback that
         * gets called for each component (one in this case) and that takes care of udating local storage
         * and/or source href for a later server-to-server copy request.</p>
         *
         * @private
         */
        private _copyComponent;
        /**
         * Copies the given component from a different branch of the same composite into this branch.
         * Notice that this method and its call to copyComponentCallback are synchronous. If you need to
         * do anything asynchronous you will need to do that before (preferably) or after calling this
         * method.
         *
         * Throws if it runs into an error.
         * @private
         * @param   {AdobeDCXComponent} component               The component to copy.
         * @param   {AdobeDCXNode}      [parentNode]            Optional: The node to copy the component to.
         *                                                      If none if provided then the component will
         *                                                      be added to the root.
         * @param   {Boolean}           [replaceExisting]       Optional: Default is false. Whether to
         *                                                      replace an existing component.
         * @param   {String}            [newPath]               Optional: If provided the copy of the
         *                                                      component will be assigned this a its
         *                                                      path property and it will also get
         *                                                      assigned a new id.
         * @param   {String}            [newId]                 Optional: If provided the copy of the
         *                                                      component will be assigned this as its id.
         * @param   {ComponentCallback} [copyComponentCallback] Optional. Gets called for each component
         *                                                      that gets copied. Caller can use this to
         *                                                      tweak the component before it gets added
         *                                                      to the DOM.
         *                                                      Signature: function (originalComponent,
         *                                                      copiedCoponent, localDataOfTargetBranch)
         * @returns {AdobeDCXComponent}                         The new component
         */
        private _copyComponentModel;
        /**
         * <p>Deep copies the given child node and its nodes and components into this branch as a new child.
         * The node can be from the same or from a different composite.
         * If it is a root node then you must specify newPath since it can't keep its original path.</p>
         *
         * <p>This function gets called in various different situations and thus needs to work correctly or
         * fail with proper errors in the various possible permutations:</p>
         *
         * <p>- whether the source and target are from the same branch, different branches of the
         * same composite, different composites or even composites with different endpoints.</p>
         * <p>- whether the node should be a new node or replace (update) an existing one.</p>
         * <p>- whether the components are unmodified, or modified with a source href.</p>
         *
         * <p>After some initial verification and preparation the function first starts any necessary
         * asynchronous operations (i.e. file copies). If none are necessary or once they all have
         * succeeded it calls _copyChildModel to do the actual model changes, passing in a callback that
         * gets called for each component and that takes care of udating local storage and/or source hrefs
         * for a later server-to-server copy request.</p>
         *
         * <p>The function creates copies of the lookup tables and manipulates those during the copy
         * operation. Only once everything has succeeded it inserts the new node (and removes the one to replace)
         * and replaces the lookup tables with its copies so that it can bail out at any time before that
         * without having actually modified the DOM.</p>
         *
         * @private
         */
        private _copyChild;
        /**
         * Copies the given child node with all its nodes and components. Notice that this method and
         * its call to copyComponentCallback are synchronous. If you need to do anything asynchronous you
         * will need to do that before (preferably) or after calling this method.
         *
         * Throws if it runs into an error.
         * @private
         * @param   {AdobeDCXNode} node                  The child node (or whole branch) to copy.
         * @param   {AdobeDCXNode} parentNode            The parent node to copy the child node to.
         *                                               Gets ignored if replaceExisting is true.
         * @param   {Integer}      index                 Optional: If given and less than or equal to the
         *                                               current number of children of the parentNode the
         *                                               node gets inserted at the given index. Otherwise
         *                                               it gets added to the end. Gets ignored if
         *                                               replaceExisting is true.
         * @param   {Boolean}      replaceExisting       Optional: Default is false.
         * @param   {String}       newPath               Optional: If provided the copy of the component
         *                                               will be assigned this a its path property.
         * @param   {String}       newId                 Optional: If provided the copy of the component
         *                                               will be assigned this as its id.
         * @param   {Boolean}      reuseIds              If true we try to reuse ids.
         * @param   {NodeCallback} copyComponentCallback Optional. Gets called for each component that
         *                                               gets copied. Caller can use this to tweak the
         *                                               component before it gets added to the DOM.
         *                                               Should throw if something goes wrong.
         *                                               Signature: function (originalComponent,
         *                                               copiedCoponent, localDataOfTargetBranch)
         * @returns {AdobeDCXNode}          new child node.
         */
        private _copyChildModel;
        /**
         * Verifies the integrity of the in-memory structures of the branch.
         * Looks for incorrect caches/lookup tables, incorrect
         * object references and cycles/duplicate objects.
         * Also, optionally, verifies that all asset files exist locally.
         *
         * @internal
         * @param   {Boolean}  shouldBeComplete Whether to check for the existence of all component assets.
         *                                      @warning This check is using synchronous file system calls.
         * @param   {Function} [logger]         A function that gets called for every error found.
         *                                      Signature: function (string)
         * @param   {Object}   [fs]             The file system object to use in the shouldBeComplete check
         * @returns {Array}    Array of errors or null if everything is OK.
         */
        _verifyIntegrity(shouldBeComplete?: boolean, logger?: (log?: string) => unknown, fs?: any): AdobeDCXError_2[] | null;
    }

    /**
     * @class
     * @classdesc AdobeDCXComponent represents a component of a DCX manifest.
     * <p>The constructor for AdobeDCXComponent is private. Refer to {@link AdobeDCXBranch} to
     * learn how to access existing components or create new ones.
     * @hideconstructor
     * @param {Object}  data
     * @param {Boolean} readOnly
     */
    export declare class AdobeDCXComponent implements AdobeDCXComponent_2 {
        /** @internal */
        private _readOnly;
        /** @internal */
        private _compositeId?;
        /** @internal */
        _data: AdobeDCXComponentData;
        /** @internal */
        _owner?: AdobeDCXBranch | AdobeDCXElement;
        /** @internal */
        _parentPath?: string;
        /** @internal */
        _assetId?: string;
        /** @internal */
        _repoId?: string;
        records: Record<string, AdobeUploadRecord>;
        static readonly STATES: Record<AdobeDCXState, AdobeDCXState>;
        constructor(data?: AdobeDCXComponentData, readOnly?: boolean);
        get compositeId(): string | undefined;
        get owner(): AdobeDCXBranch_2 | AdobeDCXElement_2 | undefined;
        get data(): AdobeDCXComponentData;
        /**
         * The id of the component. Must be a unique among the components of the composite.
         *
         * <p>Cannot be changed for a component that is part of a branch.</p>
         * @memberof AdobeDCXComponent#
         * @type {String}
         */
        get id(): string;
        set id(id: string);
        /**
         * The name of the component.
         *
         * @memberof AdobeDCXComponent#
         * @type {String}
         */
        get name(): string | undefined;
        set name(name: string | undefined);
        /**
         * The type of the component.
         *
         * @memberof AdobeDCXComponent#
         * @type {String}
         */
        get type(): string;
        set type(type: string);
        /**
         * The path of the component.
         *
         * @memberof AdobeDCXComponent#
         * @type {String}
         */
        get path(): string;
        set path(path: string);
        /**
         * The absolute path of the parent of the component.
         *
         * @memberof AdobeDCXComponent#
         * @readonly
         * @type {String}
         */
        get parentPath(): string | undefined;
        set parentPath(_: string | undefined);
        /**
         * The absolute path of the component.
         *
         * @memberof AdobeDCXComponent#
         * @readonly
         * @type {String}
         */
        get absolutePath(): string | undefined;
        set absolutePath(_: string | undefined);
        /**
         * The relationship of the component to its parent node and its sibling components.
         *
         * @memberof AdobeDCXComponent#
         * @type {String}
         */
        get relationship(): string | undefined;
        set relationship(relationship: string | undefined);
        /**
         * The edit state of the component.
         *
         * @memberof AdobeDCXComponent#
         * @readonly
         * @private
         * @type {String}
         */
        get state(): AdobeDCXState;
        set state(state: AdobeDCXState);
        /**
         * The etag of the component.
         *
         * @memberof AdobeDCXComponent#
         * @readonly
         * @private
         * @type {String}
         */
        get etag(): string | undefined;
        set etag(etag: string | undefined);
        /**
         * The md5 of the component.
         *
         * @memberof AdobeDCXComponent#
         * @readonly
         * @private
         * @type {String}
         */
        get md5(): string | undefined;
        set md5(md5: string | undefined);
        /**
         * The version of the component.
         *
         * @memberof AdobeDCXComponent#
         * @readonly
         * @private
         * @type {String}
         */
        get version(): string | undefined;
        set version(version: string | undefined);
        /**
         * The content length of the component.
         *
         * @memberof AdobeDCXComponent#
         * @readonly
         * @type {Integer}
         */
        get length(): number | undefined;
        set length(length: number | undefined);
        /**
         * The width property of the component.
         *
         * @memberof AdobeDCXComponent#
         * @type {Number}
         */
        get width(): number | undefined;
        set width(width: number | undefined);
        /**
         * The height property of the component.
         *
         * @memberof AdobeDCXComponent#
         * @type {Number}
         */
        get height(): number | undefined;
        set height(height: number | undefined);
        /**
         * The asset id of the component in cloud storage
         *
         * @memberof AdobeDCXComponent#
         * @type {String}
         */
        get assetId(): string | undefined;
        set assetId(assetId: string | undefined);
        /**
         * The repo id of the component in cloud storage
         *
         * @memberof AdobeDCXComponent#
         * @type {String}
         */
        get repositoryId(): string | undefined;
        set repositoryId(repoId: string | undefined);
        /**
         * Get a serialized component descriptor.
         *
         * @returns {string}
         *
         * ```ts
         * const componentDescriptor = component.getComponentDescriptor();
         * ```
         */
        getComponentDescriptor(): string;
        /**
         * Returns an array of custom keys that are present at this component. Custom keys are manifest
         * properties that are not considered standard DCX properties.
         * @returns {Array}
         */
        getCustomKeys(): string[];
        /**
         * Returns the object or value for the given custom key.
         * @param   {String} key The custom key to look up.
         * @returns {*}
         */
        getValue<T = any>(key: string): T;
        /**
         * Sets the object or value for the given custom key.
         * @param {String} key   The custom key to set the value for.
         * @param {*}      value The value to set.
         */
        setValue<T = any>(key: string, value: T): void;
        /**
         * Removes the object or value for the given custom key.
         * @param {String} key The custom key to remove.
         */
        removeValue(key: string): void;
        /**
         * Returns the link with the given relationship as a JS object or undefined if the component
         * doesn't have such a link.
         * @param   {String} relationship The relationship of the link to the component.
         * @returns {Object} The link object with the given relationship as a JS object or undefined if
         *                   the component doesn't have such a link.
         */
        getLink(relationship: string): HalLink | undefined;
        /**
         * Sets the link with the given relationship to the given object.
         * @param {Object} link         A JS object representing the link.
         * @param {String} relationship The relationship of the link to the component.
         */
        setLink(link: HalLink, relationship: string): void;
        /**
         * Removes the link with the given relationship.
         * @param {String} relationship The relationship of the link to the component.
         *
         */
        removeLink(relationship: string): void;
        /**
         * Returns false if any of the properties of the given component is different from the properties
         * of this component. Recurses both data structures.
         *
         * @example
         * if (!component.isEqualTo(otherComponent, { unimportantProperty: true })) {
         *      // The components have different properties
         * }
         * @param   {AdobeDCXComponent} component            The component to compare with.
         * @param   {Object}            [propertiesToIgnore] An object having the properties that should
         *                                                 not be compared.
         * @returns {Boolean}
         */
        isEqualTo(component: AdobeDCXComponent, propertiesToIgnore?: Record<string, boolean>): boolean;
        /**
         * Verifies and sets the new data. Throws if invalid data.
         * @private
         * @param   {Object}   data
         * @returns {AdobeDCXComponent}
         */
        private _setData;
        /**
         * Sets the dirty flag on the node's branch (if set)
         * @internal
         */
        _setDirty(): void;
        /**
         * Returns an error if the passed in data is not a valid component. Returns null if everything is OK.
         * @private
         * @param   {Object} data
         * @returns {Error}
         */
        private _verify;
    }

    /**
     * @class
     * @classdesc AdobeDCXComposite represents a DCX composite.
     * <p>The constructor for AdobeDCXComposite is private. Refer to {@link AdobeDCX} to learn how
     * to create instances of AdobeDCXComposite.
     * @hideconstructor
     * @param {String} name
     * @param {String} type
     * @param {String} id
     * @param {String} assetId
     * @param {Object} options
     */
    export declare class AdobeDCXComposite implements AdobeDCXComposite_2 {
        /**
         * Constants for the collaborationType property.
         * @private
         */
        static readonly COLLABORATION: Record<"PRIVATE" | "SHARED_WITH_USER" | "SHARED_BY_USER", string>;
        /** @internal */
        private _clientDataString?;
        /** @internal */
        private _baseBranchData?;
        /** @internal */
        private _name;
        /** @internal */
        private _href?;
        /** @internal */
        private _assetId?;
        /** @internal */
        private _type;
        /** @internal */
        private _id;
        /** @internal */
        _current: AdobeDCXBranch;
        /** @internal */
        private _path;
        /** @internal */
        private _repoId;
        /** @internal */
        private _collaborationType;
        /** @internal */
        _options: AdobeDCXCompositeOptions;
        /** @internal */
        _pushJournal?: AdobeDCXPushJournal;
        /** @internal */
        _links?: LinkSet;
        /** @internal */
        _pushedBranchData?: string;
        /** @internal */
        _pulledBranchData?: string;
        constructor(name?: string, type?: string, id?: string, assetId?: string, repoId?: string | AdobeDCXCompositeOptions, options?: AdobeDCXCompositeOptions);
        get href(): string;
        set href(href: string);
        get links(): LinkSet | undefined;
        set links(links: LinkSet | undefined);
        get repositoryId(): string | undefined;
        set repositoryId(repoId: string | undefined);
        /**
         * The id of the composite.
         *
         * <p>While not strictly read-only most clients do not ever have to modify this property.</p>
         * @memberof AdobeDCXComposite#
         * @type {String}
         */
        get id(): string;
        set id(id: string);
        /**
         * The name of the composite.
         *
         * @memberof AdobeDCXComposite#
         * @type {String}
         */
        get name(): string;
        set name(name: string);
        /**
         * The type of the composite.
         *
         * @memberof AdobeDCXComposite#
         * @type {String}
         */
        get type(): string;
        set type(type: string);
        /**
         * The asset id of the composite that can be used to pull and push the composite.
         * <strong>Do not modify this for a bound composite.</strong>
         * @memberof AdobeDCXComposite#
         * @type {String}
         */
        get assetId(): string | undefined;
        set assetId(assetId: string | undefined);
        /**
         * Whether (and how) the composite is shared. See
         * {@link AdobeDCX.COLLABORATION}.
         * It is the client's responsibility to correctly set this property so that DCX can push
         * the composite correctly.
         * <p><strong>Composites with a collaboration type of AdobeDCX.COLLABORATION.SHARED_WITH_USER
         * must not be deleted. Use AdobeStorageSession.leaveSharedComposite() to remove a shared
         * composite from the user's sync group.</p>
         * // @TODO: Determine if this is still used/necessary in RAPI.
         * @memberof AdobeDCXComposite#
         * @type {String}
         * @default [COLLABORATION.PRIVATE]
         */
        get collaborationType(): string | undefined;
        set collaborationType(value: string | undefined);
        /**
         * User-defined data to associate with the composite - this can be an arbitrary string, up to a limit of 1KB.
         * This data is not synchronized to the server, but it is persisted locally to disk.
         *
         * @memberof AdobeDCXComposite#
         * @type {String}
         * @default [undefined]
         */
        get clientDataString(): string | undefined;
        set clientDataString(value: string | undefined);
        /**
         * Whether the composite is bound to a composite on a server. If <em>false</em> for newly
         * created empty composites that have never been pulled from or pushed to the server.
         * @readonly
         * @memberof AdobeDCXComposite#
         * @type {Boolean}
         */
        get isBound(): boolean;
        set isBound(_: boolean);
        /**
         * The editable current branch the composite. Is undefined in case of a composite that hasn't
         * been pulled from the server yet.
         * @readonly
         * @memberof AdobeDCXComposite#
         * @type {AdobeDCXBranch}
         */
        get current(): AdobeDCXBranch_2;
        /**
         * @private
         */
        set current(_: AdobeDCXBranch_2);
        /**
         * <p>Creates and returns a new composite object that is a copy of compositeBranchOrElement.</p>
         *
         * <p> The resulting composite will be in memory only and you can push it to the server, which
         * will result in the component files being copied on the server. </p>
         *
         * @param   {Object}            compositeOrBranchOrElement As the name implies this param is expected to be
         *                                                         either a composite (with a valid current branch),
         *                                                         a branch or an element. Furthermore it may (at
         *                                                         this point in time) not contain an new or modified
         *                                                         components.
         * @param   {String}            [name]                     An optional new name for the new composite. If undefined
         *                                                         the composite will have the same name as the original.
         * @param   {String}            [type]                     An optional new type for the new composite. If undefined
         *                                                         the composite will have the same type as the original.
         * @param   {String}            [id]                       An optional new id for the new composite. If undefined
         *                                                         the composite will get a random new id.
         * @param   {Object}            [options]                  See constructor.
         * @returns {AdobeDCXComposite} The new composite
         */
        static newCompositeAsCopyOf(compositeOrBranchOrElement: AdobeDCXBranch_2 | AdobeDCXComposite_2 | AdobeDCXElement_2, name?: string, type?: string, id?: string, options?: AdobeDCXCompositeOptions): AdobeDCXComposite;
        /**
         * Loads the base manifest and instantiates a read-only branch if the manifest exists.
         *
         * <p>This method can only be called if the AdobeDCXComposite instance has been initialized with the
         * <em>xhrBaseBranchSupport</em> option.</p>
         *
         * @param {BranchCallback} callback Gets called on success or failure.
         */
        loadBaseBranch(): AdobePromise<AdobeDCXBranch_2, AdobeDCXError_2>;
        loadBaseBranch(callback: BranchCallback): void;
        /**
         * Callback function used for operations that return a branch.
         * @callback BranchCallback@callback BranchCallback
         *    @param {Error}           error
         *    @param {AdobeDCXBranch}  branch
         */
        /**
         * Callback function used for operations that don't return anything other than a potential error.
         * @callback ErrorCallback@callback ErrorCallback
         *    @param {Error}           error
         */
        /**
         * Callback function used for operations that don't return anything other than an array if error
         * objects.
         * @callback ErrorsCallback@callback ErrorsCallback
         *    @param {Array}           Array of error objects or undefined.
         */
        /**
         * Accepts the given merged branch as the new current branch, discards any temporary pull data
         * and also updates the base manifest. Is a no-op if no branch is provided and if there
         * is no pulled manifest in local storage (as may be the case if a pull didn't find any
         * modification on the server).
         *
         * @example
         * // NJS
         * pullComposite(composite, session, function (error, pulledBranch) {
         *      if (!error) {
         *          // The pull has succeeded. Now you need to incorporate the changes from the server
         *          // into your current branch.
         *          // Start the merge by making a mutable copy of pulledBranch
         *          var mergedBranch = pulledBranch.copy();
         *          // Now merge any changes you have made to current since the last successful push or
         *          // pull. You might want to also load the base branch to help you figure out what has
         *          // changed in either branch.
         *          ...
         *          // When done merging you need to make this call:
         *          composite.resolvePullWithBranch(mergedBranch, function (error, newCurrent) {
         *              if (!error) {
         *                  // Now you are done!
         *              }
         *          });
         *      }
         * });
         *
         * @example
         * // XHR
         * pullCompositeManifestOnly(composite, session, function (error, pulledBranch) {
         *      if (!error) {
         *          // The pull has succeeded. Now you need to incorporate the changes from the server
         *          // into your current branch. If you follow the recommendations for working in an
         *          // online environment you will not have modified current so you can just call:
         *          composite.resolvePullWithBranch(pulledBranch);
         *      }
         * });
         *
         *
         * <p><strong>The branch passed in must be derived from the pulled branch.</strong></p>
         *
         * @param {AdobeDCXBranch} branch     A branch which should become the new current branch. It
         *                                    should be the result of merging the previously pulled
         *                                    branch with any changes in current.
         * @param {BranchCallback} [callback] Optional if running in an <strong>XHR</strong>
         *                                    environment. Gets called on completion.
         * @return {AdobeDCXBranch}           Only returns the new current branch if called without
         *                                     a callback.
         */
        resolvePullWithBranch(branch: AdobeDCXBranch_2): void;
        resolvePullWithBranch(branch: AdobeDCXBranch_2, callback: BranchCallback): void;
        /**
         * Updates the current branch (both in memory and -- if applicable -- in local storage) with the
         * results of the most recent push, discards any temporary push data and updates base. Is a
         * no-op if there are no push results (because e.g. there were no changes to push).
         *
         * @example
         * // NJS
         * pushComposite(composite, false, session, function (error) {
         *      if (!error) {
         *          // The push has succeeded. You now need to accept it to update your current branch
         *          composite.acceptPush(function (error) {
         *              if (!error) {
         *                  // Now you are done!
         *              }
         *          });
         *      }
         * });
         *
         * @example
         * // XHR
         * pushComposite(composite, false, session, function (error) {
         *      if (!error) {
         *          // The push has succeeded. If you want to continue to work with the composite you
         *          // must accept the push -- otherwise you are done now
         *          composite.acceptPush();
         *      }
         * });
         *
         * @param   {ErrorCallback} [callback]  Optional when calling in an <strong>XHR</strong>
         *                                      environment. Gets called on completion.
         * @returns {AdobeDCXBranch}            Only returns the new current branch if called without
         *                                      a callback.
         */
        acceptPush(callback?: (err?: Error) => unknown): void | AdobeDCXBranch_2;
        /**
         * Removes all service-related data from the current banch and resets all other branches so that
         * the composite can be pushed again to the same or a different service.
         * @param {ErrorCallback} [callback] Optional if called from an <strong>XHR</strong>
         *                                   environment. Gets called on success or failure.
         */
        resetBinding(callback?: (err?: Error) => unknown): void;
        /**
         * Assigns a new id to the current branch and resets all other branches. Also removes all
         * service-related data from the current branch so that it can be pushed again to the same or
         * a different service.
         * @param {ErrorCallback} [callback] Optional if called from an <strong>XHR</strong>
         *                                   environment. Gets called on success or failure.
         */
        resetIdentity(callback?: (err?: Error) => unknown): void;
        /** Sets the path property and creates or updates local storage. */
        /**
         * @private
         * @param {String} path
         */
        private _setPath;
        /**
         * @internal
         */
        get _isRepoComposite(): boolean;
    }

    export declare interface AdobeDCXCompositeOptions {
        xhrBaseBranchSupport?: boolean;
        maxClientDataLength?: number;
    }

    /**
     * @class
     * @classdesc An element is a node in a dcx composite that represents an embedded composite. The AdobeDCXElement
     * class allows working with such an element in a safe manner.
     * <p>The constructor for AdobeDCXElement is private. Instances are getting instantiated on an
     * as needed-basis and can be accessed via the {@link AdobeDCXBranch} instance.</p>
     * @hideconstructor
     * @param {Object}  [data]      private
     * @param {Object}  [owner]    private
     * @param {Boolean} [readOnly]  private
     */
    export declare class AdobeDCXElement implements AdobeDCXElement_2 {
        /** @internal */
        _owner: AdobeDCXBranch;
        /** @internal */
        _core: AdobeDCXBranchCore;
        /** @internal */
        _data: AdobeDCXNodeData;
        constructor(data?: AdobeDCXRootNodeData, owner?: AdobeDCXBranch_2, readOnly?: boolean);
        get owner(): AdobeDCXBranch_2;
        /**
         * An AdobeDCXNode object that represents the root of the underlying manifest.
         * @memberof AdobeDCXElement#
         * @type {AdobeDCXNode}
         * @readonly
         */
        get rootNode(): AdobeDCXNode_2;
        /**
         * The name of the composite.
         * @memberof AdobeDCXElement#
         * @type {String}
         */
        get name(): string | undefined;
        set name(name: string | undefined);
        /**
         * The type of the element.
         * @memberof AdobeDCXElement#
         * @type {String}
         */
        get type(): string;
        set type(type: string);
        /**
         * The asset id of the composite that can be used to pull and push the composite.
         * @memberof AdobeDCXElement#
         * @type {String}
         * @readonly
         */
        get compositeAssetId(): string | undefined;
        set compositeAssetId(_: string | undefined);
        /**
         * The repository id of the composite that can be used to pull and push the composite.
         * @memberof AdobeDCXElement#
         * @type {String}
         * @readonly
         */
        get compositeRepositoryId(): string | undefined;
        set compositeRepositoryId(_: string | undefined);
        /**
         * @memberof AdobeDCXElement#
         * @private
         * @type {Boolean}
         */
        private get _isDirty();
        private set _isDirty(value);
        /**
         * Whether the composite has has been modified in memory and needs to be committed to local
         * storage.
         * @memberof AdobeDCXElement#
         * @readonly
         * @type {Boolean}
         */
        get isDirty(): boolean;
        /**
         * @memberof AdobeDCXElement#
         * @private
         * @readonly
         */
        get changeCount(): number;
        /**
         * Returns the node with the given id or undefined if not found.
         * @param   {String } id The id of the child node to look up.
         * @returns {AdobeDCXNode}
         */
        getChildWithId(id: string): AdobeDCXNode_2 | undefined;
        /**
         * Returns the node with the given absolute path or undefined if not found.
         * @param   {String} path The absolute path.
         * @returns {AdobeDCXNode}
         */
        getChildWithAbsolutePath(path: string): AdobeDCXNode_2 | undefined;
        /**
         * Generates and returns an array of the child nodes of the given parent node.
         * @example
         * var rootNodes = element.getChildrenOf(element.rootNode);
         * @param   {AdobeDCXNode} parentNode The parent node to return the children for.
         * @returns {Array}
         */
        getChildrenOf(parentNode: AdobeDCXNode_2): AdobeDCXNode_2[];
        /**
         * Creates a new node and inserts it into the children list of the given parent node or of the
         * root if no parent node is given.
         * Returns the new child node.
         * @param   {String}  [name]       The name of the new child. If undefined the child will not
         *                                 have a name.
         * @param   {String}  [nodeId]     The id of the new child. If undefined the new child node will
         *                                 get a random id.
         * @param   {Integer} [index]      If given and less than or equal to the current number of
         *                                 children than the node gets inserted at the given index.
         *                                 Otherwise it gets added to the end.
         * @param   {String}  [parentNode] The parent node to add the node to. Default parent is the
         *                                 root node.
         * @returns {AdobeDCXNode}
         */
        addChild(name?: string, nodeId?: string, index?: number, parentNode?: AdobeDCXNode_2): AdobeDCXNode_2;
        /**
         * Removes and returns the given child node from the element.
         * @param   {AdobeDCXNode} node The child node to remove.
         * @returns {AdobeDCXNode}
         */
        removeChild(node: AdobeDCXNode_2): AdobeDCXNode_2;
        /**
         * Moves the existing child from its current parent/index to the given parent/index.
         * @param   {AdobeDCXNode} node         The child node to move
         * @param   {Integer}      [index]      If given and less than or equal to the current number of
         *                                      children than the node gets inserted at the given index.
         *                                      Otherwise it gets added to the end.
         * @param   {AdobeDCXNode} [parentNode] The parent node to move the node to. Default parent is
         *                                      the root.
         * @returns {AdobeDCXNode}
         */
        moveChild(node: AdobeDCXNode_2, index?: number, parentNode?: AdobeDCXNode_2): AdobeDCXNode_2;
        /**
         * Copies the given child node as a new node into this element. The node can be from the same or
         * from a different composite.
         *
         * <p>This function will try reuse the ids of any children and components of the copied node,
         * in order to minimize the amount of data that will later have to be uploaded, however, clients
         * must not rely on these ids being preserved in the copied objects.</p>
         *
         * <p>Fails if a node with the same id or same absolute path already exists.</p>
         *
         * <p>Notice: This method does not work without local storage (e.g. browser environment) if
         * used to copy between two composites stored at different endpoints.</p>
         *
         * @param   {AdobeDCXNode} node         The child node to copy. If it is the root node then
         *                                      newPath must be provided.
         * @param   {AdobeDCXNode} [parentNode] The parent node to copy the child node to. If undefined
         *                                      then the new child node will be added to the root of the
         *                                      branch.
         * @param   {Integer}      [index]      If provided and less than or equal to the current number of
         *                                      children of the parentNode (or root) the child node gets
         *                                      inserted at the given index. Otherwise it gets added to
         *                                      the end.
         * @param   {String}       [newPath]    <p>If provided, the copy of the child node will be assigned
         *                                      this a its path property and it will also receive a new
         *                                      random id (unless one is provided with the newId param).
         *                                      If left undefined then the copy of the node will keep
         *                                      the path of the original. In either case the function will
         *                                      fail if the resulting absolute path of the child or any
         *                                      of its children/components conflicts with an already
         *                                      existing absolute path.</p>
         *                                      <p>You must provide a newPath if you are copying the root
         *                                      node of a branch or element.</p>
         * @param   {String}       [newId]      If provided, the copy of the child node will be assigned
         *                                      this a its id. If left undefined (and the newPath param
         *                                      is also undefined) then the copy will retain the id of
         *                                      the original. In either case the function will
         *                                      fail if the resulting id of the child or any
         *                                      of its children/components conflicts with an already
         *                                      existing id.
         * @param   {NodeCallback} [callback]   Optional when not copying between different composites or
         *                                      when not using local storage.
         *                                      Gets called when the copy is done or has failed.
         * @returns {AdobeDCXNode}              Only returns the created child node if no callback is
         *                                      given.
         */
        copyChild(node: AdobeDCXNode_2, parentNode?: AdobeDCXNode_2, index?: number, newPath?: string, newId?: string): AdobeDCXNode_2;
        copyChild(node: AdobeDCXNode_2, parentNode: AdobeDCXNode_2 | undefined, index: number | undefined, newPath: string | undefined, newId: string | undefined, callback: NodeCallback): void;
        /**
         * Returns an array of all components in the element.
         * @returns {Array}.
         */
        allComponents(): AdobeDCXComponent_2[];
        /**
         * Returns the component with the given id or undefined if not found.
         * @param   {String} id The id of the component to look up.
         * @returns {AdobeDCXComponent}
         */
        getComponentWithId(id: string): AdobeDCXComponent_2 | undefined;
        /**
         * Returns the component with the given absolute path or undefined if not found.
         * @param   {String} path The absolute path of the desired component.
         * @returns {AdobeDCXComponent}
         */
        getComponentWithAbsolutePath(path: string): AdobeDCXComponent_2 | undefined;
        /**
         * Returns an array containing the components of the given node.
         * @param   {AdobeDCXNode} parentNode The node whose components to return.
         * @returns {Array}
         */
        getComponentsOf(parentNode: AdobeDCXNode_2): AdobeDCXComponent_2[];
        /**
         * Given an INCOMPLETE_COMPOSITE DCXError, this will attempt to return the invalid components so they can be removed or updated
         * @param error An IMCOMPLETE_COMPOSITE error
         * @returns Array of components from this branch that are declared missing in the INCOMPLETE_COMPOSITE error report
         */
        getMissingComponentsFromError(error: AdobeDCXError_2): AdobeDCXComponent_2[];
        /**
         * <p>Creates and adds a component to the given parent node or to the root if no parent node is
         * given.</p>
         *
         * @param   {String}            name          The name of the new component.
         * @param   {String}            relationship  The relationship of the new component.
         * @param   {String}            path          The path of the new component. Must satisfy uniqueness
         *                                            rules for components.
         * @param   {AdobeDCXNode}      [parentNode]  The node to add the node to. Defaults to the root.
         * @param   {Object}            uploadResults The upload results object returned by a previous call
         *                                            to AdobeDCXCompositeXfer.uploadAssetForComponent().
         * @returns {AdobeDCXComponent}               The new component.
         */
        addComponentWithUploadResults(name: string, relationship: string, path: string, parentNode: AdobeDCXNode_2 | undefined, uploadResults: AdobeUploadResults): AdobeDCXComponent;
        /**
         * <p>Creates and adds a component to the given parent node or to the root if no parent node is
         * given.</p>
         *
         * @param componentDescriptor The serialized component descriptor to use.
         * @param name          The name of the new component.
         * @param path          The path of the new component. Must satisfy uniquenes rules for components.
         * @param relationship  The relationship of the new component. If not provided, will default to rel:component.
         * @param parentNode  The node to add the node to. Defaults to the root.
         * @returns {AdobeDCXComponent}               The new component.
         */
        addComponentWithComponentDescriptor(componentDescriptor: string, name: string, path: string, relationship?: LinkRelationKey, parentNode?: AdobeDCXNode_2): AdobeDCXComponent;
        /**
         * <p>Updates the component record with the results of a recent upload of said component.</p>
         *
         * @param   {AdobeDCXComponent} component     The component.
         * @param   {Object}            uploadResults The upload results object returned by a previous
         *                                            call to AdobeDCXCompositeXfer.uploadAssetForComponent().
         * @returns {AdobeDCXComponent} The updated component.
         */
        updateComponentWithUploadResults(component: AdobeDCXComponent_2, uploadResults: AdobeUploadResults): AdobeDCXComponent_2;
        /**
         * Removes the component from the element.
         * @param   {AdobeDCXComponent} component The component to remove.
         * @returns {AdobeDCXComponent} The removed component.
         */
        removeComponent(component: AdobeDCXComponent_2): AdobeDCXComponent_2;
        /**
         * Moves the component to the given node or the root if node is undefined
         * @param   {AdobeDCXComponent} component    The component to move.
         * @param   {AdobeDCXNode}      [parentNode] The node to move the component to.
         * @returns {AdobeDCXComponent} The moved component.
         */
        moveComponent(component: AdobeDCXComponent_2, parentNode?: AdobeDCXNode_2): AdobeDCXComponent_2;
        /**
         * Copies the given component and adds it as a new component to this branch. Fails if the
         * component already exists.
         *
         * <p>Notice: This method does not work without local storage (browser environment) if
         * used to copy between two composites with different endpoints.</p>
         *
         * @param   {AdobeDCXComponent} component    The component to copy.
         * @param   {AdobeDCXNode}      [parentNode] The node to copy the component to. If none is
         *                                           provided then the component will be added to the
         *                                           root.
         * @param   {String}            [newPath]    If provided the copy of the component will be
         *                                           assigned this a its path property and it will also
         *                                           get assigned a random new id if none is provided via
         *                                           the <em>newId</em> param.
         * @param   {String}            [newId]      If provided the copy of the component will be assigned
         *                                           this a its id. If left undefined (and if newPath is
         *                                           undefined as well) then the copy of the component
         *                                           will retain the id of the original.
         *                                           This is useful when merging conflicting changes since
         *                                           it preserves the identity of components and avoids
         *                                           unnecessary network traffic.
         * @param   {ComponentCallback} [callback]   Optional when not copying between different
         *                                           composites or when copying without local storage.
         *                                           Gets called when the copy is done or has failed.
         * @returns {AdobeDCXComponent}              Only returns the new component when called without
         *                                           a callback.
         */
        copyComponent(component: AdobeDCXComponent_2, parentNode?: AdobeDCXNode_2, newPath?: string, newId?: string): AdobeDCXComponent_2;
        copyComponent(component: AdobeDCXComponent_2, parentNode: AdobeDCXNode_2 | undefined, newPath: string | undefined, newId: string | undefined, callback: ComponentCallback): void;
        /**
         * Restores the element from its stringified representation (manifest). Throws if data is invalid.
         * @internal
         * @param   {String} data The stringified representation.
         * @returns {AdobeDCXElement}.
         */
        parse(data: string): AdobeDCXElement;
        /**
         * Creates and returns a read-write deep copy of the element.
         * @internal
         * @returns {AdobeDCXElement}
         */
        copy(): AdobeDCXElement;
        /**
         * Returns an error if the passed in data is not a valid manifest. Returns null if everything is OK.
         * @private
         * @param   {Object} data The value object to verify.
         * @returns {Error}
         */
        private _verify;
        /**
         * Verifies and sets the new data and creates the caches. Throws if invalid data.
         * @private
         * @param   {Object}         data Data
         * @param {Boolean} readOnly Whether the element is read-only.
         * @returns {AdobeDCXElement} The element.
         */
        private _setData;
        /** @internal */
        _local(): AdobeDCXLocalNodeData['local'];
        /**
         * Sets the dirty flag and (optionally) the compositeState
         * @internal
         * @param {Boolean} preserveCompositeState
         */
        _setDirty(preserveCompositeState?: boolean): void;
        /**
         * Updates the path of a node. Caller must dirty the element.
         * @internal
         * @param {Object} node
         * @param {String} newPath
         */
        _setPathOfNode(node: AdobeDCXNode_2, newPath?: string): void;
        /**
         * Verifies the integrity of the in-memory structures of the element.
         * Looks for incorrect caches/lookup tables, incorrect
         * object references and cycles/duplicate objects.
         * Also, optionally, verifies that all asset files exist locally.
         * @internal
         * @param   {Boolean}  shouldBeComplete Whether to check for the existence of all component assets.
         *                                      @warning This check is using synchronous file system calls.
         * @param   {Function} [logger]         A function that gets called for every error found.
         *                                      Signature: function (string)
         * @param   {Object}   [fs]             The file system object to use in the shouldBeComplete check
         * @returns {Array}    Array of errors or null if everything is OK.
         */
        _verifyIntegrity(shouldBeComplete: boolean, logger?: (data?: string) => unknown, fs?: any): AdobeDCXError_2[] | null;
    }

    export { AdobeDCXError }

    declare interface AdobeDCXLocalNodeData {
        local?: {
            version?: number;
            change?: number;
            collaborationType?: string;
            clientDataString?: string;
            archivalState?: 'pending' | 'archived';
            manifestEtag?: string;
        };
    }

    export { AdobeDCXLogger }

    /**
     * @class
     * @classdesc AdobeDCXNode represents a node of a DCX manifest.
     * <p>The constructor for AdobeDCXNode is private. Refer to {@link AdobeDCXBranch} to
     * learn how to access existing nodes or create new ones.
     * @hideconstructor
     * @param {Object}  data
     * @param {Boolean} readOnly
     * @param {Boolean} isRoot
     */
    export declare class AdobeDCXNode implements AdobeDCXNode_2 {
        static ROOT_PATH: string;
        /** @internal  */
        _parentPath?: string;
        /** @internal  */
        _owner?: AdobeDCXBranch | AdobeDCXElement;
        /** @internal  */
        _data: (AdobeDCXNodeData | AdobeDCXRootNodeData) & AdobeDCXLocalNodeData;
        /** @internal  */
        _readOnly: boolean;
        readonly _isRoot: boolean;
        constructor(data?: AdobeDCXNodeData | AdobeDCXRootNodeData, readOnly?: boolean, isRoot?: boolean);
        get owner(): AdobeDCXElement_2 | AdobeDCXBranch_2 | undefined;
        /**
         * The id of the node. Must be a unique among the nodes of the composite.
         * <p>Cannot be changed for a node that is part of a branch or element.</p>
         * @memberof AdobeDCXNode#
         * @type {String}
         */
        get id(): string;
        set id(id: string);
        /**
         * The name of the node.
         *
         * @memberof AdobeDCXNode#
         * @type {String}
         */
        get name(): string | undefined;
        set name(name: string | undefined);
        /**
         * The type of the node.
         *
         * @memberof AdobeDCXNode#
         * @type {String}
         */
        get type(): string;
        set type(type: string);
        /**
         * The relationship of the node to its parent node.
         *
         * @memberof AdobeDCXNode#
         * @type {String}
         */
        get relationship(): string | undefined;
        set relationship(relationship: string | undefined);
        /**
         * The path property of the node.
         *
         * @memberof AdobeDCXNode#
         * @type {String}
         */
        get path(): string | undefined;
        set path(path: string | undefined);
        /**
         * The absolute path of the parent of the node.
         *
         * @memberof AdobeDCXNode#
         * @readonly
         * @type {String}
         */
        get parentPath(): string | undefined;
        set parentPath(_: string | undefined);
        /**
         * The absolute path of the node.
         *
         * @memberof AdobeDCXNode#
         * @readonly
         * @type {String}
         */
        get absolutePath(): string | undefined;
        set absolutePath(_: string | undefined);
        /**
         * Whether this node is the root of its branch or element.
         *
         * @memberof AdobeDCXNode#
         * @readonly
         * @type {Boolean}
         */
        get isRoot(): boolean;
        set isRoot(_: boolean);
        /**
         * Returns the link with the given relationship as a JS object or undefined if the node
         * doesn't have such a link.
         * @param   {String} relationship The relationship of the link to the node.
         * @returns {Object} The link with the given relationship as a JS object or undefined if
         *                   the node doesn't have such a link.
         */
        getLink(relationship: string): HalLink | undefined;
        /**
         * Sets the link with the given relationship to the given object.
         * @param {Object} link         A JS object representing the link.
         * @param {String} relationship The relationship of the link to the node.
         */
        setLink(link: HalLink, relationship: string): void;
        /**
         * Removes the link with the given relationship.
         * @param {String} relationship The relationship of the link to the node.
         *
         */
        removeLink(relationship: string): void;
        /**
         * Returns an array of non-standard keys that are present at this node.
         * @returns {Array} An array of all non-standard property keys.
         */
        getCustomKeys(): string[];
        /**
         * Returns the object or value for the given key.
         * @param   {String} key The custom key to look up.
         * @returns {*} The value or object for the key.
         */
        getValue<T = any>(key: string): T;
        /**
         * Returns the object or value for the given key.
         * @param {String}   key   The custom key to set the value for.
         * @param {*} value The value or object.
         */
        setValue<T = any>(key: string, value: T): void;
        /**
         * Removes the object or value for the given key.
         * @param {String} key The custom key to remove.
         */
        removeValue(key: string): void;
        /**
         * Creates and returns a deep copy of the node sans any of its components or children.
         * @returns {AdobeDCXNode} The copy.
         */
        copy(): AdobeDCXNode_2;
        /**
         * Returns false if any of the properties of the given node is different from the properties
         * of this node. Recurses both data structures.
         * @param   {AdobeDCXNode} node                          The node to compare with.
         * @param   {Array}        [nodePropertiesToIgnore]      Optional. An object having the properties
         *                                                       that should not be compared for node.
         * @param   {Array}        [componentPropertiesToIgnore] Optional. An object having the properties
         *                                                       that should not be compared for components.
         * @returns {Boolean}
         */
        isEqualTo(node: AdobeDCXNode_2, nodePropertiesToIgnore?: Record<string, boolean>, componentPropertiesToIgnore?: Record<string, boolean>): boolean;
        /**
         * Internal. Compares nodeData
         * @private
         * @param   {Object}  nodeData1
         * @param   {Object}  nodeData2
         * @param   {Object}  nodePropertiesToIgnore
         * @param   {Object}  componentPropertiesToIgnore
         * @returns {Boolean}
         */
        private _isEqual;
        /**
         * Verifies and sets the new data. Throws if invalid data.
         * @private
         * @param   {Object} data
         * @returns {AdobeDCXNode}
         *
         * @throws {AdobeDCXError}
         */
        private _setData;
        /**
         * Returns an error if the passed in data is not a valid node. Returns null if everything is OK.
         * @private
         * @param   {Object} data
         * @returns {AdobeDCXError | null}
         */
        private _verify;
        /**
         * Sets the dirty flag on the node's branch or element (if set)
         * @private
         */
        private _setDirty;
    }

    /**
     * Captures the state and progess of a composite push operation
     * which can be used to resume a failed push at a later time.
     * @private
     */
    export declare class AdobeDCXPushJournal {
        private _data;
        private _waitingCallbacks;
        private _commitInProgress;
        private _needAnotherCommit;
        constructor(composite: AdobeDCXComposite_2);
        get compositeHref(): string;
        set compositeHref(id: string);
        get derivationType(): DerivationType | undefined;
        set derivationType(derivationType: DerivationType | undefined);
        get manifestEtag(): string | undefined;
        set manifestEtag(etag: string | undefined);
        get versionId(): string | undefined;
        set versionId(v: string | undefined);
        get currentBranchEtag(): string | undefined;
        set currentBranchEtag(etag: string | undefined);
        get changeCount(): number | undefined;
        set changeCount(change: number | undefined);
        get compositeHasBeenDeleted(): boolean;
        set compositeHasBeenDeleted(hasBeenDeleted: boolean);
        get compositeHasBeenArchived(): boolean;
        set compositeHasBeenArchived(hasBeenArchived: boolean);
        get isEmpty(): boolean;
        set isEmpty(_: boolean);
        get isComplete(): boolean;
        set isComplete(_: boolean);
        /**
         * Records the upload of the given component.
         * @internal
         * @param {String}  componentId
         * @param {String}  etag
         * @param {String}  version
         * @param {String}  md5
         * @param {Integer} length
         * @param {Object}  sourceAssetInfo
         */
        recordUploadedComponent(componentId: string, etag: string, version: string, md5: string, length: number, sourceAssetInfo?: SourceAssetInfoEntry): void;
        /**
         * Returns an array of the ids of all uploaded components.
         * @internal
         * @returns {Array}
         */
        idsOfAllUploadedComponents(): string[];
        /**
         * Returns an upload record of the given component or undefined if it has not been uploaded or
         * has aged out.
         * @param   {String}   componentId
         * @returns {Object}
         * @example
         *      {
         *           etag: componentEtag,
         *           length: componentLength,
         *           version: component.Version,
         *           md5: componentMd5,
         *           'source-asset-info': {
         *              'compositeAssetId': assetId,
         *              'componentId': componentId,
         *              'componentVersion': version
         *           }
         *      }
         */
        getRecordForUploadedComponent(componentId: string): UploadedComponentRecord | undefined;
        /**
         * Deletes the upload record for the given component.
         */
        removeRecordForUploadedComponent(componentId: string): void;
        /**
         * Applies the journaled data to the provided branch.
         */
        applyToBranch(pBranch: AdobeDCXBranch_2, preserveDirtyState?: boolean): void;
    }

    /** @public */
    export declare const AdobeDCXUtil: typeof _AdobeDCXUtil;

    export { AdobeHTTPService }

    export declare const AdobeNetworkHTTPService: new (authHandler?: AdobeAuthProvider | AuthenticationCallback | undefined, options?: AdobeHTTPServiceOptions | undefined) => AdobeHTTPService;

    /*************************************************************************
     *
     * ADOBE CONFIDENTIAL
     * ___________________
     *
     * @license
     * Copyright 2020 Adobe Inc.
     * All Rights Reserved.
     *
     * NOTICE:  All information contained herein is, and remains
     * the property of Adobe Inc. and its suppliers,
     * if any.  The intellectual and technical concepts contained
     * herein are proprietary to Adobe Inc. and its
     * suppliers and are protected by trade secret or copyright law.
     * Dissemination of this information or reproduction of this material
     * is strictly forbidden unless prior written permission is obtained
     * from Adobe Inc.
     **************************************************************************/
    /**
     * @class
     * @classdesc AdobeRemixData represents data to add to XMP for published composite.
     * <p>The constructor for AdobeRemixData is private. Refer to {@link AdobeDCX} to learn how
     * to create instances of AdobeRemixData.
     * @hideconstructor
     */
    declare class AdobeRemixData {
        private _originURL;
        private _manageUIURL;
        private _licenseType;
        private _licenseUrl;
        private _attributionURL;
        private _attributionName;
        get originURL(): string | null;
        set originURL(originURL: string | null);
        get manageUIURL(): string | null;
        set manageUIURL(manageUIURL: string | null);
        get licenseType(): string | null;
        set licenseType(licenseType: string | null);
        get licenseUrl(): string | null;
        set licenseUrl(licenseUrl: string | null);
        get attributionURL(): string | null;
        set attributionURL(attributionURL: string | null);
        get attributionName(): string | null;
        set attributionName(attributionName: string | null);
    }
    export { AdobeRemixData }
    export { AdobeRemixData as RemixData }

    /**
     * Public XferContext API.
     */
    declare interface AdobeXferContext {
        /**
         * Components failed during an xfer, used for pushComposite.
         * If none failed, this will be an empty array.
         */
        failedComponents: FailedComponent[];
        /**
         * Whether the xfer has been aborted.
         */
        aborted: boolean;
        /**
         * Total bytes currently transferred at a given time.
         */
        bytesTransfered: number;
        /**
         * Total estimated bytes for the xfer.
         */
        bytesTotal: number;
        /**
         * Register callback to be called after aborting xfer.
         * @param {AbortHandler} cb - The handler to be called.
         */
        onAbort: (cb: AbortHandler) => void;
        /**
         * Set a callback to be called on each progress event of the xfer.
         * Unlike onAbort, this is a single handler
         */
        onProgress: ProgressCallback | undefined;
        /**
         * Abort the xfer, canceling pending requests where possible.
         * @param {Error|string} reason - Reason for the abort, will become the error message for each canceled promise.
         */
        abort(reason?: Error | string): void;
    }

    /**
     * Contains cached content location and link data previously retrieved by issuing
     * a head request.
     * @typedef {Object} CachedAssetInfo@typedef {Object} CachedAssetInfo
     *   @property {String}  primaryTemplate  Primary ID-based URI template to the composite in aggregate
     *   @property {String}  manifestTemplate URI template that can be expanded to locate the asset's manifest
     *   @property {String}  componentTemplate URI template that can be expanded to locate the asset's components
     *   @property {String}  versionHistory
     */
    declare interface CachedAssetInfo {
        primaryTemplate: string;
        manifestTemplate: string;
        componentTemplate: string;
        versionHistory: string;
        renditionTemplates: RenditionTemplate[];
    }

    /**
     * The different types of collaboration for a composite. You can set the collaboration type
     * directly on a {@link AdobeDCX#Composite|AdobeDCXComposite} object.
     * @enum {String}
     * @public
     */
    export declare const COLLABORATION: Record<"PRIVATE" | "SHARED_WITH_USER" | "SHARED_BY_USER", string>;

    /**
     * The {@link ./src/AdobeRemixData} class.  Gives access to the DCX AdobeCommunityPublicationRecord which represents publishing data for the Community Platform..
     * @readonly
     * @public
     * @type {AdobeRemixData}
     */
    export declare const CommunityPublicationRecord: typeof AdobeCommunityPublicationRecord;

    declare type CompositeWithManifestAndComponents<C extends ComponentRequestByPath[]> = {
        composite: AdobeDCXComposite_2;
    } & ManifestAndComponentsByPathResponse<C>;

    /**
     * Convert an HLA asset class instance, or AdobeAsset compatible data object to an AdobeDCXComposite.
     *
     * @note Does not validate that incoming asset has any specific properties.
     *
     * @param {AdobeAsset}                  asset           - Asset to convert.
     * @param {string}                      [id]            - Composite ID.
     * @param {AdobeDCXCompositeOptions}    [opts={}]       - Additional configuration options
     */
    export declare function convertToDCXComposite(asset: AdobeAsset_2 | Composite, id?: string, opts?: AdobeDCXCompositeOptions): AdobeDCXComposite;

    /**
     * Copies resources from source to target asset using the COPY_RESOURCES operation.
     * See {@link https://git.corp.adobe.com/pages/caf/api-spec/chapters/operations/copying_resources.html}
     *
     * @param {AdobeRepoAPISession} session                             Repository session obj
     * @param {PathOrIdAssetDesignator} sourceAsset                     The source asset
     * @param {PathOrIdAssetDesignator} targetAsset                     The destination asset
     * @param {CopyResourceDesignator[]} resources                      An array of resource designators to be copied from the source to the target asset.
     * @param {JSONPatchDocument} [manifestPatch]                       An optional JSON Patch document to be applied to the target asset's manifest.
     * @param {boolean} [intermediates]                                 If true, create intermediate assets if they do not exist.
     *
     * @returns {AdobePromise<RepoResponseResult<AdobeAsset, 'json'>, AdobeDCXError>}
     */
    export declare function copyResources(session: AdobeRepoAPISession, sourceAsset: PathOrIdAssetDesignator | AdobeDCXComposite_2, targetAsset: PathOrIdAssetDesignator | AdobeDCXComposite_2, resources: CopyResourceDesignator[], intermediates?: boolean, manifestPatch?: JSONPatchDocument): AdobePromise<RepoResponseResult<CopyResourcesOperationResult, 'json'>, AdobeDCXError_2>;

    /**
     * Constructs and returns a {@link ./src/AdobeCommunityPublicationRecord} instance.
     * @public
     */
    export declare const createCommunityPublicationRecord: () => AdobeCommunityPublicationRecord;

    /**
     * Constructs and returns a community session instance.
     * @public
     * @example
     * ```js
     * const service = // create instance of AdobeHTTPService
     * ...
     * const session = createCommunitySession(service, 'https://my.proxy.adobe.com/cp');
     * ```
     * @param   {AdobeHTTPService}    httpService The HTTP service.
     * @param   {String}              endpoint    The url for the storage server.
     */
    export declare const createCommunitySession: (httpService: AdobeHTTPService, endpoint: string) => AdobeCommunitySession;

    /**
     * Create a new composite cloud asset at the specified path.
     *
     * <p> After creating a new, local-only composite the client must first bind it to a specific repository, path,
     * and asset id in the cloud by calling this method. If successful then the composite object's assetId property will
     * be assigned and the client is now free to upload or copy new components for the composite and call pushComposite.
     *
     * @param session               The repo session to use.
     * @param composite             New composite object whose assetId property is still undefined.
     * @param parentDir             Parent directory in which to create the composite.
     * @param relPath               Path at which new composite will be created in the cloud, relative to parentDir
     */
    export declare function createComposite(session: AdobeRepoAPISession, composite: AdobeDCXComposite, parentDir: AdobeAsset_2, relPath: string): AdobePromise<AdobeDCXComposite, AdobeDCXError_2>;

    /**
     * Create a new composite cloud asset at the specified path.
     *
     * <p> After creating a new, local-only composite the client must first bind it to a specific repository, path,
     * and asset id in the cloud by calling this method. If successful then the composite object's assetId property will
     * be assigned and the client is now free to upload or copy new components for the composite and call pushComposite.
     *
     * @param session               The repo session to use.
     * @param composite             New composite object whose assetId property is still undefined.
     * @param parentDir             Parent directory in which to create the composite.
     * @param relPath               Path at which new composite will be created in the cloud, relative to parentDir
     * @param respondWith           undefined
     * @param additionalHeaders     Additional headers to be applied to HTTP requests
     */
    export declare function createComposite(session: AdobeRepoAPISession, composite: AdobeDCXComposite, parentDir: AdobeAsset_2, relPath: string, respondWith: undefined, additionalHeaders?: Record<string, string>, snapshot?: SliceableData | GetSliceCallback, snapshotSize?: number): AdobePromise<AdobeDCXComposite, AdobeDCXError_2>;

    /**
     * Create a new composite cloud asset at the specified path and respond with the requested resource if possible.
     * <p> After creating a new, local-only composite the client must first bind it to a specific repository, path,
     * and asset id in the cloud by calling this method. If successful then the composite object's assetId property will
     * be assigned and the client is now free to upload or copy new components for the composite and call pushComposite.
     * The resolved value of the promise when a resource designator is provided is the requested resource itself.
     *
     * @see {@link https://git.corp.adobe.com/pages/caf/api-spec/chapters/basics/create.html#alternate-form-create-with-response}
     *
     * @param session               The repo session to use.
     * @param composite             New composite object whose assetId property is still undefined.
     * @param parentDir             Parent directory in which to create the composite.
     * @param relPath               Path at which new composite will be created in the cloud, relative to parentDir
     * @param respondWith           A resource to respond with. This is useful for resolving with the repository metadata
     * @param additionalHeaders     Additional headers to be applied to HTTP requests
     *
     * @returns {AdobePromise<AdobeAsset, AdobeDCXError>}
     */
    export declare function createComposite(session: AdobeRepoAPISession, composite: AdobeDCXComposite, parentDir: AdobeAsset_2, relPath: string, respondWith: ResourceDesignator, additionalHeaders?: Record<string, string>, snapshot?: SliceableData | GetSliceCallback, snapshotSize?: number): AdobePromise<AdobeAsset_2, AdobeDCXError_2>;

    /**
     * Create a new composite cloud asset at the specified path and respond with the requested resource if possible.
     * <p> After creating a new, local-only composite the client must first bind it to a specific repository, path,
     * and asset id in the cloud by calling this method. If successful then the composite object's assetId property will
     * be assigned and the client is now free to upload or copy new components for the composite and call pushComposite.
     * The resolved value of the promise when a resource designator is provided is the requested resource itself.
     *
     * @see {@link https://git.corp.adobe.com/pages/caf/api-spec/chapters/basics/create.html#alternate-form-create-with-response}
     *
     * @param session               The repo session to use.
     * @param composite             New composite object whose assetId property is still undefined.
     * @param parentDir             Parent directory in which to create the composite.
     * @param relPath               Path at which new composite will be created in the cloud, relative to parentDir
     * @param respondWith           A resource to respond with. This is useful for resolving with the repository metadata
     * @param additionalHeaders     Additional headers to be applied to HTTP requests
     *
     * @returns {AdobePromise<AdobeAsset, AdobeDCXError>}
     */
    export declare function createComposite(session: AdobeRepoAPISession, composite: AdobeDCXComposite, parentDir: AdobeAsset_2, relPath: string, respondWith: ResourceDesignator, additionalHeaders?: Record<string, string>, snapshot?: SliceableData | GetSliceCallback, snapshotSize?: number): AdobePromise<AdobeAsset_2, AdobeDCXError_2>;

    export { createHTTPService }

    /**
     * Constructs and returns a remixData instance.
     * @public
     */
    export declare const createRemixData: () => AdobeRemixData;

    export { DCXError }

    /*************************************************************************
     *
     * ADOBE CONFIDENTIAL
     * ___________________
     *
     * @license
     * Copyright 2021 Adobe Inc.
     * All Rights Reserved.
     *
     * NOTICE:  All information contained herein is, and remains
     * the property of Adobe Inc. and its suppliers,
     * if any.  The intellectual and technical concepts contained
     * herein are proprietary to Adobe Inc. and its
     * suppliers and are protected by trade secret or copyright law.
     * Dissemination of this information or reproduction of this material
     * is strictly forbidden unless prior written permission is obtained
     * from Adobe Inc.
     **************************************************************************/
    declare enum DerivationType {
        NONE = 0,
        COPY = 1
    }

    /**
     * Gets passed into `getCachedAssetInfo()`.
     * @callback GetCachedAssetInfoCallback@callback GetCachedAssetInfoCallback
     *   @param {Error}             error       If not undefined the request has failed.
     *   @param {CachedAssetInfo}   assetInfo
     */
    declare interface GetCachedAssetInfoCallback {
        (error?: undefined, info?: CachedAssetInfo): any;
        (error?: AdobeDCXError_2, info?: undefined): any;
    }

    /**
     * @param session - The repo session to use.
     * @param asset - Asset from which the manifest and components should be retrieved. May be a DCXComposite or minimal AdobeAsset.
     * If a composite is provided, the same composite will returned on the response object.
     * @param components An array of ComponentRequestsByPath. NOTE: Paths are restricted to well-known paths only as determined by specific composite media type.
     * @see {@link https://wiki.corp.adobe.com/display/CA/Proposal%3A+Download+Components+by+DCX+Path Proposal: Download DCX Components by Path}
     * If using components that do not exist on the given well-known paths, please use @see performBulkRequest
     * @example
     *  ```
     *  const components = [
     *    {
     *      "/model/database.json",
     *      responseType: "json" // default value "defaultbuffer"
     *    }
     *  ]
     *  ```
     * @param version           Version of the composite manifest to fetch (components all come from this version of the manifest)
     * @param etag              Etag to use within the if-match header of the request
     * @param additionalHeaders Additional headers to attach to HTTP requests
     * @example
     * ```
     * {
     *   composite: AdobeDCXComposite, // The supplied composite is returned here, if it was not supplied a new one is created
     *   manifest: {
     *     data?: ManifestData, // JSON parsed manifest data
     *     error?: DCXError, // present if there was an error fetching the manifest
     *     response: AdobeResponse // response for the manifest sub-request (or secondary follow-up manifest request)
     *   },
     *   components: {
     *     "/model/database.json": { // component paths are the keys
     *       component_path: "/model/database.json",
     *       data?: ResponseTypeMap[ResponseType], // parsed into the requested responseType
     *       error?: DCXError, // present if there was an error fetching the manifest
     *       response: AdobeResponse, // response for component sub-request (or follow-up request)
     *     }
     *   },
     *   responses: AdobeResponse[] // array of Bulk request responses (1 response per bulk request issued)
     * }
     * ```
     */
    export declare function getCompositeManifestAndComponentsByPath<C extends ComponentRequestByPath[]>(session: AdobeRepoAPISession, asset: AdobeAsset, components: C, version?: string, etag?: string, additionalHeaders?: Record<string, string>): AdobePromise<CompositeWithManifestAndComponents<C>, AdobeDCXError_2>;

    export { getGlobalLogger }

    /**
     * Returns a URL that points to the component asset on the server.
     * When using the result URL for for creating a new component via PUT, `null`
     * should be provided for the revision parameter.
     *
     * @param session           The repo session to use.
     * @param component         The existing component. Must be part of a composite branch.
     * @param componentRevision Specific revision of the component to get.
     *                              If not provided, will use the revision defined in the component, or undefined.
     *                              To bypass the component's revision, pass null as revision.
     * @param additionalHeaders Additional headers to attach to HTTP requests
     */
    export declare function getURLForComponent(session: AdobeRepoAPISession, component: AdobeDCXComponent_2, componentRevision?: string, additionalHeaders?: Record<string, string>): AdobePromise<string, AdobeDCXError_2>;

    export declare const HTTPService: new (authHandler?: AdobeAuthProvider | AuthenticationCallback | undefined, options?: AdobeHTTPServiceOptions | undefined) => AdobeHTTPService;

    export { isAdobeDCXError }

    /** @public */
    export declare const logger: AdobeDCXLogger;

    /**
     * Creates and returns a new composite object that is a copy of compositeBranchOrElement.
     * @public
     *
     * @param   {Object}    compositeOrBranchOrElement As the name implies this param is expected to be
     *                                                  either a composite (with a valid current branch),
     *                                                  a branch or an element. Furthermore it may (at
     *                                                  this point in time) not contain an new or modified
     *                                                  components.
     * @param   {String}    [name]                     An optional new name for the new composite. If undefined
     *                                                  the composite will have the same name as the original.
     * @param   {String}    [type]                     An optional new type for the new composite. If undefined
     *                                                   the composite will have the same type as the original.
     * @param   {String}    [id]                       An optional new id for the new composite. If undefined
     *                                                  the composite will get a random new id.
     * @param {AdobeDCXCompositeOptions} [options]                   Creation options
     */
    export declare const newCompositeAsCopyOf: (compositeOrBranchOrElement: AdobeDCXComposite_2 | AdobeDCXBranch_2 | AdobeDCXElement_2, name?: string, type?: string, id?: string, options?: AdobeDCXCompositeOptions) => AdobeDCXComposite;

    /**
     * Convenience APIs
     */
    /**
     * Factory method for creating a R-API based DCXComposite.
     * To create a bound composite, provide `repositoryId` and `assetId` and/or `links`.
     * To create an unbound composite, provide neither `repositoryId` or `assetId`. Must provide `name` and `type`.
     *
     * @experimental
     *
     * @param {string}                  [assetId]           - Asset ID of the composite if it already exists in the cloud.
     * @param {string}                  [repositoryId]      - Repository ID of the composite if it already exists in the cloud.
     * @param {string}                  [name]              - Composite name.
     * @param {string}                  [id]                - Composite ID.
     * @param {string}                  [type]              - Content Type of the composite, once created this cannot be changed.
     * @param {Record<string, Link>}    [links]             - Links associated with the composite.
     * @param {AdobeDCXCompositeOptions}              [options]           - Additional configuration options.
     */
    export declare function newDCXComposite(assetId?: string, repositoryId?: string, name?: string, id?: string, type?: string, links?: Record<string, Link>, options?: AdobeDCXCompositeOptions): AdobeDCXComposite;

    /**
     * Create a pull branch with just the manifest updated.
     *
     * @param   {AdobeRepoAPISession}       session     - The repo session to pull from.
     * @param   {AdobeDCXComposite}         composite   - The composite to pull.
     * @returns {AdobePromise<DCXBranch, AdobeDCXError, AdobeXferContext>}
     *
     */
    export declare function pullCompositeManifestOnly(session: AdobeRepoAPISession, composite: AdobeDCXComposite_2, additionalHeaders?: Record<string, string>): AdobePromise<AdobeDCXBranch, AdobeDCXError_2, AdobeXferContext>;

    /**
     * Download the manifest of a specific version and return a read-only branch.
     *
     * @param session   The repo session to pull from.
     * @param composite The composite to pull.
     * @param versionId Composite version
     * @param additionalHeaders Additional headers to attach to HTTP requests
     */
    export declare function pullCompositeVersionManifestOnly(session: AdobeRepoAPISession, composite: AdobeDCXComposite_2, versionId: string, additionalHeaders?: Record<string, string>): AdobePromise<AdobeDCXBranch, AdobeDCXError_2, AdobeXferContext>;

    /**
     * Push the composite.
     *
     * There are 4 modes for XMP metadata updates, determined by the `options` argument:
     * 1. Managed: all fields are managed by dcx-js. creatorTool is set to `dcx-js`
     * 2. Partially managed: Specific fields (eg. creatorTool) can be replaced by the caller,
     *    by passing them as key/values in an options object.
     * 3. Managed by client app via JSON Patch/initial XMP XML:
     *    On initial push: dcx-js will use the provided string `options.initialXMPXML` to create the component.
     *    On subsequent pushes: dcx-js will use the provided JSON Patch document `options.xmpPatch` to patch embedded
     *    metadata alongside the manifest push. This results in a single version, but leaves all validation and error \
     *    handling to the client application.
     *    See {@link https://git.corp.adobe.com/DMA/dcx-js/tree/dev/packages/xmp-util | @dcx/xmp-util} for
     *    convenience APIs for XMP Patching.
     * 4. Unmanaged: dcx-js skips the embedded metadata update entirely. It is the caller's responsbility
     *    to handle updates however they choose. If using this mode, a version will be created during dcx-js
     *    push; later updates by client applications will lead to an additional version being created.
     *
     * @note
     * To use mode 1 or 2, no mode needs to be specified. Properties that can be customized by clients
     * can be provided in the options object. If another mode is explicitly defined, those fields may be ignored.
     *
     * @note
     * If using mode 3, initialXMPXML is only used for initial pushes or when the manifest
     * does not yet contain a metadata component. If not provided, dcx-js uses the default XMP content.
     * Similarly, xmpPatch is only used for bound composites that contain a metadata component. If not
     * provided, no update will be performed on update pushes.
     *
     * @example
     * ```js
     * // 1. Managed mode
     * pushComposite(session, composite, overwrite, vLevel);
     * ```
     *
     * @example
     * ```js
     * // 2. Partially managed mode
     * pushComposite(session, composite, overwrite, vLevel, { creatorTool: 'your application name' });
     * ```
     *
     * @example
     * ```js
     * // 3. Client managed mode
     * pushComposite(session, composite, overwrite, vLevel, {
     *   mode: XMPModes.CLIENT_MANAGED,
     *   xmpPatch: [{ op: 'replace', path: '/xmp:ModifyDate', value: now}, ... ],
     *   initialXMPXML: '<x:xmpmeta ... />'
     * });
     * ```
     *
     * @example
     * ```js
     * // 4. Unmanaged mode
     * pushComposite(session, composite, overwrite, vLevel, { mode: XMPModes.UNMANAGED });
     * ```
     *
     * @note
     * <p>Notice that in the case of a rejected promise that error might represent multiple
     * errors since components are uploaded in parallel and each upload might fail individually.
     * Clients can get to per-component error information by checking the DCXError#additionalData#failedComponents
     * property on the error object. If set it will contain an array with one object per failed component
     * upload. Each component failure object has two properties: component and error.</p>
     *
     * @param   {AdobeRepoAPISession}                   session                 The repo session to use.
     * @param   {AdobeDCXComposite}                     composite               The composite to push.
     * @param   {Boolean}                               overwriteExisting       Whether to overwrite an existing composite.
     *                                                                          Only set this to true for an unbound composite
     *                                                                          if a previous push has failed with an
     *                                                                          INVALID_STATE error indicating that there is
     *                                                                          already a composite with the same id <em>and</em>
     *                                                                          if you are sure that you want to overwrite it.
     * @param   {number}                                [validationLevel=1]     Validation level for the manifest. Defaults to 1, must be >=1.
     * @param   {PushCompositeOptions}                  [options]               Push options
     * @returns {AdobePromise<DCXBranch, AdobeDCXError<{failedComponents?: FailedComponent[]}>, AdobeXferContext>}
     */
    export declare function pushComposite(session: AdobeRepoAPISession, composite: AdobeDCXComposite_2, overwriteExisting: boolean, validationLevel?: number, options?: PushCompositeOptions, additionalHeaders?: Record<string, string>): AdobePromise<AdobeDCXBranch_2, AdobeDCXError_2<{
        failedComponents?: FailedComponent;
    }>, AdobeXferContext>;

    declare type PushCompositeOptions = XMPConfig;

    declare interface RenditionTemplate {
        uri: string;
    }

    /**
     * @class
     * @classdesc Base class for the different sessions.
     * @param httpService the HTTP service
     * @param server      the url for the storage server
     */
    declare class SessionBase implements AdobeSessionBase {
        protected _server: string;
        _endPoint?: string;
        protected _maxRedirects: number;
        protected _authenticationAllowList: string[];
        protected _assetInfoCache: any;
        protected _assetIdResolutionTemplate: any;
        protected readonly SYNC_ASYNC_DEFAULT_DELAY = 5;
        protected readonly ASYNC_DEFAULT_DELAY = 1;
        protected readonly DEFAULT_POLL_DELAY = 10;
        /** @internal */
        _service: AdobeHTTPService;
        constructor(httpService: AdobeHTTPService, server: string);
        /**
         * The maximum number of redirects the session will follow *if* the underlying service
         * doesn't handle redirects. Gets ignored for services that handle redirects (e.g. XHR).
         * Set this to 0 if the session should not follow redirects. Default value: 5
         * @memberof AdobeSessionBase#
         * @type Integer
         */
        get maxRedirects(): number;
        set maxRedirects(value: number);
        /**
         * A list of domain names that should get sent the auth credentials of the underlying service.
         * @memberof AdobeSessionBase#
         * @type Array
         */
        get authenticationAllowList(): string[];
        set authenticationAllowList(value: string[]);
        /**
         * Given an href string this method returns true if it is either relative or it refers
         * to the same endpoint as the session's server.
         * @param {String} href The href to check
         */
        isValidHref(href: string): boolean;
        isDomainOnAllowList(href: string): boolean;
        /**
         * Gets an asset from the service.
         * @param {String}          href                The full URL of the asset to retrieve.
         * @param {String|Object}   [etagOrHeaders]     If a string, the etag to use, if an object a set of additional headers, if undefined. ignored
         * @param {Function}        callback            Called back when the asset has been fetched. Signature: `callback(error, httpResponse)`.
         * @return {Object}         The http requestDescriptor.
         */
        getAsset(href: string, etagOrHeaders: string | Record<string, string>, responseType: AdobeResponseType, callback: ResponseCallback): RequestDescriptor;
        /**
         * @private
         * @param {Object}          reuseRequestDesc    A RequestDescriptor object to reuse for additional HTTP requests
         */
        protected _getAsset(href: string, etagOrHeaders: string | Record<string, string> | undefined, responseType: AdobeResponseType, reuseRequestDesc: RequestDescriptor | undefined, callback: ResponseCallback): RequestDescriptor;
        /**
         * Get asset data in specified responseType result
         * @param {String}          href                The full URL of the asset to retrieve.
         * @param {String}          responseType        The desired response type.
         * @param {String|Object}   [etagOrHeaders]     If a string, the etag to use, if an object a set of additional headers, if undefined. ignored
         * @param {Function}        callback            Called back when the asset has been fetched. Signature: `callback(error, buffer, etag, response)`. The buffer is "null" if the etags match.
         *
         * @return               the requestDescriptor for the request.
         */
        getAssetAsType(href: string, responseType: AdobeResponseType, etagOrHeaders: string | Record<string, string>, callback: (error?: AdobeDCXError_2, buffer?: Buffer | null, etag?: string, response?: AdobeResponse) => void): RequestDescriptor;
        private _cacheLinksFromResponse;
        /**
         * @private
         * @param {Object}          reuseRequestDesc    A RequestDescriptor object to reuse for additional HTTP requests
         */
        _getAssetAsType(href: string, responseType: AdobeResponseType, etagOrHeaders: string | Record<string, string> | undefined, reuseRequestDesc: RequestDescriptor | undefined, assetId: string | undefined, versionId: string | undefined, callback: (error?: AdobeDCXError_2, buffer?: Buffer | null, etag?: string, response?: AdobeResponse) => void): RequestDescriptor;
        _getResourcePathFromHref(href: string, callback: (err?: AdobeDCXError_2, path?: string) => void): RequestDescriptor;
        resolveRootURLAsync(): AdobePromise<any, AdobeDCXError_2, RequestDescriptor>;
        getPromiseCacheInfo(fn: (...args: any[]) => AdobePromise<any, AdobeDCXError_2, RequestDescriptor>): AdobePromise<any, AdobeDCXError_2, RequestDescriptor>;
        private _parseCachableLinks;
        /**
         * Returns CachedAssetInfo for the specified asset id
         *
         * @param {String}  assetId     The unique id of the asset
         * @param {GetCachedAssetInfoCallback} Callback function to call with the result
         * @returns {RequestDescriptor} A RequestDescriptor if an HTTP request was made or undefined if none was required
         */
        getCachedAssetInfo(assetId: string, getCachedInfoCallback: GetCachedAssetInfoCallback): any;
        /**
         * Registers a set of links and returns a (fake) assetId
         *
         * @param {Object}  links   The links to register (body of _links object)
         * @returns {String}        Unique (but fake) assetId
         */
        registerLinks(links: Record<string, Link>): string;
        /** @internal */
        _infoForAssetId(assetId: string): any;
        private _awaitInfoForAssetId;
        protected _cacheInfoForAssetId(assetId: string, error?: Error, info?: any): void;
        /**
         * A _very_ naive URL resolver whose function is to prepend the a base to a relative URL
         * or to simply return the href directly if it's absolute.
         * Nothing is done about . or .. elements.
         */
        _resolveUrl(href: string): string;
        /**
         * @private
         * @param {String} href The href
         */
        protected _makeRelativeUrl(href: string): string;
        /**
         * Helper function to parse a response when polling for asynchronous results.
         * The body returned from these requests includes the response to the original request
         * including its own status code and headers.
         *
         * @notice This methods throws if it fails to parse at least the status code.
         *
         * @param asyncResponse The respone received from a successful (status code 200) poll request.
         * @return A fake response object with a statusCode and headers property set.
         *
         * @notice For now this methods drops the response body of the embedded response.
         * @internal
         */
        _parseAsyncResponse(asyncResponse: any): any;
        /**
         * Issues and handles the responses to an async poll reuqest.
         * Calls itself recursively if it gets another 202 response.
         *
         * @private
         * @param pollHref The href returned by the original 202 response.
         * @param pollFrequencyInSeconds Self explanatory.
         * @param requestDesc The request descriptor to reuse.
         * @param callback Gets called upon success or failure. Signature: function (error, response)
         */
        private _pollForAsyncResponse;
        /**
         * Handles a 202 response by scheduling a poll request reusing the same requestDesc.
         *
         * @protected
         * @param response The original 202 response.
         * @param requestDesc The request descriptor to reuse.
         * @param defaultSecondsToWaitForRetry Integer >= 0. If the reply doesn't contain a retry-after directive this is being used as the initial polling delay.
         * @param callback Gets called upon success or failure. Signature: function (error, response)
         */
        protected _handle202Response(response: any, requestDesc: RequestDescriptor, defaultSecondsToWaitForRetry: number, callback: (err?: AdobeDCXError_2, result?: any) => void): void;
    }

    declare interface SourceAssetInfoEntry {
        componentPath: string;
        compositeAssetId: string;
        componentId: string;
        componentVersion: string;
        repositoryId?: string;
    }

    /**
     * <p>Uploads the given data as the new asset for the given component. Does not update the
     * component in the composite branch. Instead it returns (via a promise) an object
     * containing the upload results which then can be used to update the component in the branch.</p>
     *
     * @param   {AdobeRepoAPISession}           session                 The repo session to use for the upload.
     * @param   {AdobeDCXComposite}             composite               The composite of the component.
     * @param   {AdobeDCXComponent}             component               The component to upload the new asset for.
     * @param   {Buffer|Function}               dataOrSliceCallback     The data to upload, or a method that returns slices of data.                                                                  unique within the composite. If not provided
     * @param   {number}                        [size]                  The estimated size of the component data to upload.
     * @param   {string}                        [md5]                   The MD5 of the component data to upload.
     *
     * @returns {AdobePromise<AdobeUploadResults, AdobeDCXError, AdobeXferContext>}
     */
    export declare function uploadComponent(session: AdobeRepoAPISession, composite: AdobeDCXComposite_2, component: AdobeDCXComponent_2, dataOrSliceCallback: SliceableData | GetSliceCallback, size?: number, md5?: string, progressCb?: ProgressCallback, additionalHeaders?: Record<string, string>): AdobePromise<AdobeUploadResults, AdobeDCXError_2, AdobeXferContext>;

    declare interface UploadedComponentRecord {
        etag: string;
        length: number;
        version: string;
        md5: string;
        timestamp: string;
        'source-asset-info'?: any;
    }

    /**
     * <p>Uploads the given data as the asset for a new component in the current branch of the given
     * composite. Does not add the component in the composite branch. Instead it returns
     * (via a promise) an object containing the upload results which then can be used to
     * add the component to the branch.</p>
     *
     * @remarks Service can override the block size client specified @see {@link https://git.corp.adobe.com/caf/api-spec/blob/gh-pages/schemas/repository/transfer-document.schema.json#L45}
     *
     * @param session               The repo session to use for the upload.
     * @param composite             The composite to add the new component asset to.
     * @param dataOrSliceCallback   The data to upload, or a method that returns slices of data.
     * @param type                  The content type of the component.
     * @param componentId           The id to use for the new component. Must be
     *                                  unique within the composite. If not provided
     *                                  the component will get assigned a random uuid.
     * @param size                  The estimated size of the component data to upload.
     * @param md5                   The MD5 of the component data to upload.
     * @param progressCb            A callback to be invoked with progress updates
     * @param additionalHeaders     Additional headers to attach to HTTP requests
     * @param blockSize             Desired block size for the upload in bytes
     */
    export declare function uploadNewComponent(session: AdobeRepoAPISession, composite: AdobeDCXComposite_2, dataOrSliceCallback: SliceableData | GetSliceCallback, type: string, componentId?: string, size?: number, md5?: string, progressCb?: ProgressCallback, additionalHeaders?: Record<string, string>, blockSize?: number): AdobePromise<AdobeUploadResults, AdobeDCXError_2, AdobeXferContext>;

    /**
     * @class AdobeCommunityPlatform
     * @classdesc AdobeCommunityPlatform is a static class that implements methods for publishing/remixing DCX composites to/from CP.
     * <p>Clients do not need to require() the class since a reference to it is available via their instance
     * of {@link AdobeDCX}.
     * @hideconstructor
     */
    /**
     * Callback for monitoring progress of the various transfer functions.
     * @callback ProgressCallback@callback ProgressCallback
     *    @param {Integer} bytesCompleted
     *    @param {Integer} totalBytes
     */
    /**
     * @class
     * @hideconstructor
     * @classdesc An XferContext object is returned when a transfer is initiated.
     * Clients can use it to abort the transfer or register a progress handler with the context.
     * @property {Integer}          [bytesTransfered]   The current number of bytes transfered.
     * @property {Integer}          [bytesTotal]        The total number of bytes to transfer.
     * @property {ProgressCallback} [onProgress]        Set this to a progressCallback function if you
     *                                                  want to receives progress callbacks.
     * @property {Array}            [failedComponents]  Upon failure this it is an array of
     *                                                  { component: component, error: error } for
     *                                                  each component that failed to down or upload.
     */
    declare class XferContext {
        private _session;
        private _callback;
        private _cleanup;
        private _componentsPending;
        private _bytesTransfered;
        private _bytesTotal;
        private _onProgress;
        private _reportProgress;
        private _aborted;
        constructor(session: AdobeCommunitySession, callback: any, cleanup?: any);
        /**
         * @internal
         */
        get xferComplete(): (completionError: any, result?: any) => any;
        /**
         * Is true if the xfer has been aborted.
         * @memberof XferContext#
         * @type {Boolean}
         */
        get aborted(): boolean;
        /**
         * The number of bytes already transfered
         * @memberof XferContext#
         * @type {Integer}
         */
        get bytesTransfered(): number;
        /**
         * The total number of bytes to transfer
         * @memberof XferContext#
         * @type {Integer}
         */
        get bytesTotal(): number;
        /**
         * The progress callback that should get called on progress.
         * @memberof XferContext#
         * @type {ProgressCallback}
         */
        set onProgress(progressCallback: any);
        get onProgress(): any;
        /**
         * Call the client callback. Repeated calls will get ignored.
         * @private
         */
        private _callCallback;
        /**
         * Called when the xfer has either succeeded or failed.
         * @private
         */
        private _xferComplete;
        /**
         * Call this to abort the transfer.
         * @param {Error} [error] If not undefined then the callback for the xfer gets
         *                        invoked and passed this as the first (error) argument.
         */
        abort(abortError: AdobeDCXError_2 | Error): any;
    }

    declare type XMPConfig = XMPConfigClientManaged | XMPConfigManaged | XMPConfigUnmanaged;

    declare type XMPConfigClientManaged = {
        mode: XMPModes.CLIENT_MANAGED;
        initialXMPXML?: string;
        xmpPatch?: JSONPatchDocument;
    };

    declare type XMPConfigManaged = {
        mode?: XMPModes.MANAGED | XMPModes.PARTIALLY_MANAGED;
        /**
         * Client app using dcx-js to push the metadata.
         * If undefined will use `dcx-js`.
         */
        creatorTool?: string;
        /**
         * Datetime string in ISO8601 format.
         */
        modifyDate?: string;
    };

    declare type XMPConfigUnmanaged = {
        mode: XMPModes.UNMANAGED;
    };

    export declare enum XMPModes {
        MANAGED = 0,
        PARTIALLY_MANAGED = 1,
        CLIENT_MANAGED = 2,
        UNMANAGED = 3
    }


    export * from "@dcx/promise";
    export * from "@dcx/repo-api-session";

    export { }
