/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * @license
 * Copyright 2020 Adobe Inc.
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Inc. and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Inc. and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Inc.
 **************************************************************************/

/**
 * Entrypoint for browser builds
 * Insert instances of browser-specific interfaces and polyfills here
 * ie. Storage
 */

import {
    AdobeDCXBranch as IAdobeDCXBranch,
    AdobeDCXComposite as IAdobeDCXComposite,
    AdobeDCXElement as IAdobeDCXElement,
} from '@dcx/common-types';
import '@dcx/core';
import { AdobeHTTPService, AdobeNetworkHTTPService as _AdobeNetworkHTTPService } from '@dcx/http';
import { AdobeDCXLogger, getGlobalLogger } from '@dcx/logger';
import '@dcx/polyfill';
import * as _AdobeDCXUtil from '@dcx/util';
import { AdobeCommunityPublicationRecord } from './src/AdobeCommunityPublicationRecord';
import { AdobeCommunitySession } from './src/AdobeCommunitySession';
import { AdobeDCXComposite, AdobeDCXCompositeOptions } from './src/AdobeDCXComposite';
import { AdobeRemixData } from './src/AdobeRemixData';
import { checkEnvironment } from './src/helpers/env';

export { AdobeDCXError, DCXError, isAdobeDCXError } from '@dcx/error';
export { AdobeHTTPService, createHTTPService } from '@dcx/http';
export { /* istanbul ignore next */ AdobeDCXLogger, /* istanbul ignore next */ getGlobalLogger } from '@dcx/logger';
export * from '@dcx/promise';
export * from '@dcx/repo-api-session';
export {
    /* istanbul ignore next */ AdobeCommunityPlatform,
    /* istanbul ignore next */ AdobeCommunityPlatform as communityPlatform,
} from './src/AdobeCommunityPlatform';
export { /* istanbul ignore next */ AdobeCommunityPublicationRecord } from './src/AdobeCommunityPublicationRecord';
export {
    /* istanbul ignore next */ AdobeCommunitySession,
    /* istanbul ignore next */ AdobeCommunitySession as CommunitySession,
} from './src/AdobeCommunitySession';
export { /* istanbul ignore next */ AdobeDCXBranch } from './src/AdobeDCXBranch';
export { /* istanbul ignore next */ AdobeDCXComponent } from './src/AdobeDCXComponent';
export {
    /* istanbul ignore next */ AdobeDCXComposite,
    /* istanbul ignore next */ AdobeDCXCompositeOptions,
    /* istanbul ignore next */ convertToDCXComposite,
    /* istanbul ignore next */ createComposite,
    /* istanbul ignore next */ newDCXComposite,
} from './src/AdobeDCXComposite';
export { /* istanbul ignore next */ AdobeDCXElement } from './src/AdobeDCXElement';
export { /* istanbul ignore next */ AdobeDCXNode } from './src/AdobeDCXNode';
export { /* istanbul ignore next */ AdobeDCXPushJournal } from './src/AdobeDCXPushJournal';
export {
    /* istanbul ignore next */ AdobeRemixData,
    /* istanbul ignore next */ AdobeRemixData as RemixData,
} from './src/AdobeRemixData';
// eslint-disable-next-line import/export
export {
    XMPModes,
    copyResources,
    getCompositeManifestAndComponentsByPath,
    getURLForComponent,
    pullCompositeManifestOnly,
    pullCompositeVersionManifestOnly,
    pushComposite,
    uploadComponent,
    uploadNewComponent,
} from './src/CompositeXfer';
export const AdobeNetworkHTTPService = _AdobeNetworkHTTPService;
export const HTTPService = AdobeNetworkHTTPService;

checkEnvironment();

/**
 * Export classes by name for backwards compatibility
 */
/** @public */
export const logger: AdobeDCXLogger = getGlobalLogger();
/** @public */
export const AdobeDCXUtil = _AdobeDCXUtil;

/**
 * The different types of collaboration for a composite. You can set the collaboration type
 * directly on a {@link AdobeDCX#Composite|AdobeDCXComposite} object.
 * @enum {String}
 * @public
 */
export const COLLABORATION = AdobeDCXComposite.COLLABORATION;

//******************************************************************************
// Creating Composites
//******************************************************************************

/**
 * Creates and returns a new composite object that is a copy of compositeBranchOrElement.
 * @public
 *
 * @param   {Object}    compositeOrBranchOrElement As the name implies this param is expected to be
 *                                                  either a composite (with a valid current branch),
 *                                                  a branch or an element. Furthermore it may (at
 *                                                  this point in time) not contain an new or modified
 *                                                  components.
 * @param   {String}    [name]                     An optional new name for the new composite. If undefined
 *                                                  the composite will have the same name as the original.
 * @param   {String}    [type]                     An optional new type for the new composite. If undefined
 *                                                   the composite will have the same type as the original.
 * @param   {String}    [id]                       An optional new id for the new composite. If undefined
 *                                                  the composite will get a random new id.
 * @param {AdobeDCXCompositeOptions} [options]                   Creation options
 */
export const newCompositeAsCopyOf = (
    compositeOrBranchOrElement: IAdobeDCXComposite | IAdobeDCXBranch | IAdobeDCXElement,
    name?: string,
    type?: string,
    id?: string,
    options: AdobeDCXCompositeOptions = {},
): AdobeDCXComposite => {
    return AdobeDCXComposite.newCompositeAsCopyOf(compositeOrBranchOrElement, name, type, id, options);
};

//******************************************************************************
// Transfering Composites
//******************************************************************************

/**
 * Constructs and returns a community session instance.
 * @public
 * @example
 * ```js
 * const service = // create instance of AdobeHTTPService
 * ...
 * const session = createCommunitySession(service, 'https://my.proxy.adobe.com/cp');
 * ```
 * @param   {AdobeHTTPService}    httpService The HTTP service.
 * @param   {String}              endpoint    The url for the storage server.
 */
export const createCommunitySession = (httpService: AdobeHTTPService, endpoint: string): AdobeCommunitySession => {
    return new AdobeCommunitySession(httpService, endpoint);
};

/**
 * Constructs and returns a remixData instance.
 * @public
 */
export const createRemixData = (): AdobeRemixData => new AdobeRemixData();

/**
 * The {@link ./src/AdobeRemixData} class.  Gives access to the DCX AdobeCommunityPublicationRecord which represents publishing data for the Community Platform..
 * @readonly
 * @public
 * @type {AdobeRemixData}
 */
export const CommunityPublicationRecord = AdobeCommunityPublicationRecord;

/**
 * Constructs and returns a {@link ./src/AdobeCommunityPublicationRecord} instance.
 * @public
 */
export const createCommunityPublicationRecord = (): AdobeCommunityPublicationRecord =>
    new AdobeCommunityPublicationRecord();
