/* istanbul ignore file */

/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * @license
 * Copyright 2020 Adobe Inc.
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Inc. and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Inc. and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Inc.
 **************************************************************************/

export interface AdobeCommunityPublicationRecordMetadata {
    title?: string;
    description?: string;
    alias?: string;
    undiscoverable?: boolean;
    private?: boolean;
    tags?: string[];
    // eslint-disable-next-line camelcase
    creator_ids?: string[];
    // eslint-disable-next-line camelcase
    category_id?: string;
    // eslint-disable-next-line camelcase
    sub_category_ids?: string[];
    custom?: unknown;
    // eslint-disable-next-line camelcase
    main_resource?: {
        // eslint-disable-next-line camelcase
        resource_path?: string;
        // eslint-disable-next-line camelcase
        resource_version?: string;
    };
    artwork?: {
        // eslint-disable-next-line camelcase
        resource_path?: string;
        // eslint-disable-next-line camelcase
        resource_version?: string;
    };
}
/**
 * @class
 * @classdesc AdobeCommunityPublicationRecord represents publishing data for the Community Platform.
 * <p>The constructor for AdobeCommunityPublicationRecord is private. Refer to {@link AdobeDCX} to learn how
 * to create instances of AdobeCommunityPublicationRecord.
 * @hideconstructor
 */
export class AdobeCommunityPublicationRecord {
    private _communityId: string | null = null;
    private _artworkComponentId: string | null = null;
    private _assetId: string | null = null;
    private _resourcePath: string | null = null;
    private _mainResource: any = null;
    private _mainResourceVersion: string | null = null;
    private _artworkResource: string | null = null;
    private _artworkResourceVersion: string | null = null;
    private _title: string | null = null;
    private _alias: string | null = null;
    private _tags: string[] = [];
    private _description: string | null = null;
    private _categoryId: string | null = null;
    private _subCategoryIds: string[] = [];
    private _creatorIds: string[] = [];
    private _undiscoverable = false;
    private _isPrivate = false;
    private _custom: unknown = null;

    public get communityId(): string | null {
        return this._communityId;
    }
    public set communityId(communityId: string | null) {
        this._communityId = communityId;
    }

    public get artworkComponentId(): string | null {
        return this._artworkComponentId;
    }
    public set artworkComponentId(artworkComponentId: string | null) {
        this._artworkComponentId = artworkComponentId;
    }

    public get assetId(): string | null {
        return this._assetId;
    }
    public set assetId(assetId: string | null) {
        this._assetId = assetId;
    }

    public get resourcePath(): string | null {
        return this._resourcePath;
    }
    public set resourcePath(resourcePath: string | null) {
        this._resourcePath = resourcePath;
    }

    public get mainResource(): any {
        return this._mainResource;
    }
    public set mainResource(mainResource: any) {
        this._mainResource = mainResource;
    }

    public get mainResourceVersion(): string | null {
        return this._mainResourceVersion;
    }
    public set mainResourceVersion(mainResourceVersion: string | null) {
        this._mainResourceVersion = mainResourceVersion;
    }

    public get artworkResource(): string | null {
        return this._artworkResource;
    }
    public set artworkResource(artworkResource: string | null) {
        this._artworkResource = artworkResource;
    }

    public get artworkResourceVersion(): string | null {
        return this._artworkResourceVersion;
    }
    public set artworkResourceVersion(artworkResourceVersion: string | null) {
        this._artworkResourceVersion = artworkResourceVersion;
    }

    public get title(): string | null {
        return this._title;
    }
    public set title(title: string | null) {
        this._title = title;
    }

    public get alias(): string | null {
        return this._alias;
    }
    public set alias(alias: string | null) {
        this._alias = alias;
    }

    public get tags(): string[] {
        return this._tags;
    }
    public set tags(tags: string[]) {
        this._tags = this._tags.concat(tags);
    }

    public get description(): string | null {
        return this._description;
    }
    public set description(description: string | null) {
        this._description = description;
    }

    public get categoryId(): string | null {
        return this._categoryId;
    }
    public set categoryId(categoryId: string | null) {
        this._categoryId = categoryId;
    }

    public get subCategoryIds(): string[] {
        return this._subCategoryIds;
    }
    public set subCategoryIds(subCategoryIds: string[]) {
        this._subCategoryIds = this._subCategoryIds.concat(subCategoryIds);
    }

    public get creatorIds(): string[] {
        return this._creatorIds;
    }
    public set creatorIds(creatorIds: string[]) {
        this._creatorIds = this._creatorIds.concat(creatorIds);
    }

    public get undiscoverable(): boolean {
        return this._undiscoverable;
    }
    public set undiscoverable(undiscoverable: boolean) {
        this._undiscoverable = undiscoverable;
    }

    public get isPrivate(): boolean {
        return this._isPrivate;
    }
    public set isPrivate(isPrivate: boolean) {
        this._isPrivate = isPrivate;
    }

    public get custom(): unknown {
        return this._custom;
    }

    public set custom(custom: unknown) {
        this._custom = custom;
    }
}

export default AdobeCommunityPublicationRecord;
