/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * @license
 * Copyright 2020 Adobe Inc.
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Inc. and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Inc. and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Inc.
 **************************************************************************/

/**
 * @class
 * @classdesc AdobeRemixData represents data to add to XMP for published composite.
 * <p>The constructor for AdobeRemixData is private. Refer to {@link AdobeDCX} to learn how
 * to create instances of AdobeRemixData.
 * @hideconstructor
 */
export class AdobeRemixData {
    private _originURL: string | null = null;
    private _manageUIURL: string | null = null;
    private _licenseType: string | null = null;
    private _licenseUrl: string | null = null;
    private _attributionURL: string | null = null;
    private _attributionName: string | null = null;

    public get originURL(): string | null {
        return this._originURL;
    }
    public set originURL(originURL: string | null) {
        this._originURL = originURL;
    }

    public get manageUIURL(): string | null {
        return this._manageUIURL;
    }
    public set manageUIURL(manageUIURL: string | null) {
        this._manageUIURL = manageUIURL;
    }

    public get licenseType(): string | null {
        return this._licenseType;
    }
    public set licenseType(licenseType: string | null) {
        this._licenseType = licenseType;
    }

    public get licenseUrl(): string | null {
        return this._licenseUrl;
    }
    public set licenseUrl(licenseUrl: string | null) {
        this._licenseUrl = licenseUrl;
    }

    public get attributionURL(): string | null {
        return this._attributionURL;
    }
    public set attributionURL(attributionURL: string | null) {
        this._attributionURL = attributionURL;
    }

    public get attributionName(): string | null {
        return this._attributionName;
    }
    public set attributionName(attributionName: string | null) {
        this._attributionName = attributionName;
    }
}

export default AdobeRemixData;
