/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * @license
 * Copyright 2020 Adobe Inc.
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Inc. and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Inc. and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Inc.
 **************************************************************************/

import Logger from '@dcx/logger';
import { isBrowser, isBrowserSDK, isNode } from '@dcx/util';

/* istanbul ignore next */
export const envWarnTemplate = (bundle: string, env: string): string => {
    return (
        `It looks like you're using a ${bundle} bundle in a ${env} environment. \r\n` +
        `This may lead to unexpected results. \n\n` +
        `See https://git.corp.adobe.com/DMA/dcx-js/blob/dev/docs/guides/bundles.md for main field definitions.`
    );
};

/* istanbul ignore next */
export const checkEnvironment = () => {
    if (isBrowserSDK() && isNode()) {
        Logger.warn(envWarnTemplate('browser', 'Node'));
    } else if (!isBrowserSDK() && isBrowser()) {
        Logger.warn(envWarnTemplate('Node', 'browser'));
    }
};
